"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *


class QFileSelector(QObject):
    """
    https://doc.qt.io/qt-5/qfileselector.html

    **Detailed Description**

    QFileSelector is a convenience for selecting file variants based on platform
    or device characteristics. This allows you to develop and deploy one
    codebase containing all the different variants more easily in some
    circumstances, such as when the correct variant cannot be determined during
    the deploy step.

    **Using QFileSelector**

    If you always use the same file you do not need to use QFileSelector.

    Consider the following example usage, where you want to use different
    settings files on different locales. You might select code between locales
    like this:

    **QString**  defaultsBasePath = "data/";
            **QString**  defaultsPath =
    defaultsBasePath + "defaults.conf";
            **QString**  localizedPath =
    defaultsBasePath
                    + **QString**
    ("%1/defaults.conf").arg(**QLocale** ().name());
            if (**QFile**
    ::exists(localizedPath))
                defaultsPath = localizedPath;
    **QFile**  defaults(defaultsPath);

    Similarly, if you want to pick a different data file based on target
    platform, your code might look something like this:

    **QString**  defaultsPath = "data/defaults.conf";
        #if
    defined(Q_OS_ANDROID)
            defaultsPath = "data/android/defaults.conf";
    #elif defined(Q_OS_IOS)
            defaultsPath = "data/ios/defaults.conf";
    #endif
            **QFile**  defaults(defaultsPath);

    QFileSelector provides a convenient alternative to writing such boilerplate
    code, and in the latter case it allows you to start using an platform-
    specific configuration without a recompile. QFileSelector also allows for
    chaining of multiple selectors in a convenient way, for example selecting a
    different file only on certain combinations of platform and locale. For
    example, to select based on platform and/or locale, the code is as follows:

    **QFileSelector**  selector;
            **QFile**
    defaultsFile(selector.select("data/defaults.conf"));

    The files to be selected are placed in directories named with a `'+'` and a
    selector name. In the above example you could have the platform
    configurations selected by placing them in the following locations:

    data/defaults.conf
            data/+android/defaults.conf
    data/+ios/+en_GB/defaults.conf

    To find selected files, QFileSelector looks in the same directory as the
    base file. If there are any directories of the form +<selector> with an
    active selector, QFileSelector will prefer a file with the same file name
    from that directory over the base file. These directories can be nested to
    check against multiple selectors, for example:

    images/background.png
            images/+android/+en_GB/background.png

    With those files available, you would select a different file on the android
    platform, but only if the locale was en_GB.

    For error handling in the case no valid selectors are present, it is
    recommended to have a default or error-handling file in the base file
    location even if you expect selectors to be present for all deployments.

    In a future version, some may be marked as deploy-time static and be moved
    during the deployment step as an optimization. As selectors come with a
    performance cost, it is recommended to avoid their use in circumstances
    involving performance-critical code.

    **Adding Selectors**

    Selectors normally available are

    * platform, any of the following strings which match the platform the
    application is running on (list not exhaustive): android, ios, osx, darwin,
    mac, macos, linux, qnx, unix, windows. On Linux, if it can be determined,
    the name of the distribution too, like debian, fedora or opensuse.
      *
    locale, same as QLocale().name().

    Further selectors will be added from the `QT_FILE_SELECTORS` environment
    variable, which when set should be a set of comma separated selectors. Note
    that this variable will only be read once; selectors may not update if the
    variable changes while the application is running. The initial set of
    selectors are evaluated only once, on first use.

    You can also add extra selectors at runtime for custom behavior. These will
    be used in any future calls to **select** (). If the extra selectors list
    has been changed, calls to **select** () will use the new list and may
    return differently.

    **Conflict Resolution when Multiple Selectors Apply**

    When multiple selectors could be applied to the same file, the first
    matching selector is chosen. The order selectors are checked in are:

    1. Selectors set via **setExtraSelectors** (), in the order they are in the
    list
      2. Selectors in the `QT_FILE_SELECTORS` environment variable, from
    left to right
      3. Locale
      4. Platform

    Here is an example involving multiple selectors matching at the same time.
    It uses platform selectors, plus an extra selector named "admin" is set by
    the application based on user credentials. The example is sorted so that the
    lowest matching file would be chosen if all selectors were present:

    images/background.png
            images/+linux/background.png
    images/+windows/background.png
            images/+admin/background.png
    images/+admin/+linux/background.png

    Because extra selectors are checked before platform the
    `+admin/background.png` will be chosen on Windows when the admin selector is
    set, and `+windows/background.png` will be chosen on Windows when the admin
    selector is not set. On Linux, the `+admin/+linux/background.png` will be
    chosen when admin is set, and the `+linux/background.png` when it is not.
    """

    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qfileselector.html#QFileSelector

        **QFileSelector::QFileSelector(QObject * parent = nullptr)**

        Create a QFileSelector instance. This instance will have the same static
        selectors as other QFileSelector instances, but its own set of extra
        selectors.

        If supplied, it will have the given **QObject**  **parent**.
        """
        ...

    def allSelectors(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfileselector.html#allSelectors

        **QStringList QFileSelector::allSelectors() const**

        Returns the complete, ordered list of selectors used by this instance
        """
        ...

    def setExtraSelectors(self, list: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfileselector.html#setExtraSelectors

        **void QFileSelector::setExtraSelectors(const QStringList & list )**

        Sets the **list** of extra selectors which have been added
        programmatically to this instance.

        These selectors have priority over any which have been automatically
        picked up.

        **See also** **extraSelectors** ().
        """
        ...

    def extraSelectors(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfileselector.html#extraSelectors

        **QStringList QFileSelector::extraSelectors() const**

        Returns the list of extra selectors which have been added
        programmatically to this instance.

        **See also** **setExtraSelectors** ().
        """
        ...

    @typing.overload
    def select(self, filePath: str) -> str:
        """
        https://doc.qt.io/qt-5/qfileselector.html#select

        **QString QFileSelector::select(const QString & filePath ) const**

        This function returns the selected version of the path, based on the
        conditions at runtime. If no selectable files are present, returns the
        original **filePath**.

        If the original file does not exist, the original **filePath** is
        returned. This means that you must have a base file to fall back on, you
        cannot have only files in selectable sub-directories.

        See the class overview for the selection algorithm.
        """
        ...

    @typing.overload
    def select(self, filePath: "QUrl") -> "QUrl":
        """
        https://doc.qt.io/qt-5/qfileselector.html#select-1

        **QUrl QFileSelector::select(const QUrl & filePath ) const**

        This is a convenience version of select operating on **QUrl**  objects.
        If the scheme is not file or qrc, **filePath** is returned immediately.
        Otherwise selection is applied to the path of **filePath** and a
        **QUrl**  is returned with the selected path and other **QUrl**  parts
        the same as **filePath**.

        See the class overview for the selection algorithm.
        """
        ...
