"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QDataStream(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdatastream.html

    **Detailed Description**

    A data stream is a binary stream of encoded information which is 100%
    independent of the host computer's operating system, CPU or byte order. For
    example, a data stream that is written by a PC under Windows can be read by
    a Sun SPARC running Solaris.

    You can also use a data stream to read/write **raw unencoded binary data** .
    If you want a "parsing" input stream, see **QTextStream** .

    The QDataStream class implements the serialization of C++'s basic data
    types, like `char`, `short`, `int`, `char *`, etc. Serialization of more
    complex data is accomplished by breaking up the data into primitive units.

    A data stream cooperates closely with a **QIODevice** . A **QIODevice**
    represents an input/output medium one can read data from and write data to.
    The **QFile**  class is an example of an I/O device.

    Example (write binary data to a stream):

    **QFile**  file("file.dat");
        file.open(**QIODevice** ::WriteOnly);
    **QDataStream**  out(&file);   // we will serialize the data into the file
    out << **QString** ("the answer is");   // serialize a string
        out <<
    (**qint32** )42;        // serialize an integer

    Example (read binary data from a stream):

    **QFile**  file("file.dat");
        file.open(**QIODevice** ::ReadOnly);
    **QDataStream**  in(&file);    // read the data serialized from the file
    **QString**  str;
        **qint32**  a;
        in >> str >> a;           //
    extract "the answer is" and 42

    Each item written to the stream is written in a predefined binary format
    that varies depending on the item's type. Supported Qt types include
    **QBrush** , **QColor** , **QDateTime** , **QFont** , **QPixmap** ,
    **QString** , **QVariant**  and many others. For the complete list of all Qt
    types supporting data streaming see **Serializing Qt Data Types** .

    For integers it is best to always cast to a Qt integer type for writing, and
    to read back into the same Qt integer type. This ensures that you get
    integers of the size you want and insulates you from compiler and platform
    differences.

    Enumerations can be serialized through QDataStream without the need of
    manually defining streaming operators. Enum classes are serialized using the
    declared size.

    To take one example, a `char *` string is written as a 32-bit integer equal
    to the length of the string including the '\\0' byte, followed by all the
    characters of the string including the '\\0' byte. When reading a `char *`
    string, 4 bytes are read to create the 32-bit length value, then that many
    characters for the `char *` string including the '\\0' terminator are read.

    The initial I/O device is usually set in the constructor, but can be changed
    with **setDevice** (). If you've reached the end of the data (or if there is
    no I/O device set) **atEnd** () will return true.

    **Versioning**

    QDataStream's binary format has evolved since Qt 1.0, and is likely to
    continue evolving to reflect changes done in Qt. When inputting or
    outputting complex types, it's very important to make sure that the same
    version of the stream (**version** ()) is used for reading and writing. If
    you need both forward and backward compatibility, you can hardcode the
    version number in the application:

    stream.setVersion(**QDataStream** ::Qt_4_0);

    If you are producing a new binary data format, such as a file format for
    documents created by your application, you could use a QDataStream to write
    the data in a portable format. Typically, you would write a brief header
    containing a magic string and a version number to give yourself room for
    future expansion. For example:

    **QFile**  file("file.xxx");
        file.open(**QIODevice** ::WriteOnly);
    **QDataStream**  out(&file);

        // Write a header with a "magic
    number" and a version
        out << (**quint32** )0xA0B0C0D0;
        out <<
    (**qint32** )123;

        out.setVersion(**QDataStream** ::Qt_4_0);
    // Write the data
        out << lots_of_interesting_data;

    Then read it in with:

    **QFile**  file("file.xxx");
        file.open(**QIODevice** ::ReadOnly);
    **QDataStream**  in(&file);

        // Read and check the header
    **quint32**  magic;
        in >> magic;
        if (magic != 0xA0B0C0D0)
    return XXX_BAD_FILE_FORMAT;

        // Read the version
        **qint32**
    version;
        in >> version;
        if (version < 100)
            return
    XXX_BAD_FILE_TOO_OLD;
        if (version > 123)
            return
    XXX_BAD_FILE_TOO_NEW;

        if (version <= 110)
    in.setVersion(**QDataStream** ::Qt_3_2);
        else
    in.setVersion(**QDataStream** ::Qt_4_0);

        // Read the data
        in >>
    lots_of_interesting_data;
        if (version >= 120)
            in >>
    data_new_in_XXX_version_1_2;
        in >> other_interesting_data;

    You can select which byte order to use when serializing data. The default
    setting is big endian (MSB first). Changing it to little endian breaks the
    portability (unless the reader also changes to little endian). We recommend
    keeping this setting unless you have special requirements.

    **Reading and Writing Raw Binary Data**

    You may wish to read/write your own raw binary data to/from the data stream
    directly. Data may be read from the stream into a preallocated `char *`
    using **readRawData** (). Similarly data can be written to the stream using
    **writeRawData** (). Note that any encoding/decoding of the data must be
    done by you.

    A similar pair of functions is **readBytes** () and **writeBytes** (). These
    differ from their **raw** counterparts as follows: **readBytes** () reads a
    quint32 which is taken to be the length of the data to be read, then that
    number of bytes is read into the preallocated `char *`; **writeBytes** ()
    writes a quint32 containing the length of the data, followed by the data.
    Note that any encoding/decoding of the data (apart from the length quint32)
    must be done by you.

    **Reading and Writing Qt Collection Classes**

    The Qt container classes can also be serialized to a QDataStream. These
    include **QList** , QLinkedList, **QVector** , **QSet** , **QHash** , and
    **QMap** . The stream operators are declared as non-members of the classes.

    **Reading and Writing Other Qt Classes**

    In addition to the overloaded stream operators documented here, any Qt
    classes that you might want to serialize to a QDataStream will have
    appropriate stream operators declared as non-member of the class:

    **QDataStream**  &operator<<(**QDataStream**  &, const QXxx &);
    **QDataStream**  &operator>>(**QDataStream**  &, QXxx &);

    For example, here are the stream operators declared as non-members of the
    **QImage**  class:

    **QDataStream**  & operator<< (**QDataStream** & stream, const **QImage** &
    image);
            **QDataStream**  & operator>> (**QDataStream** & stream,
    **QImage** & image);

    To see if your favorite Qt class has similar stream operators defined, check
    the **Related Non-Members** section of the class's documentation page.

    **Using Read Transactions**

    When a data stream operates on an asynchronous device, the chunks of data
    can arrive at arbitrary points in time. The QDataStream class implements a
    transaction mechanism that provides the ability to read the data atomically
    with a series of stream operators. As an example, you can handle incomplete
    reads from a socket by using a transaction in a slot connected to the
    readyRead() signal:

    in.startTransaction();
        **QString**  str;
        **qint32**  a;
        in >>
    str >> a; // try to read packet atomically

        if
    (!in.commitTransaction())
            return;     // wait for more data

    If no full packet is received, this code restores the stream to the initial
    position, after which you need to wait for more data to arrive.

    **See also** **QTextStream**  and **QVariant** .
    """

    class FloatingPointPrecision(int):
        SinglePrecision: QDataStream = ...
        DoublePrecision: QDataStream = ...

    class Status(int):
        Ok: QDataStream = ...
        ReadPastEnd: QDataStream = ...
        ReadCorruptData: QDataStream = ...
        WriteFailed: QDataStream = ...

    class ByteOrder(int):
        BigEndian: QDataStream = ...
        LittleEndian: QDataStream = ...

    class Version(int):
        Qt_1_0: QDataStream = ...
        Qt_2_0: QDataStream = ...
        Qt_2_1: QDataStream = ...
        Qt_3_0: QDataStream = ...
        Qt_3_1: QDataStream = ...
        Qt_3_3: QDataStream = ...
        Qt_4_0: QDataStream = ...
        Qt_4_1: QDataStream = ...
        Qt_4_2: QDataStream = ...
        Qt_4_3: QDataStream = ...
        Qt_4_4: QDataStream = ...
        Qt_4_5: QDataStream = ...
        Qt_4_6: QDataStream = ...
        Qt_4_7: QDataStream = ...
        Qt_4_8: QDataStream = ...
        Qt_4_9: QDataStream = ...
        Qt_5_0: QDataStream = ...
        Qt_5_1: QDataStream = ...
        Qt_5_2: QDataStream = ...
        Qt_5_3: QDataStream = ...
        Qt_5_4: QDataStream = ...
        Qt_5_5: QDataStream = ...
        Qt_5_6: QDataStream = ...
        Qt_5_7: QDataStream = ...
        Qt_5_8: QDataStream = ...
        Qt_5_9: QDataStream = ...
        Qt_5_10: QDataStream = ...
        Qt_5_11: QDataStream = ...
        Qt_5_12: QDataStream = ...
        Qt_5_13: QDataStream = ...
        Qt_5_14: QDataStream = ...
        Qt_5_15: QDataStream = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#QDataStream

        **QDataStream::QDataStream()**

        Constructs a data stream that has no I/O device.

        **See also** **setDevice** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#QDataStream-1

        **QDataStream::QDataStream(QIODevice * d )**

        Constructs a data stream that uses the I/O device **d**.

        **See also** **setDevice** () and **device** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: QByteArray,
        flags: typing.Union[QIODevice.OpenMode, QIODevice.OpenModeFlag],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#QDataStream-2

        **QDataStream::QDataStream(QByteArray * a , QIODevice::OpenMode mode )**

        Constructs a data stream that operates on a byte array, **a**. The
        **mode** describes how the device is to be used.

        Alternatively, you can use QDataStream(const **QByteArray**  &) if you
        just want to read from a byte array.

        Since **QByteArray**  is not a **QIODevice**  subclass, internally a
        **QBuffer**  is created to wrap the byte array.
        """
        ...

    @typing.overload
    def __init__(self, a0: QByteArray) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#QDataStream-3

        **QDataStream::QDataStream(const QByteArray & a )**

        Constructs a read-only data stream that operates on byte array **a**.
        Use QDataStream(**QByteArray** *, int) if you want to write to a byte
        array.

        Since **QByteArray**  is not a **QIODevice**  subclass, internally a
        **QBuffer**  is created to wrap the byte array.
        """
        ...

    def abortTransaction(self) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#abortTransaction

        **void QDataStream::abortTransaction()**

        Aborts a read transaction.

        This function is commonly used to discard the transaction after higher-
        level protocol errors or loss of stream synchronization.

        If called on an inner transaction, aborting is delegated to the
        outermost transaction, and subsequently started inner transactions are
        forced to fail.

        For the outermost transaction, discards the restoration point and any
        internally duplicated data of the stream. Will not affect the current
        read position of the stream.

        Sets the status of the data stream to

        ConstantDescription
        `ReadCorruptData`.

        This function was introduced in Qt 5.7.

        **See also** **startTransaction** (), **commitTransaction** (), and
        **rollbackTransaction** ().
        """
        ...

    def rollbackTransaction(self) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#rollbackTransaction

        **void QDataStream::rollbackTransaction()**

        Reverts a read transaction.

        This function is commonly used to rollback the transaction when an
        incomplete read was detected prior to committing the transaction.

        If called on an inner transaction, reverting is delegated to the
        outermost transaction, and subsequently started inner transactions are
        forced to fail.

        For the outermost transaction, restores the stream data to the point of
        the **startTransaction** () call. If the data stream has read corrupt
        data or any of the inner transactions was aborted, this function aborts
        the transaction.

        If the preceding stream operations were successful, sets the status of
        the data stream to

        ConstantDescription
        `ReadPastEnd`.

        This function was introduced in Qt 5.7.

        **See also** **startTransaction** (), **commitTransaction** (), and
        **abortTransaction** ().
        """
        ...

    def commitTransaction(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdatastream.html#commitTransaction

        **bool QDataStream::commitTransaction()**

        Completes a read transaction. Returns `true` if no read errors have
        occurred during the transaction; otherwise returns `false`.

        If called on an inner transaction, committing will be postponed until
        the outermost commitTransaction(), **rollbackTransaction** (), or
        **abortTransaction** () call occurs.

        Otherwise, if the stream status indicates reading past the end of the
        data, this function restores the stream data to the point of the
        **startTransaction** () call. When this situation occurs, you need to
        wait for more data to arrive, after which you start a new transaction.
        If the data stream has read corrupt data or any of the inner
        transactions was aborted, this function aborts the transaction.

        This function was introduced in Qt 5.7.

        **See also** **startTransaction** (), **rollbackTransaction** (), and
        **abortTransaction** ().
        """
        ...

    def startTransaction(self) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#startTransaction

        **void QDataStream::startTransaction()**

        Starts a new read transaction on the stream.

        Defines a restorable point within the sequence of read operations. For
        sequential devices, read data will be duplicated internally to allow
        recovery in case of incomplete reads. For random-access devices, this
        function saves the current position of the stream. Call
        **commitTransaction** (), **rollbackTransaction** (), or
        **abortTransaction** () to finish the current transaction.

        Once a transaction is started, subsequent calls to this function will
        make the transaction recursive. Inner transactions act as agents of the
        outermost transaction (i.e., report the status of read operations to the
        outermost transaction, which can restore the position of the stream).

        **Note:** Restoring to the point of the nested startTransaction() call
        is not supported.

        When an error occurs during a transaction (including an inner
        transaction failing), reading from the data stream is suspended (all
        subsequent read operations return empty/zero values) and subsequent
        inner transactions are forced to fail. Starting a new outermost
        transaction recovers from this state. This behavior makes it unnecessary
        to error-check every read operation separately.

        This function was introduced in Qt 5.7.

        **See also** **commitTransaction** (), **rollbackTransaction** (), and
        **abortTransaction** ().
        """
        ...

    def setFloatingPointPrecision(
        self, precision: "QDataStream.FloatingPointPrecision"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#setFloatingPointPrecision

        **void QDataStream::setFloatingPointPrecision(QDataStream::FloatingPoint
        Precision precision )**

        Sets the floating point precision of the data stream to **precision**.
        If the floating point precision is **DoublePrecision**  and the version
        of the data stream is **Qt_4_6**  or higher, all floating point numbers
        will be written and read with 64-bit precision. If the floating point
        precision is **SinglePrecision**  and the version is **Qt_4_6**  or
        higher, all floating point numbers will be written and read with 32-bit
        precision.

        For versions prior to **Qt_4_6** , the precision of floating point
        numbers in the data stream depends on the stream operator called.

        The default is **DoublePrecision** .

        Note that this property does not affect the serialization or
        deserialization of `qfloat16` instances.

        **Warning:** This property must be set to the same value on the object
        that writes and the object that reads the data stream.

        This function was introduced in Qt 4.6.

        **See also** **floatingPointPrecision** ().
        """
        ...

    def floatingPointPrecision(self) -> "QDataStream.FloatingPointPrecision":
        """
        https://doc.qt.io/qt-5/qdatastream.html#floatingPointPrecision

        **QDataStream::FloatingPointPrecision
        QDataStream::floatingPointPrecision() const**

        Returns the floating point precision of the data stream.

        This function was introduced in Qt 4.6.

        **See also** **FloatingPointPrecision**  and
        **setFloatingPointPrecision** ().
        """
        ...

    def writeRawData(self, a0: bytes) -> int:
        """
        https://doc.qt.io/qt-5/qdatastream.html#writeRawData

        **int QDataStream::writeRawData(const char * s , int len )**

        Writes **len** bytes from **s** to the stream. Returns the number of
        bytes actually written, or -1 on error. The data is **not** encoded.

        **See also** **writeBytes** (), **QIODevice::write** (), and
        **readRawData** ().
        """
        ...

    def writeBytes(self, a0: bytes) -> "QDataStream":
        """
        https://doc.qt.io/qt-5/qdatastream.html#writeBytes

        **QDataStream &QDataStream::writeBytes(const char * s , uint len )**

        Writes the length specifier **len** and the buffer **s** to the stream
        and returns a reference to the stream.

        The **len** is serialized as a quint32, followed by **len** bytes from
        **s**. Note that the data is **not** encoded.

        **See also** **writeRawData** () and **readBytes** ().
        """
        ...

    def readRawData(self, len: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qdatastream.html#readRawData

        **int QDataStream::readRawData(char * s , int len )**

        Reads at most **len** bytes from the stream into **s** and returns the
        number of bytes read. If an error occurs, this function returns -1.

        The buffer **s** must be preallocated. The data is **not** decoded.

        **See also** **readBytes** (), **QIODevice::read** (), and
        **writeRawData** ().
        """
        ...

    def readBytes(self) -> bytes:
        """
        https://doc.qt.io/qt-5/qdatastream.html#readBytes

        **QDataStream &QDataStream::readBytes(char *& s , uint & l )**

        Reads the buffer **s** from the stream and returns a reference to the
        stream.

        The buffer **s** is allocated using `new []`. Destroy it with the
        `delete []` operator.

        The **l** parameter is set to the length of the buffer. If the string
        read is empty, **l** is set to 0 and **s** is set to `nullptr`.

        The serialization format is a quint32 length specifier first, then **l**
        bytes of data.

        **See also** **readRawData** () and **writeBytes** ().
        """
        ...

    def writeQVariantHash(self, qvarhash: typing.Dict[str, typing.Any]) -> None:
        ...

    def readQVariantHash(self) -> typing.Dict[str, typing.Any]:
        ...

    def writeQVariantMap(self, qvarmap: typing.Dict[str, typing.Any]) -> None:
        ...

    def readQVariantMap(self) -> typing.Dict[str, typing.Any]:
        ...

    def writeQVariantList(self, qvarlst: typing.Iterable[typing.Any]) -> None:
        ...

    def readQVariantList(self) -> typing.List[typing.Any]:
        ...

    def writeQVariant(self, qvar: typing.Any) -> None:
        ...

    def readQVariant(self) -> typing.Any:
        ...

    def writeQStringList(self, qstrlst: typing.Iterable[str]) -> None:
        ...

    def readQStringList(self) -> typing.List[str]:
        ...

    def writeQString(self, qstr: str) -> None:
        ...

    def readQString(self) -> str:
        ...

    def writeString(self, str: bytes) -> None:
        ...

    def writeDouble(self, f: float) -> None:
        ...

    def writeFloat(self, f: float) -> None:
        ...

    def writeBool(self, i: bool) -> None:
        ...

    def writeUInt64(self, i: int) -> None:
        ...

    def writeInt64(self, i: int) -> None:
        ...

    def writeUInt32(self, i: int) -> None:
        ...

    def writeInt32(self, i: int) -> None:
        ...

    def writeUInt16(self, i: int) -> None:
        ...

    def writeInt16(self, i: int) -> None:
        ...

    def writeUInt8(self, i: int) -> None:
        ...

    def writeInt8(self, i: int) -> None:
        ...

    def writeInt(self, i: int) -> None:
        ...

    def readString(self) -> bytes:
        ...

    def readDouble(self) -> float:
        ...

    def readFloat(self) -> float:
        ...

    def readBool(self) -> bool:
        ...

    def readUInt64(self) -> int:
        ...

    def readInt64(self) -> int:
        ...

    def readUInt32(self) -> int:
        ...

    def readInt32(self) -> int:
        ...

    def readUInt16(self) -> int:
        ...

    def readInt16(self) -> int:
        ...

    def readUInt8(self) -> int:
        ...

    def readInt8(self) -> int:
        ...

    def readInt(self) -> int:
        ...

    def skipRawData(self, len: int) -> int:
        """
        https://doc.qt.io/qt-5/qdatastream.html#skipRawData

        **int QDataStream::skipRawData(int len )**

        Skips **len** bytes from the device. Returns the number of bytes
        actually skipped, or -1 on error.

        This is equivalent to calling **readRawData** () on a buffer of length
        **len** and ignoring the buffer.

        This function was introduced in Qt 4.1.

        **See also** **QIODevice::seek** ().
        """
        ...

    def setVersion(self, v: int) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#setVersion

        **void QDataStream::setVersion(int v )**

        Sets the version number of the data serialization format to **v** , a
        value of the **Version**  enum.

        You don't **have** to set a version if you are using the current version
        of Qt, but for your own custom binary formats we recommend that you do;
        see **Versioning**  in the Detailed Description.

        To accommodate new functionality, the datastream serialization format of
        some Qt classes has changed in some versions of Qt. If you want to read
        data that was created by an earlier version of Qt, or write data that
        can be read by a program that was compiled with an earlier version of
        Qt, use this function to modify the serialization format used by
        **QDataStream** .

        The **Version**  enum provides symbolic constants for the different
        versions of Qt. For example:

        **QDataStream**  out(file);
            out.setVersion(**QDataStream**
        ::Qt_4_0);

        **See also** **version** () and **Version** .
        """
        ...

    def version(self) -> int:
        """
        https://doc.qt.io/qt-5/qdatastream.html#version

        **int QDataStream::version() const**

        Returns the version number of the data serialization format.

        **See also** **setVersion** () and **Version** .
        """
        ...

    def setByteOrder(self, a0: "QDataStream.ByteOrder") -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#setByteOrder

        **void QDataStream::setByteOrder(QDataStream::ByteOrder bo )**

        Sets the serialization byte order to **bo**.

        The **bo** parameter can be **QDataStream::BigEndian**  or
        **QDataStream::LittleEndian** .

        The default setting is big endian. We recommend leaving this setting
        unless you have special requirements.

        **See also** **byteOrder** ().
        """
        ...

    def byteOrder(self) -> "QDataStream.ByteOrder":
        """
        https://doc.qt.io/qt-5/qdatastream.html#byteOrder

        **QDataStream::ByteOrder QDataStream::byteOrder() const**

        Returns the current byte order setting -- either **BigEndian**  or
        **LittleEndian** .

        **See also** **setByteOrder** ().
        """
        ...

    def resetStatus(self) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#resetStatus

        **void QDataStream::resetStatus()**

        Resets the status of the data stream.

        **See also** **Status** , **status** (), and **setStatus** ().
        """
        ...

    def setStatus(self, status: "QDataStream.Status") -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#setStatus

        **void QDataStream::setStatus(QDataStream::Status status )**

        Sets the status of the data stream to the **status** given.

        Subsequent calls to setStatus() are ignored until **resetStatus** () is
        called.

        **See also** **Status** , **status** (), and **resetStatus** ().
        """
        ...

    def status(self) -> "QDataStream.Status":
        """
        https://doc.qt.io/qt-5/qdatastream.html#status

        **QDataStream::Status QDataStream::status() const**

        Returns the status of the data stream.

        **See also** **Status** , **setStatus** (), and **resetStatus** ().
        """
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdatastream.html#atEnd

        **bool QDataStream::atEnd() const**

        Returns `true` if the I/O device has reached the end position (end of
        the stream or file) or if there is no I/O device set; otherwise returns
        `false`.

        **See also** **QIODevice::atEnd** ().
        """
        ...

    def setDevice(self, a0: QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qdatastream.html#setDevice

        **void QDataStream::setDevice(QIODevice * d )**

        void QDataStream::setDevice(**QIODevice**  *d)

        Sets the I/O device to **d** , which can be `nullptr` to unset to
        current I/O device.

        **See also** **device** ().
        """
        ...

    def device(self) -> QIODevice:
        """
        https://doc.qt.io/qt-5/qdatastream.html#device

        **QIODevice *QDataStream::device() const**

        Returns the I/O device currently set, or `nullptr` if no device is
        currently set.

        **See also** **setDevice** ().
        """
        ...
