"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *


class QCoreApplication(QObject):
    """
    https://doc.qt.io/qt-5/qcoreapplication.html

    **Detailed Description**

    This class is used by non-GUI applications to provide their event loop. For
    non-GUI application that uses Qt, there should be exactly one
    QCoreApplication object. For GUI applications, see **QGuiApplication** . For
    applications that use the Qt Widgets module, see **QApplication** .

    QCoreApplication contains the main event loop, where all events from the
    operating system (e.g., timer and network events) and other sources are
    processed and dispatched. It also handles the application's initialization
    and finalization, as well as system-wide and application-wide settings.

    **The Event Loop and Event Handling**

    The event loop is started with a call to **exec** (). Long-running
    operations can call **processEvents** () to keep the application responsive.

    In general, we recommend that you create a QCoreApplication,
    **QGuiApplication**  or a **QApplication**  object in your `main()` function
    as early as possible. **exec** () will not return until the event loop
    exits; e.g., when **quit** () is called.

    Several static convenience functions are also provided. The QCoreApplication
    object is available from **instance** (). Events can be sent with
    **sendEvent** () or posted to an event queue with **postEvent** (). Pending
    events can be removed with **removePostedEvents** () or dispatched with
    **sendPostedEvents** ().

    The class provides a **quit** () slot and an **aboutToQuit** () signal.

    **Application and Library Paths**

    An application has an **applicationDirPath** () and an
    **applicationFilePath** (). Library paths (see **QLibrary** ) can be
    retrieved with **libraryPaths** () and manipulated by **setLibraryPaths**
    (), **addLibraryPath** (), and **removeLibraryPath** ().

    **Internationalization and Translations**

    Translation files can be added or removed using **installTranslator** () and
    **removeTranslator** (). Application strings can be translated using
    **translate** (). The **QObject::tr** () and QObject::trUtf8() functions are
    implemented in terms of **translate** ().

    **Accessing Command Line Arguments**

    The command line arguments which are passed to QCoreApplication's
    constructor should be accessed using the **arguments** () function.

    **Note:** QCoreApplication removes option `-qmljsdebugger="..."`. It parses
    the argument of `qmljsdebugger`, and then removes this option plus its
    argument.

    For more advanced command line option handling, create a
    **QCommandLineParser** .

    **Locale Settings**

    On Unix/Linux Qt is configured to use the system locale settings by default.
    This can cause a conflict when using POSIX functions, for instance, when
    converting between data types such as floats and strings, since the notation
    may differ between locales. To get around this problem, call the POSIX
    function `setlocale(LC_NUMERIC,"C")` right after initializing
    **QApplication** , **QGuiApplication**  or QCoreApplication to reset the
    locale that is used for number formatting to "C"-locale.

    **See also** **QGuiApplication** , **QAbstractEventDispatcher** ,
    **QEventLoop** , **Semaphores Example** , and **Wait Conditions Example** .
    """

    def __init__(self, argv: typing.List[str]) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#QCoreApplication

        **QCoreApplication::QCoreApplication(int & argc , char ** argv )**

        Constructs a Qt core application. Core applications are applications
        without a graphical user interface. Such applications are used at the
        console or as server processes.

        The **argc** and **argv** arguments are processed by the application,
        and made available in a more convenient form by the **arguments** ()
        function.

        **Warning:** The data referred to by **argc** and **argv** must stay
        valid for the entire lifetime of the QCoreApplication object. In
        addition, **argc** must be greater than zero and **argv** must contain
        at least one valid character string.
        """
        ...

    def __exit__(
        self, type: typing.Any, value: typing.Any, traceback: typing.Any
    ) -> None:
        ...

    def __enter__(self) -> typing.Any:
        ...

    @staticmethod
    def isSetuidAllowed() -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#isSetuidAllowed

        **[static] bool QCoreApplication::isSetuidAllowed()**

        Returns true if the application is allowed to run setuid on UNIX
        platforms.

        This function was introduced in Qt 5.3.

        **See also** **QCoreApplication::setSetuidAllowed** ().
        """
        ...

    @staticmethod
    def setSetuidAllowed(allow: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#setSetuidAllowed

        **[static] void QCoreApplication::setSetuidAllowed(bool allow )**

        Allows the application to run setuid on UNIX platforms if **allow** is
        true.

        If **allow** is false (the default) and Qt detects the application is
        running with an effective user id different than the real user id, the
        application will be aborted when a **QCoreApplication**  instance is
        created.

        Qt is not an appropriate solution for setuid programs due to its large
        attack surface. However some applications may be required to run in this
        manner for historical reasons. This flag will prevent Qt from aborting
        the application when this is detected, and must be set before a
        **QCoreApplication**  instance is created.

        **Note:** It is strongly recommended not to enable this option since it
        introduces security risks.

        This function was introduced in Qt 5.3.

        **See also** **isSetuidAllowed** ().
        """
        ...

    def removeNativeEventFilter(self, filterObj: QAbstractNativeEventFilter) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#removeNativeEventFilter

        **void
        QCoreApplication::removeNativeEventFilter(QAbstractNativeEventFilter *
        filterObject )**

        Removes an event **filterObject** from this object. The request is
        ignored if such an event filter has not been installed.

        All event filters for this object are automatically removed when this
        object is destroyed.

        It is always safe to remove an event filter, even during event filter
        activation (i.e. from the nativeEventFilter() function).

        This function was introduced in Qt 5.0.

        **See also** **installNativeEventFilter** ().
        """
        ...

    def installNativeEventFilter(self, filterObj: QAbstractNativeEventFilter) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#installNativeEventFilter

        **void
        QCoreApplication::installNativeEventFilter(QAbstractNativeEventFilter *
        filterObj )**

        Installs an event filter **filterObj** for all native events received by
        the application in the main thread.

        The event filter **filterObj** receives events via its
        **nativeEventFilter()**  function, which is called for all native events
        received in the main thread.

        The **QAbstractNativeEventFilter::nativeEventFilter** () function should
        return true if the event should be filtered, i.e. stopped. It should
        return false to allow normal Qt processing to continue: the native event
        can then be translated into a **QEvent**  and handled by the standard Qt
        **event**  filtering, e.g. **QObject::installEventFilter** ().

        If multiple event filters are installed, the filter that was installed
        last is activated first.

        **Note:** The filter function set here receives native messages, i.e.
        MSG or XCB event structs.

        **Note:** Native event filters will be disabled in the application when
        the **Qt::AA_PluginApplication**  attribute is set.

        For maximum portability, you should always try to use **QEvent**  and
        **QObject::installEventFilter** () whenever possible.

        This function was introduced in Qt 5.0.

        **See also** **QObject::installEventFilter** ().
        """
        ...

    @staticmethod
    def setQuitLockEnabled(enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#quitLockEnabled-prop

        **quitLockEnabled : bool**

        This property holds whether the use of the **QEventLoopLocker**  feature
        can cause the application to quit.

        The default is `true`.

        **Access functions:**

        bool **isQuitLockEnabled** ()
        void **setQuitLockEnabled** (bool
        **enabled** )

        **See also** **QEventLoopLocker** .

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def isQuitLockEnabled() -> bool:
        ...

    @staticmethod
    def setEventDispatcher(eventDispatcher: QAbstractEventDispatcher) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#setEventDispatcher

        **[static] void
        QCoreApplication::setEventDispatcher(QAbstractEventDispatcher *
        eventDispatcher )**

        Sets the event dispatcher for the main thread to **eventDispatcher**.
        This is only possible as long as there is no event dispatcher installed
        yet. That is, before **QCoreApplication**  has been instantiated. This
        method takes ownership of the object.

        **See also** **eventDispatcher** ().
        """
        ...

    @staticmethod
    def eventDispatcher() -> QAbstractEventDispatcher:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#eventDispatcher

        **[static] QAbstractEventDispatcher
        *QCoreApplication::eventDispatcher()**

        Returns a pointer to the event dispatcher object for the main thread. If
        no event dispatcher exists for the thread, this function returns
        `nullptr`.

        **See also** **setEventDispatcher** ().
        """
        ...

    @staticmethod
    def applicationPid() -> int:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#applicationPid

        **[static] qint64 QCoreApplication::applicationPid()**

        Returns the current process ID for the application.

        This function was introduced in Qt 4.4.
        """
        ...

    @staticmethod
    def applicationVersion() -> str:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#applicationVersion-prop

        **applicationVersion : QString**

        This property holds the version of this application

        If not set, the application version defaults to a platform-specific
        value determined from the main application executable or package (since
        Qt 5.9):

        PlatformSource
        Windows (classic desktop)PRODUCTVERSION parameter of
        the VERSIONINFO resource
        Universal Windows Platformversion attribute
        of the application package manifest
        macOS, iOS, tvOS,
        watchOSCFBundleVersion property of the information property list
        Androidandroid:versionName property of the AndroidManifest.xml manifest
        element

        On other platforms, the default is the empty string.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QString **applicationVersion** ()
        void **setApplicationVersion**
        (const QString & **version** )

        **Notifier signal:**

        void **applicationVersionChanged** ()

        **See also** **applicationName** , **organizationName** , and
        **organizationDomain** .
        """
        ...

    @staticmethod
    def setApplicationVersion(version: str) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#applicationVersion-prop

        **applicationVersion : QString**

        This property holds the version of this application

        If not set, the application version defaults to a platform-specific
        value determined from the main application executable or package (since
        Qt 5.9):

        PlatformSource
        Windows (classic desktop)PRODUCTVERSION parameter of
        the VERSIONINFO resource
        Universal Windows Platformversion attribute
        of the application package manifest
        macOS, iOS, tvOS,
        watchOSCFBundleVersion property of the information property list
        Androidandroid:versionName property of the AndroidManifest.xml manifest
        element

        On other platforms, the default is the empty string.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QString **applicationVersion** ()
        void **setApplicationVersion**
        (const QString & **version** )

        **Notifier signal:**

        void **applicationVersionChanged** ()

        **See also** **applicationName** , **organizationName** , and
        **organizationDomain** .
        """
        ...

    def event(self, a0: "QEvent") -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#event

        **[override virtual protected] bool QCoreApplication::event(QEvent * e
        )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    @staticmethod
    def quit() -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#quit

        **[static slot] void QCoreApplication::quit()**

        Tells the application to exit with return code 0 (success). Equivalent
        to calling **QCoreApplication::exit** (0).

        It's common to connect the **QGuiApplication::lastWindowClosed** ()
        signal to quit(), and you also often connect e.g.
        **QAbstractButton::clicked** () or signals in **QAction** , **QMenu** ,
        or **QMenuBar**  to it.

        It's good practice to always connect signals to this slot using a
        **QueuedConnection** . If a signal connected (non-queued) to this slot
        is emitted before control enters the main event loop (such as before
        "int main" calls **exec()** ), the slot has no effect and the
        application never exits. Using a queued connection ensures that the slot
        will not be invoked until after control enters the main event loop.

        Example:

        **QPushButton**  *quitButton = new **QPushButton** ("Quit");
        connect(quitButton, &**QPushButton** ::clicked, &app,
        &**QCoreApplication** ::quit, Qt::QueuedConnection);

        **See also** **exit** (), **aboutToQuit** (), and
        **QGuiApplication::lastWindowClosed** ().
        """
        ...

    @staticmethod
    def testAttribute(attribute: Qt.ApplicationAttribute) -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#testAttribute

        **[static] bool QCoreApplication::testAttribute(Qt::ApplicationAttribute
        attribute )**

        Returns `true` if attribute **attribute** is set; otherwise returns
        `false`.

        **See also** **setAttribute** ().
        """
        ...

    @staticmethod
    def setAttribute(attribute: Qt.ApplicationAttribute, on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#setAttribute

        **[static] void QCoreApplication::setAttribute(Qt::ApplicationAttribute
        attribute , bool on = true)**

        Sets the attribute **attribute** if **on** is true; otherwise clears the
        attribute.

        **Note:** Some application attributes must be set **before** creating a
        **QCoreApplication**  instance. Refer to the
        **Qt::ApplicationAttribute**  documentation for more information.

        **See also** **testAttribute** ().
        """
        ...

    @staticmethod
    def flush() -> None:
        ...

    @staticmethod
    def translate(
        context: str,
        sourceText: str,
        disambiguation: typing.Optional[str] = ...,
        n: int = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#translate

        **[static] QString QCoreApplication::translate(const char * context ,
        const char * sourceText , const char * disambiguation = nullptr, int n =
        -1)**

        Returns the translation text for **sourceText** , by querying the
        installed translation files. The translation files are searched from the
        most recently installed file back to the first installed file.

        **QObject::tr** () provides this functionality more conveniently.

        **context** is typically a class name (e.g., "MyDialog") and
        **sourceText** is either English text or a short identifying text.

        **disambiguation** is an identifying string, for when the same
        **sourceText** is used in different roles within the same context. By
        default, it is `nullptr`.

        See the **QTranslator**  and **QObject::tr** () documentation for more
        information about contexts, disambiguations and comments.

        **n** is used in conjunction with `%n` to support plural forms. See
        **QObject::tr** () for details.

        If none of the translation files contain a translation for
        **sourceText** in **context** , this function returns a **QString**
        equivalent of **sourceText**.

        This function is not virtual. You can use alternative translation
        techniques by subclassing **QTranslator** .

        **Note:** This function is **thread-safe** .

        **See also** **QObject::tr** (), **installTranslator** (),
        **removeTranslator** (), and translate().
        """
        ...

    @staticmethod
    def removeTranslator(messageFile: "QTranslator") -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#removeTranslator

        **[static] bool QCoreApplication::removeTranslator(QTranslator *
        translationFile )**

        Removes the translation file **translationFile** from the list of
        translation files used by this application. (It does not delete the
        translation file from the file system.)

        The function returns `true` on success and false on failure.

        **See also** **installTranslator** (), **translate** (), and
        **QObject::tr** ().
        """
        ...

    @staticmethod
    def installTranslator(messageFile: "QTranslator") -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#installTranslator

        **[static] bool QCoreApplication::installTranslator(QTranslator *
        translationFile )**

        Adds the translation file **translationFile** to the list of translation
        files to be used for translations.

        Multiple translation files can be installed. Translations are searched
        for in the reverse order in which they were installed, so the most
        recently installed translation file is searched first and the first
        translation file installed is searched last. The search stops as soon as
        a translation containing a matching string is found.

        Installing or removing a **QTranslator** , or changing an installed
        **QTranslator**  generates a **LanguageChange**  event for the
        **QCoreApplication**  instance. A **QApplication**  instance will
        propagate the event to all toplevel widgets, where a reimplementation of
        changeEvent can re-translate the user interface by passing user-visible
        strings via the **tr** () function to the respective property setters.
        User-interface classes generated by Qt Designer provide a
        `retranslateUi()` function that can be called.

        The function returns `true` on success and false on failure.

        **See also** **removeTranslator** (), **translate** (),
        **QTranslator::load** (), and **Dynamic Translation** .
        """
        ...

    @staticmethod
    def removeLibraryPath(a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#removeLibraryPath

        **[static] void QCoreApplication::removeLibraryPath(const QString & path
        )**

        Removes **path** from the library path list. If **path** is empty or not
        in the path list, the list is not changed.

        The library paths are reset to the default when an instance of
        **QCoreApplication**  is destructed.

        **See also** **addLibraryPath** (), **libraryPaths** (), and
        **setLibraryPaths** ().
        """
        ...

    @staticmethod
    def addLibraryPath(a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#addLibraryPath

        **[static] void QCoreApplication::addLibraryPath(const QString & path
        )**

        Prepends **path** to the beginning of the library path list, ensuring
        that it is searched for libraries first. If **path** is empty or already
        in the path list, the path list is not changed.

        The default path list consists of a single entry, the installation
        directory for plugins. The default installation directory for plugins is
        `INSTALL/plugins`, where `INSTALL` is the directory where Qt was
        installed.

        The library paths are reset to the default when an instance of
        **QCoreApplication**  is destructed.

        **See also** **removeLibraryPath** (), **libraryPaths** (), and
        **setLibraryPaths** ().
        """
        ...

    @staticmethod
    def libraryPaths() -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#libraryPaths

        **[static] QStringList QCoreApplication::libraryPaths()**

        Returns a list of paths that the application will search when
        dynamically loading libraries.

        The return value of this function may change when a **QCoreApplication**
        is created. It is not recommended to call it before creating a
        **QCoreApplication** . The directory of the application executable (
        **not** the working directory) is part of the list if it is known. In
        order to make it known a **QCoreApplication**  has to be constructed as
        it will use `argv[0]` to find it.

        Qt provides default library paths, but they can also be set using a
        **qt.conf**  file. Paths specified in this file will override default
        values. Note that if the qt.conf file is in the directory of the
        application executable, it may not be found until a **QCoreApplication**
        is created. If it is not found when calling this function, the default
        library paths will be used.

        The list will include the installation directory for plugins if it
        exists (the default installation directory for plugins is
        `INSTALL/plugins`, where `INSTALL` is the directory where Qt was
        installed). The colon separated entries of the `QT_PLUGIN_PATH`
        environment variable are always added. The plugin installation directory
        (and its existence) may change when the directory of the application
        executable becomes known.

        If you want to iterate over the list, you can use the **foreach**
        pseudo-keyword:

        foreach (const **QString**  &path, app.libraryPaths())
        do_something(path);

        **See also** **setLibraryPaths** (), **addLibraryPath** (),
        **removeLibraryPath** (), **QLibrary** , and **How to Create Qt
        Plugins** .
        """
        ...

    @staticmethod
    def setLibraryPaths(a0: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#setLibraryPaths

        **[static] void QCoreApplication::setLibraryPaths(const QStringList &
        paths )**

        Sets the list of directories to search when loading libraries to
        **paths**. All existing paths will be deleted and the path list will
        consist of the paths given in **paths**.

        The library paths are reset to the default when an instance of
        **QCoreApplication**  is destructed.

        **See also** **libraryPaths** (), **addLibraryPath** (),
        **removeLibraryPath** (), and **QLibrary** .
        """
        ...

    @staticmethod
    def applicationFilePath() -> str:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#applicationFilePath

        **[static] QString QCoreApplication::applicationFilePath()**

        Returns the file path of the application executable.

        For example, if you have installed Qt in the `/usr/local/qt` directory,
        and you run the `regexp` example, this function will return
        "/usr/local/qt/examples/tools/regexp/regexp".

        **Warning:** On Linux, this function will try to get the path from the
        `/proc` file system. If that fails, it assumes that `argv[0]` contains
        the absolute file name of the executable. The function also assumes that
        the current directory has not been changed by the application.

        **See also** **applicationDirPath** ().
        """
        ...

    @staticmethod
    def applicationDirPath() -> str:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#applicationDirPath

        **[static] QString QCoreApplication::applicationDirPath()**

        Returns the directory that contains the application executable.

        For example, if you have installed Qt in the `C:\\Qt` directory, and you
        run the `regexp` example, this function will return
        "C:/Qt/examples/tools/regexp".

        On macOS and iOS this will point to the directory actually containing
        the executable, which may be inside an application bundle (if the
        application is bundled).

        **Warning:** On Linux, this function will try to get the path from the
        `/proc` file system. If that fails, it assumes that `argv[0]` contains
        the absolute file name of the executable. The function also assumes that
        the current directory has not been changed by the application.

        **See also** **applicationFilePath** ().
        """
        ...

    @staticmethod
    def closingDown() -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#closingDown

        **[static] bool QCoreApplication::closingDown()**

        Returns `true` if the application objects are being destroyed; otherwise
        returns `false`.

        **See also** **startingUp** ().
        """
        ...

    @staticmethod
    def startingUp() -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#startingUp

        **[static] bool QCoreApplication::startingUp()**

        Returns `true` if an application object has not been created yet;
        otherwise returns `false`.

        **See also** **closingDown** ().
        """
        ...

    def notify(self, a0: QObject, a1: "QEvent") -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#notify

        **[virtual] bool QCoreApplication::notify(QObject * receiver , QEvent *
        event )**

        Sends **event** to **receiver** : **receiver** ->event( **event** ).
        Returns the value that is returned from the receiver's event handler.
        Note that this function is called for all events sent to any object in
        any thread.

        For certain types of events (e.g. mouse and key events), the event will
        be propagated to the receiver's parent and so on up to the top-level
        object if the receiver is not interested in the event (i.e., it returns
        `false`).

        There are five different ways that events can be processed;
        reimplementing this virtual function is just one of them. All five
        approaches are listed below:

        1. Reimplementing **paintEvent()** , **mousePressEvent()**  and so on.
        This is the most common, easiest, and least powerful way.
          2.
        Reimplementing this function. This is very powerful, providing complete
        control; but only one subclass can be active at a time.
          3. Installing
        an event filter on **QCoreApplication::instance** (). Such an event
        filter is able to process all events for all widgets, so it's just as
        powerful as reimplementing notify(); furthermore, it's possible to have
        more than one application-global event filter. Global event filters even
        see mouse events for **disabled widgets** . Note that application event
        filters are only called for objects that live in the main thread.
          4.
        Reimplementing **QObject::event** () (as **QWidget**  does). If you do
        this you get Tab key presses, and you get to see the events before any
        widget-specific event filters.
          5. Installing an event filter on the
        object. Such an event filter gets all the events, including Tab and
        Shift+Tab key press events, as long as they do not change the focus
        widget.

        **Future direction:** This function will not be called for objects that
        live outside the main thread in Qt 6. Applications that need that
        functionality should find other solutions for their event inspection
        needs in the meantime. The change may be extended to the main thread,
        causing this function to be deprecated.

        **Warning:** If you override this function, you must ensure all threads
        that process events stop doing so before your application object begins
        destruction. This includes threads started by other libraries that you
        may be using, but does not apply to Qt's own threads.

        **See also** **QObject::event** () and **installNativeEventFilter** ().
        """
        ...

    @staticmethod
    def hasPendingEvents() -> bool:
        ...

    @staticmethod
    def removePostedEvents(receiver: QObject, eventType: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#removePostedEvents

        **[static] void QCoreApplication::removePostedEvents(QObject * receiver
        , int eventType = 0)**

        Removes all events of the given **eventType** that were posted using
        **postEvent** () for **receiver**.

        The events are **not** dispatched, instead they are removed from the
        queue. You should never need to call this function. If you do call it,
        be aware that killing events may cause **receiver** to break one or more
        invariants.

        If **receiver** is `nullptr`, the events of **eventType** are removed
        for all objects. If **eventType** is 0, all the events are removed for
        **receiver**. You should never call this function with **eventType** of
        0.

        **Note:** This function is **thread-safe** .

        This function was introduced in Qt 4.3.
        """
        ...

    @staticmethod
    def sendPostedEvents(
        receiver: typing.Optional[QObject] = ..., eventType: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#sendPostedEvents

        **[static] void QCoreApplication::sendPostedEvents(QObject * receiver =
        nullptr, int event_type = 0)**

        Immediately dispatches all events which have been previously queued with
        **QCoreApplication::postEvent** () and which are for the object
        **receiver** and have the event type **event_type**.

        Events from the window system are **not** dispatched by this function,
        but by **processEvents** ().

        If **receiver** is `nullptr`, the events of **event_type** are sent for
        all objects. If **event_type** is 0, all the events are sent for
        **receiver**.

        **Note:** This method must be called from the thread in which its
        **QObject**  parameter, **receiver** , lives.

        **See also** **flush** () and **postEvent** ().
        """
        ...

    @staticmethod
    def postEvent(receiver: QObject, event: "QEvent", priority: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#postEvent

        **[static] void QCoreApplication::postEvent(QObject * receiver , QEvent
        * event , int priority = Qt::NormalEventPriority)**

        Adds the event **event** , with the object **receiver** as the receiver
        of the event, to an event queue and returns immediately.

        The event must be allocated on the heap since the post event queue will
        take ownership of the event and delete it once it has been posted. It is
        **not safe** to access the event after it has been posted.

        When control returns to the main event loop, all events that are stored
        in the queue will be sent using the **notify** () function.

        Events are sorted in descending **priority** order, i.e. events with a
        high **priority** are queued before events with a lower **priority**.
        The **priority** can be any integer value, i.e. between INT_MAX and
        INT_MIN, inclusive; see **Qt::EventPriority**  for more details. Events
        with equal **priority** will be processed in the order posted.

        **Note:** This function is **thread-safe** .

        This function was introduced in Qt 4.3.

        **See also** **sendEvent** (), **notify** (), **sendPostedEvents** (),
        and **Qt::EventPriority** .
        """
        ...

    @staticmethod
    def sendEvent(receiver: QObject, event: "QEvent") -> bool:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#sendEvent

        **[static] bool QCoreApplication::sendEvent(QObject * receiver , QEvent
        * event )**

        Sends event **event** directly to receiver **receiver** , using the
        **notify** () function. Returns the value that was returned from the
        event handler.

        The event is **not** deleted when the event has been sent. The normal
        approach is to create the event on the stack, for example:

        **QMouseEvent**  event(**QEvent** ::MouseButtonPress, pos, 0, 0, 0);
        **QApplication** ::sendEvent(mainWindow, &event);

        **See also** **postEvent** () and **notify** ().
        """
        ...

    @staticmethod
    def exit(returnCode: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#exit

        **[static] void QCoreApplication::exit(int returnCode = 0)**

        Tells the application to exit with a return code.

        After this function has been called, the application leaves the main
        event loop and returns from the call to **exec** (). The **exec** ()
        function returns **returnCode**. If the event loop is not running, this
        function does nothing.

        By convention, a **returnCode** of 0 means success, and any non-zero
        value indicates an error.

        It's good practice to always connect signals to this slot using a
        **QueuedConnection** . If a signal connected (non-queued) to this slot
        is emitted before control enters the main event loop (such as before
        "int main" calls **exec()** ), the slot has no effect and the
        application never exits. Using a queued connection ensures that the slot
        will not be invoked until after control enters the main event loop.

        Note that unlike the C library function of the same name, this function
        **does** return to the caller -- it is event processing that stops.

        **See also** **quit** () and **exec** ().
        """
        ...

    @typing.overload
    @staticmethod
    def processEvents(
        flags: typing.Union[
            "QEventLoop.ProcessEventsFlags", "QEventLoop.ProcessEventsFlag"
        ] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#processEvents

        **[static] void
        QCoreApplication::processEvents(QEventLoop::ProcessEventsFlags flags =
        QEventLoop::AllEvents)**

        Processes all pending events for the calling thread according to the
        specified **flags** until there are no more events to process.

        You can call this function occasionally when your program is busy
        performing a long operation (e.g. copying a file).

        In the event that you are running a local loop which calls this function
        continuously, without an event loop, the **DeferredDelete**  events will
        not be processed. This can affect the behaviour of widgets, e.g.
        **QToolTip** , that rely on **DeferredDelete**  events to function
        properly. An alternative would be to call **sendPostedEvents()**  from
        within that local loop.

        Calling this function processes events only for the calling thread, and
        returns after all available events have been processed. Available events
        are events queued before the function call. This means that events that
        are posted while the function runs will be queued until a later round of
        event processing.

        **Note:** This function is **thread-safe** .

        **See also** **exec** (), **QTimer** , **QEventLoop::processEvents** (),
        **flush** (), and **sendPostedEvents** ().
        """
        ...

    @typing.overload
    @staticmethod
    def processEvents(
        flags: typing.Union[
            "QEventLoop.ProcessEventsFlags", "QEventLoop.ProcessEventsFlag"
        ],
        maxtime: int,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#processEvents-1

        **[static] void
        QCoreApplication::processEvents(QEventLoop::ProcessEventsFlags flags ,
        int ms )**

        This function overloads processEvents().

        Processes pending events for the calling thread for **ms** milliseconds
        or until there are no more events to process, whichever is shorter.

        You can call this function occasionally when your program is busy doing
        a long operation (e.g. copying a file).

        Calling this function processes events only for the calling thread.

        **Note:** Unlike the **processEvents()**  overload, this function also
        processes events that are posted while the function runs.

        **Note:** This function is **thread-safe** .

        **See also** **exec** (), **QTimer** , and **QEventLoop::processEvents**
        ().
        """
        ...

    @staticmethod
    def exec() -> int:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#exec

        **[static] int QCoreApplication::exec()**

        Enters the main event loop and waits until **exit** () is called.
        Returns the value that was passed to **exit** () (which is 0 if **exit**
        () is called via **quit** ()).

        It is necessary to call this function to start event handling. The main
        event loop receives events from the window system and dispatches these
        to the application widgets.

        To make your application perform idle processing (by executing a special
        function whenever there are no pending events), use a **QTimer**  with 0
        timeout. More advanced idle processing schemes can be achieved using
        **processEvents** ().

        We recommend that you connect clean-up code to the **aboutToQuit()**
        signal, instead of putting it in your application's `main()` function
        because on some platforms the exec() call may not return. For example,
        on Windows when the user logs off, the system terminates the process
        after Qt closes all top-level windows. Hence, there is no guarantee that
        the application will have time to exit its event loop and execute code
        at the end of the `main()` function after the exec() call.

        **See also** **quit** (), **exit** (), **processEvents** (), and
        **QApplication::exec** ().
        """
        ...

    @staticmethod
    def exec_() -> int:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#exec

        **[static] int QCoreApplication::exec()**

        Enters the main event loop and waits until **exit** () is called.
        Returns the value that was passed to **exit** () (which is 0 if **exit**
        () is called via **quit** ()).

        It is necessary to call this function to start event handling. The main
        event loop receives events from the window system and dispatches these
        to the application widgets.

        To make your application perform idle processing (by executing a special
        function whenever there are no pending events), use a **QTimer**  with 0
        timeout. More advanced idle processing schemes can be achieved using
        **processEvents** ().

        We recommend that you connect clean-up code to the **aboutToQuit()**
        signal, instead of putting it in your application's `main()` function
        because on some platforms the exec() call may not return. For example,
        on Windows when the user logs off, the system terminates the process
        after Qt closes all top-level windows. Hence, there is no guarantee that
        the application will have time to exit its event loop and execute code
        at the end of the `main()` function after the exec() call.

        **See also** **quit** (), **exit** (), **processEvents** (), and
        **QApplication::exec** ().
        """
        ...

    @staticmethod
    def instance() -> "QCoreApplication":
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#instance

        **[static] QCoreApplication *QCoreApplication::instance()**

        Returns a pointer to the application's **QCoreApplication**  (or
        **QGuiApplication** /**QApplication** ) instance.

        If no instance has been allocated, `nullptr` is returned.
        """
        ...

    @staticmethod
    def arguments() -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#arguments

        **[static] QStringList QCoreApplication::arguments()**

        Returns the list of command-line arguments.

        Usually arguments().at(0) is the program name, arguments().at(1) is the
        first argument, and arguments().last() is the last argument. See the
        note below about Windows.

        Calling this function is slow - you should store the result in a
        variable when parsing the command line.

        **Warning:** On Unix, this list is built from the argc and argv
        parameters passed to the constructor in the main() function. The string-
        data in argv is interpreted using **QString::fromLocal8Bit** (); hence
        it is not possible to pass, for example, Japanese command line arguments
        on a system that runs in a Latin1 locale. Most modern Unix systems do
        not have this limitation, as they are Unicode-based.

        On Windows, the list is built from the argc and argv parameters only if
        modified argv/argc parameters are passed to the constructor. In that
        case, encoding problems might occur.

        Otherwise, the arguments() are constructed from the return value of
        **GetCommandLine()** . As a result of this, the string given by
        arguments().at(0) might not be the program name on Windows, depending on
        how the application was started.

        This function was introduced in Qt 4.1.

        **See also** **applicationFilePath** () and **QCommandLineParser** .
        """
        ...

    @staticmethod
    def applicationName() -> str:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#applicationName-prop

        **applicationName : QString**

        This property holds the name of this application

        The value is used by the **QSettings**  class when it is constructed
        using the empty constructor. This saves having to repeat this
        information each time a **QSettings**  object is created.

        If not set, the application name defaults to the executable name (since
        5.0).

        **Access functions:**

        QString **applicationName** ()
        void **setApplicationName** (const
        QString & **application** )

        **Notifier signal:**

        void **applicationNameChanged** ()

        **See also** **organizationName** , **organizationDomain** ,
        **applicationVersion** , and **applicationFilePath** ().
        """
        ...

    @staticmethod
    def setApplicationName(application: str) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#applicationName-prop

        **applicationName : QString**

        This property holds the name of this application

        The value is used by the **QSettings**  class when it is constructed
        using the empty constructor. This saves having to repeat this
        information each time a **QSettings**  object is created.

        If not set, the application name defaults to the executable name (since
        5.0).

        **Access functions:**

        QString **applicationName** ()
        void **setApplicationName** (const
        QString & **application** )

        **Notifier signal:**

        void **applicationNameChanged** ()

        **See also** **organizationName** , **organizationDomain** ,
        **applicationVersion** , and **applicationFilePath** ().
        """
        ...

    @staticmethod
    def organizationName() -> str:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#organizationName-prop

        **organizationName : QString**

        This property holds the name of the organization that wrote this
        application

        The value is used by the **QSettings**  class when it is constructed
        using the empty constructor. This saves having to repeat this
        information each time a **QSettings**  object is created.

        On Mac, **QSettings**  uses **organizationDomain()**  as the
        organization if it's not an empty string; otherwise it uses
        organizationName(). On all other platforms, **QSettings**  uses
        organizationName() as the organization.

        **Access functions:**

        QString **organizationName** ()
        void **setOrganizationName** (const
        QString & **orgName** )

        **Notifier signal:**

        void **organizationNameChanged** ()

        **See also** **organizationDomain**  and **applicationName** .
        """
        ...

    @staticmethod
    def setOrganizationName(orgName: str) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#organizationName-prop

        **organizationName : QString**

        This property holds the name of the organization that wrote this
        application

        The value is used by the **QSettings**  class when it is constructed
        using the empty constructor. This saves having to repeat this
        information each time a **QSettings**  object is created.

        On Mac, **QSettings**  uses **organizationDomain()**  as the
        organization if it's not an empty string; otherwise it uses
        organizationName(). On all other platforms, **QSettings**  uses
        organizationName() as the organization.

        **Access functions:**

        QString **organizationName** ()
        void **setOrganizationName** (const
        QString & **orgName** )

        **Notifier signal:**

        void **organizationNameChanged** ()

        **See also** **organizationDomain**  and **applicationName** .
        """
        ...

    @staticmethod
    def organizationDomain() -> str:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#organizationDomain-prop

        **organizationDomain : QString**

        This property holds the Internet domain of the organization that wrote
        this application

        The value is used by the **QSettings**  class when it is constructed
        using the empty constructor. This saves having to repeat this
        information each time a **QSettings**  object is created.

        On Mac, **QSettings**  uses organizationDomain() as the organization if
        it's not an empty string; otherwise it uses **organizationName** (). On
        all other platforms, **QSettings**  uses **organizationName** () as the
        organization.

        **Access functions:**

        QString **organizationDomain** ()
        void **setOrganizationDomain**
        (const QString & **orgDomain** )

        **Notifier signal:**

        void **organizationDomainChanged** ()

        **See also** **organizationName** , **applicationName** , and
        **applicationVersion** .
        """
        ...

    @staticmethod
    def setOrganizationDomain(orgDomain: str) -> None:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#organizationDomain-prop

        **organizationDomain : QString**

        This property holds the Internet domain of the organization that wrote
        this application

        The value is used by the **QSettings**  class when it is constructed
        using the empty constructor. This saves having to repeat this
        information each time a **QSettings**  object is created.

        On Mac, **QSettings**  uses organizationDomain() as the organization if
        it's not an empty string; otherwise it uses **organizationName** (). On
        all other platforms, **QSettings**  uses **organizationName** () as the
        organization.

        **Access functions:**

        QString **organizationDomain** ()
        void **setOrganizationDomain**
        (const QString & **orgDomain** )

        **Notifier signal:**

        void **organizationDomainChanged** ()

        **See also** **organizationName** , **applicationName** , and
        **applicationVersion** .
        """
        ...

    @property
    def aboutToQuit(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcoreapplication.html#aboutToQuit

        **[signal] void QCoreApplication::aboutToQuit()**

        This signal is emitted when the application is about to quit the main
        event loop, e.g. when the event loop level drops to zero. This may
        happen either after a call to **quit** () from inside the application or
        when the user shuts down the entire desktop session.

        The signal is particularly useful if your application has to do some
        last-second cleanup. Note that no user interaction is possible in this
        state.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **quit** ().
        """
        ...

    @property
    def applicationNameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def applicationVersionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def organizationDomainChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def organizationNameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
