"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QCommandLineParser(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcommandlineparser.html

    **Detailed Description**

    **QCoreApplication**  provides the command-line arguments as a simple list
    of strings. QCommandLineParser provides the ability to define a set of
    options, parse the command-line arguments, and store which options have
    actually been used, as well as option values.

    Any argument that isn't an option (i.e. doesn't start with a `-`) is stored
    as a "positional argument".

    The parser handles short names, long names, more than one name for the same
    option, and option values.

    Options on the command line are recognized as starting with a single or
    double `-` character(s). The option `-` (single dash alone) is a special
    case, often meaning standard input, and not treated as an option. The parser
    will treat everything after the option `--` (double dash) as positional
    arguments.

    Short options are single letters. The option `v` would be specified by
    passing `-v` on the command line. In the default parsing mode, short options
    can be written in a compact form, for instance `-abc` is equivalent to `-a
    -b -c`. The parsing mode for can be set to **ParseAsLongOptions** , in which
    case `-abc` will be parsed as the long option `abc`.

    Long options are more than one letter long and cannot be compacted together.
    The long option `verbose` would be passed as `--verbose` or `-verbose`.

    Passing values to options can be done using the assignment operator:
    `-v=value` `--verbose=value`, or a space: `-v value` `--verbose value`, i.e.
    the next argument is used as value (even if it starts with a `-`).

    The parser does not support optional values - if an option is set to require
    a value, one must be present. If such an option is placed last and has no
    value, the option will be treated as if it had not been specified.

    The parser does not automatically support negating or disabling long options
    by using the format `--disable-option` or `--no-option`. However, it is
    possible to handle this case explicitly by making an option with `no-option`
    as one of its names, and handling the option explicitly.

    Example:

    int main(int argc, char *argv[])
        {
            **QCoreApplication**
    app(argc, argv);
            **QCoreApplication** ::setApplicationName("my-copy-
    program");
            **QCoreApplication** ::setApplicationVersion("1.0");
    **QCommandLineParser**  parser;
    parser.setApplicationDescription("Test helper");
    parser.addHelpOption();
            parser.addVersionOption();
    parser.addPositionalArgument("source", **QCoreApplication**
    ::translate("main", "Source file to copy."));
    parser.addPositionalArgument("destination", **QCoreApplication**
    ::translate("main", "Destination directory."));

            // A boolean
    option with a single name (-p)
            **QCommandLineOption**
    showProgressOption("p", **QCoreApplication** ::translate("main", "Show
    progress during copy"));
            parser.addOption(showProgressOption);
    // A boolean option with multiple names (-f, --force)
    **QCommandLineOption**  forceOption(**QStringList** () << "f" << "force",
    **QCoreApplication** ::translate("main", "Overwrite existing files."));
    parser.addOption(forceOption);

            // An option with a value
    **QCommandLineOption**  targetDirectoryOption(**QStringList** () << "t" <<
    "target-directory",
                    **QCoreApplication** ::translate("main",
    "Copy all source files into <directory>."),
    **QCoreApplication** ::translate("main", "directory"));
    parser.addOption(targetDirectoryOption);

            // Process the actual
    command line arguments given by the user
            parser.process(app);
    const **QStringList**  args = parser.positionalArguments();
            //
    source is args.at(0), destination is args.at(1)

            bool
    showProgress = parser.isSet(showProgressOption);
            bool force =
    parser.isSet(forceOption);
            **QString**  targetDir =
    parser.value(targetDirectoryOption);
            // ...
        }

    If your compiler supports the C++11 standard, the three **addOption** ()
    calls in the above example can be simplified:

    parser.addOptions({
                // A boolean option with a single name (-p)
    {"p",
                    **QCoreApplication** ::translate("main", "Show
    progress during copy")},
                // A boolean option with multiple names
    (-f, --force)
                {{"f", "force"},
    **QCoreApplication** ::translate("main", "Overwrite existing files.")},
    // An option with a value
                {{"t", "target-directory"},
    **QCoreApplication** ::translate("main", "Copy all source files into
    <directory>."),
                    **QCoreApplication** ::translate("main",
    "directory")},
            });

    Known limitation: the parsing of Qt options inside **QCoreApplication**  and
    subclasses happens before QCommandLineParser exists, so it can't take it
    into account. This means any option value that looks like a builtin Qt
    option, will be treated by **QCoreApplication**  as a builtin Qt option.
    Example: `--profile -reverse` will lead to **QGuiApplication**  seeing the
    -reverse option set, and removing it from **QCoreApplication::arguments** ()
    before QCommandLineParser defines the `profile` option and parses the
    command line.

    **How to Use QCommandLineParser in Complex Applications**

    In practice, additional error checking needs to be performed on the
    positional arguments and option values. For example, ranges of numbers
    should be checked.

    It is then advisable to introduce a function to do the command line parsing
    which takes a struct or class receiving the option values returning an
    enumeration representing the result. The dnslookup example of the
    **QtNetwork**  module illustrates this:

    struct DnsQuery
        {
            DnsQuery() : type(**QDnsLookup** ::A) {}
    **QDnsLookup** ::Type type;
            **QHostAddress**  nameServer;
    **QString**  name;
        };

        enum CommandLineParseResult
        {
    CommandLineOk,
            CommandLineError,
    CommandLineVersionRequested,
            CommandLineHelpRequested
        };
    CommandLineParseResult parseCommandLine(**QCommandLineParser**  &parser,
    DnsQuery *query, **QString**  *errorMessage)
        {
    parser.setSingleDashWordOptionMode(**QCommandLineParser**
    ::ParseAsLongOptions);
            const **QCommandLineOption**
    nameServerOption("n", "The name server to use.", "nameserver");
    parser.addOption(nameServerOption);
            const **QCommandLineOption**
    typeOption("t", "The lookup type.", "type");
    parser.addOption(typeOption);
            parser.addPositionalArgument("name",
    "The name to look up.");
            const **QCommandLineOption**  helpOption =
    parser.addHelpOption();
            const **QCommandLineOption**  versionOption
    = parser.addVersionOption();

            if
    (!parser.parse(**QCoreApplication** ::arguments())) {
    *errorMessage = parser.errorText();
                return CommandLineError;
    }

            if (parser.isSet(versionOption))
                return
    CommandLineVersionRequested;

            if (parser.isSet(helpOption))
    return CommandLineHelpRequested;

            if
    (parser.isSet(nameServerOption)) {
                const **QString**  nameserver
    = parser.value(nameServerOption);
                query->nameServer =
    **QHostAddress** (nameserver);
                if (query->nameServer.isNull() ||
    query->nameServer.protocol() == **QAbstractSocket**
    ::UnknownNetworkLayerProtocol) {
                    *errorMessage = "Bad
    nameserver address: " + nameserver;
                    return CommandLineError;
    }
            }

            if (parser.isSet(typeOption)) {
                const
    **QString**  typeParameter = parser.value(typeOption);
                const int
    type = typeFromParameter(typeParameter.toLower());
                if (type < 0)
    {
                    *errorMessage = "Bad record type: " + typeParameter;
    return CommandLineError;
                }
                query->type =
    static_cast<**QDnsLookup** ::Type>(type);
            }

            const
    **QStringList**  positionalArguments = parser.positionalArguments();
    if (positionalArguments.isEmpty()) {
                *errorMessage = "Argument
    'name' missing.";
                return CommandLineError;
            }
            if
    (positionalArguments.size() > 1) {
                *errorMessage = "Several
    'name' arguments specified.";
                return CommandLineError;
            }
    query->name = positionalArguments.first();

            return
    CommandLineOk;
        }

    In the main function, help should be printed to the standard output if the
    help option was passed and the application should return the exit code 0.

    If an error was detected, the error message should be printed to the
    standard error output and the application should return an exit code other
    than 0.

    **QCoreApplication** ::setApplicationVersion(QT_VERSION_STR);
    **QCoreApplication** ::setApplicationName(**QCoreApplication**
    ::translate("QDnsLookupExample", "DNS Lookup Example"));
    **QCommandLineParser**  parser;
    parser.setApplicationDescription(**QCoreApplication**
    ::translate("QDnsLookupExample", "An example demonstrating the class
    QDnsLookup."));
            DnsQuery query;
            **QString**  errorMessage;
    switch (parseCommandLine(parser, &query, &errorMessage)) {
            case
    CommandLineOk:
                break;
            case CommandLineError:
    fputs(**qPrintable** (errorMessage), stderr);
                fputs("\\n\\n",
    stderr);
                fputs(**qPrintable** (parser.helpText()), stderr);
    return 1;
            case CommandLineVersionRequested:
                printf("%s
    %s\\n", **qPrintable** (**QCoreApplication** ::applicationName()),
    **qPrintable** (**QCoreApplication** ::applicationVersion()));
    return 0;
            case CommandLineHelpRequested:
    parser.showHelp();
                Q_UNREACHABLE();
            }

    A special case to consider here are GUI applications on Windows and mobile
    platforms. These applications may not use the standard output or error
    channels since the output is either discarded or not accessible.

    On Windows, QCommandLineParser uses message boxes to display usage
    information and errors if no console window can be obtained.

    For other platforms, it is recommended to display help texts and error
    messages using a **QMessageBox** . To preserve the formatting of the help
    text, rich text with `<pre>` elements should be used:

    switch (parseCommandLine(parser, &query, &errorMessage)) {
        case
    CommandLineOk:
            break;
        case CommandLineError:
    **QMessageBox** ::warning(0, **QGuiApplication** ::applicationDisplayName(),
    "<html><head/><body><h2>" + errorMessage + "</h2><pre>"
    + parser.helpText() + "</pre></body></html>");
            return 1;
        case
    CommandLineVersionRequested:
            **QMessageBox** ::information(0,
    **QGuiApplication** ::applicationDisplayName(),
    **QGuiApplication** ::applicationDisplayName() + ' '
    + **QCoreApplication** ::applicationVersion());
            return 0;
        case
    CommandLineHelpRequested:
            **QMessageBox** ::warning(0,
    **QGuiApplication** ::applicationDisplayName(),
    "<html><head/><body><pre>"
                                 + parser.helpText()
    + "</pre></body></html>");
            return 0;
        }

    However, this does not apply to the dnslookup example, because it is a
    console application.

    **See also** **QCommandLineOption**  and **QCoreApplication** .
    """

    class OptionsAfterPositionalArgumentsMode(int):
        ParseAsOptions: QCommandLineParser = ...
        ParseAsPositionalArguments: QCommandLineParser = ...

    class SingleDashWordOptionMode(int):
        ParseAsCompactedShortOptions: QCommandLineParser = ...
        ParseAsLongOptions: QCommandLineParser = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#QCommandLineParser

        **QCommandLineParser::QCommandLineParser()**

        Constructs a command line parser object.
        """
        ...

    def setOptionsAfterPositionalArgumentsMode(
        self, mode: "QCommandLineParser.OptionsAfterPositionalArgumentsMode"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#setOptionsAfterPositional
        ArgumentsMode

        **void QCommandLineParser::setOptionsAfterPositionalArgumentsMode(QComma
        ndLineParser::OptionsAfterPositionalArgumentsMode parsingMode )**

        Sets the parsing mode to **parsingMode**. This must be called before
        **process** () or **parse** ().

        This function was introduced in Qt 5.6.
        """
        ...

    def showVersion(self) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#showVersion

        **void QCommandLineParser::showVersion()**

        Displays the version information from
        **QCoreApplication::applicationVersion** (), and exits the application.
        This is automatically triggered by the --version option, but can also be
        used to display the version when not using **process** (). The exit code
        is set to EXIT_SUCCESS (0).

        This function was introduced in Qt 5.4.

        **See also** **addVersionOption** ().
        """
        ...

    def addOptions(self, options: typing.Iterable[QCommandLineOption]) -> bool:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#addOptions

        **bool QCommandLineParser::addOptions(const QList<QCommandLineOption> &
        options )**

        Adds the options to look for while parsing. The options are specified by
        the parameter **options**.

        Returns `true` if adding all of the options was successful; otherwise
        returns `false`.

        See the documentation for **addOption** () for when this function may
        fail.

        This function was introduced in Qt 5.4.
        """
        ...

    def helpText(self) -> str:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#helpText

        **QString QCommandLineParser::helpText() const**

        Returns a string containing the complete help information.

        **See also** **showHelp** ().
        """
        ...

    def showHelp(self, exitCode: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#showHelp

        **void QCommandLineParser::showHelp(int exitCode = 0)**

        Displays the help information, and exits the application. This is
        automatically triggered by the --help option, but can also be used to
        display the help when the user is not invoking the application
        correctly. The exit code is set to **exitCode**. It should be set to 0
        if the user requested to see the help, and to any other value in case of
        an error.

        **See also** **helpText** ().
        """
        ...

    def unknownOptionNames(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#unknownOptionNames

        **QStringList QCommandLineParser::unknownOptionNames() const**

        Returns a list of unknown option names.

        This list will include both long an short name options that were not
        recognized. For any long options that were in the form {--option=value},
        the value part will have been dropped and only the long name is added.

        The names in this list do not include the preceding dash characters.
        Names may appear more than once in this list if they were encountered
        more than once by the parser.

        **See also** **optionNames** ().
        """
        ...

    def optionNames(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#optionNames

        **QStringList QCommandLineParser::optionNames() const**

        Returns a list of option names that were found.

        This returns a list of all the recognized option names found by the
        parser, in the order in which they were found. For any long options that
        were in the form {--option=value}, the value part will have been
        dropped.

        The names in this list do not include the preceding dash characters.
        Names may appear more than once in this list if they were encountered
        more than once by the parser.

        Any entry in the list can be used with `value()` or with `values()` to
        get any relevant option values.
        """
        ...

    def positionalArguments(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#positionalArguments

        **QStringList QCommandLineParser::positionalArguments() const**

        Returns a list of positional arguments.

        These are all of the arguments that were not recognized as part of an
        option.
        """
        ...

    @typing.overload
    def values(self, name: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#values

        **QStringList QCommandLineParser::values(const QString & optionName )
        const**

        Returns a list of option values found for the given option name
        **optionName** , or an empty list if not found.

        The name provided can be any long or short name of any option that was
        added with `addOption()`. All the options names are treated as being
        equivalent. If the name is not recognized or that option was not
        present, an empty list is returned.

        For options found by the parser, the list will contain an entry for each
        time the option was encountered by the parser. If the option wasn't
        specified on the command line, the default values are returned.

        An empty list is returned if the option does not take a value.

        **See also** **value** (), **QCommandLineOption::setDefaultValue** (),
        and **QCommandLineOption::setDefaultValues** ().
        """
        ...

    @typing.overload
    def values(self, option: QCommandLineOption) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#values-1

        **QStringList QCommandLineParser::values(const QCommandLineOption &
        option ) const**

        This is an overloaded function.

        Returns a list of option values found for the given **option** , or an
        empty list if not found.

        For options found by the parser, the list will contain an entry for each
        time the option was encountered by the parser. If the option wasn't
        specified on the command line, the default values are returned.

        An empty list is returned if the option does not take a value.

        **See also** **value** (), **QCommandLineOption::setDefaultValue** (),
        and **QCommandLineOption::setDefaultValues** ().
        """
        ...

    @typing.overload
    def value(self, name: str) -> str:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#value

        **QString QCommandLineParser::value(const QString & optionName ) const**

        Returns the option value found for the given option name **optionName**
        , or an empty string if not found.

        The name provided can be any long or short name of any option that was
        added with `addOption()`. All the option names are treated as being
        equivalent. If the name is not recognized or that option was not
        present, an empty string is returned.

        For options found by the parser, the last value found for that option is
        returned. If the option wasn't specified on the command line, the
        default value is returned.

        An empty string is returned if the option does not take a value.

        **See also** **values** (), **QCommandLineOption::setDefaultValue** (),
        and **QCommandLineOption::setDefaultValues** ().
        """
        ...

    @typing.overload
    def value(self, option: QCommandLineOption) -> str:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#value-1

        **QString QCommandLineParser::value(const QCommandLineOption & option )
        const**

        This is an overloaded function.

        Returns the option value found for the given **option** , or an empty
        string if not found.

        For options found by the parser, the last value found for that option is
        returned. If the option wasn't specified on the command line, the
        default value is returned.

        An empty string is returned if the option does not take a value.

        **See also** **values** (), **QCommandLineOption::setDefaultValue** (),
        and **QCommandLineOption::setDefaultValues** ().
        """
        ...

    @typing.overload
    def isSet(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#isSet

        **bool QCommandLineParser::isSet(const QString & name ) const**

        Checks whether the option **name** was passed to the application.

        Returns `true` if the option **name** was set, false otherwise.

        The name provided can be any long or short name of any option that was
        added with `addOption()`. All the options names are treated as being
        equivalent. If the name is not recognized or that option was not
        present, false is returned.

        Example:

        bool verbose = parser.isSet("verbose");
        """
        ...

    @typing.overload
    def isSet(self, option: QCommandLineOption) -> bool:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#isSet-1

        **bool QCommandLineParser::isSet(const QCommandLineOption & option )
        const**

        This is an overloaded function.

        Checks whether the **option** was passed to the application.

        Returns `true` if the **option** was set, false otherwise.

        This is the recommended way to check for options with no values.

        Example:

        **QCoreApplication**  app(argc, argv);
            **QCommandLineParser**
        parser;
            **QCommandLineOption**  verboseOption("verbose");
        parser.addOption(verboseOption);
            parser.process(app);
            bool
        verbose = parser.isSet(verboseOption);
        """
        ...

    def errorText(self) -> str:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#errorText

        **QString QCommandLineParser::errorText() const**

        Returns a translated error text for the user. This should only be called
        when **parse** () returns `false`.
        """
        ...

    def parse(self, arguments: typing.Iterable[str]) -> bool:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#parse

        **bool QCommandLineParser::parse(const QStringList & arguments )**

        Parses the command line **arguments**.

        Most programs don't need to call this, a simple call to **process** ()
        is enough.

        parse() is more low-level, and only does the parsing. The application
        will have to take care of the error handling, using **errorText** () if
        parse() returns `false`. This can be useful for instance to show a
        graphical error message in graphical programs.

        Calling parse() instead of **process** () can also be useful in order to
        ignore unknown options temporarily, because more option definitions will
        be provided later on (depending on one of the arguments), before calling
        **process** ().

        Don't forget that **arguments** must start with the name of the
        executable (ignored, though).

        Returns `false` in case of a parse error (unknown option or missing
        value); returns `true` otherwise.

        **See also** **process** ().
        """
        ...

    @typing.overload
    def process(self, arguments: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#process

        **void QCommandLineParser::process(const QStringList & arguments )**

        Processes the command line **arguments**.

        In addition to parsing the options (like **parse** ()), this function
        also handles the builtin options and handles errors.

        The builtin options are `--version` if **addVersionOption**  was called
        and `--help` / `--help-all` if **addHelpOption**  was called.

        When invoking one of these options, or when an error happens (for
        instance an unknown option was passed), the current process will then
        stop, using the exit() function.

        **See also** **QCoreApplication::arguments** () and **parse** ().
        """
        ...

    @typing.overload
    def process(self, app: "QCoreApplication") -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#process-1

        **void QCommandLineParser::process(const QCoreApplication & app )**

        This is an overloaded function.

        The command line is obtained from the **QCoreApplication**  instance
        **app**.
        """
        ...

    def clearPositionalArguments(self) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#clearPositionalArguments

        **void QCommandLineParser::clearPositionalArguments()**

        Clears the definitions of additional arguments from the help text.

        This is only needed for the special case of tools which support multiple
        commands with different options. Once the actual command has been
        identified, the options for this command can be defined, and the help
        text for the command can be adjusted accordingly.

        Example:

        **QCoreApplication**  app(argc, argv);
            **QCommandLineParser**
        parser;

            parser.addPositionalArgument("command", "The command to
        execute.");

            // Call parse() to find out the positional
        arguments.
            parser.parse(**QCoreApplication** ::arguments());
        const **QStringList**  args = parser.positionalArguments();
            const
        **QString**  command = args.isEmpty() ? **QString** () : args.first();
        if (command == "resize") {
                parser.clearPositionalArguments();
        parser.addPositionalArgument("resize", "Resize the object to a new
        size.", "resize [resize_options]");
        parser.addOption(**QCommandLineOption** ("size", "New size.",
        "new_size"));
                parser.process(app);
                // ...
            }
        /*
            This code results in context-dependent help:

            $ tool
        --help
            Usage: tool command

            Arguments:
              command  The
        command to execute.

            $ tool resize --help
            Usage: tool resize
        [resize_options]

            Options:
              --size <size>  New size.
        Arguments:
              resize         Resize the object to a new size.
            */
        """
        ...

    def addPositionalArgument(
        self, name: str, description: str, syntax: str = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#addPositionalArgument

        **void QCommandLineParser::addPositionalArgument(const QString & name ,
        const QString & description , const QString & syntax = QString())**

        Defines an additional argument to the application, for the benefit of
        the help text.

        The argument **name** and **description** will appear under the
        `Arguments:` section of the help. If **syntax** is specified, it will be
        appended to the Usage line, otherwise the **name** will be appended.

        Example:

        // Usage: image-editor file
            //
            // Arguments:
            //   file
        The file to open.
            parser.addPositionalArgument("file",
        **QCoreApplication** ::translate("main", "The file to open."));
        // Usage: web-browser [urls...]
            //
            // Arguments:
            //   urls
        URLs to open, optionally.
            parser.addPositionalArgument("urls",
        **QCoreApplication** ::translate("main", "URLs to open, optionally."),
        "[urls...]");

            // Usage: cp source destination
            //
            //
        Arguments:
            //   source                Source file to copy.
            //
        destination           Destination directory.
        parser.addPositionalArgument("source", **QCoreApplication**
        ::translate("main", "Source file to copy."));
        parser.addPositionalArgument("destination", **QCoreApplication**
        ::translate("main", "Destination directory."));

        **See also** **addHelpOption** () and **helpText** ().
        """
        ...

    def applicationDescription(self) -> str:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#applicationDescription

        **QString QCommandLineParser::applicationDescription() const**

        Returns the application description set in **setApplicationDescription**
        ().

        **See also** **setApplicationDescription** ().
        """
        ...

    def setApplicationDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#setApplicationDescription

        **void QCommandLineParser::setApplicationDescription(const QString &
        description )**

        Sets the application **description** shown by **helpText** ().

        **See also** **applicationDescription** ().
        """
        ...

    def addHelpOption(self) -> QCommandLineOption:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#addHelpOption

        **QCommandLineOption QCommandLineParser::addHelpOption()**

        Adds the help option (`-h`, `--help` and `-?` on Windows) as well as an
        option `--help-all` to include Qt-specific options in the output.

        These options are handled automatically by **QCommandLineParser** .

        Remember to use **setApplicationDescription**  to set the application
        description, which will be displayed when this option is used.

        Example:

        int main(int argc, char *argv[])
            {
                **QCoreApplication**
        app(argc, argv);
                **QCoreApplication** ::setApplicationName("my-
        copy-program");
                **QCoreApplication**
        ::setApplicationVersion("1.0");

                **QCommandLineParser**
        parser;
                parser.setApplicationDescription("Test helper");
        parser.addHelpOption();
                parser.addVersionOption();
        parser.addPositionalArgument("source", **QCoreApplication**
        ::translate("main", "Source file to copy."));
        parser.addPositionalArgument("destination", **QCoreApplication**
        ::translate("main", "Destination directory."));

                // A
        boolean option with a single name (-p)
                **QCommandLineOption**
        showProgressOption("p", **QCoreApplication** ::translate("main", "Show
        progress during copy"));
                parser.addOption(showProgressOption);
        // A boolean option with multiple names (-f, --force)
        **QCommandLineOption**  forceOption(**QStringList** () << "f" <<
        "force",
                        **QCoreApplication** ::translate("main",
        "Overwrite existing files."));
                parser.addOption(forceOption);
        // An option with a value
                **QCommandLineOption**
        targetDirectoryOption(**QStringList** () << "t" << "target-directory",
        **QCoreApplication** ::translate("main", "Copy all source files into
        <directory>."),
                        **QCoreApplication** ::translate("main",
        "directory"));
                parser.addOption(targetDirectoryOption);
        // Process the actual command line arguments given by the user
        parser.process(app);

                const **QStringList**  args =
        parser.positionalArguments();
                // source is args.at(0),
        destination is args.at(1)

                bool showProgress =
        parser.isSet(showProgressOption);
                bool force =
        parser.isSet(forceOption);
                **QString**  targetDir =
        parser.value(targetDirectoryOption);
                // ...
            }

        Returns the option instance, which can be used to call **isSet** ().
        """
        ...

    def addVersionOption(self) -> QCommandLineOption:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#addVersionOption

        **QCommandLineOption QCommandLineParser::addVersionOption()**

        Adds the `-v` / `--version` option, which displays the version string of
        the application.

        This option is handled automatically by **QCommandLineParser** .

        You can set the actual version string by using
        **QCoreApplication::setApplicationVersion** ().

        Returns the option instance, which can be used to call **isSet** ().
        """
        ...

    def addOption(self, commandLineOption: QCommandLineOption) -> bool:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#addOption

        **bool QCommandLineParser::addOption(const QCommandLineOption & option
        )**

        Adds the option **option** to look for while parsing.

        Returns `true` if adding the option was successful; otherwise returns
        `false`.

        Adding the option fails if there is no name attached to the option, or
        the option has a name that clashes with an option name added before.
        """
        ...

    def setSingleDashWordOptionMode(
        self, parsingMode: "QCommandLineParser.SingleDashWordOptionMode"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcommandlineparser.html#setSingleDashWordOptionMo
        de

        **void QCommandLineParser::setSingleDashWordOptionMode(QCommandLineParse
        r::SingleDashWordOptionMode singleDashWordOptionMode )**

        Sets the parsing mode to **singleDashWordOptionMode**. This must be
        called before **process** () or **parse** ().
        """
        ...
