"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QLowEnergyCharacteristic(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qlowenergycharacteristic.html

    **Detailed Description**

    QLowEnergyCharacteristic provides information about a Bluetooth Low Energy
    service characteristic's **name** (), **uuid** (), **value** (),
    **properties** (), **handle** () and **descriptors** (). To obtain the
    characteristic's specification and information, it is necessary to connect
    to the device using the **QLowEnergyService**  and **QLowEnergyController**
    classes.

    The characteristic value may be written via the **QLowEnergyService**
    instance that manages the service to which this characteristic belongs. The
    **QLowEnergyService::writeCharacteristic** () function writes the new value.
    The **QLowEnergyService::characteristicWritten** () signal is emitted upon
    success. The **value** () of this object is automatically updated
    accordingly.

    Characteristics may contain none, one or more descriptors. They can be
    individually retrieved using the **descriptor** () function. The
    **descriptors** () function returns all descriptors as a list. The general
    purpose of a descriptor is to add contextual information to the
    characteristic. For example, the descriptor might provide format or range
    information specifying how the characteristic's value is to be interpreted.

    **See also** **QLowEnergyService**  and **QLowEnergyDescriptor** .
    """

    class PropertyType(int):
        Unknown: QLowEnergyCharacteristic = ...
        Broadcasting: QLowEnergyCharacteristic = ...
        Read: QLowEnergyCharacteristic = ...
        WriteNoResponse: QLowEnergyCharacteristic = ...
        Write: QLowEnergyCharacteristic = ...
        Notify: QLowEnergyCharacteristic = ...
        Indicate: QLowEnergyCharacteristic = ...
        WriteSigned: QLowEnergyCharacteristic = ...
        ExtendedProperty: QLowEnergyCharacteristic = ...

    class PropertyTypes(PyQt5.sip.wrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QLowEnergyCharacteristic.PropertyTypes",
                "QLowEnergyCharacteristic.PropertyType",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QLowEnergyCharacteristic.PropertyTypes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QLowEnergyCharacteristic.PropertyTypes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#QLowEnergyCharacter
        istic

        **QLowEnergyCharacteristic::QLowEnergyCharacteristic()**

        Construct a new QLowEnergyCharacteristic. A default-constructed instance
        of this class is always invalid.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QLowEnergyCharacteristic") -> None:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#QLowEnergyCharacter
        istic-1

        **QLowEnergyCharacteristic::QLowEnergyCharacteristic(const
        QLowEnergyCharacteristic & other )**

        Construct a new QLowEnergyCharacteristic that is a copy of **other**.

        The two copies continue to share the same underlying data which does not
        detach upon write.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#isValid

        **bool QLowEnergyCharacteristic::isValid() const**

        Returns `true` if the **QLowEnergyCharacteristic**  object is valid,
        otherwise returns `false`.

        An invalid characteristic object is not associated with any service
        (default-constructed) or the associated service is no longer valid due
        to a disconnect from the underlying Bluetooth Low Energy device, for
        example. Once the object is invalid it cannot become valid anymore.

        **Note:** If a **QLowEnergyCharacteristic**  instance turns invalid due
        to a disconnect from the underlying device, the information encapsulated
        by the current instance remains as it was at the time of the disconnect.
        Therefore it can be retrieved after the disconnect event.
        """
        ...

    def descriptors(self) -> typing.List["QLowEnergyDescriptor"]:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#descriptors

        **QList<QLowEnergyDescriptor> QLowEnergyCharacteristic::descriptors()
        const**

        Returns the list of descriptors belonging to this characteristic;
        otherwise an empty list.

        **See also** **descriptor** ().
        """
        ...

    def descriptor(self, uuid: QBluetoothUuid) -> "QLowEnergyDescriptor":
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#descriptor

        **QLowEnergyDescriptor QLowEnergyCharacteristic::descriptor(const
        QBluetoothUuid & uuid ) const**

        Returns the descriptor for **uuid** or an invalid `QLowEnergyDescriptor`
        instance.

        **See also** **descriptors** ().
        """
        ...

    def handle(self) -> int:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#handle

        **QLowEnergyHandle QLowEnergyCharacteristic::handle() const**

        Returns the handle of the characteristic's value attribute; or `0` if
        the handle cannot be accessed on the platform or if the characteristic
        is invalid.

        **Note:** On macOS and iOS handles can differ from 0, but these values
        have no special meaning outside of internal/private API.
        """
        ...

    def properties(self) -> "QLowEnergyCharacteristic.PropertyTypes":
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#properties

        **QLowEnergyCharacteristic::PropertyTypes
        QLowEnergyCharacteristic::properties() const**

        Returns the properties of the characteristic.

        The properties define the access permissions for the characteristic.
        """
        ...

    def value(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#value

        **QByteArray QLowEnergyCharacteristic::value() const**

        Returns the cached value of the characteristic.

        If the characteristic's **properties** () permit writing of new values,
        the value can be updated using
        **QLowEnergyService::writeCharacteristic** ().

        The cache is updated during the associated service's **detail
        discovery** , a successful **read** /**write**  operation or when an
        update notification is received.

        The returned **QByteArray**  always remains empty if the characteristic
        does not have the **read permission** . In such cases only the
        **QLowEnergyService::characteristicChanged** () or
        **QLowEnergyService::characteristicWritten** () may provice information
        about the value of this characteristic.
        """
        ...

    def uuid(self) -> QBluetoothUuid:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#uuid

        **QBluetoothUuid QLowEnergyCharacteristic::uuid() const**

        Returns the UUID of the characteristic if **isValid** () returns `true`;
        otherwise a **null**  UUID.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qlowenergycharacteristic.html#name

        **QString QLowEnergyCharacteristic::name() const**

        Returns the human-readable name of the characteristic.

        The name is based on the characteristic's **uuid** () which must have
        been standardized. The complete list of characteristic types can be
        found under **Bluetooth.org Characteristics** .

        The returned string is empty if the **uuid** () is unknown.

        **See also** **QBluetoothUuid::characteristicToString** ().
        """
        ...
