"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QBluetoothUuid(QtCore.QUuid):
    """
    https://doc.qt.io/qt-5/qbluetoothuuid.html

    **Detailed Description**
    """

    class DescriptorType(int):
        UnknownDescriptorType: QBluetoothUuid = ...
        CharacteristicExtendedProperties: QBluetoothUuid = ...
        CharacteristicUserDescription: QBluetoothUuid = ...
        ClientCharacteristicConfiguration: QBluetoothUuid = ...
        ServerCharacteristicConfiguration: QBluetoothUuid = ...
        CharacteristicPresentationFormat: QBluetoothUuid = ...
        CharacteristicAggregateFormat: QBluetoothUuid = ...
        ValidRange: QBluetoothUuid = ...
        ExternalReportReference: QBluetoothUuid = ...
        ReportReference: QBluetoothUuid = ...
        EnvironmentalSensingConfiguration: QBluetoothUuid = ...
        EnvironmentalSensingMeasurement: QBluetoothUuid = ...
        EnvironmentalSensingTriggerSetting: QBluetoothUuid = ...

    class CharacteristicType(int):
        DeviceName: QBluetoothUuid = ...
        Appearance: QBluetoothUuid = ...
        PeripheralPrivacyFlag: QBluetoothUuid = ...
        ReconnectionAddress: QBluetoothUuid = ...
        PeripheralPreferredConnectionParameters: QBluetoothUuid = ...
        ServiceChanged: QBluetoothUuid = ...
        AlertLevel: QBluetoothUuid = ...
        TxPowerLevel: QBluetoothUuid = ...
        DateTime: QBluetoothUuid = ...
        DayOfWeek: QBluetoothUuid = ...
        DayDateTime: QBluetoothUuid = ...
        ExactTime256: QBluetoothUuid = ...
        DSTOffset: QBluetoothUuid = ...
        TimeZone: QBluetoothUuid = ...
        LocalTimeInformation: QBluetoothUuid = ...
        TimeWithDST: QBluetoothUuid = ...
        TimeAccuracy: QBluetoothUuid = ...
        TimeSource: QBluetoothUuid = ...
        ReferenceTimeInformation: QBluetoothUuid = ...
        TimeUpdateControlPoint: QBluetoothUuid = ...
        TimeUpdateState: QBluetoothUuid = ...
        GlucoseMeasurement: QBluetoothUuid = ...
        BatteryLevel: QBluetoothUuid = ...
        TemperatureMeasurement: QBluetoothUuid = ...
        TemperatureType: QBluetoothUuid = ...
        IntermediateTemperature: QBluetoothUuid = ...
        MeasurementInterval: QBluetoothUuid = ...
        BootKeyboardInputReport: QBluetoothUuid = ...
        SystemID: QBluetoothUuid = ...
        ModelNumberString: QBluetoothUuid = ...
        SerialNumberString: QBluetoothUuid = ...
        FirmwareRevisionString: QBluetoothUuid = ...
        HardwareRevisionString: QBluetoothUuid = ...
        SoftwareRevisionString: QBluetoothUuid = ...
        ManufacturerNameString: QBluetoothUuid = ...
        IEEE1107320601RegulatoryCertificationDataList: QBluetoothUuid = ...
        CurrentTime: QBluetoothUuid = ...
        ScanRefresh: QBluetoothUuid = ...
        BootKeyboardOutputReport: QBluetoothUuid = ...
        BootMouseInputReport: QBluetoothUuid = ...
        GlucoseMeasurementContext: QBluetoothUuid = ...
        BloodPressureMeasurement: QBluetoothUuid = ...
        IntermediateCuffPressure: QBluetoothUuid = ...
        HeartRateMeasurement: QBluetoothUuid = ...
        BodySensorLocation: QBluetoothUuid = ...
        HeartRateControlPoint: QBluetoothUuid = ...
        AlertStatus: QBluetoothUuid = ...
        RingerControlPoint: QBluetoothUuid = ...
        RingerSetting: QBluetoothUuid = ...
        AlertCategoryIDBitMask: QBluetoothUuid = ...
        AlertCategoryID: QBluetoothUuid = ...
        AlertNotificationControlPoint: QBluetoothUuid = ...
        UnreadAlertStatus: QBluetoothUuid = ...
        NewAlert: QBluetoothUuid = ...
        SupportedNewAlertCategory: QBluetoothUuid = ...
        SupportedUnreadAlertCategory: QBluetoothUuid = ...
        BloodPressureFeature: QBluetoothUuid = ...
        HIDInformation: QBluetoothUuid = ...
        ReportMap: QBluetoothUuid = ...
        HIDControlPoint: QBluetoothUuid = ...
        Report: QBluetoothUuid = ...
        ProtocolMode: QBluetoothUuid = ...
        ScanIntervalWindow: QBluetoothUuid = ...
        PnPID: QBluetoothUuid = ...
        GlucoseFeature: QBluetoothUuid = ...
        RecordAccessControlPoint: QBluetoothUuid = ...
        RSCMeasurement: QBluetoothUuid = ...
        RSCFeature: QBluetoothUuid = ...
        SCControlPoint: QBluetoothUuid = ...
        CSCMeasurement: QBluetoothUuid = ...
        CSCFeature: QBluetoothUuid = ...
        SensorLocation: QBluetoothUuid = ...
        CyclingPowerMeasurement: QBluetoothUuid = ...
        CyclingPowerVector: QBluetoothUuid = ...
        CyclingPowerFeature: QBluetoothUuid = ...
        CyclingPowerControlPoint: QBluetoothUuid = ...
        LocationAndSpeed: QBluetoothUuid = ...
        Navigation: QBluetoothUuid = ...
        PositionQuality: QBluetoothUuid = ...
        LNFeature: QBluetoothUuid = ...
        LNControlPoint: QBluetoothUuid = ...
        MagneticDeclination: QBluetoothUuid = ...
        Elevation: QBluetoothUuid = ...
        Pressure: QBluetoothUuid = ...
        Temperature: QBluetoothUuid = ...
        Humidity: QBluetoothUuid = ...
        TrueWindSpeed: QBluetoothUuid = ...
        TrueWindDirection: QBluetoothUuid = ...
        ApparentWindSpeed: QBluetoothUuid = ...
        ApparentWindDirection: QBluetoothUuid = ...
        GustFactor: QBluetoothUuid = ...
        PollenConcentration: QBluetoothUuid = ...
        UVIndex: QBluetoothUuid = ...
        Irradiance: QBluetoothUuid = ...
        Rainfall: QBluetoothUuid = ...
        WindChill: QBluetoothUuid = ...
        HeatIndex: QBluetoothUuid = ...
        DewPoint: QBluetoothUuid = ...
        DescriptorValueChanged: QBluetoothUuid = ...
        AerobicHeartRateLowerLimit: QBluetoothUuid = ...
        AerobicThreshold: QBluetoothUuid = ...
        Age: QBluetoothUuid = ...
        AnaerobicHeartRateLowerLimit: QBluetoothUuid = ...
        AnaerobicHeartRateUpperLimit: QBluetoothUuid = ...
        AnaerobicThreshold: QBluetoothUuid = ...
        AerobicHeartRateUpperLimit: QBluetoothUuid = ...
        DateOfBirth: QBluetoothUuid = ...
        DateOfThresholdAssessment: QBluetoothUuid = ...
        EmailAddress: QBluetoothUuid = ...
        FatBurnHeartRateLowerLimit: QBluetoothUuid = ...
        FatBurnHeartRateUpperLimit: QBluetoothUuid = ...
        FirstName: QBluetoothUuid = ...
        FiveZoneHeartRateLimits: QBluetoothUuid = ...
        Gender: QBluetoothUuid = ...
        HeartRateMax: QBluetoothUuid = ...
        Height: QBluetoothUuid = ...
        HipCircumference: QBluetoothUuid = ...
        LastName: QBluetoothUuid = ...
        MaximumRecommendedHeartRate: QBluetoothUuid = ...
        RestingHeartRate: QBluetoothUuid = ...
        SportTypeForAerobicAnaerobicThresholds: QBluetoothUuid = ...
        ThreeZoneHeartRateLimits: QBluetoothUuid = ...
        TwoZoneHeartRateLimits: QBluetoothUuid = ...
        VO2Max: QBluetoothUuid = ...
        WaistCircumference: QBluetoothUuid = ...
        Weight: QBluetoothUuid = ...
        DatabaseChangeIncrement: QBluetoothUuid = ...
        UserIndex: QBluetoothUuid = ...
        BodyCompositionFeature: QBluetoothUuid = ...
        BodyCompositionMeasurement: QBluetoothUuid = ...
        WeightMeasurement: QBluetoothUuid = ...
        WeightScaleFeature: QBluetoothUuid = ...
        UserControlPoint: QBluetoothUuid = ...
        MagneticFluxDensity2D: QBluetoothUuid = ...
        MagneticFluxDensity3D: QBluetoothUuid = ...
        Language: QBluetoothUuid = ...
        BarometricPressureTrend: QBluetoothUuid = ...

    class ServiceClassUuid(int):
        ServiceDiscoveryServer: QBluetoothUuid = ...
        BrowseGroupDescriptor: QBluetoothUuid = ...
        PublicBrowseGroup: QBluetoothUuid = ...
        SerialPort: QBluetoothUuid = ...
        LANAccessUsingPPP: QBluetoothUuid = ...
        DialupNetworking: QBluetoothUuid = ...
        IrMCSync: QBluetoothUuid = ...
        ObexObjectPush: QBluetoothUuid = ...
        OBEXFileTransfer: QBluetoothUuid = ...
        IrMCSyncCommand: QBluetoothUuid = ...
        Headset: QBluetoothUuid = ...
        AudioSource: QBluetoothUuid = ...
        AudioSink: QBluetoothUuid = ...
        AV_RemoteControlTarget: QBluetoothUuid = ...
        AdvancedAudioDistribution: QBluetoothUuid = ...
        AV_RemoteControl: QBluetoothUuid = ...
        AV_RemoteControlController: QBluetoothUuid = ...
        HeadsetAG: QBluetoothUuid = ...
        PANU: QBluetoothUuid = ...
        NAP: QBluetoothUuid = ...
        GN: QBluetoothUuid = ...
        DirectPrinting: QBluetoothUuid = ...
        ReferencePrinting: QBluetoothUuid = ...
        ImagingResponder: QBluetoothUuid = ...
        ImagingAutomaticArchive: QBluetoothUuid = ...
        ImagingReferenceObjects: QBluetoothUuid = ...
        Handsfree: QBluetoothUuid = ...
        HandsfreeAudioGateway: QBluetoothUuid = ...
        DirectPrintingReferenceObjectsService: QBluetoothUuid = ...
        ReflectedUI: QBluetoothUuid = ...
        BasicPrinting: QBluetoothUuid = ...
        PrintingStatus: QBluetoothUuid = ...
        HumanInterfaceDeviceService: QBluetoothUuid = ...
        HardcopyCableReplacement: QBluetoothUuid = ...
        HCRPrint: QBluetoothUuid = ...
        HCRScan: QBluetoothUuid = ...
        SIMAccess: QBluetoothUuid = ...
        PhonebookAccessPCE: QBluetoothUuid = ...
        PhonebookAccessPSE: QBluetoothUuid = ...
        PhonebookAccess: QBluetoothUuid = ...
        HeadsetHS: QBluetoothUuid = ...
        MessageAccessServer: QBluetoothUuid = ...
        MessageNotificationServer: QBluetoothUuid = ...
        MessageAccessProfile: QBluetoothUuid = ...
        PnPInformation: QBluetoothUuid = ...
        GenericNetworking: QBluetoothUuid = ...
        GenericFileTransfer: QBluetoothUuid = ...
        GenericAudio: QBluetoothUuid = ...
        GenericTelephony: QBluetoothUuid = ...
        VideoSource: QBluetoothUuid = ...
        VideoSink: QBluetoothUuid = ...
        VideoDistribution: QBluetoothUuid = ...
        HDP: QBluetoothUuid = ...
        HDPSource: QBluetoothUuid = ...
        HDPSink: QBluetoothUuid = ...
        BasicImage: QBluetoothUuid = ...
        GNSS: QBluetoothUuid = ...
        GNSSServer: QBluetoothUuid = ...
        Display3D: QBluetoothUuid = ...
        Glasses3D: QBluetoothUuid = ...
        Synchronization3D: QBluetoothUuid = ...
        MPSProfile: QBluetoothUuid = ...
        MPSService: QBluetoothUuid = ...
        GenericAccess: QBluetoothUuid = ...
        GenericAttribute: QBluetoothUuid = ...
        ImmediateAlert: QBluetoothUuid = ...
        LinkLoss: QBluetoothUuid = ...
        TxPower: QBluetoothUuid = ...
        CurrentTimeService: QBluetoothUuid = ...
        ReferenceTimeUpdateService: QBluetoothUuid = ...
        NextDSTChangeService: QBluetoothUuid = ...
        Glucose: QBluetoothUuid = ...
        HealthThermometer: QBluetoothUuid = ...
        DeviceInformation: QBluetoothUuid = ...
        HeartRate: QBluetoothUuid = ...
        PhoneAlertStatusService: QBluetoothUuid = ...
        BatteryService: QBluetoothUuid = ...
        BloodPressure: QBluetoothUuid = ...
        AlertNotificationService: QBluetoothUuid = ...
        HumanInterfaceDevice: QBluetoothUuid = ...
        ScanParameters: QBluetoothUuid = ...
        RunningSpeedAndCadence: QBluetoothUuid = ...
        CyclingSpeedAndCadence: QBluetoothUuid = ...
        CyclingPower: QBluetoothUuid = ...
        LocationAndNavigation: QBluetoothUuid = ...
        EnvironmentalSensing: QBluetoothUuid = ...
        BodyComposition: QBluetoothUuid = ...
        UserData: QBluetoothUuid = ...
        WeightScale: QBluetoothUuid = ...
        BondManagement: QBluetoothUuid = ...
        ContinuousGlucoseMonitoring: QBluetoothUuid = ...

    class ProtocolUuid(int):
        Sdp: QBluetoothUuid = ...
        Udp: QBluetoothUuid = ...
        Rfcomm: QBluetoothUuid = ...
        Tcp: QBluetoothUuid = ...
        TcsBin: QBluetoothUuid = ...
        TcsAt: QBluetoothUuid = ...
        Att: QBluetoothUuid = ...
        Obex: QBluetoothUuid = ...
        Ip: QBluetoothUuid = ...
        Ftp: QBluetoothUuid = ...
        Http: QBluetoothUuid = ...
        Wsp: QBluetoothUuid = ...
        Bnep: QBluetoothUuid = ...
        Upnp: QBluetoothUuid = ...
        Hidp: QBluetoothUuid = ...
        HardcopyControlChannel: QBluetoothUuid = ...
        HardcopyDataChannel: QBluetoothUuid = ...
        HardcopyNotification: QBluetoothUuid = ...
        Avctp: QBluetoothUuid = ...
        Avdtp: QBluetoothUuid = ...
        Cmtp: QBluetoothUuid = ...
        UdiCPlain: QBluetoothUuid = ...
        McapControlChannel: QBluetoothUuid = ...
        McapDataChannel: QBluetoothUuid = ...
        L2cap: QBluetoothUuid = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#QBluetoothUuid

        **QBluetoothUuid::QBluetoothUuid()**

        Constructs a new null Bluetooth UUID.
        """
        ...

    @typing.overload
    def __init__(self, uuid: int) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#QBluetoothUuid-1

        **QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::ProtocolUuid uuid )**

        Constructs a new Bluetooth UUID from the protocol **uuid**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        uuid: typing.Tuple[
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#QBluetoothUuid-2

        **QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::ServiceClassUuid uuid
        )**

        Constructs a new Bluetooth UUID from the service class **uuid**.
        """
        ...

    @typing.overload
    def __init__(self, uuid: str) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#QBluetoothUuid-3

        **QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::CharacteristicType uuid
        )**

        Constructs a new Bluetooth UUID from the characteristic type **uuid**.

        This function was introduced in Qt 5.4.
        """
        ...

    @typing.overload
    def __init__(self, uuid: "QBluetoothUuid") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#QBluetoothUuid-4

        **QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::DescriptorType uuid )**

        Constructs a new Bluetooth UUID from the descriptor type **uuid**.

        This function was introduced in Qt 5.4.
        """
        ...

    @typing.overload
    def __init__(self, uuid: QtCore.QUuid) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#QBluetoothUuid-5

        **QBluetoothUuid::QBluetoothUuid(quint16 uuid )**

        Constructs a new Bluetooth UUID from the 16 bit **uuid**.
        """
        ...

    @staticmethod
    def descriptorToString(uuid: "QBluetoothUuid.DescriptorType") -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#descriptorToString

        **[static] QString
        QBluetoothUuid::descriptorToString(QBluetoothUuid::DescriptorType uuid
        )**

        Returns a human-readable and translated name for the given descriptor
        type represented by **uuid**.

        This function was introduced in Qt 5.4.

        **See also** **QBluetoothUuid::DescriptorType** .
        """
        ...

    @staticmethod
    def characteristicToString(uuid: "QBluetoothUuid.CharacteristicType") -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#characteristicToString

        **[static] QString QBluetoothUuid::characteristicToString(QBluetoothUuid
        ::CharacteristicType uuid )**

        Returns a human-readable and translated name for the given
        characteristic type represented by **uuid**.

        This function was introduced in Qt 5.4.

        **See also** **QBluetoothUuid::CharacteristicType** .
        """
        ...

    @staticmethod
    def protocolToString(uuid: "QBluetoothUuid.ProtocolUuid") -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#protocolToString

        **[static] QString
        QBluetoothUuid::protocolToString(QBluetoothUuid::ProtocolUuid uuid )**

        Returns a human-readable and translated name for the given protocol
        represented by **uuid**.

        This function was introduced in Qt 5.4.

        **See also** **QBluetoothUuid::ProtocolUuid** .
        """
        ...

    @staticmethod
    def serviceClassToString(uuid: "QBluetoothUuid.ServiceClassUuid") -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#serviceClassToString

        **[static] QString
        QBluetoothUuid::serviceClassToString(QBluetoothUuid::ServiceClassUuid
        uuid )**

        Returns a human-readable and translated name for the given service class
        represented by **uuid**.

        This function was introduced in Qt 5.4.

        **See also** **QBluetoothUuid::ServiceClassUuid** .
        """
        ...

    def toUInt128(
        self,
    ) -> typing.Tuple[
        int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int
    ]:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#toUInt128

        **quint128 QBluetoothUuid::toUInt128() const**

        Returns the 128 bit representation of this UUID.
        """
        ...

    def toUInt32(self) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#toUInt32

        **quint32 QBluetoothUuid::toUInt32(bool * ok = nullptr) const**

        Returns the 32 bit representation of this UUID. If **ok** is passed, it
        is set to true if the conversion is possible, otherwise it is set to
        false. The return value is undefined if **ok** is set to false.
        """
        ...

    def toUInt16(self) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#toUInt16

        **quint16 QBluetoothUuid::toUInt16(bool * ok = nullptr) const**

        Returns the 16 bit representation of this UUID. If **ok** is passed, it
        is set to true if the conversion is possible, otherwise it is set to
        false. The return value is undefined if **ok** is set to false.
        """
        ...

    def minimumSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothuuid.html#minimumSize

        **int QBluetoothUuid::minimumSize() const**

        Returns the minimum size in bytes that this UUID can be represented in.
        For non-null UUIDs 2, 4 or 16 is returned. 0 is returned for null UUIDs.

        **See also** **isNull** (), **toUInt16** (), **toUInt32** (), and
        **toUInt128** ().
        """
        ...
