# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ncbi.datasets.openapi.api_client import ApiClient
from ncbi.datasets.openapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProkaryoteApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def download_prokaryote_gene_package(self, accessions, **kwargs):  # noqa: E501
        """Get a prokaryote gene dataset by RefSeq protein accession  # noqa: E501

        Get a prokaryote gene dataset including gene and protein fasta sequence, annotation and metadata by prokaryote protein accession.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_prokaryote_gene_package(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: WP prokaryote protein accession (required)
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :param int gene_flank_config_length:
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank When specified, return data from this taxon and its subtree.
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_prokaryote_gene_package_with_http_info(accessions, **kwargs)  # noqa: E501

    def download_prokaryote_gene_package_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Get a prokaryote gene dataset by RefSeq protein accession  # noqa: E501

        Get a prokaryote gene dataset including gene and protein fasta sequence, annotation and metadata by prokaryote protein accession.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_prokaryote_gene_package_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: WP prokaryote protein accession (required)
        :param list[str] include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :param int gene_flank_config_length:
        :param str taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank When specified, return data from this taxon and its subtree.
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions',
            'include_annotation_type',
            'gene_flank_config_length',
            'taxon',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_prokaryote_gene_package" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `download_prokaryote_gene_package`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `download_prokaryote_gene_package`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []
        if 'include_annotation_type' in local_var_params and local_var_params['include_annotation_type'] is not None:  # noqa: E501
            query_params.append(('include_annotation_type', local_var_params['include_annotation_type']))  # noqa: E501
            collection_formats['include_annotation_type'] = 'multi'  # noqa: E501
        if 'gene_flank_config_length' in local_var_params and local_var_params['gene_flank_config_length'] is not None:  # noqa: E501
            query_params.append(('gene_flank_config.length', local_var_params['gene_flank_config_length']))  # noqa: E501
        if 'taxon' in local_var_params and local_var_params['taxon'] is not None:  # noqa: E501
            query_params.append(('taxon', local_var_params['taxon']))  # noqa: E501
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/protein/accession/{accessions}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_prokaryote_gene_package_post(self, body, **kwargs):  # noqa: E501
        """Get a prokaryote gene dataset by RefSeq protein accession by POST  # noqa: E501

        Get a prokaryote gene dataset including gene and protein fasta sequence, annotation and metadata by prokaryote protein accession by POST.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_prokaryote_gene_package_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1ProkaryoteGeneRequest body: (required)
        :param str filename: Output file name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_prokaryote_gene_package_post_with_http_info(body, **kwargs)  # noqa: E501

    def download_prokaryote_gene_package_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get a prokaryote gene dataset by RefSeq protein accession by POST  # noqa: E501

        Get a prokaryote gene dataset including gene and protein fasta sequence, annotation and metadata by prokaryote protein accession by POST.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_prokaryote_gene_package_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1ProkaryoteGeneRequest body: (required)
        :param str filename: Output file name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body',
            'filename'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_prokaryote_gene_package_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `download_prokaryote_gene_package_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/protein/accession/download', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
