"""
    Treasury Prime API

    # Treasury Prime API  The Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.  More information at:   [https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)  ## Getting Started  To use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.  ![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)  ## Developer Sandbox and API Keys  The Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at   [https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)  ## Docs  A complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)  ## Guides  A set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).  The Developer Guides can be found at   [https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)  ### Feature Availability  Not all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).  > *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.  API Version: 1.13.548-ge22afccc  # noqa: E501

    The version of the OpenAPI document: 1.13.548-ge22afccc
    Contact: help@treasuryprime.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from treasury_prime_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from treasury_prime_client.exceptions import ApiAttributeError


def lazy_import():
    from treasury_prime_client.model.person_application_mailing_address import PersonApplicationMailingAddress
    from treasury_prime_client.model.person_application_physical_address import PersonApplicationPhysicalAddress
    globals()['PersonApplicationMailingAddress'] = PersonApplicationMailingAddress
    globals()['PersonApplicationPhysicalAddress'] = PersonApplicationPhysicalAddress


class PersonApplication(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('citizenship',): {
            'max_length': 2,
            'min_length': 2,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'citizenship': (str,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'date_of_birth': (date,),  # noqa: E501
            'email_address': (str,),  # noqa: E501
            'first_name': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'last_name': (str,),  # noqa: E501
            'phone_number': (str,),  # noqa: E501
            'physical_address': (PersonApplicationPhysicalAddress,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
            'bankdata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'document_ids': ([str],),  # noqa: E501
            'mailing_address': (PersonApplicationMailingAddress,),  # noqa: E501
            'middle_name': (str,),  # noqa: E501
            'occupation': (str,),  # noqa: E501
            'tin': (str,),  # noqa: E501
            'userdata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'citizenship': 'citizenship',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
        'date_of_birth': 'date_of_birth',  # noqa: E501
        'email_address': 'email_address',  # noqa: E501
        'first_name': 'first_name',  # noqa: E501
        'id': 'id',  # noqa: E501
        'last_name': 'last_name',  # noqa: E501
        'phone_number': 'phone_number',  # noqa: E501
        'physical_address': 'physical_address',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
        'bankdata': 'bankdata',  # noqa: E501
        'document_ids': 'document_ids',  # noqa: E501
        'mailing_address': 'mailing_address',  # noqa: E501
        'middle_name': 'middle_name',  # noqa: E501
        'occupation': 'occupation',  # noqa: E501
        'tin': 'tin',  # noqa: E501
        'userdata': 'userdata',  # noqa: E501
    }

    read_only_vars = {
        'created_at',  # noqa: E501
        'id',  # noqa: E501
        'updated_at',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, citizenship, created_at, date_of_birth, email_address, first_name, id, last_name, phone_number, physical_address, updated_at, *args, **kwargs):  # noqa: E501
        """PersonApplication - a model defined in OpenAPI

        Args:
            citizenship (str): Two letter ISO country code for the country where this person has citizenship
            created_at (datetime): Time when the object was created
            date_of_birth (date): Date of birth of the person, ISO 8601 format (\"YYYY-MM-DD\").
            email_address (str): Email address of the person
            first_name (str): First (given) name of the person
            id (str): Unique identifier for object
            last_name (str): Last name (surname) of the person
            phone_number (str): Phone number of the person
            physical_address (PersonApplicationPhysicalAddress):
            updated_at (datetime): Time when the object was last updated

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bankdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional arbitrary data that can be attached for the bank's use. [optional]  # noqa: E501
            document_ids ([str]): Array of Document IDs pertaining to this person. [optional]  # noqa: E501
            mailing_address (PersonApplicationMailingAddress): [optional]  # noqa: E501
            middle_name (str): Middle name or initial of the person, if she has one. [optional]  # noqa: E501
            occupation (str): Occupation of the person. [optional]  # noqa: E501
            tin (str): U.S. Social Security or IRS tax ID number of the person. [optional]  # noqa: E501
            userdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.citizenship = citizenship
        self.created_at = created_at
        self.date_of_birth = date_of_birth
        self.email_address = email_address
        self.first_name = first_name
        self.id = id
        self.last_name = last_name
        self.phone_number = phone_number
        self.physical_address = physical_address
        self.updated_at = updated_at
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, citizenship, date_of_birth, email_address, first_name, last_name, phone_number, physical_address, *args, **kwargs):  # noqa: E501
        """PersonApplication - a model defined in OpenAPI

        Args:
            citizenship (str): Two letter ISO country code for the country where this person has citizenship
            date_of_birth (date): Date of birth of the person, ISO 8601 format (\"YYYY-MM-DD\").
            email_address (str): Email address of the person
            first_name (str): First (given) name of the person
            last_name (str): Last name (surname) of the person
            phone_number (str): Phone number of the person
            physical_address (PersonApplicationPhysicalAddress):
        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bankdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional arbitrary data that can be attached for the bank's use. [optional]  # noqa: E501
            document_ids ([str]): Array of Document IDs pertaining to this person. [optional]  # noqa: E501
            mailing_address (PersonApplicationMailingAddress): [optional]  # noqa: E501
            middle_name (str): Middle name or initial of the person, if she has one. [optional]  # noqa: E501
            occupation (str): Occupation of the person. [optional]  # noqa: E501
            tin (str): U.S. Social Security or IRS tax ID number of the person. [optional]  # noqa: E501
            userdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.citizenship = citizenship
        self.date_of_birth = date_of_birth
        self.email_address = email_address
        self.first_name = first_name
        self.last_name = last_name
        self.phone_number = phone_number
        self.physical_address = physical_address
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
