"""
    Treasury Prime API

    # Treasury Prime API  The Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.  More information at:   [https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)  ## Getting Started  To use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.  ![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)  ## Developer Sandbox and API Keys  The Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at   [https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)  ## Docs  A complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)  ## Guides  A set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).  The Developer Guides can be found at   [https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)  ### Feature Availability  Not all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).  > *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.  API Version: 1.13.548-ge22afccc  # noqa: E501

    The version of the OpenAPI document: 1.13.548-ge22afccc
    Contact: help@treasuryprime.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from treasury_prime_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from treasury_prime_client.exceptions import ApiAttributeError


def lazy_import():
    from treasury_prime_client.model.business_application_mailing_address import BusinessApplicationMailingAddress
    from treasury_prime_client.model.business_application_person_applications_inner import BusinessApplicationPersonApplicationsInner
    from treasury_prime_client.model.business_application_physical_address import BusinessApplicationPhysicalAddress
    globals()['BusinessApplicationMailingAddress'] = BusinessApplicationMailingAddress
    globals()['BusinessApplicationPersonApplicationsInner'] = BusinessApplicationPersonApplicationsInner
    globals()['BusinessApplicationPhysicalAddress'] = BusinessApplicationPhysicalAddress


class BusinessApplication(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('legal_structure',): {
            'CCORP': "ccorp",
            'CORP': "corp",
            'ESTATE': "estate",
            'FOREIGN_ENTITY': "foreign_entity",
            'LLC': "llc",
            'LLP': "llp",
            'LP': "lp",
            'NONPROFIT': "nonprofit",
            'PARTNERSHIP': "partnership",
            'SCHEME': "scheme",
            'SCORP': "scorp",
            'SOLEPROP': "soleprop",
            'TRUST': "trust",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'created_at': (datetime,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'established_on': (date,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'legal_structure': (str,),  # noqa: E501
            'naics': (str,),  # noqa: E501
            'naics_description': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'person_applications': ([BusinessApplicationPersonApplicationsInner],),  # noqa: E501
            'phone_number': (str,),  # noqa: E501
            'physical_address': (BusinessApplicationPhysicalAddress,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
            'bank_id': (str,),  # noqa: E501
            'bankdata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'dba': (str,),  # noqa: E501
            'document_ids': ([str],),  # noqa: E501
            'incorporation_state': (str,),  # noqa: E501
            'mailing_address': (BusinessApplicationMailingAddress,),  # noqa: E501
            'tin': (str,),  # noqa: E501
            'urls': ([str],),  # noqa: E501
            'userdata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'created_at': 'created_at',  # noqa: E501
        'description': 'description',  # noqa: E501
        'established_on': 'established_on',  # noqa: E501
        'id': 'id',  # noqa: E501
        'legal_structure': 'legal_structure',  # noqa: E501
        'naics': 'naics',  # noqa: E501
        'naics_description': 'naics_description',  # noqa: E501
        'name': 'name',  # noqa: E501
        'person_applications': 'person_applications',  # noqa: E501
        'phone_number': 'phone_number',  # noqa: E501
        'physical_address': 'physical_address',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
        'bank_id': 'bank_id',  # noqa: E501
        'bankdata': 'bankdata',  # noqa: E501
        'dba': 'dba',  # noqa: E501
        'document_ids': 'document_ids',  # noqa: E501
        'incorporation_state': 'incorporation_state',  # noqa: E501
        'mailing_address': 'mailing_address',  # noqa: E501
        'tin': 'tin',  # noqa: E501
        'urls': 'urls',  # noqa: E501
        'userdata': 'userdata',  # noqa: E501
    }

    read_only_vars = {
        'created_at',  # noqa: E501
        'id',  # noqa: E501
        'updated_at',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, created_at, description, established_on, id, legal_structure, naics, naics_description, name, person_applications, phone_number, physical_address, updated_at, *args, **kwargs):  # noqa: E501
        """BusinessApplication - a model defined in OpenAPI

        Args:
            created_at (datetime): Time when the object was created
            description (str): Description of the business
            established_on (date): Date that the business was established, ISO 8601 format (\"YYYY-MM-DD\").
            id (str): Unique identifier for object
            legal_structure (str): How the business is legally structured: one of `ccorp`, `corp`, `estate`, `foreign_entity`, `llc`, `llp`, `lp`, `nonprofit`, `partnership`, `scheme`, `scorp`, `soleprop`, or `trust` 
            naics (str): NAICS sector code that accurately describes the industry the business operates in.
            naics_description (str): NAICS sector description matching the above NAICS sector code. If \"Other\", please use an industry description prefixed with \"Other: \" 
            name (str): Legal name of the business
            person_applications ([BusinessApplicationPersonApplicationsInner]): Array of sub-objects describing persons associated with this business.
            phone_number (str): Phone number of the business
            physical_address (BusinessApplicationPhysicalAddress):
            updated_at (datetime): Time when the object was last updated

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bank_id (str): [optional]  # noqa: E501
            bankdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional arbitrary data that can be attached for the bank's use. [optional]  # noqa: E501
            dba (str): Alternate \"Doing Business As\" name of the business, if it has one. [optional]  # noqa: E501
            document_ids ([str]): Array of Document IDs pertaining to this business. [optional]  # noqa: E501
            incorporation_state (str): Two letter abbreviation for the U.S. State where the business is incorporated, or three letter international state/province.. [optional]  # noqa: E501
            mailing_address (BusinessApplicationMailingAddress): [optional]  # noqa: E501
            tin (str): Tax identification number (EIN or other tax ID) for U.S. businesses. [optional]  # noqa: E501
            urls ([str]): URLs for the business website(s). [optional]  # noqa: E501
            userdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.created_at = created_at
        self.description = description
        self.established_on = established_on
        self.id = id
        self.legal_structure = legal_structure
        self.naics = naics
        self.naics_description = naics_description
        self.name = name
        self.person_applications = person_applications
        self.phone_number = phone_number
        self.physical_address = physical_address
        self.updated_at = updated_at
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, description, established_on, legal_structure, naics, naics_description, name, person_applications, phone_number, physical_address, *args, **kwargs):  # noqa: E501
        """BusinessApplication - a model defined in OpenAPI

            description (str): Description of the business
            established_on (date): Date that the business was established, ISO 8601 format (\"YYYY-MM-DD\").
            legal_structure (str): How the business is legally structured: one of `ccorp`, `corp`, `estate`, `foreign_entity`, `llc`, `llp`, `lp`, `nonprofit`, `partnership`, `scheme`, `scorp`, `soleprop`, or `trust` 
            naics (str): NAICS sector code that accurately describes the industry the business operates in.
            naics_description (str): NAICS sector description matching the above NAICS sector code. If \"Other\", please use an industry description prefixed with \"Other: \" 
            name (str): Legal name of the business
            person_applications ([BusinessApplicationPersonApplicationsInner]): Array of sub-objects describing persons associated with this business.
            phone_number (str): Phone number of the business
            physical_address (BusinessApplicationPhysicalAddress):
        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bank_id (str): [optional]  # noqa: E501
            bankdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional arbitrary data that can be attached for the bank's use. [optional]  # noqa: E501
            dba (str): Alternate \"Doing Business As\" name of the business, if it has one. [optional]  # noqa: E501
            document_ids ([str]): Array of Document IDs pertaining to this business. [optional]  # noqa: E501
            incorporation_state (str): Two letter abbreviation for the U.S. State where the business is incorporated, or three letter international state/province.. [optional]  # noqa: E501
            mailing_address (BusinessApplicationMailingAddress): [optional]  # noqa: E501
            tin (str): Tax identification number (EIN or other tax ID) for U.S. businesses. [optional]  # noqa: E501
            urls ([str]): URLs for the business website(s). [optional]  # noqa: E501
            userdata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.description = description
        self.established_on = established_on
        self.legal_structure = legal_structure
        self.naics = naics
        self.naics_description = naics_description
        self.name = name
        self.person_applications = person_applications
        self.phone_number = phone_number
        self.physical_address = physical_address
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
