"""
    Treasury Prime API

    # Treasury Prime API  The Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.  More information at:   [https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)  ## Getting Started  To use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.  ![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)  ## Developer Sandbox and API Keys  The Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at   [https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)  ## Docs  A complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)  ## Guides  A set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).  The Developer Guides can be found at   [https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)  ### Feature Availability  Not all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).  > *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.  API Version: 1.13.548-ge22afccc  # noqa: E501

    The version of the OpenAPI document: 1.13.548-ge22afccc
    Contact: help@treasuryprime.com
    Generated by: https://openapi-generator.tech
"""


class OpenApiException(Exception):
    """The base exception class for all OpenAPIExceptions"""


class ApiTypeError(OpenApiException, TypeError):
    def __init__(self, msg, path_to_item=None, valid_classes=None,
                 key_type=None):
        """ Raises an exception for TypeErrors

        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (list): a list of keys an indices to get to the
                                 current_item
                                 None if unset
            valid_classes (tuple): the primitive classes that current item
                                   should be an instance of
                                   None if unset
            key_type (bool): False if our value is a value in a dict
                             True if it is a key in a dict
                             False if our item is an item in a list
                             None if unset
        """
        self.path_to_item = path_to_item
        self.valid_classes = valid_classes
        self.key_type = key_type
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiTypeError, self).__init__(full_msg)


class ApiValueError(OpenApiException, ValueError):
    def __init__(self, msg, path_to_item=None):
        """
        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (list) the path to the exception in the
                received_data dict. None if unset
        """

        self.path_to_item = path_to_item
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiValueError, self).__init__(full_msg)


class ApiAttributeError(OpenApiException, AttributeError):
    def __init__(self, msg, path_to_item=None):
        """
        Raised when an attribute reference or assignment fails.

        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (None/list) the path to the exception in the
                received_data dict
        """
        self.path_to_item = path_to_item
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiAttributeError, self).__init__(full_msg)


class ApiKeyError(OpenApiException, KeyError):
    def __init__(self, msg, path_to_item=None):
        """
        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (None/list) the path to the exception in the
                received_data dict
        """
        self.path_to_item = path_to_item
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiKeyError, self).__init__(full_msg)


class ApiException(OpenApiException):

    def __init__(self, status=None, reason=None, http_resp=None):
        if http_resp:
            self.status = http_resp.status
            self.reason = http_resp.reason
            self.body = http_resp.data
            self.headers = http_resp.getheaders()
        else:
            self.status = status
            self.reason = reason
            self.body = None
            self.headers = None

    def __str__(self):
        """Custom error messages for exception"""
        error_message = "Status Code: {0}\n"\
                        "Reason: {1}\n".format(self.status, self.reason)
        if self.headers:
            error_message += "HTTP response headers: {0}\n".format(
                self.headers)

        if self.body:
            error_message += "HTTP response body: {0}\n".format(self.body)

        return error_message


class NotFoundException(ApiException):

    def __init__(self, status=None, reason=None, http_resp=None):
        super(NotFoundException, self).__init__(status, reason, http_resp)


class UnauthorizedException(ApiException):

    def __init__(self, status=None, reason=None, http_resp=None):
        super(UnauthorizedException, self).__init__(status, reason, http_resp)


class ForbiddenException(ApiException):

    def __init__(self, status=None, reason=None, http_resp=None):
        super(ForbiddenException, self).__init__(status, reason, http_resp)


class ServiceException(ApiException):

    def __init__(self, status=None, reason=None, http_resp=None):
        super(ServiceException, self).__init__(status, reason, http_resp)


def render_path(path_to_item):
    """Returns a string representation of a path"""
    result = ""
    for pth in path_to_item:
        if isinstance(pth, int):
            result += "[{0}]".format(pth)
        else:
            result += "['{0}']".format(pth)
    return result
