"""
    Treasury Prime API

    # Treasury Prime API  The Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.  More information at:   [https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)  ## Getting Started  To use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.  ![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)  ## Developer Sandbox and API Keys  The Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at   [https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)  ## Docs  A complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)  ## Guides  A set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).  The Developer Guides can be found at   [https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)  ### Feature Availability  Not all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).  > *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.  API Version: 1.13.548-ge22afccc  # noqa: E501

    The version of the OpenAPI document: 1.13.548-ge22afccc
    Contact: help@treasuryprime.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from treasury_prime_client.api_client import ApiClient, Endpoint as _Endpoint
from treasury_prime_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from treasury_prime_client.model.bill_pay_counterparty import BillPayCounterparty
from treasury_prime_client.model.get_all_accounts400_response import GetAllAccounts400Response
from treasury_prime_client.model.get_all_bill_pay_counterparties200_response import GetAllBillPayCounterparties200Response
from treasury_prime_client.model.get_all_bill_pay_merchants200_response import GetAllBillPayMerchants200Response
from treasury_prime_client.model.get_all_bill_pay_payments200_response import GetAllBillPayPayments200Response
from treasury_prime_client.model.get_all_bill_pay_rules200_response import GetAllBillPayRules200Response
from treasury_prime_client.model.payment import Payment
from treasury_prime_client.model.rule import Rule
from treasury_prime_client.model.update_bill_pay_payment_by_id_request import UpdateBillPayPaymentByIdRequest
from treasury_prime_client.model.update_bill_pay_rule_by_id_request import UpdateBillPayRuleByIdRequest


class BillPayApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_bill_pay_counterparty_endpoint = _Endpoint(
            settings={
                'response_type': (BillPayCounterparty,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/counterparty',
                'operation_id': 'create_bill_pay_counterparty',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bill_pay_counterparty',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bill_pay_counterparty':
                        (BillPayCounterparty,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bill_pay_counterparty': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_bill_pay_payment_endpoint = _Endpoint(
            settings={
                'response_type': (Payment,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/payment',
                'operation_id': 'create_bill_pay_payment',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment':
                        (Payment,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_bill_pay_rule_endpoint = _Endpoint(
            settings={
                'response_type': (Rule,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/rule',
                'operation_id': 'create_bill_pay_rule',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'rule',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'rule':
                        (Rule,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'rule': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_all_bill_pay_counterparties_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllBillPayCounterparties200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/counterparty',
                'operation_id': 'get_all_bill_pay_counterparties',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_bill_pay_merchants_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllBillPayMerchants200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/merchant',
                'operation_id': 'get_all_bill_pay_merchants',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'bill_account_number',
                    'street_line_1',
                    'city',
                    'state',
                    'postal_code',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'bill_account_number':
                        (str,),
                    'street_line_1':
                        (str,),
                    'city':
                        (str,),
                    'state':
                        (str,),
                    'postal_code':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'bill_account_number': 'bill_account_number',
                    'street_line_1': 'street_line_1',
                    'city': 'city',
                    'state': 'state',
                    'postal_code': 'postal_code',
                },
                'location_map': {
                    'name': 'query',
                    'bill_account_number': 'query',
                    'street_line_1': 'query',
                    'city': 'query',
                    'state': 'query',
                    'postal_code': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_bill_pay_payments_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllBillPayPayments200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/payment',
                'operation_id': 'get_all_bill_pay_payments',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'status',
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "PENDING": "pending",
                        "CANCELED": "canceled",
                        "ERROR": "error",
                        "SENT": "sent"
                    },
                },
                'openapi_types': {
                    'status':
                        (str,),
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'status': 'status',
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'status': 'query',
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_bill_pay_rules_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllBillPayRules200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/rule',
                'operation_id': 'get_all_bill_pay_rules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'status',
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "ACTIVE": "active",
                        "CANCELED": "canceled"
                    },
                },
                'openapi_types': {
                    'status':
                        (str,),
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'status': 'status',
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'status': 'query',
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_bill_pay_counterparty_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (BillPayCounterparty,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/counterparty/{billpay_counterparty_id}',
                'operation_id': 'get_bill_pay_counterparty_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'billpay_counterparty_id',
                ],
                'required': [
                    'billpay_counterparty_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'billpay_counterparty_id':
                        (str,),
                },
                'attribute_map': {
                    'billpay_counterparty_id': 'billpay_counterparty_id',
                },
                'location_map': {
                    'billpay_counterparty_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_bill_pay_payment_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Payment,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/payment/{billpay_payment_id}',
                'operation_id': 'get_bill_pay_payment_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'billpay_payment_id',
                ],
                'required': [
                    'billpay_payment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'billpay_payment_id':
                        (str,),
                },
                'attribute_map': {
                    'billpay_payment_id': 'billpay_payment_id',
                },
                'location_map': {
                    'billpay_payment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_bill_pay_rule_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Rule,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/rule/{billpay_rule_id}',
                'operation_id': 'get_bill_pay_rule_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'billpay_rule_id',
                ],
                'required': [
                    'billpay_rule_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'billpay_rule_id':
                        (str,),
                },
                'attribute_map': {
                    'billpay_rule_id': 'billpay_rule_id',
                },
                'location_map': {
                    'billpay_rule_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_bill_pay_payment_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Payment,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/payment/{billpay_payment_id}',
                'operation_id': 'update_bill_pay_payment_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'billpay_payment_id',
                    'update_bill_pay_payment_by_id_request',
                ],
                'required': [
                    'billpay_payment_id',
                    'update_bill_pay_payment_by_id_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'billpay_payment_id':
                        (str,),
                    'update_bill_pay_payment_by_id_request':
                        (UpdateBillPayPaymentByIdRequest,),
                },
                'attribute_map': {
                    'billpay_payment_id': 'billpay_payment_id',
                },
                'location_map': {
                    'billpay_payment_id': 'path',
                    'update_bill_pay_payment_by_id_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_bill_pay_rule_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Rule,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/billpay/rule/{billpay_rule_id}',
                'operation_id': 'update_bill_pay_rule_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'billpay_rule_id',
                    'update_bill_pay_rule_by_id_request',
                ],
                'required': [
                    'billpay_rule_id',
                    'update_bill_pay_rule_by_id_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'billpay_rule_id':
                        (str,),
                    'update_bill_pay_rule_by_id_request':
                        (UpdateBillPayRuleByIdRequest,),
                },
                'attribute_map': {
                    'billpay_rule_id': 'billpay_rule_id',
                },
                'location_map': {
                    'billpay_rule_id': 'path',
                    'update_bill_pay_rule_by_id_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_bill_pay_counterparty(
        self,
        **kwargs
    ):
        """Create Bill Pay Counterparty  # noqa: E501

        To initiate a one-time bill pay payment, create a new Bill Pay Counterparty object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bill_pay_counterparty(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            bill_pay_counterparty (BillPayCounterparty): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BillPayCounterparty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_bill_pay_counterparty_endpoint.call_with_http_info(**kwargs)

    def create_bill_pay_payment(
        self,
        **kwargs
    ):
        """Create Payment  # noqa: E501

        To initiate a one-time bill pay payment, create a new Payment object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bill_pay_payment(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            payment (Payment): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Payment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_bill_pay_payment_endpoint.call_with_http_info(**kwargs)

    def create_bill_pay_rule(
        self,
        **kwargs
    ):
        """Create Rule  # noqa: E501

        To generate a payment rule, create a new Bill Pay Rule object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bill_pay_rule(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            rule (Rule): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Rule
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_bill_pay_rule_endpoint.call_with_http_info(**kwargs)

    def get_all_bill_pay_counterparties(
        self,
        **kwargs
    ):
        """List all Bill Pay Counterparties  # noqa: E501

        Returns a list of all existing Bill Pay Counterparties that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_bill_pay_counterparties(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllBillPayCounterparties200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_bill_pay_counterparties_endpoint.call_with_http_info(**kwargs)

    def get_all_bill_pay_merchants(
        self,
        **kwargs
    ):
        """Search for Merchant  # noqa: E501

        Search for a merchant listed in the bill pay database. A search may include only a name, however all parameters must be included to populate the results' merchant_code fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_bill_pay_merchants(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): Merchant name. Will be fuzzy matched when not exact. [optional]
            bill_account_number (str): Account number, as specified on the merchant's bill. [optional]
            street_line_1 (str): Merchant's street address (first line), as specified on the merchant's bill. [optional]
            city (str): Merchant's city, as specified on the merchant's bill. [optional]
            state (str): Merchant's state, as specified on the merchant's bill. [optional]
            postal_code (str): Merchant's postal code, as specified on the merchant's bill. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllBillPayMerchants200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_bill_pay_merchants_endpoint.call_with_http_info(**kwargs)

    def get_all_bill_pay_payments(
        self,
        **kwargs
    ):
        """Retrieve all Payments  # noqa: E501

        Returns a list of all existing Bill Pay Payments that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_bill_pay_payments(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            status (str): Filter by payment status. [optional]
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllBillPayPayments200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_bill_pay_payments_endpoint.call_with_http_info(**kwargs)

    def get_all_bill_pay_rules(
        self,
        **kwargs
    ):
        """List All Rules  # noqa: E501

        Returns a list of all existing Bill Pay Rules that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_bill_pay_rules(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            status (str): Filter by rule status. [optional]
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllBillPayRules200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_bill_pay_rules_endpoint.call_with_http_info(**kwargs)

    def get_bill_pay_counterparty_by_id(
        self,
        billpay_counterparty_id,
        **kwargs
    ):
        """Retrieve Bill Pay Counterparty  # noqa: E501

        Retrieves the details of an existing Bill Pay Counterparty object. Pass a unique Bill Pay Counterparty ID either from a Bill Pay Counterparty creation request, or the Bill Pay Counterparty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bill_pay_counterparty_by_id(billpay_counterparty_id, async_req=True)
        >>> result = thread.get()

        Args:
            billpay_counterparty_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BillPayCounterparty
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['billpay_counterparty_id'] = \
            billpay_counterparty_id
        return self.get_bill_pay_counterparty_by_id_endpoint.call_with_http_info(**kwargs)

    def get_bill_pay_payment_by_id(
        self,
        billpay_payment_id,
        **kwargs
    ):
        """Retrieve Payment  # noqa: E501

        Retrieves the details of an existing Bill Pay Payment object. Pass a unique Bill Pay Payment ID either from a Bill Pay Payment creation request, or the Bill Pay Payment array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bill_pay_payment_by_id(billpay_payment_id, async_req=True)
        >>> result = thread.get()

        Args:
            billpay_payment_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Payment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['billpay_payment_id'] = \
            billpay_payment_id
        return self.get_bill_pay_payment_by_id_endpoint.call_with_http_info(**kwargs)

    def get_bill_pay_rule_by_id(
        self,
        billpay_rule_id,
        **kwargs
    ):
        """Retrieve Rule  # noqa: E501

        Retrieves the details of an existing Bill Pay Rule object. Pass a unique Bill Pay Rule ID either from a Bill Pay Rule creation request, or the Bill Pay Rule array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bill_pay_rule_by_id(billpay_rule_id, async_req=True)
        >>> result = thread.get()

        Args:
            billpay_rule_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Rule
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['billpay_rule_id'] = \
            billpay_rule_id
        return self.get_bill_pay_rule_by_id_endpoint.call_with_http_info(**kwargs)

    def update_bill_pay_payment_by_id(
        self,
        billpay_payment_id,
        update_bill_pay_payment_by_id_request,
        **kwargs
    ):
        """Update Payment  # noqa: E501

        Updates the specified Bill Pay Payment by setting the values of the passed parameters. Any parameters not provided will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_bill_pay_payment_by_id(billpay_payment_id, update_bill_pay_payment_by_id_request, async_req=True)
        >>> result = thread.get()

        Args:
            billpay_payment_id (str):
            update_bill_pay_payment_by_id_request (UpdateBillPayPaymentByIdRequest): Updates the specified Bill Pay Payment by setting the values of the passed parameters. Any parameters not provided will be left unchanged. 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Payment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['billpay_payment_id'] = \
            billpay_payment_id
        kwargs['update_bill_pay_payment_by_id_request'] = \
            update_bill_pay_payment_by_id_request
        return self.update_bill_pay_payment_by_id_endpoint.call_with_http_info(**kwargs)

    def update_bill_pay_rule_by_id(
        self,
        billpay_rule_id,
        update_bill_pay_rule_by_id_request,
        **kwargs
    ):
        """Update Rule  # noqa: E501

        Updates the specified Bill Payment Rule by setting the values of the passed parameters. Any parameters not provided will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_bill_pay_rule_by_id(billpay_rule_id, update_bill_pay_rule_by_id_request, async_req=True)
        >>> result = thread.get()

        Args:
            billpay_rule_id (str):
            update_bill_pay_rule_by_id_request (UpdateBillPayRuleByIdRequest): Updates the specified Bill Payment Rule by setting the values of the passed parameters. Any parameters not provided will be left unchanged. 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Rule
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['billpay_rule_id'] = \
            billpay_rule_id
        kwargs['update_bill_pay_rule_by_id_request'] = \
            update_bill_pay_rule_by_id_request
        return self.update_bill_pay_rule_by_id_endpoint.call_with_http_info(**kwargs)

