"""
    Treasury Prime API

    # Treasury Prime API  The Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.  More information at:   [https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)  ## Getting Started  To use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.  ![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)  ## Developer Sandbox and API Keys  The Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at   [https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)  ## Docs  A complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)  ## Guides  A set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).  The Developer Guides can be found at   [https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)  ### Feature Availability  Not all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).  > *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.  API Version: 1.13.548-ge22afccc  # noqa: E501

    The version of the OpenAPI document: 1.13.548-ge22afccc
    Contact: help@treasuryprime.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from treasury_prime_client.api_client import ApiClient, Endpoint as _Endpoint
from treasury_prime_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from treasury_prime_client.model.additional_person_application import AdditionalPersonApplication
from treasury_prime_client.model.get_all_accounts400_response import GetAllAccounts400Response
from treasury_prime_client.model.get_all_additional_person_applications200_response import GetAllAdditionalPersonApplications200Response
from treasury_prime_client.model.update_user_data import UpdateUserData


class AdditionalPersonApplicationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_additional_person_application_endpoint = _Endpoint(
            settings={
                'response_type': (AdditionalPersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application',
                'operation_id': 'create_additional_person_application',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'additional_person_application',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'additional_person_application':
                        (AdditionalPersonApplication,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'additional_person_application': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_additional_person_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (AdditionalPersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application/{additional_person_application_id}',
                'operation_id': 'get_additional_person_application_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'additional_person_application_id',
                ],
                'required': [
                    'additional_person_application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'additional_person_application_id':
                        (str,),
                },
                'attribute_map': {
                    'additional_person_application_id': 'additional_person_application_id',
                },
                'location_map': {
                    'additional_person_application_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_additional_person_applications_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllAdditionalPersonApplications200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application',
                'operation_id': 'get_all_additional_person_applications',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_additional_person_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (AdditionalPersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application/{additional_person_application_id}',
                'operation_id': 'update_additional_person_application_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'additional_person_application_id',
                    'update_user_data',
                ],
                'required': [
                    'additional_person_application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'additional_person_application_id':
                        (str,),
                    'update_user_data':
                        (UpdateUserData,),
                },
                'attribute_map': {
                    'additional_person_application_id': 'additional_person_application_id',
                },
                'location_map': {
                    'additional_person_application_id': 'path',
                    'update_user_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_additional_person_application(
        self,
        **kwargs
    ):
        """Create Additional Person Application  # noqa: E501

        Create a new Additional Person Application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_additional_person_application(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            additional_person_application (AdditionalPersonApplication): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AdditionalPersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_additional_person_application_endpoint.call_with_http_info(**kwargs)

    def get_additional_person_application_by_id(
        self,
        additional_person_application_id,
        **kwargs
    ):
        """Retrieve Additional Person Application  # noqa: E501

        Retrieves the details of an existing Person Additional Person Application. Pass a unique ID from the Additional Person Application list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_additional_person_application_by_id(additional_person_application_id, async_req=True)
        >>> result = thread.get()

        Args:
            additional_person_application_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AdditionalPersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['additional_person_application_id'] = \
            additional_person_application_id
        return self.get_additional_person_application_by_id_endpoint.call_with_http_info(**kwargs)

    def get_all_additional_person_applications(
        self,
        **kwargs
    ):
        """Retrieve All Additional Person Applications  # noqa: E501

        Returns a list of all existing Additional Person Application objects that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_additional_person_applications(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllAdditionalPersonApplications200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_additional_person_applications_endpoint.call_with_http_info(**kwargs)

    def update_additional_person_application_by_id(
        self,
        additional_person_application_id,
        **kwargs
    ):
        """Update Additional Person Application  # noqa: E501

        Updates the specified `Additional Person Application` by setting the values of the passed parameters. Any parameters not provided will be left unchanged. Note only the `userdata` parameter is permitted to change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_additional_person_application_by_id(additional_person_application_id, async_req=True)
        >>> result = thread.get()

        Args:
            additional_person_application_id (str):

        Keyword Args:
            update_user_data (UpdateUserData): Updates the specified Additional Person Application by setting the values of the passed parameters. Any parameters not provided will be left unchanged. Note: only the userdata parameter is permitted to change . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AdditionalPersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['additional_person_application_id'] = \
            additional_person_application_id
        return self.update_additional_person_application_by_id_endpoint.call_with_http_info(**kwargs)

