"""
    Treasury Prime API

    # Treasury Prime API  The Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.  More information at:   [https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)  ## Getting Started  To use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.  ![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)  ## Developer Sandbox and API Keys  The Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at   [https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)  ## Docs  A complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)  ## Guides  A set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).  The Developer Guides can be found at   [https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)  ### Feature Availability  Not all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).  > *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.  API Version: 1.13.548-ge22afccc  # noqa: E501

    The version of the OpenAPI document: 1.13.548-ge22afccc
    Contact: help@treasuryprime.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from treasury_prime_client.api_client import ApiClient, Endpoint as _Endpoint
from treasury_prime_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from treasury_prime_client.model.account_application import AccountApplication
from treasury_prime_client.model.account_number_reservation import AccountNumberReservation
from treasury_prime_client.model.account_product import AccountProduct
from treasury_prime_client.model.additional_person_application import AdditionalPersonApplication
from treasury_prime_client.model.business_application import BusinessApplication
from treasury_prime_client.model.create_deposit_request import CreateDepositRequest
from treasury_prime_client.model.deposit import Deposit
from treasury_prime_client.model.get_all_account_applications200_response import GetAllAccountApplications200Response
from treasury_prime_client.model.get_all_account_number_reservations200_response import GetAllAccountNumberReservations200Response
from treasury_prime_client.model.get_all_account_products200_response import GetAllAccountProducts200Response
from treasury_prime_client.model.get_all_accounts400_response import GetAllAccounts400Response
from treasury_prime_client.model.get_all_additional_person_applications200_response import GetAllAdditionalPersonApplications200Response
from treasury_prime_client.model.get_all_business_applications200_response import GetAllBusinessApplications200Response
from treasury_prime_client.model.get_all_deposits200_response import GetAllDeposits200Response
from treasury_prime_client.model.get_all_kyc_evaluations200_response import GetAllKycEvaluations200Response
from treasury_prime_client.model.get_all_kyc_products200_response import GetAllKycProducts200Response
from treasury_prime_client.model.get_all_person_applications200_response import GetAllPersonApplications200Response
from treasury_prime_client.model.kyc_evaluation import KycEvaluation
from treasury_prime_client.model.kyc_product import KycProduct
from treasury_prime_client.model.person_application import PersonApplication
from treasury_prime_client.model.update_business_application_by_id_request import UpdateBusinessApplicationByIdRequest
from treasury_prime_client.model.update_user_data import UpdateUserData


class AccountOpeningApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_account_application_endpoint = _Endpoint(
            settings={
                'response_type': (AccountApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/account_application',
                'operation_id': 'create_account_application',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_application',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_application':
                        (AccountApplication,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'account_application': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_account_number_reservation_endpoint = _Endpoint(
            settings={
                'response_type': (AccountNumberReservation,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/account_number_reservation',
                'operation_id': 'create_account_number_reservation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_additional_person_application_endpoint = _Endpoint(
            settings={
                'response_type': (AdditionalPersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application',
                'operation_id': 'create_additional_person_application',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'additional_person_application',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'additional_person_application':
                        (AdditionalPersonApplication,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'additional_person_application': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_business_application_endpoint = _Endpoint(
            settings={
                'response_type': (BusinessApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/business_application',
                'operation_id': 'create_business_application',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_idempotency_key',
                    'business_application',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_idempotency_key':
                        (str,),
                    'business_application':
                        (BusinessApplication,),
                },
                'attribute_map': {
                    'x_idempotency_key': 'X-Idempotency-Key',
                },
                'location_map': {
                    'x_idempotency_key': 'header',
                    'business_application': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_deposit_endpoint = _Endpoint(
            settings={
                'response_type': (Deposit,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/deposit',
                'operation_id': 'create_deposit',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_deposit_request',
                ],
                'required': [
                    'create_deposit_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_deposit_request':
                        (CreateDepositRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_deposit_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_kyc_evaluation_endpoint = _Endpoint(
            settings={
                'response_type': (KycEvaluation,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/kyc',
                'operation_id': 'create_kyc_evaluation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'kyc_evaluation',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'kyc_evaluation':
                        (KycEvaluation,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'kyc_evaluation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_person_application_endpoint = _Endpoint(
            settings={
                'response_type': (PersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/person_application',
                'operation_id': 'create_person_application',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'person_application',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'person_application':
                        (PersonApplication,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'person_application': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_account_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (AccountApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/account_application/{account_application_id}',
                'operation_id': 'get_account_application_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_application_id',
                ],
                'required': [
                    'account_application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_application_id':
                        (str,),
                },
                'attribute_map': {
                    'account_application_id': 'account_application_id',
                },
                'location_map': {
                    'account_application_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_account_number_reservation_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (AccountNumberReservation,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/account_number_reservation/{account_number_reservation_id}',
                'operation_id': 'get_account_number_reservation_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_number_reservation_id',
                ],
                'required': [
                    'account_number_reservation_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_number_reservation_id':
                        (str,),
                },
                'attribute_map': {
                    'account_number_reservation_id': 'account_number_reservation_id',
                },
                'location_map': {
                    'account_number_reservation_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_account_product_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (AccountProduct,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/account_product/{account_product_id}',
                'operation_id': 'get_account_product_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_product_id',
                ],
                'required': [
                    'account_product_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_product_id':
                        (str,),
                },
                'attribute_map': {
                    'account_product_id': 'account_product_id',
                },
                'location_map': {
                    'account_product_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_additional_person_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (AdditionalPersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application/{additional_person_application_id}',
                'operation_id': 'get_additional_person_application_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'additional_person_application_id',
                ],
                'required': [
                    'additional_person_application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'additional_person_application_id':
                        (str,),
                },
                'attribute_map': {
                    'additional_person_application_id': 'additional_person_application_id',
                },
                'location_map': {
                    'additional_person_application_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_account_applications_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllAccountApplications200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/account_application',
                'operation_id': 'get_all_account_applications',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'status',
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "UNSUBMITTED": "unsubmitted",
                        "SUBMITTED": "submitted",
                        "PROCESSING": "processing",
                        "MANUAL_REVIEW": "manual_review",
                        "REJECTED": "rejected",
                        "APPROVED": "approved"
                    },
                },
                'openapi_types': {
                    'status':
                        (str,),
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'status': 'status',
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'status': 'query',
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_account_number_reservations_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllAccountNumberReservations200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/account_number_reservation',
                'operation_id': 'get_all_account_number_reservations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_account_products_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllAccountProducts200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/account_product',
                'operation_id': 'get_all_account_products',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_additional_person_applications_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllAdditionalPersonApplications200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application',
                'operation_id': 'get_all_additional_person_applications',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_business_applications_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllBusinessApplications200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/business_application',
                'operation_id': 'get_all_business_applications',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_deposits_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllDeposits200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/deposit',
                'operation_id': 'get_all_deposits',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_kyc_evaluations_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllKycEvaluations200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/kyc',
                'operation_id': 'get_all_kyc_evaluations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'kyc_product_id',
                    'object_id',
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'kyc_product_id':
                        (str,),
                    'object_id':
                        (str,),
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'kyc_product_id': 'kyc_product_id',
                    'object_id': 'object_id',
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'kyc_product_id': 'query',
                    'object_id': 'query',
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_kyc_products_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllKycProducts200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/kyc_product',
                'operation_id': 'get_all_kyc_products',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'type',
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('type',): {

                        "PERSON": "person",
                        "BUSINESS": "business"
                    },
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'type':
                        (str,),
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'name': 'name',
                    'type': 'type',
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'name': 'query',
                    'type': 'query',
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_person_applications_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllPersonApplications200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/person_application',
                'operation_id': 'get_all_person_applications',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_cursor',
                    'page_size',
                    'from_date',
                    'to_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_cursor':
                        (str,),
                    'page_size':
                        (int,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                },
                'attribute_map': {
                    'page_cursor': 'page_cursor',
                    'page_size': 'page_size',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'page_cursor': 'query',
                    'page_size': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_business_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (BusinessApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/business_application/{business_application_id}',
                'operation_id': 'get_business_application_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'business_application_id',
                ],
                'required': [
                    'business_application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'business_application_id':
                        (str,),
                },
                'attribute_map': {
                    'business_application_id': 'business_application_id',
                },
                'location_map': {
                    'business_application_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_deposit_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Deposit,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/deposit/{deposit_id}',
                'operation_id': 'get_deposit_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'deposit_id',
                ],
                'required': [
                    'deposit_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'deposit_id':
                        (str,),
                },
                'attribute_map': {
                    'deposit_id': 'deposit_id',
                },
                'location_map': {
                    'deposit_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_kyc_evaluation_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (KycEvaluation,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/kyc/{kyc_id}',
                'operation_id': 'get_kyc_evaluation_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'kyc_id',
                ],
                'required': [
                    'kyc_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'kyc_id':
                        (str,),
                },
                'attribute_map': {
                    'kyc_id': 'kyc_id',
                },
                'location_map': {
                    'kyc_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_kyc_product_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (KycProduct,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/kyc_product/{kyc_product_id}',
                'operation_id': 'get_kyc_product_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'kyc_product_id',
                ],
                'required': [
                    'kyc_product_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'kyc_product_id':
                        (str,),
                },
                'attribute_map': {
                    'kyc_product_id': 'kyc_product_id',
                },
                'location_map': {
                    'kyc_product_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_person_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (PersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/person_application/{person_application_id}',
                'operation_id': 'get_person_application_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'person_application_id',
                ],
                'required': [
                    'person_application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'person_application_id':
                        (str,),
                },
                'attribute_map': {
                    'person_application_id': 'person_application_id',
                },
                'location_map': {
                    'person_application_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_additional_person_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (AdditionalPersonApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/additional_person_application/{additional_person_application_id}',
                'operation_id': 'update_additional_person_application_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'additional_person_application_id',
                    'update_user_data',
                ],
                'required': [
                    'additional_person_application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'additional_person_application_id':
                        (str,),
                    'update_user_data':
                        (UpdateUserData,),
                },
                'attribute_map': {
                    'additional_person_application_id': 'additional_person_application_id',
                },
                'location_map': {
                    'additional_person_application_id': 'path',
                    'update_user_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_business_application_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (BusinessApplication,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/apply/business_application/{business_application_id}',
                'operation_id': 'update_business_application_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'business_application_id',
                    'update_business_application_by_id_request',
                ],
                'required': [
                    'business_application_id',
                    'update_business_application_by_id_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'business_application_id':
                        (str,),
                    'update_business_application_by_id_request':
                        (UpdateBusinessApplicationByIdRequest,),
                },
                'attribute_map': {
                    'business_application_id': 'business_application_id',
                },
                'location_map': {
                    'business_application_id': 'path',
                    'update_business_application_by_id_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_account_application(
        self,
        **kwargs
    ):
        """Create Account Application  # noqa: E501

        To create an application for a new bank account, create an Account Application object.  > This example demonstrates the creation of a Personal account. Business accounts are very similar, but will utilize a few different fields. Please see [https://developers.treasuryprime.com/guides/open-accounts](https://developers.treasuryprime.com/guides/open-accounts) for more information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_application(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            account_application (AccountApplication): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_account_application_endpoint.call_with_http_info(**kwargs)

    def create_account_number_reservation(
        self,
        **kwargs
    ):
        """Create Account Number Reservation  # noqa: E501

        Creates a new Account Number Reservation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_number_reservation(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountNumberReservation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_account_number_reservation_endpoint.call_with_http_info(**kwargs)

    def create_additional_person_application(
        self,
        **kwargs
    ):
        """Create Additional Person Application  # noqa: E501

        Create a new Additional Person Application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_additional_person_application(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            additional_person_application (AdditionalPersonApplication): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AdditionalPersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_additional_person_application_endpoint.call_with_http_info(**kwargs)

    def create_business_application(
        self,
        **kwargs
    ):
        """Create Business Application  # noqa: E501

        Creates a new Business Application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_business_application(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            x_idempotency_key (str): [optional]
            business_application (BusinessApplication): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BusinessApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_business_application_endpoint.call_with_http_info(**kwargs)

    def create_deposit(
        self,
        create_deposit_request,
        **kwargs
    ):
        """Create Deposit  # noqa: E501

        Creates a new Deposit.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_deposit(create_deposit_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_deposit_request (CreateDepositRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Deposit
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_deposit_request'] = \
            create_deposit_request
        return self.create_deposit_endpoint.call_with_http_info(**kwargs)

    def create_kyc_evaluation(
        self,
        **kwargs
    ):
        """Create KYC Evaluation  # noqa: E501

        Submits a person application or business application for KYC evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_kyc_evaluation(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            kyc_evaluation (KycEvaluation): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            KycEvaluation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_kyc_evaluation_endpoint.call_with_http_info(**kwargs)

    def create_person_application(
        self,
        **kwargs
    ):
        """Create Person Application  # noqa: E501

        Create a new Person Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_person_application(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            person_application (PersonApplication): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_person_application_endpoint.call_with_http_info(**kwargs)

    def get_account_application_by_id(
        self,
        account_application_id,
        **kwargs
    ):
        """Retrieve Account Application  # noqa: E501

        Retrieves the details of an existing Account Application. Pass a unique ID from the Account Application list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_application_by_id(account_application_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_application_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_application_id'] = \
            account_application_id
        return self.get_account_application_by_id_endpoint.call_with_http_info(**kwargs)

    def get_account_number_reservation_by_id(
        self,
        account_number_reservation_id,
        **kwargs
    ):
        """Retrieve Account Number Reservation  # noqa: E501

        Retrieves the details of an existing Account Number Reservation. Pass a unique ID from the Account Number Reservation list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_number_reservation_by_id(account_number_reservation_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_number_reservation_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountNumberReservation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_number_reservation_id'] = \
            account_number_reservation_id
        return self.get_account_number_reservation_by_id_endpoint.call_with_http_info(**kwargs)

    def get_account_product_by_id(
        self,
        account_product_id,
        **kwargs
    ):
        """Retrieve Account Product  # noqa: E501

        Retrieves the details of an existing Account Product. Pass a unique ID from the Account Product list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_product_by_id(account_product_id, async_req=True)
        >>> result = thread.get()

        Args:
            account_product_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountProduct
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['account_product_id'] = \
            account_product_id
        return self.get_account_product_by_id_endpoint.call_with_http_info(**kwargs)

    def get_additional_person_application_by_id(
        self,
        additional_person_application_id,
        **kwargs
    ):
        """Retrieve Additional Person Application  # noqa: E501

        Retrieves the details of an existing Person Additional Person Application. Pass a unique ID from the Additional Person Application list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_additional_person_application_by_id(additional_person_application_id, async_req=True)
        >>> result = thread.get()

        Args:
            additional_person_application_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AdditionalPersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['additional_person_application_id'] = \
            additional_person_application_id
        return self.get_additional_person_application_by_id_endpoint.call_with_http_info(**kwargs)

    def get_all_account_applications(
        self,
        **kwargs
    ):
        """Retrieve All Account Applications  # noqa: E501

        Returns a list of all existing Account Applications that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_account_applications(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            status (str): Filter by Application Status. [optional]
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllAccountApplications200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_account_applications_endpoint.call_with_http_info(**kwargs)

    def get_all_account_number_reservations(
        self,
        **kwargs
    ):
        """Retrieve All Account Number Reservation  # noqa: E501

        Returns a list of all existing Account Number Reservation objects that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_account_number_reservations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllAccountNumberReservations200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_account_number_reservations_endpoint.call_with_http_info(**kwargs)

    def get_all_account_products(
        self,
        **kwargs
    ):
        """Retrieve all Account Products  # noqa: E501

        Returns a list of all Account Products, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_account_products(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllAccountProducts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_account_products_endpoint.call_with_http_info(**kwargs)

    def get_all_additional_person_applications(
        self,
        **kwargs
    ):
        """Retrieve All Additional Person Applications  # noqa: E501

        Returns a list of all existing Additional Person Application objects that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_additional_person_applications(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllAdditionalPersonApplications200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_additional_person_applications_endpoint.call_with_http_info(**kwargs)

    def get_all_business_applications(
        self,
        **kwargs
    ):
        """Retrieve All Business Applications  # noqa: E501

        Returns a list of all existing Business Application objects that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_business_applications(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllBusinessApplications200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_business_applications_endpoint.call_with_http_info(**kwargs)

    def get_all_deposits(
        self,
        **kwargs
    ):
        """Retrieve All Deposits  # noqa: E501

        Returns a list of all existing Deposit objects that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_deposits(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllDeposits200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_deposits_endpoint.call_with_http_info(**kwargs)

    def get_all_kyc_evaluations(
        self,
        **kwargs
    ):
        """Retrieve All KYC  # noqa: E501

        Returns a list of all KYC evaluations associated with your organization, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_kyc_evaluations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            kyc_product_id (str): Filter by KYC Product ID. [optional]
            object_id (str): Filter by KYC Object ID. [optional]
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllKycEvaluations200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_kyc_evaluations_endpoint.call_with_http_info(**kwargs)

    def get_all_kyc_products(
        self,
        **kwargs
    ):
        """Retrieve All KYC Products  # noqa: E501

        Retrieves the details of an all KYC product objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_kyc_products(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): Filter by KYC Product Name. [optional]
            type (str): Filter by KYC Product Object Type. [optional]
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllKycProducts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_kyc_products_endpoint.call_with_http_info(**kwargs)

    def get_all_person_applications(
        self,
        **kwargs
    ):
        """Retrieve All Person Applications  # noqa: E501

        Returns a list of all existing Person Application objects that have been created, or an empty list if none are available.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_person_applications(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_cursor (str): [optional]
            page_size (int): [optional]
            from_date (date): [optional]
            to_date (date): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAllPersonApplications200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_person_applications_endpoint.call_with_http_info(**kwargs)

    def get_business_application_by_id(
        self,
        business_application_id,
        **kwargs
    ):
        """Retrieve Business Application  # noqa: E501

        Retrieves the details of an existing Business Application. Pass a unique ID from the Business Application list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_business_application_by_id(business_application_id, async_req=True)
        >>> result = thread.get()

        Args:
            business_application_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BusinessApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['business_application_id'] = \
            business_application_id
        return self.get_business_application_by_id_endpoint.call_with_http_info(**kwargs)

    def get_deposit_by_id(
        self,
        deposit_id,
        **kwargs
    ):
        """Retrieve a Deposit  # noqa: E501

        Retrieves the details of an existing Deposit. Pass a unique ID from the Deposit list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deposit_by_id(deposit_id, async_req=True)
        >>> result = thread.get()

        Args:
            deposit_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Deposit
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['deposit_id'] = \
            deposit_id
        return self.get_deposit_by_id_endpoint.call_with_http_info(**kwargs)

    def get_kyc_evaluation_by_id(
        self,
        kyc_id,
        **kwargs
    ):
        """Retrieve KYC Evaluation  # noqa: E501

        Retrieves the details of an existing KYC evaluation object. Pass a unique KYC ID from the KYC index endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_kyc_evaluation_by_id(kyc_id, async_req=True)
        >>> result = thread.get()

        Args:
            kyc_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            KycEvaluation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['kyc_id'] = \
            kyc_id
        return self.get_kyc_evaluation_by_id_endpoint.call_with_http_info(**kwargs)

    def get_kyc_product_by_id(
        self,
        kyc_product_id,
        **kwargs
    ):
        """Retrieve a KYC Product  # noqa: E501

        Retrieves the details of an existing KYC product object. Pass a unique KYC product ID from the KYC product index endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_kyc_product_by_id(kyc_product_id, async_req=True)
        >>> result = thread.get()

        Args:
            kyc_product_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            KycProduct
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['kyc_product_id'] = \
            kyc_product_id
        return self.get_kyc_product_by_id_endpoint.call_with_http_info(**kwargs)

    def get_person_application_by_id(
        self,
        person_application_id,
        **kwargs
    ):
        """Retrieve Person Application  # noqa: E501

        Retrieves the details of an existing Person Application. Pass a unique ID from the Person Application list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_application_by_id(person_application_id, async_req=True)
        >>> result = thread.get()

        Args:
            person_application_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['person_application_id'] = \
            person_application_id
        return self.get_person_application_by_id_endpoint.call_with_http_info(**kwargs)

    def update_additional_person_application_by_id(
        self,
        additional_person_application_id,
        **kwargs
    ):
        """Update Additional Person Application  # noqa: E501

        Updates the specified `Additional Person Application` by setting the values of the passed parameters. Any parameters not provided will be left unchanged. Note only the `userdata` parameter is permitted to change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_additional_person_application_by_id(additional_person_application_id, async_req=True)
        >>> result = thread.get()

        Args:
            additional_person_application_id (str):

        Keyword Args:
            update_user_data (UpdateUserData): Updates the specified Additional Person Application by setting the values of the passed parameters. Any parameters not provided will be left unchanged. Note: only the userdata parameter is permitted to change . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AdditionalPersonApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['additional_person_application_id'] = \
            additional_person_application_id
        return self.update_additional_person_application_by_id_endpoint.call_with_http_info(**kwargs)

    def update_business_application_by_id(
        self,
        business_application_id,
        update_business_application_by_id_request,
        **kwargs
    ):
        """Update Business Application  # noqa: E501

        Updates the details of an existing Business Application. Pass a unique ID from the Business Application list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_business_application_by_id(business_application_id, update_business_application_by_id_request, async_req=True)
        >>> result = thread.get()

        Args:
            business_application_id (str):
            update_business_application_by_id_request (UpdateBusinessApplicationByIdRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BusinessApplication
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['business_application_id'] = \
            business_application_id
        kwargs['update_business_application_by_id_request'] = \
            update_business_application_by_id_request
        return self.update_business_application_by_id_endpoint.call_with_http_info(**kwargs)

