# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['treasury_prime_client',
 'treasury_prime_client.api',
 'treasury_prime_client.apis',
 'treasury_prime_client.model',
 'treasury_prime_client.models']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil>=2.5.3,<3.0.0', 'urllib3>=1.25.3,<2.0.0']

setup_kwargs = {
    'name': 'treasury-prime-client',
    'version': '1.13.548',
    'description': 'Treasury Prime API Client generated by openapi-generator',
    'long_description': '# treasury-prime-client\n# Treasury Prime API\n\nThe Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.\n\nMore information at:  \n[https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)\n\n## Getting Started\n\nTo use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.\n\n![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)\n\n## Developer Sandbox and API Keys\n\nThe Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at  \n[https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)\n\n## Docs\n\nA complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)\n\n## Guides\n\nA set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).\n\nThe Developer Guides can be found at  \n[https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)\n\n### Feature Availability\n\nNot all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).\n\n> *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.\n\nAPI Version: 1.13.548-ge22afccc\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 1.13.548-ge22afccc\n- Package version: 1.0.0\n- Build package: org.openapitools.codegen.languages.PythonPriorClientCodegen\nFor more information, please visit [https://developers.treasuryprime.com/docs](https://developers.treasuryprime.com/docs)\n\n## Requirements.\n\nPython >=3.6\n\n## Installation & Usage\n### pip install\n\nIf the python package is hosted on a repository, you can install directly using:\n\n```sh\npip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git\n```\n(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)\n\nThen import the package:\n```python\nimport treasury_prime_client\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\nThen import the package:\n```python\nimport treasury_prime_client\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nimport treasury_prime_client\nfrom pprint import pprint\nfrom treasury_prime_client.api import ach_api\nfrom treasury_prime_client.model.ach import Ach\nfrom treasury_prime_client.model.get_all_accounts400_response import GetAllAccounts400Response\nfrom treasury_prime_client.model.get_all_ach_transfers200_response import GetAllAchTransfers200Response\nfrom treasury_prime_client.model.update_ach_transfer_by_id_request import UpdateAchTransferByIdRequest\n# Defining the host is optional and defaults to https://api.sandbox.treasuryprime.com\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = treasury_prime_client.Configuration(\n    host = "https://api.sandbox.treasuryprime.com"\n)\n\n# The client must configure the authentication and authorization parameters\n# in accordance with the API server security policy.\n# Examples for each auth method are provided below, use the example that\n# satisfies your auth use case.\n\n# Configure HTTP basic authorization: basicAuth\nconfiguration = treasury_prime_client.Configuration(\n    username = \'YOUR_USERNAME\',\n    password = \'YOUR_PASSWORD\'\n)\n\n\n# Enter a context with an instance of the API client\nwith treasury_prime_client.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = ach_api.ACHApi(api_client)\n    ach = Ach(\n        account_id="account_id_example",\n        amount="4.80",\n        counterparty_id="counterparty_id_example",\n        description="description_example",\n        direction="credit",\n        sec_code="sec_code_example",\n        service="standard",\n        userdata={},\n        addenda=[\n            "addenda_example",\n        ],\n    ) # Ach |  (optional)\n\n    try:\n        # Create ACH\n        api_response = api_instance.create_ach_transfer(ach=ach)\n        pprint(api_response)\n    except treasury_prime_client.ApiException as e:\n        print("Exception when calling ACHApi->create_ach_transfer: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://api.sandbox.treasuryprime.com*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*ACHApi* | [**create_ach_transfer**](docs/ACHApi.md#create_ach_transfer) | **POST** /ach | Create ACH\n*ACHApi* | [**get_ach_transfer_by_id**](docs/ACHApi.md#get_ach_transfer_by_id) | **GET** /ach/{ach_id} | Retrieve ACH\n*ACHApi* | [**get_all_ach_transfers**](docs/ACHApi.md#get_all_ach_transfers) | **GET** /ach | Retrieve All ACH\n*ACHApi* | [**update_ach_transfer_by_id**](docs/ACHApi.md#update_ach_transfer_by_id) | **PATCH** /ach/{ach_id} | Update ACH\n*AccountApplicationApi* | [**create_account_application**](docs/AccountApplicationApi.md#create_account_application) | **POST** /apply/account_application | Create Account Application\n*AccountApplicationApi* | [**get_account_application_by_id**](docs/AccountApplicationApi.md#get_account_application_by_id) | **GET** /apply/account_application/{account_application_id} | Retrieve Account Application\n*AccountApplicationApi* | [**get_all_account_applications**](docs/AccountApplicationApi.md#get_all_account_applications) | **GET** /apply/account_application | Retrieve All Account Applications\n*AccountOpeningApi* | [**create_account_application**](docs/AccountOpeningApi.md#create_account_application) | **POST** /apply/account_application | Create Account Application\n*AccountOpeningApi* | [**create_account_number_reservation**](docs/AccountOpeningApi.md#create_account_number_reservation) | **POST** /account_number_reservation | Create Account Number Reservation\n*AccountOpeningApi* | [**create_additional_person_application**](docs/AccountOpeningApi.md#create_additional_person_application) | **POST** /apply/additional_person_application | Create Additional Person Application\n*AccountOpeningApi* | [**create_business_application**](docs/AccountOpeningApi.md#create_business_application) | **POST** /apply/business_application | Create Business Application\n*AccountOpeningApi* | [**create_deposit**](docs/AccountOpeningApi.md#create_deposit) | **POST** /apply/deposit | Create Deposit\n*AccountOpeningApi* | [**create_kyc_evaluation**](docs/AccountOpeningApi.md#create_kyc_evaluation) | **POST** /apply/kyc | Create KYC Evaluation\n*AccountOpeningApi* | [**create_person_application**](docs/AccountOpeningApi.md#create_person_application) | **POST** /apply/person_application | Create Person Application\n*AccountOpeningApi* | [**get_account_application_by_id**](docs/AccountOpeningApi.md#get_account_application_by_id) | **GET** /apply/account_application/{account_application_id} | Retrieve Account Application\n*AccountOpeningApi* | [**get_account_number_reservation_by_id**](docs/AccountOpeningApi.md#get_account_number_reservation_by_id) | **GET** /account_number_reservation/{account_number_reservation_id} | Retrieve Account Number Reservation\n*AccountOpeningApi* | [**get_account_product_by_id**](docs/AccountOpeningApi.md#get_account_product_by_id) | **GET** /account_product/{account_product_id} | Retrieve Account Product\n*AccountOpeningApi* | [**get_additional_person_application_by_id**](docs/AccountOpeningApi.md#get_additional_person_application_by_id) | **GET** /apply/additional_person_application/{additional_person_application_id} | Retrieve Additional Person Application\n*AccountOpeningApi* | [**get_all_account_applications**](docs/AccountOpeningApi.md#get_all_account_applications) | **GET** /apply/account_application | Retrieve All Account Applications\n*AccountOpeningApi* | [**get_all_account_number_reservations**](docs/AccountOpeningApi.md#get_all_account_number_reservations) | **GET** /account_number_reservation | Retrieve All Account Number Reservation\n*AccountOpeningApi* | [**get_all_account_products**](docs/AccountOpeningApi.md#get_all_account_products) | **GET** /account_product | Retrieve all Account Products\n*AccountOpeningApi* | [**get_all_additional_person_applications**](docs/AccountOpeningApi.md#get_all_additional_person_applications) | **GET** /apply/additional_person_application | Retrieve All Additional Person Applications\n*AccountOpeningApi* | [**get_all_business_applications**](docs/AccountOpeningApi.md#get_all_business_applications) | **GET** /apply/business_application | Retrieve All Business Applications\n*AccountOpeningApi* | [**get_all_deposits**](docs/AccountOpeningApi.md#get_all_deposits) | **GET** /apply/deposit | Retrieve All Deposits\n*AccountOpeningApi* | [**get_all_kyc_evaluations**](docs/AccountOpeningApi.md#get_all_kyc_evaluations) | **GET** /apply/kyc | Retrieve All KYC\n*AccountOpeningApi* | [**get_all_kyc_products**](docs/AccountOpeningApi.md#get_all_kyc_products) | **GET** /apply/kyc_product | Retrieve All KYC Products\n*AccountOpeningApi* | [**get_all_person_applications**](docs/AccountOpeningApi.md#get_all_person_applications) | **GET** /apply/person_application | Retrieve All Person Applications\n*AccountOpeningApi* | [**get_business_application_by_id**](docs/AccountOpeningApi.md#get_business_application_by_id) | **GET** /apply/business_application/{business_application_id} | Retrieve Business Application\n*AccountOpeningApi* | [**get_deposit_by_id**](docs/AccountOpeningApi.md#get_deposit_by_id) | **GET** /apply/deposit/{deposit_id} | Retrieve a Deposit\n*AccountOpeningApi* | [**get_kyc_evaluation_by_id**](docs/AccountOpeningApi.md#get_kyc_evaluation_by_id) | **GET** /apply/kyc/{kyc_id} | Retrieve KYC Evaluation\n*AccountOpeningApi* | [**get_kyc_product_by_id**](docs/AccountOpeningApi.md#get_kyc_product_by_id) | **GET** /apply/kyc_product/{kyc_product_id} | Retrieve a KYC Product\n*AccountOpeningApi* | [**get_person_application_by_id**](docs/AccountOpeningApi.md#get_person_application_by_id) | **GET** /apply/person_application/{person_application_id} | Retrieve Person Application\n*AccountOpeningApi* | [**update_additional_person_application_by_id**](docs/AccountOpeningApi.md#update_additional_person_application_by_id) | **PATCH** /apply/additional_person_application/{additional_person_application_id} | Update Additional Person Application\n*AccountOpeningApi* | [**update_business_application_by_id**](docs/AccountOpeningApi.md#update_business_application_by_id) | **PATCH** /apply/business_application/{business_application_id} | Update Business Application\n*AccountsApi* | [**create_card_by_person_id**](docs/AccountsApi.md#create_card_by_person_id) | **POST** /person/{person_id}/card | Issue New Card\n*AccountsApi* | [**create_reserve**](docs/AccountsApi.md#create_reserve) | **POST** /reserve | Create a Reserve\n*AccountsApi* | [**create_statement_config**](docs/AccountsApi.md#create_statement_config) | **POST** /statement_config | Create Statement Config Copy\n*AccountsApi* | [**delete_reserve_by_id**](docs/AccountsApi.md#delete_reserve_by_id) | **DELETE** /reserve/{reserve_id} | Delete a Reserve\n*AccountsApi* | [**get_account_by_id**](docs/AccountsApi.md#get_account_by_id) | **GET** /account/{account_id} | Retrieve Account\n*AccountsApi* | [**get_account_statement_by_id_and_date**](docs/AccountsApi.md#get_account_statement_by_id_and_date) | **GET** /account/{account_id}/statement | Retrieve Statement\n*AccountsApi* | [**get_all_accounts**](docs/AccountsApi.md#get_all_accounts) | **GET** /account | Retrieve All Accounts\n*AccountsApi* | [**get_all_cards_by_person_id**](docs/AccountsApi.md#get_all_cards_by_person_id) | **GET** /person/{person_id}/card | Retrieve All Person Cards\n*AccountsApi* | [**get_all_check_images**](docs/AccountsApi.md#get_all_check_images) | **GET** /check_image | List All Check Images\n*AccountsApi* | [**get_all_reserves**](docs/AccountsApi.md#get_all_reserves) | **GET** /reserve | Retrieve all Reserves\n*AccountsApi* | [**get_all_statement_configs**](docs/AccountsApi.md#get_all_statement_configs) | **GET** /statement_config | Retrieve All Statement Configs\n*AccountsApi* | [**get_all_transactions**](docs/AccountsApi.md#get_all_transactions) | **GET** /transaction | Retrieve All Transactions\n*AccountsApi* | [**get_all_transactions_by_account**](docs/AccountsApi.md#get_all_transactions_by_account) | **GET** /account/{account_id}/transaction | Retrieve All Account Transactions\n*AccountsApi* | [**get_average_account_balance_by_id**](docs/AccountsApi.md#get_average_account_balance_by_id) | **GET** /account/{account_id}/average_balance | List Average Balances\n*AccountsApi* | [**get_business_by_id**](docs/AccountsApi.md#get_business_by_id) | **GET** /business/{business_id} | Retrieve Business\n*AccountsApi* | [**get_card_by_person_id_and_card_id**](docs/AccountsApi.md#get_card_by_person_id_and_card_id) | **GET** /person/{person_id}/card/{card_id} | Retrieve Card\n*AccountsApi* | [**get_check_image_by_id**](docs/AccountsApi.md#get_check_image_by_id) | **GET** /check_image/{check_image_id} | Retrieve Check Image\n*AccountsApi* | [**get_daily_account_balance_by_id**](docs/AccountsApi.md#get_daily_account_balance_by_id) | **GET** /account/{account_id}/daily_balance | List Daily Balances\n*AccountsApi* | [**get_person_by_id**](docs/AccountsApi.md#get_person_by_id) | **GET** /person/{person_id} | Retrieve Person\n*AccountsApi* | [**get_reserve_by_id**](docs/AccountsApi.md#get_reserve_by_id) | **GET** /reserve/{reserve_id} | Retrieve Reserve\n*AccountsApi* | [**get_transaction_by_id**](docs/AccountsApi.md#get_transaction_by_id) | **GET** /transaction/{transaction_id} | Retrieve a Transaction\n*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PATCH** /account/{account_id} | Lock a Account\n*AccountsApi* | [**update_person_by_id**](docs/AccountsApi.md#update_person_by_id) | **PATCH** /person/{person_id} | Update Person\n*AccountsApi* | [**update_reserve_by_id**](docs/AccountsApi.md#update_reserve_by_id) | **PATCH** /reserve/{reserve_id} | Update Reserve\n*AccountsApi* | [**update_statement_config_by_id**](docs/AccountsApi.md#update_statement_config_by_id) | **PATCH** /statement_config/{statement_config_id} | Update Statement Config Copy\n*AdditionalPersonApplicationApi* | [**create_additional_person_application**](docs/AdditionalPersonApplicationApi.md#create_additional_person_application) | **POST** /apply/additional_person_application | Create Additional Person Application\n*AdditionalPersonApplicationApi* | [**get_additional_person_application_by_id**](docs/AdditionalPersonApplicationApi.md#get_additional_person_application_by_id) | **GET** /apply/additional_person_application/{additional_person_application_id} | Retrieve Additional Person Application\n*AdditionalPersonApplicationApi* | [**get_all_additional_person_applications**](docs/AdditionalPersonApplicationApi.md#get_all_additional_person_applications) | **GET** /apply/additional_person_application | Retrieve All Additional Person Applications\n*AdditionalPersonApplicationApi* | [**update_additional_person_application_by_id**](docs/AdditionalPersonApplicationApi.md#update_additional_person_application_by_id) | **PATCH** /apply/additional_person_application/{additional_person_application_id} | Update Additional Person Application\n*AverageBalanceApi* | [**get_average_account_balance_by_id**](docs/AverageBalanceApi.md#get_average_account_balance_by_id) | **GET** /account/{account_id}/average_balance | List Average Balances\n*BillPayApi* | [**create_bill_pay_counterparty**](docs/BillPayApi.md#create_bill_pay_counterparty) | **POST** /billpay/counterparty | Create Bill Pay Counterparty\n*BillPayApi* | [**create_bill_pay_payment**](docs/BillPayApi.md#create_bill_pay_payment) | **POST** /billpay/payment | Create Payment\n*BillPayApi* | [**create_bill_pay_rule**](docs/BillPayApi.md#create_bill_pay_rule) | **POST** /billpay/rule | Create Rule\n*BillPayApi* | [**get_all_bill_pay_counterparties**](docs/BillPayApi.md#get_all_bill_pay_counterparties) | **GET** /billpay/counterparty | List all Bill Pay Counterparties\n*BillPayApi* | [**get_all_bill_pay_merchants**](docs/BillPayApi.md#get_all_bill_pay_merchants) | **GET** /billpay/merchant | Search for Merchant\n*BillPayApi* | [**get_all_bill_pay_payments**](docs/BillPayApi.md#get_all_bill_pay_payments) | **GET** /billpay/payment | Retrieve all Payments\n*BillPayApi* | [**get_all_bill_pay_rules**](docs/BillPayApi.md#get_all_bill_pay_rules) | **GET** /billpay/rule | List All Rules\n*BillPayApi* | [**get_bill_pay_counterparty_by_id**](docs/BillPayApi.md#get_bill_pay_counterparty_by_id) | **GET** /billpay/counterparty/{billpay_counterparty_id} | Retrieve Bill Pay Counterparty\n*BillPayApi* | [**get_bill_pay_payment_by_id**](docs/BillPayApi.md#get_bill_pay_payment_by_id) | **GET** /billpay/payment/{billpay_payment_id} | Retrieve Payment\n*BillPayApi* | [**get_bill_pay_rule_by_id**](docs/BillPayApi.md#get_bill_pay_rule_by_id) | **GET** /billpay/rule/{billpay_rule_id} | Retrieve Rule\n*BillPayApi* | [**update_bill_pay_payment_by_id**](docs/BillPayApi.md#update_bill_pay_payment_by_id) | **PATCH** /billpay/payment/{billpay_payment_id} | Update Payment\n*BillPayApi* | [**update_bill_pay_rule_by_id**](docs/BillPayApi.md#update_bill_pay_rule_by_id) | **PATCH** /billpay/rule/{billpay_rule_id} | Update Rule\n*BookApi* | [**create_book_transfer**](docs/BookApi.md#create_book_transfer) | **POST** /book | Create Book Transfer\n*BookApi* | [**get_all_book_transfers**](docs/BookApi.md#get_all_book_transfers) | **GET** /book | Retrieve All Book Transfers\n*BookApi* | [**get_book_transfer_by_id**](docs/BookApi.md#get_book_transfer_by_id) | **GET** /book/{book_id} | Retrieve Book Transfer\n*BookApi* | [**update_book_transfer_by_id**](docs/BookApi.md#update_book_transfer_by_id) | **PATCH** /book/{book_id} | Update Book Transfer\n*BusinessApi* | [**get_business_by_id**](docs/BusinessApi.md#get_business_by_id) | **GET** /business/{business_id} | Retrieve Business\n*BusinessApplicationApi* | [**create_business_application**](docs/BusinessApplicationApi.md#create_business_application) | **POST** /apply/business_application | Create Business Application\n*BusinessApplicationApi* | [**get_all_business_applications**](docs/BusinessApplicationApi.md#get_all_business_applications) | **GET** /apply/business_application | Retrieve All Business Applications\n*BusinessApplicationApi* | [**get_business_application_by_id**](docs/BusinessApplicationApi.md#get_business_application_by_id) | **GET** /apply/business_application/{business_application_id} | Retrieve Business Application\n*BusinessApplicationApi* | [**update_business_application_by_id**](docs/BusinessApplicationApi.md#update_business_application_by_id) | **PATCH** /apply/business_application/{business_application_id} | Update Business Application\n*CardAuthLoopEndpointApi* | [**create_card_auth_loop_endpoint**](docs/CardAuthLoopEndpointApi.md#create_card_auth_loop_endpoint) | **POST** /card_auth_loop_endpoint | Create Card Auth Loop Endpoint\n*CardAuthLoopEndpointApi* | [**delete_card_auth_loop_endpoint_by_id**](docs/CardAuthLoopEndpointApi.md#delete_card_auth_loop_endpoint_by_id) | **DELETE** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Delete a Card Auth Loop Endpoint\n*CardAuthLoopEndpointApi* | [**get_all_card_auth_loop_endpoint**](docs/CardAuthLoopEndpointApi.md#get_all_card_auth_loop_endpoint) | **GET** /card_auth_loop_endpoint | Retrieve All Card Auth Loop Endpoints\n*CardAuthLoopEndpointApi* | [**get_card_auth_loop_endpoint_by_id**](docs/CardAuthLoopEndpointApi.md#get_card_auth_loop_endpoint_by_id) | **GET** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Retrieve a Card Auth Loop Endpoint\n*CardAuthLoopEndpointApi* | [**update_card_auth_loop_endpoint_by_id**](docs/CardAuthLoopEndpointApi.md#update_card_auth_loop_endpoint_by_id) | **PATCH** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Update a Card Auth Loop Endpoint\n*CardChargeApi* | [**create_card_charge**](docs/CardChargeApi.md#create_card_charge) | **POST** /card/charge | Create Card Charge\n*CardChargeApi* | [**get_all_card_charges**](docs/CardChargeApi.md#get_all_card_charges) | **GET** /card/charge | Retrieve all Card Charges\n*CardEventApi* | [**get_all_card_events**](docs/CardEventApi.md#get_all_card_events) | **GET** /card_event | Retrieve All Card Events\n*CardEventApi* | [**get_card_event_by_id**](docs/CardEventApi.md#get_card_event_by_id) | **GET** /card_event/{card_event_id} | Retrieve Card Event\n*CardProductApi* | [**get_all_card_products**](docs/CardProductApi.md#get_all_card_products) | **GET** /cardproduct | Retrieve All Card Products\n*CardProductApi* | [**get_card_product_by_id**](docs/CardProductApi.md#get_card_product_by_id) | **GET** /cardproduct/{card_product_id} | Retrieve Card Product\n*CardProductApi* | [**update_card_product_by_id**](docs/CardProductApi.md#update_card_product_by_id) | **PATCH** /cardproduct/{card_product_id} | Update Card Product\n*CardsApi* | [**create_apple_pay_digital_wallet_token_by_card_id**](docs/CardsApi.md#create_apple_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/apple_pay | Provision Apply Pay\n*CardsApi* | [**create_card**](docs/CardsApi.md#create_card) | **POST** /card | Create Card\n*CardsApi* | [**create_card_auth_loop_endpoint**](docs/CardsApi.md#create_card_auth_loop_endpoint) | **POST** /card_auth_loop_endpoint | Create Card Auth Loop Endpoint\n*CardsApi* | [**create_card_by_person_id**](docs/CardsApi.md#create_card_by_person_id) | **POST** /person/{person_id}/card | Issue New Card\n*CardsApi* | [**create_google_pay_digital_wallet_token_by_card_id**](docs/CardsApi.md#create_google_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/google_pay | Provision Google Pay\n*CardsApi* | [**delete_card_auth_loop_endpoint_by_id**](docs/CardsApi.md#delete_card_auth_loop_endpoint_by_id) | **DELETE** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Delete a Card Auth Loop Endpoint\n*CardsApi* | [**get_all_card_auth_loop_endpoint**](docs/CardsApi.md#get_all_card_auth_loop_endpoint) | **GET** /card_auth_loop_endpoint | Retrieve All Card Auth Loop Endpoints\n*CardsApi* | [**get_all_card_events**](docs/CardsApi.md#get_all_card_events) | **GET** /card_event | Retrieve All Card Events\n*CardsApi* | [**get_all_card_products**](docs/CardsApi.md#get_all_card_products) | **GET** /cardproduct | Retrieve All Card Products\n*CardsApi* | [**get_all_cards**](docs/CardsApi.md#get_all_cards) | **GET** /card | Retrieve All Cards\n*CardsApi* | [**get_all_cards_by_person_id**](docs/CardsApi.md#get_all_cards_by_person_id) | **GET** /person/{person_id}/card | Retrieve All Person Cards\n*CardsApi* | [**get_card_auth_loop_endpoint_by_id**](docs/CardsApi.md#get_card_auth_loop_endpoint_by_id) | **GET** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Retrieve a Card Auth Loop Endpoint\n*CardsApi* | [**get_card_by_id**](docs/CardsApi.md#get_card_by_id) | **GET** /card/{card_id} | Retrieve Card\n*CardsApi* | [**get_card_by_person_id_and_card_id**](docs/CardsApi.md#get_card_by_person_id_and_card_id) | **GET** /person/{person_id}/card/{card_id} | Retrieve Card\n*CardsApi* | [**get_card_event_by_id**](docs/CardsApi.md#get_card_event_by_id) | **GET** /card_event/{card_event_id} | Retrieve Card Event\n*CardsApi* | [**get_card_product_by_id**](docs/CardsApi.md#get_card_product_by_id) | **GET** /cardproduct/{card_product_id} | Retrieve Card Product\n*CardsApi* | [**get_marqueta_token_by_card_id**](docs/CardsApi.md#get_marqueta_token_by_card_id) | **GET** /card/{card_id}/token | Request Client Access Token\n*CardsApi* | [**update_card_auth_loop_endpoint_by_id**](docs/CardsApi.md#update_card_auth_loop_endpoint_by_id) | **PATCH** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Update a Card Auth Loop Endpoint\n*CardsApi* | [**update_card_by_id**](docs/CardsApi.md#update_card_by_id) | **PATCH** /card/{card_id} | Remove Card Controls\n*CardsApi* | [**update_card_product_by_id**](docs/CardsApi.md#update_card_product_by_id) | **PATCH** /cardproduct/{card_product_id} | Update Card Product\n*CheckDepositApi* | [**create_check_deposit**](docs/CheckDepositApi.md#create_check_deposit) | **POST** /check_deposit | Create Check Deposit\n*CheckDepositApi* | [**get_all_check_deposits**](docs/CheckDepositApi.md#get_all_check_deposits) | **GET** /check_deposit | Retrieve all Check Deposits\n*CheckDepositApi* | [**get_check_deposit_by_id**](docs/CheckDepositApi.md#get_check_deposit_by_id) | **GET** /check_deposit/{check_id} | Retrieve Check Deposit\n*CheckImageApi* | [**get_all_check_images**](docs/CheckImageApi.md#get_all_check_images) | **GET** /check_image | List All Check Images\n*CheckImageApi* | [**get_check_image_by_id**](docs/CheckImageApi.md#get_check_image_by_id) | **GET** /check_image/{check_image_id} | Retrieve Check Image\n*CheckIssuingApi* | [**create_check**](docs/CheckIssuingApi.md#create_check) | **POST** /check | Create Check\n*CheckIssuingApi* | [**get_all_checks**](docs/CheckIssuingApi.md#get_all_checks) | **GET** /check | Retrieve all Checks\n*CheckIssuingApi* | [**get_check_by_id**](docs/CheckIssuingApi.md#get_check_by_id) | **GET** /check/{check_id} | Retrieve Check\n*CounterpartiesApi* | [**create_counterparty**](docs/CounterpartiesApi.md#create_counterparty) | **POST** /counterparty | Create Counterparty\n*CounterpartiesApi* | [**get_all_counterparties**](docs/CounterpartiesApi.md#get_all_counterparties) | **GET** /counterparty | Retrieve All Counterparties\n*CounterpartiesApi* | [**get_counterparty_by_id**](docs/CounterpartiesApi.md#get_counterparty_by_id) | **GET** /counterparty/{counterparty_id} | Retrieve Counterparty\n*CounterpartiesApi* | [**update_counterparty_by_id**](docs/CounterpartiesApi.md#update_counterparty_by_id) | **PATCH** /counterparty/{counterparty_id} | Update Counterparty\n*DailyBalanceApi* | [**get_daily_account_balance_by_id**](docs/DailyBalanceApi.md#get_daily_account_balance_by_id) | **GET** /account/{account_id}/daily_balance | List Daily Balances\n*DepositApi* | [**create_deposit**](docs/DepositApi.md#create_deposit) | **POST** /apply/deposit | Create Deposit\n*DepositApi* | [**get_all_deposits**](docs/DepositApi.md#get_all_deposits) | **GET** /apply/deposit | Retrieve All Deposits\n*DepositApi* | [**get_deposit_by_id**](docs/DepositApi.md#get_deposit_by_id) | **GET** /apply/deposit/{deposit_id} | Retrieve a Deposit\n*DigitalWalletTokensApi* | [**create_apple_pay_digital_wallet_token_by_card_id**](docs/DigitalWalletTokensApi.md#create_apple_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/apple_pay | Provision Apply Pay\n*DigitalWalletTokensApi* | [**create_google_pay_digital_wallet_token_by_card_id**](docs/DigitalWalletTokensApi.md#create_google_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/google_pay | Provision Google Pay\n*DocumentApi* | [**create_document**](docs/DocumentApi.md#create_document) | **POST** /document | Create a Document\n*DocumentApi* | [**get_all_documents**](docs/DocumentApi.md#get_all_documents) | **GET** /document | List All Documents\n*DocumentApi* | [**get_document_by_id**](docs/DocumentApi.md#get_document_by_id) | **GET** /document/{document_id} | Retrieve a Document\n*DocumentApi* | [**update_document_by_id**](docs/DocumentApi.md#update_document_by_id) | **PATCH** /document/{document_id} | Update a Document\n*FileUploadApi* | [**create_file**](docs/FileUploadApi.md#create_file) | **POST** /file | Create File\n*FileUploadApi* | [**get_file_by_id**](docs/FileUploadApi.md#get_file_by_id) | **GET** /file/{file_id} | Get File\n*IncomingWireApi* | [**get_all_incoming_wires**](docs/IncomingWireApi.md#get_all_incoming_wires) | **GET** /incoming_wire | Retrieve All Incoming Wires\n*IncomingWireApi* | [**get_incoming_wire_by_id**](docs/IncomingWireApi.md#get_incoming_wire_by_id) | **GET** /incoming_wire/{incoming_wire_id} | Retrieve Incoming Wire\n*KYCApi* | [**create_kyc_evaluation**](docs/KYCApi.md#create_kyc_evaluation) | **POST** /apply/kyc | Create KYC Evaluation\n*KYCApi* | [**get_all_kyc_evaluations**](docs/KYCApi.md#get_all_kyc_evaluations) | **GET** /apply/kyc | Retrieve All KYC\n*KYCApi* | [**get_all_kyc_products**](docs/KYCApi.md#get_all_kyc_products) | **GET** /apply/kyc_product | Retrieve All KYC Products\n*KYCApi* | [**get_kyc_evaluation_by_id**](docs/KYCApi.md#get_kyc_evaluation_by_id) | **GET** /apply/kyc/{kyc_id} | Retrieve KYC Evaluation\n*KYCProductApi* | [**get_kyc_product_by_id**](docs/KYCProductApi.md#get_kyc_product_by_id) | **GET** /apply/kyc_product/{kyc_product_id} | Retrieve a KYC Product\n*MarqetaJSApi* | [**get_marqueta_token_by_card_id**](docs/MarqetaJSApi.md#get_marqueta_token_by_card_id) | **GET** /card/{card_id}/token | Request Client Access Token\n*PaymentsApi* | [**create_ach_transfer**](docs/PaymentsApi.md#create_ach_transfer) | **POST** /ach | Create ACH\n*PaymentsApi* | [**create_bill_pay_counterparty**](docs/PaymentsApi.md#create_bill_pay_counterparty) | **POST** /billpay/counterparty | Create Bill Pay Counterparty\n*PaymentsApi* | [**create_bill_pay_payment**](docs/PaymentsApi.md#create_bill_pay_payment) | **POST** /billpay/payment | Create Payment\n*PaymentsApi* | [**create_bill_pay_rule**](docs/PaymentsApi.md#create_bill_pay_rule) | **POST** /billpay/rule | Create Rule\n*PaymentsApi* | [**create_book_transfer**](docs/PaymentsApi.md#create_book_transfer) | **POST** /book | Create Book Transfer\n*PaymentsApi* | [**create_card_charge**](docs/PaymentsApi.md#create_card_charge) | **POST** /card/charge | Create Card Charge\n*PaymentsApi* | [**create_check**](docs/PaymentsApi.md#create_check) | **POST** /check | Create Check\n*PaymentsApi* | [**create_check_deposit**](docs/PaymentsApi.md#create_check_deposit) | **POST** /check_deposit | Create Check Deposit\n*PaymentsApi* | [**create_counterparty**](docs/PaymentsApi.md#create_counterparty) | **POST** /counterparty | Create Counterparty\n*PaymentsApi* | [**create_wire**](docs/PaymentsApi.md#create_wire) | **POST** /wire | Create Wire\n*PaymentsApi* | [**get_ach_transfer_by_id**](docs/PaymentsApi.md#get_ach_transfer_by_id) | **GET** /ach/{ach_id} | Retrieve ACH\n*PaymentsApi* | [**get_all_ach_transfers**](docs/PaymentsApi.md#get_all_ach_transfers) | **GET** /ach | Retrieve All ACH\n*PaymentsApi* | [**get_all_bill_pay_counterparties**](docs/PaymentsApi.md#get_all_bill_pay_counterparties) | **GET** /billpay/counterparty | List all Bill Pay Counterparties\n*PaymentsApi* | [**get_all_bill_pay_merchants**](docs/PaymentsApi.md#get_all_bill_pay_merchants) | **GET** /billpay/merchant | Search for Merchant\n*PaymentsApi* | [**get_all_bill_pay_payments**](docs/PaymentsApi.md#get_all_bill_pay_payments) | **GET** /billpay/payment | Retrieve all Payments\n*PaymentsApi* | [**get_all_bill_pay_rules**](docs/PaymentsApi.md#get_all_bill_pay_rules) | **GET** /billpay/rule | List All Rules\n*PaymentsApi* | [**get_all_book_transfers**](docs/PaymentsApi.md#get_all_book_transfers) | **GET** /book | Retrieve All Book Transfers\n*PaymentsApi* | [**get_all_card_charges**](docs/PaymentsApi.md#get_all_card_charges) | **GET** /card/charge | Retrieve all Card Charges\n*PaymentsApi* | [**get_all_check_deposits**](docs/PaymentsApi.md#get_all_check_deposits) | **GET** /check_deposit | Retrieve all Check Deposits\n*PaymentsApi* | [**get_all_checks**](docs/PaymentsApi.md#get_all_checks) | **GET** /check | Retrieve all Checks\n*PaymentsApi* | [**get_all_counterparties**](docs/PaymentsApi.md#get_all_counterparties) | **GET** /counterparty | Retrieve All Counterparties\n*PaymentsApi* | [**get_all_incoming_wires**](docs/PaymentsApi.md#get_all_incoming_wires) | **GET** /incoming_wire | Retrieve All Incoming Wires\n*PaymentsApi* | [**get_all_wires**](docs/PaymentsApi.md#get_all_wires) | **GET** /wire | Retrieve All Wires\n*PaymentsApi* | [**get_bill_pay_counterparty_by_id**](docs/PaymentsApi.md#get_bill_pay_counterparty_by_id) | **GET** /billpay/counterparty/{billpay_counterparty_id} | Retrieve Bill Pay Counterparty\n*PaymentsApi* | [**get_bill_pay_payment_by_id**](docs/PaymentsApi.md#get_bill_pay_payment_by_id) | **GET** /billpay/payment/{billpay_payment_id} | Retrieve Payment\n*PaymentsApi* | [**get_bill_pay_rule_by_id**](docs/PaymentsApi.md#get_bill_pay_rule_by_id) | **GET** /billpay/rule/{billpay_rule_id} | Retrieve Rule\n*PaymentsApi* | [**get_book_transfer_by_id**](docs/PaymentsApi.md#get_book_transfer_by_id) | **GET** /book/{book_id} | Retrieve Book Transfer\n*PaymentsApi* | [**get_check_by_id**](docs/PaymentsApi.md#get_check_by_id) | **GET** /check/{check_id} | Retrieve Check\n*PaymentsApi* | [**get_check_deposit_by_id**](docs/PaymentsApi.md#get_check_deposit_by_id) | **GET** /check_deposit/{check_id} | Retrieve Check Deposit\n*PaymentsApi* | [**get_counterparty_by_id**](docs/PaymentsApi.md#get_counterparty_by_id) | **GET** /counterparty/{counterparty_id} | Retrieve Counterparty\n*PaymentsApi* | [**get_incoming_wire_by_id**](docs/PaymentsApi.md#get_incoming_wire_by_id) | **GET** /incoming_wire/{incoming_wire_id} | Retrieve Incoming Wire\n*PaymentsApi* | [**get_wire_by_id**](docs/PaymentsApi.md#get_wire_by_id) | **GET** /wire/{wire_id} | Retrieve Wire\n*PaymentsApi* | [**update_ach_transfer_by_id**](docs/PaymentsApi.md#update_ach_transfer_by_id) | **PATCH** /ach/{ach_id} | Update ACH\n*PaymentsApi* | [**update_bill_pay_payment_by_id**](docs/PaymentsApi.md#update_bill_pay_payment_by_id) | **PATCH** /billpay/payment/{billpay_payment_id} | Update Payment\n*PaymentsApi* | [**update_bill_pay_rule_by_id**](docs/PaymentsApi.md#update_bill_pay_rule_by_id) | **PATCH** /billpay/rule/{billpay_rule_id} | Update Rule\n*PaymentsApi* | [**update_book_transfer_by_id**](docs/PaymentsApi.md#update_book_transfer_by_id) | **PATCH** /book/{book_id} | Update Book Transfer\n*PaymentsApi* | [**update_counterparty_by_id**](docs/PaymentsApi.md#update_counterparty_by_id) | **PATCH** /counterparty/{counterparty_id} | Update Counterparty\n*PaymentsApi* | [**update_wire_by_id**](docs/PaymentsApi.md#update_wire_by_id) | **PATCH** /wire/{wire_id} | Update Wire\n*PersonApi* | [**create_card_by_person_id**](docs/PersonApi.md#create_card_by_person_id) | **POST** /person/{person_id}/card | Issue New Card\n*PersonApi* | [**get_all_cards_by_person_id**](docs/PersonApi.md#get_all_cards_by_person_id) | **GET** /person/{person_id}/card | Retrieve All Person Cards\n*PersonApi* | [**get_card_by_person_id_and_card_id**](docs/PersonApi.md#get_card_by_person_id_and_card_id) | **GET** /person/{person_id}/card/{card_id} | Retrieve Card\n*PersonApi* | [**get_person_by_id**](docs/PersonApi.md#get_person_by_id) | **GET** /person/{person_id} | Retrieve Person\n*PersonApi* | [**update_person_by_id**](docs/PersonApi.md#update_person_by_id) | **PATCH** /person/{person_id} | Update Person\n*PersonApplicationApi* | [**create_person_application**](docs/PersonApplicationApi.md#create_person_application) | **POST** /apply/person_application | Create Person Application\n*PersonApplicationApi* | [**get_all_person_applications**](docs/PersonApplicationApi.md#get_all_person_applications) | **GET** /apply/person_application | Retrieve All Person Applications\n*PersonApplicationApi* | [**get_person_application_by_id**](docs/PersonApplicationApi.md#get_person_application_by_id) | **GET** /apply/person_application/{person_application_id} | Retrieve Person Application\n*ReserveApi* | [**create_reserve**](docs/ReserveApi.md#create_reserve) | **POST** /reserve | Create a Reserve\n*ReserveApi* | [**delete_reserve_by_id**](docs/ReserveApi.md#delete_reserve_by_id) | **DELETE** /reserve/{reserve_id} | Delete a Reserve\n*ReserveApi* | [**get_all_reserves**](docs/ReserveApi.md#get_all_reserves) | **GET** /reserve | Retrieve all Reserves\n*ReserveApi* | [**get_reserve_by_id**](docs/ReserveApi.md#get_reserve_by_id) | **GET** /reserve/{reserve_id} | Retrieve Reserve\n*ReserveApi* | [**update_reserve_by_id**](docs/ReserveApi.md#update_reserve_by_id) | **PATCH** /reserve/{reserve_id} | Update Reserve\n*RoutingNumberApi* | [**get_routing_number**](docs/RoutingNumberApi.md#get_routing_number) | **GET** /routing_number/{routing_number} | Retrieve a Routing Number\n*SearchApi* | [**search**](docs/SearchApi.md#search) | **GET** /search | Search\n*SettingsApi* | [**get_setting**](docs/SettingsApi.md#get_setting) | **GET** /setting | Retrieve Setting\n*SimulationsApi* | [**simulation_post**](docs/SimulationsApi.md#simulation_post) | **POST** /simulation | Create a Wire simulation sent\n*StatementApi* | [**create_statement_config**](docs/StatementApi.md#create_statement_config) | **POST** /statement_config | Create Statement Config Copy\n*StatementApi* | [**get_account_statement_by_id_and_date**](docs/StatementApi.md#get_account_statement_by_id_and_date) | **GET** /account/{account_id}/statement | Retrieve Statement\n*StatementApi* | [**get_all_statement_configs**](docs/StatementApi.md#get_all_statement_configs) | **GET** /statement_config | Retrieve All Statement Configs\n*StatementApi* | [**update_statement_config_by_id**](docs/StatementApi.md#update_statement_config_by_id) | **PATCH** /statement_config/{statement_config_id} | Update Statement Config Copy\n*TransactionApi* | [**get_all_transactions**](docs/TransactionApi.md#get_all_transactions) | **GET** /transaction | Retrieve All Transactions\n*TransactionApi* | [**get_all_transactions_by_account**](docs/TransactionApi.md#get_all_transactions_by_account) | **GET** /account/{account_id}/transaction | Retrieve All Account Transactions\n*TransactionApi* | [**get_transaction_by_id**](docs/TransactionApi.md#get_transaction_by_id) | **GET** /transaction/{transaction_id} | Retrieve a Transaction\n*UtilitiesApi* | [**create_document**](docs/UtilitiesApi.md#create_document) | **POST** /document | Create a Document\n*UtilitiesApi* | [**create_file**](docs/UtilitiesApi.md#create_file) | **POST** /file | Create File\n*UtilitiesApi* | [**create_webhook**](docs/UtilitiesApi.md#create_webhook) | **POST** /webhook | Create Webhook\n*UtilitiesApi* | [**delete_webhook_by_id**](docs/UtilitiesApi.md#delete_webhook_by_id) | **DELETE** /webhook/{webhook_id} | Delete Webhook\n*UtilitiesApi* | [**get_all_documents**](docs/UtilitiesApi.md#get_all_documents) | **GET** /document | List All Documents\n*UtilitiesApi* | [**get_all_webhooks**](docs/UtilitiesApi.md#get_all_webhooks) | **GET** /webhook | Retrieve All Webhooks\n*UtilitiesApi* | [**get_document_by_id**](docs/UtilitiesApi.md#get_document_by_id) | **GET** /document/{document_id} | Retrieve a Document\n*UtilitiesApi* | [**get_file_by_id**](docs/UtilitiesApi.md#get_file_by_id) | **GET** /file/{file_id} | Get File\n*UtilitiesApi* | [**get_routing_number**](docs/UtilitiesApi.md#get_routing_number) | **GET** /routing_number/{routing_number} | Retrieve a Routing Number\n*UtilitiesApi* | [**get_setting**](docs/UtilitiesApi.md#get_setting) | **GET** /setting | Retrieve Setting\n*UtilitiesApi* | [**get_webhook_by_id**](docs/UtilitiesApi.md#get_webhook_by_id) | **GET** /webhook/{webhook_id} | Retrieve Webhook\n*UtilitiesApi* | [**search**](docs/UtilitiesApi.md#search) | **GET** /search | Search\n*UtilitiesApi* | [**update_document_by_id**](docs/UtilitiesApi.md#update_document_by_id) | **PATCH** /document/{document_id} | Update a Document\n*UtilitiesApi* | [**update_webhook_by_id**](docs/UtilitiesApi.md#update_webhook_by_id) | **PATCH** /webhook/{webhook_id} | Update Webhook\n*WebhooksApi* | [**create_webhook**](docs/WebhooksApi.md#create_webhook) | **POST** /webhook | Create Webhook\n*WebhooksApi* | [**delete_webhook_by_id**](docs/WebhooksApi.md#delete_webhook_by_id) | **DELETE** /webhook/{webhook_id} | Delete Webhook\n*WebhooksApi* | [**get_all_webhooks**](docs/WebhooksApi.md#get_all_webhooks) | **GET** /webhook | Retrieve All Webhooks\n*WebhooksApi* | [**get_webhook_by_id**](docs/WebhooksApi.md#get_webhook_by_id) | **GET** /webhook/{webhook_id} | Retrieve Webhook\n*WebhooksApi* | [**update_webhook_by_id**](docs/WebhooksApi.md#update_webhook_by_id) | **PATCH** /webhook/{webhook_id} | Update Webhook\n*WireApi* | [**create_wire**](docs/WireApi.md#create_wire) | **POST** /wire | Create Wire\n*WireApi* | [**get_all_wires**](docs/WireApi.md#get_all_wires) | **GET** /wire | Retrieve All Wires\n*WireApi* | [**get_wire_by_id**](docs/WireApi.md#get_wire_by_id) | **GET** /wire/{wire_id} | Retrieve Wire\n*WireApi* | [**update_wire_by_id**](docs/WireApi.md#update_wire_by_id) | **PATCH** /wire/{wire_id} | Update Wire\n*WireSimulationsApi* | [**simulation_post**](docs/WireSimulationsApi.md#simulation_post) | **POST** /simulation | Create a Wire simulation sent\n*DefaultApi* | [**get_health**](docs/DefaultApi.md#get_health) | **GET** /ping | API Health Check\n\n\n## Documentation For Models\n\n - [Account](docs/Account.md)\n - [AccountAddress](docs/AccountAddress.md)\n - [AccountApplication](docs/AccountApplication.md)\n - [AccountApplicationAllOf](docs/AccountApplicationAllOf.md)\n - [AccountLock](docs/AccountLock.md)\n - [AccountNumberReservation](docs/AccountNumberReservation.md)\n - [AccountProduct](docs/AccountProduct.md)\n - [Ach](docs/Ach.md)\n - [AchDeposit](docs/AchDeposit.md)\n - [AchDepositAllOf](docs/AchDepositAllOf.md)\n - [AchDepositAllOfAch](docs/AchDepositAllOfAch.md)\n - [AdditionalPersonApplication](docs/AdditionalPersonApplication.md)\n - [ApplePayToken](docs/ApplePayToken.md)\n - [AverageBalance](docs/AverageBalance.md)\n - [BaseDeposit](docs/BaseDeposit.md)\n - [BillPayCounterparty](docs/BillPayCounterparty.md)\n - [BillPayCounterpartyAddress](docs/BillPayCounterpartyAddress.md)\n - [BookTransfer](docs/BookTransfer.md)\n - [Business](docs/Business.md)\n - [BusinessApplication](docs/BusinessApplication.md)\n - [BusinessApplicationMailingAddress](docs/BusinessApplicationMailingAddress.md)\n - [BusinessApplicationPersonApplicationsInner](docs/BusinessApplicationPersonApplicationsInner.md)\n - [BusinessApplicationPhysicalAddress](docs/BusinessApplicationPhysicalAddress.md)\n - [Card](docs/Card.md)\n - [CardCharge](docs/CardCharge.md)\n - [CardChargeCard](docs/CardChargeCard.md)\n - [CardControls](docs/CardControls.md)\n - [CardControlsControlsInner](docs/CardControlsControlsInner.md)\n - [CardDeposit](docs/CardDeposit.md)\n - [CardDepositAllOf](docs/CardDepositAllOf.md)\n - [CardDepositAllOfCard](docs/CardDepositAllOfCard.md)\n - [CardEvent](docs/CardEvent.md)\n - [CardEventAtm](docs/CardEventAtm.md)\n - [CardEventMerchant](docs/CardEventMerchant.md)\n - [CardEventMerchantAddress](docs/CardEventMerchantAddress.md)\n - [CardFulfillment](docs/CardFulfillment.md)\n - [CardLoopAuthEndpoint](docs/CardLoopAuthEndpoint.md)\n - [CardProduct](docs/CardProduct.md)\n - [CardToken](docs/CardToken.md)\n - [Check](docs/Check.md)\n - [CheckDeposit](docs/CheckDeposit.md)\n - [CheckDepositDevice](docs/CheckDepositDevice.md)\n - [CheckImage](docs/CheckImage.md)\n - [CheckRecipient](docs/CheckRecipient.md)\n - [CheckRecipientAddress](docs/CheckRecipientAddress.md)\n - [Counterparty](docs/Counterparty.md)\n - [CounterpartyAch](docs/CounterpartyAch.md)\n - [CounterpartyWire](docs/CounterpartyWire.md)\n - [CounterpartyWireAddressOnAccount](docs/CounterpartyWireAddressOnAccount.md)\n - [CounterpartyWireBankAddress](docs/CounterpartyWireBankAddress.md)\n - [CreateApplePayDigitalWalletTokenByCardIdRequest](docs/CreateApplePayDigitalWalletTokenByCardIdRequest.md)\n - [CreateDepositRequest](docs/CreateDepositRequest.md)\n - [CreateDepositRequestOneOf](docs/CreateDepositRequestOneOf.md)\n - [CreateDepositRequestOneOf1](docs/CreateDepositRequestOneOf1.md)\n - [CreateDepositRequestOneOf1Ach](docs/CreateDepositRequestOneOf1Ach.md)\n - [CreateDepositRequestOneOfCard](docs/CreateDepositRequestOneOfCard.md)\n - [CreateGooglePayDigitalWalletTokenByCardIdRequest](docs/CreateGooglePayDigitalWalletTokenByCardIdRequest.md)\n - [DailyBalance](docs/DailyBalance.md)\n - [Deposit](docs/Deposit.md)\n - [Document](docs/Document.md)\n - [DocumentFields](docs/DocumentFields.md)\n - [File](docs/File.md)\n - [GetAccountStatementByIdAndDate200Response](docs/GetAccountStatementByIdAndDate200Response.md)\n - [GetAllAccountApplications200Response](docs/GetAllAccountApplications200Response.md)\n - [GetAllAccountNumberReservations200Response](docs/GetAllAccountNumberReservations200Response.md)\n - [GetAllAccountProducts200Response](docs/GetAllAccountProducts200Response.md)\n - [GetAllAccounts200Response](docs/GetAllAccounts200Response.md)\n - [GetAllAccounts200ResponseDataInner](docs/GetAllAccounts200ResponseDataInner.md)\n - [GetAllAccounts400Response](docs/GetAllAccounts400Response.md)\n - [GetAllAchTransfers200Response](docs/GetAllAchTransfers200Response.md)\n - [GetAllAdditionalPersonApplications200Response](docs/GetAllAdditionalPersonApplications200Response.md)\n - [GetAllBillPayCounterparties200Response](docs/GetAllBillPayCounterparties200Response.md)\n - [GetAllBillPayMerchants200Response](docs/GetAllBillPayMerchants200Response.md)\n - [GetAllBillPayPayments200Response](docs/GetAllBillPayPayments200Response.md)\n - [GetAllBillPayRules200Response](docs/GetAllBillPayRules200Response.md)\n - [GetAllBookTransfers200Response](docs/GetAllBookTransfers200Response.md)\n - [GetAllBusinessApplications200Response](docs/GetAllBusinessApplications200Response.md)\n - [GetAllCardAuthLoopEndpoint200Response](docs/GetAllCardAuthLoopEndpoint200Response.md)\n - [GetAllCardCharges200Response](docs/GetAllCardCharges200Response.md)\n - [GetAllCardEvents200Response](docs/GetAllCardEvents200Response.md)\n - [GetAllCardProducts200Response](docs/GetAllCardProducts200Response.md)\n - [GetAllCards200Response](docs/GetAllCards200Response.md)\n - [GetAllCheckDeposits200Response](docs/GetAllCheckDeposits200Response.md)\n - [GetAllCheckImages200Response](docs/GetAllCheckImages200Response.md)\n - [GetAllChecks200Response](docs/GetAllChecks200Response.md)\n - [GetAllCounterparties200Response](docs/GetAllCounterparties200Response.md)\n - [GetAllDeposits200Response](docs/GetAllDeposits200Response.md)\n - [GetAllDocuments200Response](docs/GetAllDocuments200Response.md)\n - [GetAllIncomingWires200Response](docs/GetAllIncomingWires200Response.md)\n - [GetAllKycEvaluations200Response](docs/GetAllKycEvaluations200Response.md)\n - [GetAllKycProducts200Response](docs/GetAllKycProducts200Response.md)\n - [GetAllPersonApplications200Response](docs/GetAllPersonApplications200Response.md)\n - [GetAllReserves200Response](docs/GetAllReserves200Response.md)\n - [GetAllStatementConfigs200Response](docs/GetAllStatementConfigs200Response.md)\n - [GetAllTransactionsByAccount200Response](docs/GetAllTransactionsByAccount200Response.md)\n - [GetAllWebhooks200Response](docs/GetAllWebhooks200Response.md)\n - [GetAllWires200Response](docs/GetAllWires200Response.md)\n - [GetAverageAccountBalanceById200Response](docs/GetAverageAccountBalanceById200Response.md)\n - [GetDailyAccountBalanceById200Response](docs/GetDailyAccountBalanceById200Response.md)\n - [GetHealth200Response](docs/GetHealth200Response.md)\n - [GooglePayToken](docs/GooglePayToken.md)\n - [GooglePayTokenPushTokenizeRequestData](docs/GooglePayTokenPushTokenizeRequestData.md)\n - [GooglePayTokenPushTokenizeRequestDataUserAddress](docs/GooglePayTokenPushTokenizeRequestDataUserAddress.md)\n - [IncomingWire](docs/IncomingWire.md)\n - [IncomingWireBeneficiary](docs/IncomingWireBeneficiary.md)\n - [IncomingWireBeneficiaryBankData](docs/IncomingWireBeneficiaryBankData.md)\n - [IncomingWireImad](docs/IncomingWireImad.md)\n - [IncomingWireImadParsed](docs/IncomingWireImadParsed.md)\n - [IncomingWireOriginator](docs/IncomingWireOriginator.md)\n - [IncomingWireOriginatorBankData](docs/IncomingWireOriginatorBankData.md)\n - [KycEvaluation](docs/KycEvaluation.md)\n - [KycEvaluationAllOf](docs/KycEvaluationAllOf.md)\n - [KycProduct](docs/KycProduct.md)\n - [LockAccount](docs/LockAccount.md)\n - [LockAccountLock](docs/LockAccountLock.md)\n - [Merchant](docs/Merchant.md)\n - [MerchantRestriction](docs/MerchantRestriction.md)\n - [Payment](docs/Payment.md)\n - [Person](docs/Person.md)\n - [PersonApplication](docs/PersonApplication.md)\n - [PersonApplicationMailingAddress](docs/PersonApplicationMailingAddress.md)\n - [PersonApplicationPhysicalAddress](docs/PersonApplicationPhysicalAddress.md)\n - [PersonBankdata](docs/PersonBankdata.md)\n - [PersonMailingAddress](docs/PersonMailingAddress.md)\n - [QueryResult](docs/QueryResult.md)\n - [Reserve](docs/Reserve.md)\n - [RoutingNumber](docs/RoutingNumber.md)\n - [Rule](docs/Rule.md)\n - [Search200Response](docs/Search200Response.md)\n - [Setting](docs/Setting.md)\n - [SimulationPostRequest](docs/SimulationPostRequest.md)\n - [SimulationPostRequestOneOf](docs/SimulationPostRequestOneOf.md)\n - [SimulationPostRequestOneOf1](docs/SimulationPostRequestOneOf1.md)\n - [SimulationPostRequestOneOf1Simulation](docs/SimulationPostRequestOneOf1Simulation.md)\n - [SimulationPostRequestOneOf1SimulationAtm](docs/SimulationPostRequestOneOf1SimulationAtm.md)\n - [SimulationPostRequestOneOf2](docs/SimulationPostRequestOneOf2.md)\n - [SimulationPostRequestOneOf2Simulation](docs/SimulationPostRequestOneOf2Simulation.md)\n - [SimulationPostRequestOneOf3](docs/SimulationPostRequestOneOf3.md)\n - [SimulationPostRequestOneOf4](docs/SimulationPostRequestOneOf4.md)\n - [SimulationPostRequestOneOf5](docs/SimulationPostRequestOneOf5.md)\n - [SimulationPostRequestOneOf5Simulation](docs/SimulationPostRequestOneOf5Simulation.md)\n - [SimulationPostRequestOneOf6](docs/SimulationPostRequestOneOf6.md)\n - [SimulationPostRequestOneOf7](docs/SimulationPostRequestOneOf7.md)\n - [SimulationPostRequestOneOf7Simulation](docs/SimulationPostRequestOneOf7Simulation.md)\n - [SimulationPostRequestOneOf8](docs/SimulationPostRequestOneOf8.md)\n - [SimulationPostRequestOneOf8Simulation](docs/SimulationPostRequestOneOf8Simulation.md)\n - [SimulationPostRequestOneOf9](docs/SimulationPostRequestOneOf9.md)\n - [SimulationPostRequestOneOfSimulation](docs/SimulationPostRequestOneOfSimulation.md)\n - [SimulationPostRequestOneOfSimulationMerchant](docs/SimulationPostRequestOneOfSimulationMerchant.md)\n - [SimulationPostRequestOneOfSimulationMerchantAddress](docs/SimulationPostRequestOneOfSimulationMerchantAddress.md)\n - [SpendVelocityRestriction](docs/SpendVelocityRestriction.md)\n - [StatementConfig](docs/StatementConfig.md)\n - [Transaction](docs/Transaction.md)\n - [TransactionIncomingWire](docs/TransactionIncomingWire.md)\n - [UnlockAccount](docs/UnlockAccount.md)\n - [UpdateAccountRequest](docs/UpdateAccountRequest.md)\n - [UpdateAccountStatus](docs/UpdateAccountStatus.md)\n - [UpdateAchTransferByIdRequest](docs/UpdateAchTransferByIdRequest.md)\n - [UpdateBillPayPaymentByIdRequest](docs/UpdateBillPayPaymentByIdRequest.md)\n - [UpdateBillPayRuleByIdRequest](docs/UpdateBillPayRuleByIdRequest.md)\n - [UpdateBookTransferByIdRequest](docs/UpdateBookTransferByIdRequest.md)\n - [UpdateBusinessApplicationByIdRequest](docs/UpdateBusinessApplicationByIdRequest.md)\n - [UpdateCardByIdRequest](docs/UpdateCardByIdRequest.md)\n - [UpdateDocumentByIdRequest](docs/UpdateDocumentByIdRequest.md)\n - [UpdateReserveByIdRequest](docs/UpdateReserveByIdRequest.md)\n - [UpdateUserData](docs/UpdateUserData.md)\n - [UpdateWebhookByIdRequest](docs/UpdateWebhookByIdRequest.md)\n - [UpdateWebhookByIdRequestAllOf](docs/UpdateWebhookByIdRequestAllOf.md)\n - [UpdateWireByIdRequest](docs/UpdateWireByIdRequest.md)\n - [Webhook](docs/Webhook.md)\n - [Wire](docs/Wire.md)\n - [WithdrawalVelocityRestriction](docs/WithdrawalVelocityRestriction.md)\n\n\n## Documentation For Authorization\n\n\n## basicAuth\n\n- **Type**: HTTP basic authentication\n\n\n## Author\n\nhelp@treasuryprime.com\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in treasury_prime_client.apis and treasury_prime_client.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from treasury_prime_client.api.default_api import DefaultApi`\n- `from treasury_prime_client.model.pet import Pet`\n\nSolution 2:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nimport treasury_prime_client\nfrom treasury_prime_client.apis import *\nfrom treasury_prime_client.models import *\n```\n\n',
    'author': 'Swadesh',
    'author_email': 'dev@swadesh.co',
    'maintainer': 'D. Kasi Pavan Kumar',
    'maintainer_email': 'kasi@swadesh.co',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
