# treasury-prime-client
# Treasury Prime API

The Treasury Prime APIs enable Developers to embed a full range of banking services, from cards to account opening to payments, into their applications.

More information at:  
[https://www.treasuryprime.com/developers](https://www.treasuryprime.com/developers)

## Getting Started

To use this collection, you will need to [generate a set of API Keys](https://developers.treasuryprime.com/guides/getting-started), then update the Postman Environment settings with your API_KEY_ID and API_SECRET_KEY.

![](https://drive.google.com/uc?id=1H399zwFTtTCqq7MF0m5KxEp2S0Etjo57)

## Developer Sandbox and API Keys

The Developer Sandbox has been created to provide a safe space to test the Treasury Prime APIs. You can sign up for a free Developer Sandbox account and generate a set of API Keys to authenticate your requests at  
[https://developers.sandbox.treasuryprime.com](https://developers.sandbox.treasuryprime.com)

## Docs

A complete set of API Reference documentation can be found at [https://developers.treasuryprime.com/docs/](https://developers.treasuryprime.com/docs/)

## Guides

A set of Developer Guides have been created to help quickly explain how to accomplish common tasks such as [Opening Accounts](https://developers.treasuryprime.com/guides/open-accounts) and [Issuing Debit Cards](https://developers.treasuryprime.com/guides/issuing-cards).

The Developer Guides can be found at  
[https://developers.sandbox.treasuryprime.com/guides](https://developers.sandbox.treasuryprime.com/guides)

### Feature Availability

Not all products and features are available at all of our bank partners. If you are a current customer and have questions regarding product or feature availability, please contact your Customer Success team or email [help@treasuryprime.com](mailto:help@treasuryprime.com).

> *NOTE:* This collection is maintained on a best-effort basis and is not guaranteed to be up-to-date with the latest API Schema. Please consult our [API Reference Docs](https://developers.treasuryprime.com/docs) for the most recent definitions.

API Version: 1.13.548-ge22afccc

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.13.548-ge22afccc
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonPriorClientCodegen
For more information, please visit [https://developers.treasuryprime.com/docs](https://developers.treasuryprime.com/docs)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import treasury_prime_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import treasury_prime_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import treasury_prime_client
from pprint import pprint
from treasury_prime_client.api import ach_api
from treasury_prime_client.model.ach import Ach
from treasury_prime_client.model.get_all_accounts400_response import GetAllAccounts400Response
from treasury_prime_client.model.get_all_ach_transfers200_response import GetAllAchTransfers200Response
from treasury_prime_client.model.update_ach_transfer_by_id_request import UpdateAchTransferByIdRequest
# Defining the host is optional and defaults to https://api.sandbox.treasuryprime.com
# See configuration.py for a list of all supported configuration parameters.
configuration = treasury_prime_client.Configuration(
    host = "https://api.sandbox.treasuryprime.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = treasury_prime_client.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)


# Enter a context with an instance of the API client
with treasury_prime_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ach_api.ACHApi(api_client)
    ach = Ach(
        account_id="account_id_example",
        amount="4.80",
        counterparty_id="counterparty_id_example",
        description="description_example",
        direction="credit",
        sec_code="sec_code_example",
        service="standard",
        userdata={},
        addenda=[
            "addenda_example",
        ],
    ) # Ach |  (optional)

    try:
        # Create ACH
        api_response = api_instance.create_ach_transfer(ach=ach)
        pprint(api_response)
    except treasury_prime_client.ApiException as e:
        print("Exception when calling ACHApi->create_ach_transfer: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.sandbox.treasuryprime.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ACHApi* | [**create_ach_transfer**](docs/ACHApi.md#create_ach_transfer) | **POST** /ach | Create ACH
*ACHApi* | [**get_ach_transfer_by_id**](docs/ACHApi.md#get_ach_transfer_by_id) | **GET** /ach/{ach_id} | Retrieve ACH
*ACHApi* | [**get_all_ach_transfers**](docs/ACHApi.md#get_all_ach_transfers) | **GET** /ach | Retrieve All ACH
*ACHApi* | [**update_ach_transfer_by_id**](docs/ACHApi.md#update_ach_transfer_by_id) | **PATCH** /ach/{ach_id} | Update ACH
*AccountApplicationApi* | [**create_account_application**](docs/AccountApplicationApi.md#create_account_application) | **POST** /apply/account_application | Create Account Application
*AccountApplicationApi* | [**get_account_application_by_id**](docs/AccountApplicationApi.md#get_account_application_by_id) | **GET** /apply/account_application/{account_application_id} | Retrieve Account Application
*AccountApplicationApi* | [**get_all_account_applications**](docs/AccountApplicationApi.md#get_all_account_applications) | **GET** /apply/account_application | Retrieve All Account Applications
*AccountOpeningApi* | [**create_account_application**](docs/AccountOpeningApi.md#create_account_application) | **POST** /apply/account_application | Create Account Application
*AccountOpeningApi* | [**create_account_number_reservation**](docs/AccountOpeningApi.md#create_account_number_reservation) | **POST** /account_number_reservation | Create Account Number Reservation
*AccountOpeningApi* | [**create_additional_person_application**](docs/AccountOpeningApi.md#create_additional_person_application) | **POST** /apply/additional_person_application | Create Additional Person Application
*AccountOpeningApi* | [**create_business_application**](docs/AccountOpeningApi.md#create_business_application) | **POST** /apply/business_application | Create Business Application
*AccountOpeningApi* | [**create_deposit**](docs/AccountOpeningApi.md#create_deposit) | **POST** /apply/deposit | Create Deposit
*AccountOpeningApi* | [**create_kyc_evaluation**](docs/AccountOpeningApi.md#create_kyc_evaluation) | **POST** /apply/kyc | Create KYC Evaluation
*AccountOpeningApi* | [**create_person_application**](docs/AccountOpeningApi.md#create_person_application) | **POST** /apply/person_application | Create Person Application
*AccountOpeningApi* | [**get_account_application_by_id**](docs/AccountOpeningApi.md#get_account_application_by_id) | **GET** /apply/account_application/{account_application_id} | Retrieve Account Application
*AccountOpeningApi* | [**get_account_number_reservation_by_id**](docs/AccountOpeningApi.md#get_account_number_reservation_by_id) | **GET** /account_number_reservation/{account_number_reservation_id} | Retrieve Account Number Reservation
*AccountOpeningApi* | [**get_account_product_by_id**](docs/AccountOpeningApi.md#get_account_product_by_id) | **GET** /account_product/{account_product_id} | Retrieve Account Product
*AccountOpeningApi* | [**get_additional_person_application_by_id**](docs/AccountOpeningApi.md#get_additional_person_application_by_id) | **GET** /apply/additional_person_application/{additional_person_application_id} | Retrieve Additional Person Application
*AccountOpeningApi* | [**get_all_account_applications**](docs/AccountOpeningApi.md#get_all_account_applications) | **GET** /apply/account_application | Retrieve All Account Applications
*AccountOpeningApi* | [**get_all_account_number_reservations**](docs/AccountOpeningApi.md#get_all_account_number_reservations) | **GET** /account_number_reservation | Retrieve All Account Number Reservation
*AccountOpeningApi* | [**get_all_account_products**](docs/AccountOpeningApi.md#get_all_account_products) | **GET** /account_product | Retrieve all Account Products
*AccountOpeningApi* | [**get_all_additional_person_applications**](docs/AccountOpeningApi.md#get_all_additional_person_applications) | **GET** /apply/additional_person_application | Retrieve All Additional Person Applications
*AccountOpeningApi* | [**get_all_business_applications**](docs/AccountOpeningApi.md#get_all_business_applications) | **GET** /apply/business_application | Retrieve All Business Applications
*AccountOpeningApi* | [**get_all_deposits**](docs/AccountOpeningApi.md#get_all_deposits) | **GET** /apply/deposit | Retrieve All Deposits
*AccountOpeningApi* | [**get_all_kyc_evaluations**](docs/AccountOpeningApi.md#get_all_kyc_evaluations) | **GET** /apply/kyc | Retrieve All KYC
*AccountOpeningApi* | [**get_all_kyc_products**](docs/AccountOpeningApi.md#get_all_kyc_products) | **GET** /apply/kyc_product | Retrieve All KYC Products
*AccountOpeningApi* | [**get_all_person_applications**](docs/AccountOpeningApi.md#get_all_person_applications) | **GET** /apply/person_application | Retrieve All Person Applications
*AccountOpeningApi* | [**get_business_application_by_id**](docs/AccountOpeningApi.md#get_business_application_by_id) | **GET** /apply/business_application/{business_application_id} | Retrieve Business Application
*AccountOpeningApi* | [**get_deposit_by_id**](docs/AccountOpeningApi.md#get_deposit_by_id) | **GET** /apply/deposit/{deposit_id} | Retrieve a Deposit
*AccountOpeningApi* | [**get_kyc_evaluation_by_id**](docs/AccountOpeningApi.md#get_kyc_evaluation_by_id) | **GET** /apply/kyc/{kyc_id} | Retrieve KYC Evaluation
*AccountOpeningApi* | [**get_kyc_product_by_id**](docs/AccountOpeningApi.md#get_kyc_product_by_id) | **GET** /apply/kyc_product/{kyc_product_id} | Retrieve a KYC Product
*AccountOpeningApi* | [**get_person_application_by_id**](docs/AccountOpeningApi.md#get_person_application_by_id) | **GET** /apply/person_application/{person_application_id} | Retrieve Person Application
*AccountOpeningApi* | [**update_additional_person_application_by_id**](docs/AccountOpeningApi.md#update_additional_person_application_by_id) | **PATCH** /apply/additional_person_application/{additional_person_application_id} | Update Additional Person Application
*AccountOpeningApi* | [**update_business_application_by_id**](docs/AccountOpeningApi.md#update_business_application_by_id) | **PATCH** /apply/business_application/{business_application_id} | Update Business Application
*AccountsApi* | [**create_card_by_person_id**](docs/AccountsApi.md#create_card_by_person_id) | **POST** /person/{person_id}/card | Issue New Card
*AccountsApi* | [**create_reserve**](docs/AccountsApi.md#create_reserve) | **POST** /reserve | Create a Reserve
*AccountsApi* | [**create_statement_config**](docs/AccountsApi.md#create_statement_config) | **POST** /statement_config | Create Statement Config Copy
*AccountsApi* | [**delete_reserve_by_id**](docs/AccountsApi.md#delete_reserve_by_id) | **DELETE** /reserve/{reserve_id} | Delete a Reserve
*AccountsApi* | [**get_account_by_id**](docs/AccountsApi.md#get_account_by_id) | **GET** /account/{account_id} | Retrieve Account
*AccountsApi* | [**get_account_statement_by_id_and_date**](docs/AccountsApi.md#get_account_statement_by_id_and_date) | **GET** /account/{account_id}/statement | Retrieve Statement
*AccountsApi* | [**get_all_accounts**](docs/AccountsApi.md#get_all_accounts) | **GET** /account | Retrieve All Accounts
*AccountsApi* | [**get_all_cards_by_person_id**](docs/AccountsApi.md#get_all_cards_by_person_id) | **GET** /person/{person_id}/card | Retrieve All Person Cards
*AccountsApi* | [**get_all_check_images**](docs/AccountsApi.md#get_all_check_images) | **GET** /check_image | List All Check Images
*AccountsApi* | [**get_all_reserves**](docs/AccountsApi.md#get_all_reserves) | **GET** /reserve | Retrieve all Reserves
*AccountsApi* | [**get_all_statement_configs**](docs/AccountsApi.md#get_all_statement_configs) | **GET** /statement_config | Retrieve All Statement Configs
*AccountsApi* | [**get_all_transactions**](docs/AccountsApi.md#get_all_transactions) | **GET** /transaction | Retrieve All Transactions
*AccountsApi* | [**get_all_transactions_by_account**](docs/AccountsApi.md#get_all_transactions_by_account) | **GET** /account/{account_id}/transaction | Retrieve All Account Transactions
*AccountsApi* | [**get_average_account_balance_by_id**](docs/AccountsApi.md#get_average_account_balance_by_id) | **GET** /account/{account_id}/average_balance | List Average Balances
*AccountsApi* | [**get_business_by_id**](docs/AccountsApi.md#get_business_by_id) | **GET** /business/{business_id} | Retrieve Business
*AccountsApi* | [**get_card_by_person_id_and_card_id**](docs/AccountsApi.md#get_card_by_person_id_and_card_id) | **GET** /person/{person_id}/card/{card_id} | Retrieve Card
*AccountsApi* | [**get_check_image_by_id**](docs/AccountsApi.md#get_check_image_by_id) | **GET** /check_image/{check_image_id} | Retrieve Check Image
*AccountsApi* | [**get_daily_account_balance_by_id**](docs/AccountsApi.md#get_daily_account_balance_by_id) | **GET** /account/{account_id}/daily_balance | List Daily Balances
*AccountsApi* | [**get_person_by_id**](docs/AccountsApi.md#get_person_by_id) | **GET** /person/{person_id} | Retrieve Person
*AccountsApi* | [**get_reserve_by_id**](docs/AccountsApi.md#get_reserve_by_id) | **GET** /reserve/{reserve_id} | Retrieve Reserve
*AccountsApi* | [**get_transaction_by_id**](docs/AccountsApi.md#get_transaction_by_id) | **GET** /transaction/{transaction_id} | Retrieve a Transaction
*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PATCH** /account/{account_id} | Lock a Account
*AccountsApi* | [**update_person_by_id**](docs/AccountsApi.md#update_person_by_id) | **PATCH** /person/{person_id} | Update Person
*AccountsApi* | [**update_reserve_by_id**](docs/AccountsApi.md#update_reserve_by_id) | **PATCH** /reserve/{reserve_id} | Update Reserve
*AccountsApi* | [**update_statement_config_by_id**](docs/AccountsApi.md#update_statement_config_by_id) | **PATCH** /statement_config/{statement_config_id} | Update Statement Config Copy
*AdditionalPersonApplicationApi* | [**create_additional_person_application**](docs/AdditionalPersonApplicationApi.md#create_additional_person_application) | **POST** /apply/additional_person_application | Create Additional Person Application
*AdditionalPersonApplicationApi* | [**get_additional_person_application_by_id**](docs/AdditionalPersonApplicationApi.md#get_additional_person_application_by_id) | **GET** /apply/additional_person_application/{additional_person_application_id} | Retrieve Additional Person Application
*AdditionalPersonApplicationApi* | [**get_all_additional_person_applications**](docs/AdditionalPersonApplicationApi.md#get_all_additional_person_applications) | **GET** /apply/additional_person_application | Retrieve All Additional Person Applications
*AdditionalPersonApplicationApi* | [**update_additional_person_application_by_id**](docs/AdditionalPersonApplicationApi.md#update_additional_person_application_by_id) | **PATCH** /apply/additional_person_application/{additional_person_application_id} | Update Additional Person Application
*AverageBalanceApi* | [**get_average_account_balance_by_id**](docs/AverageBalanceApi.md#get_average_account_balance_by_id) | **GET** /account/{account_id}/average_balance | List Average Balances
*BillPayApi* | [**create_bill_pay_counterparty**](docs/BillPayApi.md#create_bill_pay_counterparty) | **POST** /billpay/counterparty | Create Bill Pay Counterparty
*BillPayApi* | [**create_bill_pay_payment**](docs/BillPayApi.md#create_bill_pay_payment) | **POST** /billpay/payment | Create Payment
*BillPayApi* | [**create_bill_pay_rule**](docs/BillPayApi.md#create_bill_pay_rule) | **POST** /billpay/rule | Create Rule
*BillPayApi* | [**get_all_bill_pay_counterparties**](docs/BillPayApi.md#get_all_bill_pay_counterparties) | **GET** /billpay/counterparty | List all Bill Pay Counterparties
*BillPayApi* | [**get_all_bill_pay_merchants**](docs/BillPayApi.md#get_all_bill_pay_merchants) | **GET** /billpay/merchant | Search for Merchant
*BillPayApi* | [**get_all_bill_pay_payments**](docs/BillPayApi.md#get_all_bill_pay_payments) | **GET** /billpay/payment | Retrieve all Payments
*BillPayApi* | [**get_all_bill_pay_rules**](docs/BillPayApi.md#get_all_bill_pay_rules) | **GET** /billpay/rule | List All Rules
*BillPayApi* | [**get_bill_pay_counterparty_by_id**](docs/BillPayApi.md#get_bill_pay_counterparty_by_id) | **GET** /billpay/counterparty/{billpay_counterparty_id} | Retrieve Bill Pay Counterparty
*BillPayApi* | [**get_bill_pay_payment_by_id**](docs/BillPayApi.md#get_bill_pay_payment_by_id) | **GET** /billpay/payment/{billpay_payment_id} | Retrieve Payment
*BillPayApi* | [**get_bill_pay_rule_by_id**](docs/BillPayApi.md#get_bill_pay_rule_by_id) | **GET** /billpay/rule/{billpay_rule_id} | Retrieve Rule
*BillPayApi* | [**update_bill_pay_payment_by_id**](docs/BillPayApi.md#update_bill_pay_payment_by_id) | **PATCH** /billpay/payment/{billpay_payment_id} | Update Payment
*BillPayApi* | [**update_bill_pay_rule_by_id**](docs/BillPayApi.md#update_bill_pay_rule_by_id) | **PATCH** /billpay/rule/{billpay_rule_id} | Update Rule
*BookApi* | [**create_book_transfer**](docs/BookApi.md#create_book_transfer) | **POST** /book | Create Book Transfer
*BookApi* | [**get_all_book_transfers**](docs/BookApi.md#get_all_book_transfers) | **GET** /book | Retrieve All Book Transfers
*BookApi* | [**get_book_transfer_by_id**](docs/BookApi.md#get_book_transfer_by_id) | **GET** /book/{book_id} | Retrieve Book Transfer
*BookApi* | [**update_book_transfer_by_id**](docs/BookApi.md#update_book_transfer_by_id) | **PATCH** /book/{book_id} | Update Book Transfer
*BusinessApi* | [**get_business_by_id**](docs/BusinessApi.md#get_business_by_id) | **GET** /business/{business_id} | Retrieve Business
*BusinessApplicationApi* | [**create_business_application**](docs/BusinessApplicationApi.md#create_business_application) | **POST** /apply/business_application | Create Business Application
*BusinessApplicationApi* | [**get_all_business_applications**](docs/BusinessApplicationApi.md#get_all_business_applications) | **GET** /apply/business_application | Retrieve All Business Applications
*BusinessApplicationApi* | [**get_business_application_by_id**](docs/BusinessApplicationApi.md#get_business_application_by_id) | **GET** /apply/business_application/{business_application_id} | Retrieve Business Application
*BusinessApplicationApi* | [**update_business_application_by_id**](docs/BusinessApplicationApi.md#update_business_application_by_id) | **PATCH** /apply/business_application/{business_application_id} | Update Business Application
*CardAuthLoopEndpointApi* | [**create_card_auth_loop_endpoint**](docs/CardAuthLoopEndpointApi.md#create_card_auth_loop_endpoint) | **POST** /card_auth_loop_endpoint | Create Card Auth Loop Endpoint
*CardAuthLoopEndpointApi* | [**delete_card_auth_loop_endpoint_by_id**](docs/CardAuthLoopEndpointApi.md#delete_card_auth_loop_endpoint_by_id) | **DELETE** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Delete a Card Auth Loop Endpoint
*CardAuthLoopEndpointApi* | [**get_all_card_auth_loop_endpoint**](docs/CardAuthLoopEndpointApi.md#get_all_card_auth_loop_endpoint) | **GET** /card_auth_loop_endpoint | Retrieve All Card Auth Loop Endpoints
*CardAuthLoopEndpointApi* | [**get_card_auth_loop_endpoint_by_id**](docs/CardAuthLoopEndpointApi.md#get_card_auth_loop_endpoint_by_id) | **GET** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Retrieve a Card Auth Loop Endpoint
*CardAuthLoopEndpointApi* | [**update_card_auth_loop_endpoint_by_id**](docs/CardAuthLoopEndpointApi.md#update_card_auth_loop_endpoint_by_id) | **PATCH** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Update a Card Auth Loop Endpoint
*CardChargeApi* | [**create_card_charge**](docs/CardChargeApi.md#create_card_charge) | **POST** /card/charge | Create Card Charge
*CardChargeApi* | [**get_all_card_charges**](docs/CardChargeApi.md#get_all_card_charges) | **GET** /card/charge | Retrieve all Card Charges
*CardEventApi* | [**get_all_card_events**](docs/CardEventApi.md#get_all_card_events) | **GET** /card_event | Retrieve All Card Events
*CardEventApi* | [**get_card_event_by_id**](docs/CardEventApi.md#get_card_event_by_id) | **GET** /card_event/{card_event_id} | Retrieve Card Event
*CardProductApi* | [**get_all_card_products**](docs/CardProductApi.md#get_all_card_products) | **GET** /cardproduct | Retrieve All Card Products
*CardProductApi* | [**get_card_product_by_id**](docs/CardProductApi.md#get_card_product_by_id) | **GET** /cardproduct/{card_product_id} | Retrieve Card Product
*CardProductApi* | [**update_card_product_by_id**](docs/CardProductApi.md#update_card_product_by_id) | **PATCH** /cardproduct/{card_product_id} | Update Card Product
*CardsApi* | [**create_apple_pay_digital_wallet_token_by_card_id**](docs/CardsApi.md#create_apple_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/apple_pay | Provision Apply Pay
*CardsApi* | [**create_card**](docs/CardsApi.md#create_card) | **POST** /card | Create Card
*CardsApi* | [**create_card_auth_loop_endpoint**](docs/CardsApi.md#create_card_auth_loop_endpoint) | **POST** /card_auth_loop_endpoint | Create Card Auth Loop Endpoint
*CardsApi* | [**create_card_by_person_id**](docs/CardsApi.md#create_card_by_person_id) | **POST** /person/{person_id}/card | Issue New Card
*CardsApi* | [**create_google_pay_digital_wallet_token_by_card_id**](docs/CardsApi.md#create_google_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/google_pay | Provision Google Pay
*CardsApi* | [**delete_card_auth_loop_endpoint_by_id**](docs/CardsApi.md#delete_card_auth_loop_endpoint_by_id) | **DELETE** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Delete a Card Auth Loop Endpoint
*CardsApi* | [**get_all_card_auth_loop_endpoint**](docs/CardsApi.md#get_all_card_auth_loop_endpoint) | **GET** /card_auth_loop_endpoint | Retrieve All Card Auth Loop Endpoints
*CardsApi* | [**get_all_card_events**](docs/CardsApi.md#get_all_card_events) | **GET** /card_event | Retrieve All Card Events
*CardsApi* | [**get_all_card_products**](docs/CardsApi.md#get_all_card_products) | **GET** /cardproduct | Retrieve All Card Products
*CardsApi* | [**get_all_cards**](docs/CardsApi.md#get_all_cards) | **GET** /card | Retrieve All Cards
*CardsApi* | [**get_all_cards_by_person_id**](docs/CardsApi.md#get_all_cards_by_person_id) | **GET** /person/{person_id}/card | Retrieve All Person Cards
*CardsApi* | [**get_card_auth_loop_endpoint_by_id**](docs/CardsApi.md#get_card_auth_loop_endpoint_by_id) | **GET** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Retrieve a Card Auth Loop Endpoint
*CardsApi* | [**get_card_by_id**](docs/CardsApi.md#get_card_by_id) | **GET** /card/{card_id} | Retrieve Card
*CardsApi* | [**get_card_by_person_id_and_card_id**](docs/CardsApi.md#get_card_by_person_id_and_card_id) | **GET** /person/{person_id}/card/{card_id} | Retrieve Card
*CardsApi* | [**get_card_event_by_id**](docs/CardsApi.md#get_card_event_by_id) | **GET** /card_event/{card_event_id} | Retrieve Card Event
*CardsApi* | [**get_card_product_by_id**](docs/CardsApi.md#get_card_product_by_id) | **GET** /cardproduct/{card_product_id} | Retrieve Card Product
*CardsApi* | [**get_marqueta_token_by_card_id**](docs/CardsApi.md#get_marqueta_token_by_card_id) | **GET** /card/{card_id}/token | Request Client Access Token
*CardsApi* | [**update_card_auth_loop_endpoint_by_id**](docs/CardsApi.md#update_card_auth_loop_endpoint_by_id) | **PATCH** /card_auth_loop_endpoint/{card_auth_loop_endpoint_id} | Update a Card Auth Loop Endpoint
*CardsApi* | [**update_card_by_id**](docs/CardsApi.md#update_card_by_id) | **PATCH** /card/{card_id} | Remove Card Controls
*CardsApi* | [**update_card_product_by_id**](docs/CardsApi.md#update_card_product_by_id) | **PATCH** /cardproduct/{card_product_id} | Update Card Product
*CheckDepositApi* | [**create_check_deposit**](docs/CheckDepositApi.md#create_check_deposit) | **POST** /check_deposit | Create Check Deposit
*CheckDepositApi* | [**get_all_check_deposits**](docs/CheckDepositApi.md#get_all_check_deposits) | **GET** /check_deposit | Retrieve all Check Deposits
*CheckDepositApi* | [**get_check_deposit_by_id**](docs/CheckDepositApi.md#get_check_deposit_by_id) | **GET** /check_deposit/{check_id} | Retrieve Check Deposit
*CheckImageApi* | [**get_all_check_images**](docs/CheckImageApi.md#get_all_check_images) | **GET** /check_image | List All Check Images
*CheckImageApi* | [**get_check_image_by_id**](docs/CheckImageApi.md#get_check_image_by_id) | **GET** /check_image/{check_image_id} | Retrieve Check Image
*CheckIssuingApi* | [**create_check**](docs/CheckIssuingApi.md#create_check) | **POST** /check | Create Check
*CheckIssuingApi* | [**get_all_checks**](docs/CheckIssuingApi.md#get_all_checks) | **GET** /check | Retrieve all Checks
*CheckIssuingApi* | [**get_check_by_id**](docs/CheckIssuingApi.md#get_check_by_id) | **GET** /check/{check_id} | Retrieve Check
*CounterpartiesApi* | [**create_counterparty**](docs/CounterpartiesApi.md#create_counterparty) | **POST** /counterparty | Create Counterparty
*CounterpartiesApi* | [**get_all_counterparties**](docs/CounterpartiesApi.md#get_all_counterparties) | **GET** /counterparty | Retrieve All Counterparties
*CounterpartiesApi* | [**get_counterparty_by_id**](docs/CounterpartiesApi.md#get_counterparty_by_id) | **GET** /counterparty/{counterparty_id} | Retrieve Counterparty
*CounterpartiesApi* | [**update_counterparty_by_id**](docs/CounterpartiesApi.md#update_counterparty_by_id) | **PATCH** /counterparty/{counterparty_id} | Update Counterparty
*DailyBalanceApi* | [**get_daily_account_balance_by_id**](docs/DailyBalanceApi.md#get_daily_account_balance_by_id) | **GET** /account/{account_id}/daily_balance | List Daily Balances
*DepositApi* | [**create_deposit**](docs/DepositApi.md#create_deposit) | **POST** /apply/deposit | Create Deposit
*DepositApi* | [**get_all_deposits**](docs/DepositApi.md#get_all_deposits) | **GET** /apply/deposit | Retrieve All Deposits
*DepositApi* | [**get_deposit_by_id**](docs/DepositApi.md#get_deposit_by_id) | **GET** /apply/deposit/{deposit_id} | Retrieve a Deposit
*DigitalWalletTokensApi* | [**create_apple_pay_digital_wallet_token_by_card_id**](docs/DigitalWalletTokensApi.md#create_apple_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/apple_pay | Provision Apply Pay
*DigitalWalletTokensApi* | [**create_google_pay_digital_wallet_token_by_card_id**](docs/DigitalWalletTokensApi.md#create_google_pay_digital_wallet_token_by_card_id) | **POST** /card/{card_id}/digital_wallet_token/google_pay | Provision Google Pay
*DocumentApi* | [**create_document**](docs/DocumentApi.md#create_document) | **POST** /document | Create a Document
*DocumentApi* | [**get_all_documents**](docs/DocumentApi.md#get_all_documents) | **GET** /document | List All Documents
*DocumentApi* | [**get_document_by_id**](docs/DocumentApi.md#get_document_by_id) | **GET** /document/{document_id} | Retrieve a Document
*DocumentApi* | [**update_document_by_id**](docs/DocumentApi.md#update_document_by_id) | **PATCH** /document/{document_id} | Update a Document
*FileUploadApi* | [**create_file**](docs/FileUploadApi.md#create_file) | **POST** /file | Create File
*FileUploadApi* | [**get_file_by_id**](docs/FileUploadApi.md#get_file_by_id) | **GET** /file/{file_id} | Get File
*IncomingWireApi* | [**get_all_incoming_wires**](docs/IncomingWireApi.md#get_all_incoming_wires) | **GET** /incoming_wire | Retrieve All Incoming Wires
*IncomingWireApi* | [**get_incoming_wire_by_id**](docs/IncomingWireApi.md#get_incoming_wire_by_id) | **GET** /incoming_wire/{incoming_wire_id} | Retrieve Incoming Wire
*KYCApi* | [**create_kyc_evaluation**](docs/KYCApi.md#create_kyc_evaluation) | **POST** /apply/kyc | Create KYC Evaluation
*KYCApi* | [**get_all_kyc_evaluations**](docs/KYCApi.md#get_all_kyc_evaluations) | **GET** /apply/kyc | Retrieve All KYC
*KYCApi* | [**get_all_kyc_products**](docs/KYCApi.md#get_all_kyc_products) | **GET** /apply/kyc_product | Retrieve All KYC Products
*KYCApi* | [**get_kyc_evaluation_by_id**](docs/KYCApi.md#get_kyc_evaluation_by_id) | **GET** /apply/kyc/{kyc_id} | Retrieve KYC Evaluation
*KYCProductApi* | [**get_kyc_product_by_id**](docs/KYCProductApi.md#get_kyc_product_by_id) | **GET** /apply/kyc_product/{kyc_product_id} | Retrieve a KYC Product
*MarqetaJSApi* | [**get_marqueta_token_by_card_id**](docs/MarqetaJSApi.md#get_marqueta_token_by_card_id) | **GET** /card/{card_id}/token | Request Client Access Token
*PaymentsApi* | [**create_ach_transfer**](docs/PaymentsApi.md#create_ach_transfer) | **POST** /ach | Create ACH
*PaymentsApi* | [**create_bill_pay_counterparty**](docs/PaymentsApi.md#create_bill_pay_counterparty) | **POST** /billpay/counterparty | Create Bill Pay Counterparty
*PaymentsApi* | [**create_bill_pay_payment**](docs/PaymentsApi.md#create_bill_pay_payment) | **POST** /billpay/payment | Create Payment
*PaymentsApi* | [**create_bill_pay_rule**](docs/PaymentsApi.md#create_bill_pay_rule) | **POST** /billpay/rule | Create Rule
*PaymentsApi* | [**create_book_transfer**](docs/PaymentsApi.md#create_book_transfer) | **POST** /book | Create Book Transfer
*PaymentsApi* | [**create_card_charge**](docs/PaymentsApi.md#create_card_charge) | **POST** /card/charge | Create Card Charge
*PaymentsApi* | [**create_check**](docs/PaymentsApi.md#create_check) | **POST** /check | Create Check
*PaymentsApi* | [**create_check_deposit**](docs/PaymentsApi.md#create_check_deposit) | **POST** /check_deposit | Create Check Deposit
*PaymentsApi* | [**create_counterparty**](docs/PaymentsApi.md#create_counterparty) | **POST** /counterparty | Create Counterparty
*PaymentsApi* | [**create_wire**](docs/PaymentsApi.md#create_wire) | **POST** /wire | Create Wire
*PaymentsApi* | [**get_ach_transfer_by_id**](docs/PaymentsApi.md#get_ach_transfer_by_id) | **GET** /ach/{ach_id} | Retrieve ACH
*PaymentsApi* | [**get_all_ach_transfers**](docs/PaymentsApi.md#get_all_ach_transfers) | **GET** /ach | Retrieve All ACH
*PaymentsApi* | [**get_all_bill_pay_counterparties**](docs/PaymentsApi.md#get_all_bill_pay_counterparties) | **GET** /billpay/counterparty | List all Bill Pay Counterparties
*PaymentsApi* | [**get_all_bill_pay_merchants**](docs/PaymentsApi.md#get_all_bill_pay_merchants) | **GET** /billpay/merchant | Search for Merchant
*PaymentsApi* | [**get_all_bill_pay_payments**](docs/PaymentsApi.md#get_all_bill_pay_payments) | **GET** /billpay/payment | Retrieve all Payments
*PaymentsApi* | [**get_all_bill_pay_rules**](docs/PaymentsApi.md#get_all_bill_pay_rules) | **GET** /billpay/rule | List All Rules
*PaymentsApi* | [**get_all_book_transfers**](docs/PaymentsApi.md#get_all_book_transfers) | **GET** /book | Retrieve All Book Transfers
*PaymentsApi* | [**get_all_card_charges**](docs/PaymentsApi.md#get_all_card_charges) | **GET** /card/charge | Retrieve all Card Charges
*PaymentsApi* | [**get_all_check_deposits**](docs/PaymentsApi.md#get_all_check_deposits) | **GET** /check_deposit | Retrieve all Check Deposits
*PaymentsApi* | [**get_all_checks**](docs/PaymentsApi.md#get_all_checks) | **GET** /check | Retrieve all Checks
*PaymentsApi* | [**get_all_counterparties**](docs/PaymentsApi.md#get_all_counterparties) | **GET** /counterparty | Retrieve All Counterparties
*PaymentsApi* | [**get_all_incoming_wires**](docs/PaymentsApi.md#get_all_incoming_wires) | **GET** /incoming_wire | Retrieve All Incoming Wires
*PaymentsApi* | [**get_all_wires**](docs/PaymentsApi.md#get_all_wires) | **GET** /wire | Retrieve All Wires
*PaymentsApi* | [**get_bill_pay_counterparty_by_id**](docs/PaymentsApi.md#get_bill_pay_counterparty_by_id) | **GET** /billpay/counterparty/{billpay_counterparty_id} | Retrieve Bill Pay Counterparty
*PaymentsApi* | [**get_bill_pay_payment_by_id**](docs/PaymentsApi.md#get_bill_pay_payment_by_id) | **GET** /billpay/payment/{billpay_payment_id} | Retrieve Payment
*PaymentsApi* | [**get_bill_pay_rule_by_id**](docs/PaymentsApi.md#get_bill_pay_rule_by_id) | **GET** /billpay/rule/{billpay_rule_id} | Retrieve Rule
*PaymentsApi* | [**get_book_transfer_by_id**](docs/PaymentsApi.md#get_book_transfer_by_id) | **GET** /book/{book_id} | Retrieve Book Transfer
*PaymentsApi* | [**get_check_by_id**](docs/PaymentsApi.md#get_check_by_id) | **GET** /check/{check_id} | Retrieve Check
*PaymentsApi* | [**get_check_deposit_by_id**](docs/PaymentsApi.md#get_check_deposit_by_id) | **GET** /check_deposit/{check_id} | Retrieve Check Deposit
*PaymentsApi* | [**get_counterparty_by_id**](docs/PaymentsApi.md#get_counterparty_by_id) | **GET** /counterparty/{counterparty_id} | Retrieve Counterparty
*PaymentsApi* | [**get_incoming_wire_by_id**](docs/PaymentsApi.md#get_incoming_wire_by_id) | **GET** /incoming_wire/{incoming_wire_id} | Retrieve Incoming Wire
*PaymentsApi* | [**get_wire_by_id**](docs/PaymentsApi.md#get_wire_by_id) | **GET** /wire/{wire_id} | Retrieve Wire
*PaymentsApi* | [**update_ach_transfer_by_id**](docs/PaymentsApi.md#update_ach_transfer_by_id) | **PATCH** /ach/{ach_id} | Update ACH
*PaymentsApi* | [**update_bill_pay_payment_by_id**](docs/PaymentsApi.md#update_bill_pay_payment_by_id) | **PATCH** /billpay/payment/{billpay_payment_id} | Update Payment
*PaymentsApi* | [**update_bill_pay_rule_by_id**](docs/PaymentsApi.md#update_bill_pay_rule_by_id) | **PATCH** /billpay/rule/{billpay_rule_id} | Update Rule
*PaymentsApi* | [**update_book_transfer_by_id**](docs/PaymentsApi.md#update_book_transfer_by_id) | **PATCH** /book/{book_id} | Update Book Transfer
*PaymentsApi* | [**update_counterparty_by_id**](docs/PaymentsApi.md#update_counterparty_by_id) | **PATCH** /counterparty/{counterparty_id} | Update Counterparty
*PaymentsApi* | [**update_wire_by_id**](docs/PaymentsApi.md#update_wire_by_id) | **PATCH** /wire/{wire_id} | Update Wire
*PersonApi* | [**create_card_by_person_id**](docs/PersonApi.md#create_card_by_person_id) | **POST** /person/{person_id}/card | Issue New Card
*PersonApi* | [**get_all_cards_by_person_id**](docs/PersonApi.md#get_all_cards_by_person_id) | **GET** /person/{person_id}/card | Retrieve All Person Cards
*PersonApi* | [**get_card_by_person_id_and_card_id**](docs/PersonApi.md#get_card_by_person_id_and_card_id) | **GET** /person/{person_id}/card/{card_id} | Retrieve Card
*PersonApi* | [**get_person_by_id**](docs/PersonApi.md#get_person_by_id) | **GET** /person/{person_id} | Retrieve Person
*PersonApi* | [**update_person_by_id**](docs/PersonApi.md#update_person_by_id) | **PATCH** /person/{person_id} | Update Person
*PersonApplicationApi* | [**create_person_application**](docs/PersonApplicationApi.md#create_person_application) | **POST** /apply/person_application | Create Person Application
*PersonApplicationApi* | [**get_all_person_applications**](docs/PersonApplicationApi.md#get_all_person_applications) | **GET** /apply/person_application | Retrieve All Person Applications
*PersonApplicationApi* | [**get_person_application_by_id**](docs/PersonApplicationApi.md#get_person_application_by_id) | **GET** /apply/person_application/{person_application_id} | Retrieve Person Application
*ReserveApi* | [**create_reserve**](docs/ReserveApi.md#create_reserve) | **POST** /reserve | Create a Reserve
*ReserveApi* | [**delete_reserve_by_id**](docs/ReserveApi.md#delete_reserve_by_id) | **DELETE** /reserve/{reserve_id} | Delete a Reserve
*ReserveApi* | [**get_all_reserves**](docs/ReserveApi.md#get_all_reserves) | **GET** /reserve | Retrieve all Reserves
*ReserveApi* | [**get_reserve_by_id**](docs/ReserveApi.md#get_reserve_by_id) | **GET** /reserve/{reserve_id} | Retrieve Reserve
*ReserveApi* | [**update_reserve_by_id**](docs/ReserveApi.md#update_reserve_by_id) | **PATCH** /reserve/{reserve_id} | Update Reserve
*RoutingNumberApi* | [**get_routing_number**](docs/RoutingNumberApi.md#get_routing_number) | **GET** /routing_number/{routing_number} | Retrieve a Routing Number
*SearchApi* | [**search**](docs/SearchApi.md#search) | **GET** /search | Search
*SettingsApi* | [**get_setting**](docs/SettingsApi.md#get_setting) | **GET** /setting | Retrieve Setting
*SimulationsApi* | [**simulation_post**](docs/SimulationsApi.md#simulation_post) | **POST** /simulation | Create a Wire simulation sent
*StatementApi* | [**create_statement_config**](docs/StatementApi.md#create_statement_config) | **POST** /statement_config | Create Statement Config Copy
*StatementApi* | [**get_account_statement_by_id_and_date**](docs/StatementApi.md#get_account_statement_by_id_and_date) | **GET** /account/{account_id}/statement | Retrieve Statement
*StatementApi* | [**get_all_statement_configs**](docs/StatementApi.md#get_all_statement_configs) | **GET** /statement_config | Retrieve All Statement Configs
*StatementApi* | [**update_statement_config_by_id**](docs/StatementApi.md#update_statement_config_by_id) | **PATCH** /statement_config/{statement_config_id} | Update Statement Config Copy
*TransactionApi* | [**get_all_transactions**](docs/TransactionApi.md#get_all_transactions) | **GET** /transaction | Retrieve All Transactions
*TransactionApi* | [**get_all_transactions_by_account**](docs/TransactionApi.md#get_all_transactions_by_account) | **GET** /account/{account_id}/transaction | Retrieve All Account Transactions
*TransactionApi* | [**get_transaction_by_id**](docs/TransactionApi.md#get_transaction_by_id) | **GET** /transaction/{transaction_id} | Retrieve a Transaction
*UtilitiesApi* | [**create_document**](docs/UtilitiesApi.md#create_document) | **POST** /document | Create a Document
*UtilitiesApi* | [**create_file**](docs/UtilitiesApi.md#create_file) | **POST** /file | Create File
*UtilitiesApi* | [**create_webhook**](docs/UtilitiesApi.md#create_webhook) | **POST** /webhook | Create Webhook
*UtilitiesApi* | [**delete_webhook_by_id**](docs/UtilitiesApi.md#delete_webhook_by_id) | **DELETE** /webhook/{webhook_id} | Delete Webhook
*UtilitiesApi* | [**get_all_documents**](docs/UtilitiesApi.md#get_all_documents) | **GET** /document | List All Documents
*UtilitiesApi* | [**get_all_webhooks**](docs/UtilitiesApi.md#get_all_webhooks) | **GET** /webhook | Retrieve All Webhooks
*UtilitiesApi* | [**get_document_by_id**](docs/UtilitiesApi.md#get_document_by_id) | **GET** /document/{document_id} | Retrieve a Document
*UtilitiesApi* | [**get_file_by_id**](docs/UtilitiesApi.md#get_file_by_id) | **GET** /file/{file_id} | Get File
*UtilitiesApi* | [**get_routing_number**](docs/UtilitiesApi.md#get_routing_number) | **GET** /routing_number/{routing_number} | Retrieve a Routing Number
*UtilitiesApi* | [**get_setting**](docs/UtilitiesApi.md#get_setting) | **GET** /setting | Retrieve Setting
*UtilitiesApi* | [**get_webhook_by_id**](docs/UtilitiesApi.md#get_webhook_by_id) | **GET** /webhook/{webhook_id} | Retrieve Webhook
*UtilitiesApi* | [**search**](docs/UtilitiesApi.md#search) | **GET** /search | Search
*UtilitiesApi* | [**update_document_by_id**](docs/UtilitiesApi.md#update_document_by_id) | **PATCH** /document/{document_id} | Update a Document
*UtilitiesApi* | [**update_webhook_by_id**](docs/UtilitiesApi.md#update_webhook_by_id) | **PATCH** /webhook/{webhook_id} | Update Webhook
*WebhooksApi* | [**create_webhook**](docs/WebhooksApi.md#create_webhook) | **POST** /webhook | Create Webhook
*WebhooksApi* | [**delete_webhook_by_id**](docs/WebhooksApi.md#delete_webhook_by_id) | **DELETE** /webhook/{webhook_id} | Delete Webhook
*WebhooksApi* | [**get_all_webhooks**](docs/WebhooksApi.md#get_all_webhooks) | **GET** /webhook | Retrieve All Webhooks
*WebhooksApi* | [**get_webhook_by_id**](docs/WebhooksApi.md#get_webhook_by_id) | **GET** /webhook/{webhook_id} | Retrieve Webhook
*WebhooksApi* | [**update_webhook_by_id**](docs/WebhooksApi.md#update_webhook_by_id) | **PATCH** /webhook/{webhook_id} | Update Webhook
*WireApi* | [**create_wire**](docs/WireApi.md#create_wire) | **POST** /wire | Create Wire
*WireApi* | [**get_all_wires**](docs/WireApi.md#get_all_wires) | **GET** /wire | Retrieve All Wires
*WireApi* | [**get_wire_by_id**](docs/WireApi.md#get_wire_by_id) | **GET** /wire/{wire_id} | Retrieve Wire
*WireApi* | [**update_wire_by_id**](docs/WireApi.md#update_wire_by_id) | **PATCH** /wire/{wire_id} | Update Wire
*WireSimulationsApi* | [**simulation_post**](docs/WireSimulationsApi.md#simulation_post) | **POST** /simulation | Create a Wire simulation sent
*DefaultApi* | [**get_health**](docs/DefaultApi.md#get_health) | **GET** /ping | API Health Check


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountAddress](docs/AccountAddress.md)
 - [AccountApplication](docs/AccountApplication.md)
 - [AccountApplicationAllOf](docs/AccountApplicationAllOf.md)
 - [AccountLock](docs/AccountLock.md)
 - [AccountNumberReservation](docs/AccountNumberReservation.md)
 - [AccountProduct](docs/AccountProduct.md)
 - [Ach](docs/Ach.md)
 - [AchDeposit](docs/AchDeposit.md)
 - [AchDepositAllOf](docs/AchDepositAllOf.md)
 - [AchDepositAllOfAch](docs/AchDepositAllOfAch.md)
 - [AdditionalPersonApplication](docs/AdditionalPersonApplication.md)
 - [ApplePayToken](docs/ApplePayToken.md)
 - [AverageBalance](docs/AverageBalance.md)
 - [BaseDeposit](docs/BaseDeposit.md)
 - [BillPayCounterparty](docs/BillPayCounterparty.md)
 - [BillPayCounterpartyAddress](docs/BillPayCounterpartyAddress.md)
 - [BookTransfer](docs/BookTransfer.md)
 - [Business](docs/Business.md)
 - [BusinessApplication](docs/BusinessApplication.md)
 - [BusinessApplicationMailingAddress](docs/BusinessApplicationMailingAddress.md)
 - [BusinessApplicationPersonApplicationsInner](docs/BusinessApplicationPersonApplicationsInner.md)
 - [BusinessApplicationPhysicalAddress](docs/BusinessApplicationPhysicalAddress.md)
 - [Card](docs/Card.md)
 - [CardCharge](docs/CardCharge.md)
 - [CardChargeCard](docs/CardChargeCard.md)
 - [CardControls](docs/CardControls.md)
 - [CardControlsControlsInner](docs/CardControlsControlsInner.md)
 - [CardDeposit](docs/CardDeposit.md)
 - [CardDepositAllOf](docs/CardDepositAllOf.md)
 - [CardDepositAllOfCard](docs/CardDepositAllOfCard.md)
 - [CardEvent](docs/CardEvent.md)
 - [CardEventAtm](docs/CardEventAtm.md)
 - [CardEventMerchant](docs/CardEventMerchant.md)
 - [CardEventMerchantAddress](docs/CardEventMerchantAddress.md)
 - [CardFulfillment](docs/CardFulfillment.md)
 - [CardLoopAuthEndpoint](docs/CardLoopAuthEndpoint.md)
 - [CardProduct](docs/CardProduct.md)
 - [CardToken](docs/CardToken.md)
 - [Check](docs/Check.md)
 - [CheckDeposit](docs/CheckDeposit.md)
 - [CheckDepositDevice](docs/CheckDepositDevice.md)
 - [CheckImage](docs/CheckImage.md)
 - [CheckRecipient](docs/CheckRecipient.md)
 - [CheckRecipientAddress](docs/CheckRecipientAddress.md)
 - [Counterparty](docs/Counterparty.md)
 - [CounterpartyAch](docs/CounterpartyAch.md)
 - [CounterpartyWire](docs/CounterpartyWire.md)
 - [CounterpartyWireAddressOnAccount](docs/CounterpartyWireAddressOnAccount.md)
 - [CounterpartyWireBankAddress](docs/CounterpartyWireBankAddress.md)
 - [CreateApplePayDigitalWalletTokenByCardIdRequest](docs/CreateApplePayDigitalWalletTokenByCardIdRequest.md)
 - [CreateDepositRequest](docs/CreateDepositRequest.md)
 - [CreateDepositRequestOneOf](docs/CreateDepositRequestOneOf.md)
 - [CreateDepositRequestOneOf1](docs/CreateDepositRequestOneOf1.md)
 - [CreateDepositRequestOneOf1Ach](docs/CreateDepositRequestOneOf1Ach.md)
 - [CreateDepositRequestOneOfCard](docs/CreateDepositRequestOneOfCard.md)
 - [CreateGooglePayDigitalWalletTokenByCardIdRequest](docs/CreateGooglePayDigitalWalletTokenByCardIdRequest.md)
 - [DailyBalance](docs/DailyBalance.md)
 - [Deposit](docs/Deposit.md)
 - [Document](docs/Document.md)
 - [DocumentFields](docs/DocumentFields.md)
 - [File](docs/File.md)
 - [GetAccountStatementByIdAndDate200Response](docs/GetAccountStatementByIdAndDate200Response.md)
 - [GetAllAccountApplications200Response](docs/GetAllAccountApplications200Response.md)
 - [GetAllAccountNumberReservations200Response](docs/GetAllAccountNumberReservations200Response.md)
 - [GetAllAccountProducts200Response](docs/GetAllAccountProducts200Response.md)
 - [GetAllAccounts200Response](docs/GetAllAccounts200Response.md)
 - [GetAllAccounts200ResponseDataInner](docs/GetAllAccounts200ResponseDataInner.md)
 - [GetAllAccounts400Response](docs/GetAllAccounts400Response.md)
 - [GetAllAchTransfers200Response](docs/GetAllAchTransfers200Response.md)
 - [GetAllAdditionalPersonApplications200Response](docs/GetAllAdditionalPersonApplications200Response.md)
 - [GetAllBillPayCounterparties200Response](docs/GetAllBillPayCounterparties200Response.md)
 - [GetAllBillPayMerchants200Response](docs/GetAllBillPayMerchants200Response.md)
 - [GetAllBillPayPayments200Response](docs/GetAllBillPayPayments200Response.md)
 - [GetAllBillPayRules200Response](docs/GetAllBillPayRules200Response.md)
 - [GetAllBookTransfers200Response](docs/GetAllBookTransfers200Response.md)
 - [GetAllBusinessApplications200Response](docs/GetAllBusinessApplications200Response.md)
 - [GetAllCardAuthLoopEndpoint200Response](docs/GetAllCardAuthLoopEndpoint200Response.md)
 - [GetAllCardCharges200Response](docs/GetAllCardCharges200Response.md)
 - [GetAllCardEvents200Response](docs/GetAllCardEvents200Response.md)
 - [GetAllCardProducts200Response](docs/GetAllCardProducts200Response.md)
 - [GetAllCards200Response](docs/GetAllCards200Response.md)
 - [GetAllCheckDeposits200Response](docs/GetAllCheckDeposits200Response.md)
 - [GetAllCheckImages200Response](docs/GetAllCheckImages200Response.md)
 - [GetAllChecks200Response](docs/GetAllChecks200Response.md)
 - [GetAllCounterparties200Response](docs/GetAllCounterparties200Response.md)
 - [GetAllDeposits200Response](docs/GetAllDeposits200Response.md)
 - [GetAllDocuments200Response](docs/GetAllDocuments200Response.md)
 - [GetAllIncomingWires200Response](docs/GetAllIncomingWires200Response.md)
 - [GetAllKycEvaluations200Response](docs/GetAllKycEvaluations200Response.md)
 - [GetAllKycProducts200Response](docs/GetAllKycProducts200Response.md)
 - [GetAllPersonApplications200Response](docs/GetAllPersonApplications200Response.md)
 - [GetAllReserves200Response](docs/GetAllReserves200Response.md)
 - [GetAllStatementConfigs200Response](docs/GetAllStatementConfigs200Response.md)
 - [GetAllTransactionsByAccount200Response](docs/GetAllTransactionsByAccount200Response.md)
 - [GetAllWebhooks200Response](docs/GetAllWebhooks200Response.md)
 - [GetAllWires200Response](docs/GetAllWires200Response.md)
 - [GetAverageAccountBalanceById200Response](docs/GetAverageAccountBalanceById200Response.md)
 - [GetDailyAccountBalanceById200Response](docs/GetDailyAccountBalanceById200Response.md)
 - [GetHealth200Response](docs/GetHealth200Response.md)
 - [GooglePayToken](docs/GooglePayToken.md)
 - [GooglePayTokenPushTokenizeRequestData](docs/GooglePayTokenPushTokenizeRequestData.md)
 - [GooglePayTokenPushTokenizeRequestDataUserAddress](docs/GooglePayTokenPushTokenizeRequestDataUserAddress.md)
 - [IncomingWire](docs/IncomingWire.md)
 - [IncomingWireBeneficiary](docs/IncomingWireBeneficiary.md)
 - [IncomingWireBeneficiaryBankData](docs/IncomingWireBeneficiaryBankData.md)
 - [IncomingWireImad](docs/IncomingWireImad.md)
 - [IncomingWireImadParsed](docs/IncomingWireImadParsed.md)
 - [IncomingWireOriginator](docs/IncomingWireOriginator.md)
 - [IncomingWireOriginatorBankData](docs/IncomingWireOriginatorBankData.md)
 - [KycEvaluation](docs/KycEvaluation.md)
 - [KycEvaluationAllOf](docs/KycEvaluationAllOf.md)
 - [KycProduct](docs/KycProduct.md)
 - [LockAccount](docs/LockAccount.md)
 - [LockAccountLock](docs/LockAccountLock.md)
 - [Merchant](docs/Merchant.md)
 - [MerchantRestriction](docs/MerchantRestriction.md)
 - [Payment](docs/Payment.md)
 - [Person](docs/Person.md)
 - [PersonApplication](docs/PersonApplication.md)
 - [PersonApplicationMailingAddress](docs/PersonApplicationMailingAddress.md)
 - [PersonApplicationPhysicalAddress](docs/PersonApplicationPhysicalAddress.md)
 - [PersonBankdata](docs/PersonBankdata.md)
 - [PersonMailingAddress](docs/PersonMailingAddress.md)
 - [QueryResult](docs/QueryResult.md)
 - [Reserve](docs/Reserve.md)
 - [RoutingNumber](docs/RoutingNumber.md)
 - [Rule](docs/Rule.md)
 - [Search200Response](docs/Search200Response.md)
 - [Setting](docs/Setting.md)
 - [SimulationPostRequest](docs/SimulationPostRequest.md)
 - [SimulationPostRequestOneOf](docs/SimulationPostRequestOneOf.md)
 - [SimulationPostRequestOneOf1](docs/SimulationPostRequestOneOf1.md)
 - [SimulationPostRequestOneOf1Simulation](docs/SimulationPostRequestOneOf1Simulation.md)
 - [SimulationPostRequestOneOf1SimulationAtm](docs/SimulationPostRequestOneOf1SimulationAtm.md)
 - [SimulationPostRequestOneOf2](docs/SimulationPostRequestOneOf2.md)
 - [SimulationPostRequestOneOf2Simulation](docs/SimulationPostRequestOneOf2Simulation.md)
 - [SimulationPostRequestOneOf3](docs/SimulationPostRequestOneOf3.md)
 - [SimulationPostRequestOneOf4](docs/SimulationPostRequestOneOf4.md)
 - [SimulationPostRequestOneOf5](docs/SimulationPostRequestOneOf5.md)
 - [SimulationPostRequestOneOf5Simulation](docs/SimulationPostRequestOneOf5Simulation.md)
 - [SimulationPostRequestOneOf6](docs/SimulationPostRequestOneOf6.md)
 - [SimulationPostRequestOneOf7](docs/SimulationPostRequestOneOf7.md)
 - [SimulationPostRequestOneOf7Simulation](docs/SimulationPostRequestOneOf7Simulation.md)
 - [SimulationPostRequestOneOf8](docs/SimulationPostRequestOneOf8.md)
 - [SimulationPostRequestOneOf8Simulation](docs/SimulationPostRequestOneOf8Simulation.md)
 - [SimulationPostRequestOneOf9](docs/SimulationPostRequestOneOf9.md)
 - [SimulationPostRequestOneOfSimulation](docs/SimulationPostRequestOneOfSimulation.md)
 - [SimulationPostRequestOneOfSimulationMerchant](docs/SimulationPostRequestOneOfSimulationMerchant.md)
 - [SimulationPostRequestOneOfSimulationMerchantAddress](docs/SimulationPostRequestOneOfSimulationMerchantAddress.md)
 - [SpendVelocityRestriction](docs/SpendVelocityRestriction.md)
 - [StatementConfig](docs/StatementConfig.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionIncomingWire](docs/TransactionIncomingWire.md)
 - [UnlockAccount](docs/UnlockAccount.md)
 - [UpdateAccountRequest](docs/UpdateAccountRequest.md)
 - [UpdateAccountStatus](docs/UpdateAccountStatus.md)
 - [UpdateAchTransferByIdRequest](docs/UpdateAchTransferByIdRequest.md)
 - [UpdateBillPayPaymentByIdRequest](docs/UpdateBillPayPaymentByIdRequest.md)
 - [UpdateBillPayRuleByIdRequest](docs/UpdateBillPayRuleByIdRequest.md)
 - [UpdateBookTransferByIdRequest](docs/UpdateBookTransferByIdRequest.md)
 - [UpdateBusinessApplicationByIdRequest](docs/UpdateBusinessApplicationByIdRequest.md)
 - [UpdateCardByIdRequest](docs/UpdateCardByIdRequest.md)
 - [UpdateDocumentByIdRequest](docs/UpdateDocumentByIdRequest.md)
 - [UpdateReserveByIdRequest](docs/UpdateReserveByIdRequest.md)
 - [UpdateUserData](docs/UpdateUserData.md)
 - [UpdateWebhookByIdRequest](docs/UpdateWebhookByIdRequest.md)
 - [UpdateWebhookByIdRequestAllOf](docs/UpdateWebhookByIdRequestAllOf.md)
 - [UpdateWireByIdRequest](docs/UpdateWireByIdRequest.md)
 - [Webhook](docs/Webhook.md)
 - [Wire](docs/Wire.md)
 - [WithdrawalVelocityRestriction](docs/WithdrawalVelocityRestriction.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author

help@treasuryprime.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in treasury_prime_client.apis and treasury_prime_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from treasury_prime_client.api.default_api import DefaultApi`
- `from treasury_prime_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import treasury_prime_client
from treasury_prime_client.apis import *
from treasury_prime_client.models import *
```

