# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['qontract_development_cli', 'qontract_development_cli.commands']

package_data = \
{'': ['*'], 'qontract_development_cli': ['templates/*']}

install_requires = \
['Jinja2>=3.1.2,<4.0.0',
 'PyYAML>=6.0,<7.0',
 'appdirs>=1.4.4,<2.0.0',
 'getkey>=0.6.5,<0.7.0',
 'pydantic>=1.10.2,<2.0.0',
 'rich>=12.5.1,<13.0.0',
 'textual>=0.2.1,<0.3.0',
 'typer>=0.6.1,<0.7.0',
 'watchfiles>=0.18.0,<0.19.0']

entry_points = \
{'console_scripts': ['qd = qontract_development_cli.__main__:app']}

setup_kwargs = {
    'name': 'qontract-development-cli',
    'version': '0.4.0',
    'description': 'Helper tool for qontract-reconcile development',
    'long_description': '# Qontract Development CLI\n\n[![PyPI](https://img.shields.io/pypi/v/qontract-development-cli)][pypi-link]\n[![PyPI platforms][pypi-platforms]][pypi-link]\n![PyPI - License](https://img.shields.io/pypi/l/qontract-development-cli)\n[![Conventional Commits](https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg)](https://conventionalcommits.org)\n\nQontract Development CLI supports your daily [qontract-reconcile][qontract-reconcile] development work.\n\n## Installation\n\nYou can install this library from [PyPI][pypi-link] with `pip`:\n\n```shell\n$ python3 -m pip install qontract-development-cli\n```\n\nOr install it with `pipx`:\n```shell\n$ pipx install qontract-development-cli\n```\n\nYou can also use `pipx` to run the library without installing it:\n\n```shell\n$ pipx run qontract-development-cli\n```\n\n## Quickstart\n\n* Create initial configuration\n  ```shell\n  $ qd config init\n  ```\n  <img src="demo/qd_config_init.gif" />\n\n* Create a profile `sql-query` to run the `sql-query` integration\n  ```shell\n  $ qd profile create sql-query\n  ```\n  <img src="demo/qd_profile_create.gif" />\n\n* Run `sql-query` profile\n  ```shell\n  $ profile run dev sql-query\n  ```\n  <img src="images/profile_run_sql_query.svg" />\n\n## Features\n\nQontract Development CLI currently provides the following features (get help with `-h` or `--help`):\n\n- Run `qontract-reconcile` and `qontract-server` as docker containers on your local machine\n- Support for different environments (dev, prod, ...) via the `env` command\n- Configure your [qontract-reconcile integration][qontract-reconcile] with the `profile` command\n- Support pull request reviews (see `profile create`)\n- Bootstrap your initial configurations with the `config` command\n- Shell autocompletion (see `qd --help`)\n\n## Commands\n\n### Config\n\nManage global qontract-development CLI configuration.\n\n`qd config [sub-cmd] --help`\n\n* **edit**: open the configuration file in your favorite editor\n* **init**: create a default configuration\n\n#### Settings\n| **Key**                     | **Description**                       | **Default**                          |\n| --------------------------- | ------------------------------------- | ------------------------------------ |\n| debug                       | Enable/disable debug mode             | false                                |\n| defaults_profile            | Name of defaults profile              | defaults                             |\n| docker_compose_project_name | Docker compose project name           | qontract-development                 |\n| editor                      | Your favorite editor                  | $EDITOR or vim                       |\n| environments_dir            | Directory to store environment files  | User config directory / environments |\n| profiles_dir                | Directory to store profile files      | User config directory / profiles     |\n| worktrees_dir               | Directory to store git repo worktrees | User cache directory / worktrees     |\n\n\n## Environments\n\nAn environment specifies app-interface instance settings, e.g., **dev** vs. **prod** config and path to the actual app-interface instance.\n\n`qd env [sub-cmd] --help`\n\n* **edit**: Create/edit an environment file in your editor.\n* **ls**: List all available environments.\n* **rm**: Remove environment.\n* **show**: Display environment.\n\n\n#### Settings\n\n| **Key**                            | **Description**                      | **Default**                                    |\n| ---------------------------------- | ------------------------------------ | ---------------------------------------------- |\n| **app_interface_path**             | Path to local app-interface instance | ~/workspace/app-interface                      |\n| app_interface_state_bucket         | S3 bucket                            | empty                                          |\n| app_interface_state_bucket_account | AWS S3 account                       | empty                                          |\n| **config**                         | app-interface config                 | ~/workspace/qontract-reconcile/config.dev.toml |\n| run_qontract_reconcile             | Run qontract-reconcile container     | true                                           |\n| run_qontract_server                | Run qontract-server container        | true                                           |\n| run_vault                          | Run vault container                  | false                                          |\n\n> :point_right: **Bold keys** are mandatory or should be customized.\n\n## Profiles\n\nA profile specifies all settings to run a qontract-reconcile integration (e.g., *sql-query*).\n\n`qd profile [sub-cmd] --help`\n\n* **create**: Create a new profile to run an integration.\n\n  Supports the creation of a new profile from an open PR/MR. See `qd profile create --help` for all available options.\n\n* **edit**: Edit a profile in your editor.\n* **ls**: List all available profiles.\n* **rm**: Remove profile.\n* **run**: Run a profile.\n* **show**: Display profile.\n\n\n#### Settings\n\n| **Key**                        | **Description**                                                    | **Default**                               |\n| ------------------------------ | ------------------------------------------------------------------ | ----------------------------------------- |\n| container_uid                  | Change ownership of /recconcile files in container to this user id | current UID                               |\n| debugger                       | Python debugger                                                    | debugpy                                   |\n| dry_run                        | Run --dry-run mode                                                 | true                                      |\n| gitlab_pr_submitter_queue_url  | Gitlab pr submitter queue url                                      |                                           |\n| **integration_name**           | Intergration name                                                  |                                           |\n| **integration_extra_args**     | Intergration extra arguments                                       |                                           |\n| log_level                      | Log level                                                          | info                                      |\n| app_interface_path             | App-interface instance path. (Overrides *env.app_interface_path*)  |                                           |\n| app_interface_pr               | App-interface PR/MR number                                         |                                           |\n| app_interface_upstream         | Upstream remote name                                               | upstream                                  |\n| qontract_reconcile_build_image | Build qontract-reconcile image                                     | true                                      |\n| qontract_reconcile_image       | Qontract-reconcile image                                           | quay.io/app-sre/qontract-reconcile:latest |\n| qontract_reconcile_path        | Qontract-reconcile path                                            | ~/workspace/qontract-reconcile            |\n| qontract_reconcile_pr          | Qontract-reconcile PR/MR number                                    |                                           |\n| qontract_reconcile_upstream    | Upstream remote name                                               | upstream                                  |\n| qontract_server_build_image    | Build qontract-server image                                        | true                                      |\n| qontract_server_image          | Qontract-server image                                              | quay.io/app-sre/qontract-server:latest    |\n| qontract_server_path           | Qontract-server path                                               | ~/workspace/qontract-server               |\n| qontract_schemas_path          | Qontract-schemas path                                              | ~/workspace/qontract-schemas              |\n| qontract_schemas_pr            | Qontract-schemas PR/MR number                                      |                                           |\n| qontract_schemas_upstream      | Upstream remote name                                               | upstream                                  |\n| run_once                       | If \'true\', execute the integration once and exit                   | true                                      |\n| sleep_duration_secs            | If not *run_once*, sleep duration until integration runs again     | 10                                        |\n\n> :point_right: **Bold keys** are mandatory or should be customized.\n\n### PR/MR support\n\nIt\'s a pretty handy feature to create a profile from a pull request (merge request). E.g.:\n\n```shell\n$ qd profile create --app-interface PATH_TO_YOUR_LOCAL/app-interface-dev-data --app-interface-pr NUMBER --qontract-schemas-pr NUMBER --qontract-reconcile-pr NUMBER --integration-name glitchtip --integration-extra-args \'\' glitchtip-pr-check\n```\n\nWhich results into this profile:\n\n```shell\n$ qd profile show glitchtip-pr-check\n---\napp_interface_path: PATH_TO_YOUR_LOCAL/app-interface-dev-data\napp_interface_pr: NUMBER\nintegration_name: glitchtip\nqontract_reconcile_pr: NUMBER\nqontract_schemas_pr: NUMBER\n```\n\nRunning this profile will:\n* Create new git worktrees (see `config.worktrees_dir`) for app-interface-dev-data, qontract-schema, and qontract-reconcile PRs\n* Start the containers with the adapted path to these worktrees\n* Restarting the profile will fetch PR updates\n\n> :point_right: A git worktree cleanup isn\'t implemented yet\n\n[pypi-link]:                https://pypi.org/project/qontract-development-cli/\n[pypi-platforms]:           https://img.shields.io/pypi/pyversions/qontract-development-cli\n[pypi-version]:             https://badge.fury.io/py/qontract-development-cli.svg\n[qontract-reconcile]:       https://github.com/app-sre/qontract-reconcile\n',
    'author': 'Christian Assing',
    'author_email': 'cassing@redhat.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'http://github.com/chassing/qontract-development-cli',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
