# -*- coding: utf-8 -*-

"""Top-level package for ReFramed."""

__author__ = "Daniel Machado"
__email__ = 'cdanielmachado@gmail.com'
__version__ = '1.5.4'


from .core.model import Model, Metabolite, Compartment, Reaction, ReactionType
from .core.cbmodel import CBReaction, Gene, Protein, GPRAssociation, CBModel
from .core.environment import Environment
from .core.transformation import make_irreversible, simplify, gpr_transform

from .solvers import set_default_solver, solver_instance

from .io.sbml import load_cbmodel, save_cbmodel
from .io.cache import ModelCache

from .cobra.variability import FVA, blocked_reactions
from .cobra.plotting import plot_flux_envelope
from .cobra.simulation import FBA, pFBA, FBrAtio, CAFBA, lMOMA, ROOM
from .cobra.thermodynamics import TFA, TVA, llFBA, NET
from .cobra.medium import minimal_medium
from .cobra.knockout import gene_knockout, hard_knockout, reaction_knockout, essential_genes, essential_reactions
from .cobra.transcriptomics import GIMME, eFlux, marge

from .community.model import Community
from .community.SteadyCom import SteadyCom, SteadyComVA

from .external.escher import escher_maps, fluxes2escher
from .external.cobrapy import to_cobrapy, from_cobrapy


