DCASE Utilities
===============

A collection of utilities for Detection and Classification of Acoustic Scenes and Events

[![Build Status](https://travis-ci.org/DCASE-REPO/dcase_util.svg?branch=master)](https://travis-ci.org/DCASE-REPO/dcase_util)
[![Coverage Status](https://coveralls.io/repos/github/DCASE-REPO/dcase_util/badge.svg?branch=master)](https://coveralls.io/github/DCASE-REPO/dcase_util?branch=master)
[![PyPI](https://img.shields.io/pypi/v/dcase_util.svg)](https://pypi.python.org/pypi/dcase_util)
[![License: MIT](https://img.shields.io/badge/license-MIT-blue.svg)](https://opensource.org/licenses/MIT)

This collection of utilities is for Detection and Classification of Acoustic Scenes
and Events (DCASE). These utilities were originally created for the DCASE challenge baseline systems
([2016](https://github.com/TUT-ARG/DCASE2016-baseline-system-python) &
[2017](https://github.com/TUT-ARG/DCASE2017-baseline-system)) and are bundled into a standalone library
to allow their re-usage in other research projects.

The main goal of the utilities is to streamline the research code, make it more readable, and easier to maintain.
Most of the implemented utilities are related to audio datasets: handling meta data and various forms of other
structured data, and provide standardized usage API to audio datasets from various sources.

Documentation
=============

See https://dcase-repo.github.io/dcase_util/ for detailed instruction, manuals and tutorials.

Installation instructions
=========================

The latest stable release is available on PyPI, and you can install with pip:
`pip install dcase_util` 

License
=======

Code released under the [MIT license](https://github.com/DCASE-REPO/dcase_util/tree/master/LICENSE).
