"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
test('Correctly validate Docker image asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            dockerImages: {
                asset: {
                    source: {
                        directory: '.',
                    },
                    destinations: {
                        dest: {
                            region: 'us-north-20',
                            repositoryName: 'REPO',
                            imageTag: 'TAG',
                        },
                    },
                },
            },
        });
    }).not.toThrow();
});
test('Throw on invalid Docker image asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            dockerImages: {
                asset: {
                    source: {},
                    destinations: {},
                },
            },
        });
    }).toThrow(/dockerImages: source: Expected key 'directory' missing/);
});
test('Correctly validate File asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            files: {
                asset: {
                    source: {
                        path: 'a/b/c',
                    },
                    destinations: {
                        dest: {
                            region: 'us-north-20',
                            bucketName: 'Bouquet',
                            objectKey: 'key',
                        },
                    },
                },
            },
        });
    }).not.toThrow();
});
test('Throw on invalid file asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            files: {
                asset: {
                    source: {
                        path: 3,
                    },
                    destinations: {
                        dest: {
                            region: 'us-north-20',
                            bucketName: 'Bouquet',
                            objectKey: 'key',
                        },
                    },
                },
            },
        });
    }).toThrow(/Expected a string, got '3'/);
});
//# sourceMappingURL=data:application/json;base64,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