# IMC Prosperity 2 Backtester

[![Build Status](https://github.com/jmerle/imc-prosperity-2-backtester/workflows/Build/badge.svg)](https://github.com/jmerle/imc-prosperity-2-backtester/actions/workflows/build.yml)
[![PyPI Version](https://img.shields.io/pypi/v/prosperity2bt)](https://pypi.org/project/prosperity2bt/)

This repository contains a backtester [IMC Prosperity 2](https://prosperity.imc.com/) algorithms. The output it generates closely matches the format of the output generated by the official submission environment and is therefore compatible with my [IMC Prosperity 2 Visualizer](https://github.com/jmerle/imc-prosperity-2-visualizer) (assuming your code contains the visualizer's required prerequisites as explained on the visualizer's homepage).

## Usage

Basic usage:
```sh
# Install the latest version of the backtester
$ pip install -U prosperity2bt

# Run the backtester on an algorithm using all data from round 0
$ prosperity2bt <path to algorithm file> 0
```

Run `pip install -U prosperity2bt` again when you want to update the backtester to the latest version.

Some more usage examples:
```sh
# Backtest on all days from round 1
$ prosperity2bt example/starter.py 1

# Backtest on round 1 day 0
$ prosperity2bt example/starter.py 1-0

# Backtest on round 1 day -1 and round 1 day 0
$ prosperity2bt example/starter.py 1--1 1-0

# Backtest on all days from rounds 1 and 2
$ prosperity2bt example/starter.py 1 2

# You get the idea

# Merge profit and loss across days
$ prosperity2bt example/starter.py 1 --merge-pnl

# Automatically open the result in the visualizer when done
# Assumes your algorithm logs in the visualizer's expected format
$ prosperity2bt example/starter.py 1 --vis

# Write algorithm output to custom file
$ prosperity2bt example/starter.py 1 --out example.log

# Skip saving the output log to a file
$ prosperity2bt example/starter.py 1 --no-out

# Backtest on custom data
# Requires the value passed to `--data` to be a path to a directory that is similar in structure to https://github.com/jmerle/imc-prosperity-2-backtester/tree/master/prosperity2bt/resources
$ prosperity2bt example/starter.py 1 --data prosperity2bt/resources

# Print trader's output to stdout while running
# This may be helpful when debugging a broken trader
$ prosperity2bt example/starter.py 1 --print

# Only match orders against order depths, not against market trades
$ prosperity2bt example/starter.py 1 --no-trades-matching
```

## Order Matching

Orders placed by `Trader.run` at a given timestamp are matched against the order depths and market trades of that timestamp's state. Order depths take priority, if an order can be filled completely using volume in the relevant order depth, market trades are not considered. If not, the backtester matches your order against the timestamp's market trades. In this case the backtester assumes that for each trade, the buyer and the seller of the trade are willing to trade with you instead at the trade's price and volume. Market trades are matched at the price of your orders, e.g. if you place a sell order for €9 and there is a market trade for €10, the sell order is matched at €9 (even though there is a buyer willing to pay €10, this appears to be consistent with what the official Prosperity environment does).

Limits are enforced before orders are matched to order depths. If for a product your position would exceed the limit, assuming all your orders would get filled, all your orders for that product get canceled.

## Data Files

Data for the following round is included:
- Round 0: prices and anonymized trades data on AMETHYSTS and STARFRUIT that was used during tutorial submission runs.
- Round 1: prices, anonymized trades, and de-anonymized trades data on AMETHYSTS and STARFRUIT.
- Round 3: prices, anonymized trades, and de-anonymized trades data on CHOCOLATE, STRAWBERRIES, ROSES, and GIFT_BASKET.
- Round 4: prices, anonymized trades, and de-anonymized trades data on COCONUT and COCONUT_COUPON.
- Round 6: prices data that was used during submission runs. Round 6 day X represents the submission data of round X, where X = 0 means the tutorial round.
- Round 7: prices data that was used during end-of-round runs. Round 7 day Y represents the end-of-round data of round Y.

Round 2 (ORCHIDS and conversion observations) is not supported. By default de-anonymized trades data is used if it is available, except when the `--no-names` flag is used.

## Environment Variables

During backtests two environment variables are set for the trader to know the round and day it's being backtested on. The environment variable named `PROSPERITY2BT_ROUND` contains the round number and `PROSPERITY2BT_DAY` contains the day number. Note that these environment variables do not exist in the official submission environment, so make sure the code you submit doesn't require them to be defined.

## Development

If you want to make changes to the backtester, clone (or fork and clone) this repository and run `pip install -e .` in the project's root. This installs the project in editable mode, so any changes you make are automatically taken into account the next time you run `prosperity2bt`.
