/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.util;

import ibis.ipl.ReadMessage;
import ibis.ipl.WriteMessage;
import java.io.IOException;

public class Message {
    public static final int LAST_PACKET = Integer.MIN_VALUE;
    public int sender;
    public short refcount;
    public int[] destinations;
    public int destinationsUsed;
    public int id;
    public int num;
    public byte[] buffer;
    public int off;
    public int len;
    public boolean last = false;
    public boolean local = false;
    public Message next;

    public Message(int len) {
        this.buffer = new byte[len];
    }

    public void read(ReadMessage rm, int len, int dst) throws IOException {
        this.off = 0;
        this.len = len;
        this.local = false;
        this.sender = rm.readInt();
        this.id = rm.readInt();
        this.num = rm.readInt();
        boolean bl = this.last = (this.num & Integer.MIN_VALUE) != 0;
        if (this.last) {
            this.num &= Integer.MAX_VALUE;
        }
        if (len > 0) {
            rm.readArray(this.buffer, 0, len);
        }
        if (dst > 0) {
            if (this.destinations == null || this.destinations.length < dst) {
                this.destinations = new int[dst];
            }
            rm.readArray(this.destinations, 0, dst);
        }
        this.destinationsUsed = dst;
    }

    public void write(WriteMessage wm, int fromDest) throws IOException {
        int destinationLength = this.destinationsUsed - fromDest;
        wm.writeInt(this.len);
        wm.writeInt(destinationLength);
        wm.writeInt(this.sender);
        wm.writeInt(this.id);
        if (this.last) {
            wm.writeInt(this.num | Integer.MIN_VALUE);
        } else {
            wm.writeInt(this.num);
        }
        if (this.len > 0) {
            wm.writeArray(this.buffer, this.off, this.len);
        }
        if (destinationLength > 0) {
            wm.writeArray(this.destinations, fromDest, destinationLength);
        }
    }
}

