/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.ipl.Credentials;
import ibis.ipl.Ibis;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisFactory;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.MessageUpcall;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePort;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.Registry;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.impl.stacking.lrmc.LrmcIbisStarter;
import ibis.ipl.impl.stacking.lrmc.LrmcReceivePort;
import ibis.ipl.impl.stacking.lrmc.LrmcSendPort;
import ibis.ipl.impl.stacking.lrmc.Multicaster;
import ibis.ipl.impl.stacking.lrmc.StackingReceivePort;
import ibis.ipl.impl.stacking.lrmc.StackingSendPort;
import ibis.ipl.impl.stacking.lrmc.util.DynamicObjectArray;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LrmcIbis
implements Ibis {
    private static final Logger logger = LoggerFactory.getLogger(LrmcIbis.class);
    static final PortType additionalPortType = new PortType(new String[]{"serialization.data", "communication.reliable", "connection.manytoone", "receive.autoupcalls"});
    Ibis base;
    int myID;
    PortType[] portTypes;
    IbisCapabilities capabilities;
    private int nextIbisID = 0;
    private BitSet diedIbises = new BitSet();
    HashMap<IbisIdentifier, Integer> knownIbis = new HashMap();
    DynamicObjectArray<IbisIdentifier> ibisList = new DynamicObjectArray();
    HashMap<String, Multicaster> multicasters = new HashMap();

    public LrmcIbis(IbisFactory factory, RegistryEventHandler registryEventHandler, Properties userProperties, IbisCapabilities capabilities, Credentials credentials, byte[] applicationTag, PortType[] portTypes, String specifiedSubImplementation, LrmcIbisStarter lrmcIbisStarter) throws IbisCreationFailedException {
        ArrayList<PortType> requiredPortTypes = new ArrayList<PortType>();
        logger.info("Constructor LRMC Ibis");
        if (specifiedSubImplementation == null) {
            throw new IbisCreationFailedException("LrmcIbis: child Ibis implementation not specified");
        }
        EventHandler h = null;
        if (registryEventHandler != null) {
            h = new EventHandler(registryEventHandler, this);
        }
        this.portTypes = portTypes;
        this.capabilities = capabilities;
        for (PortType portType : portTypes) {
            if (LrmcIbis.ourPortType(portType)) continue;
            requiredPortTypes.add(portType);
        }
        requiredPortTypes.add(additionalPortType);
        this.base = factory.createIbis((RegistryEventHandler)h, capabilities, userProperties, credentials, applicationTag, requiredPortTypes.toArray(new PortType[requiredPortTypes.size()]), specifiedSubImplementation);
    }

    public synchronized void addIbis(IbisIdentifier ibis) {
        if (!this.knownIbis.containsKey(ibis)) {
            this.knownIbis.put(ibis, new Integer(this.nextIbisID));
            this.ibisList.put(this.nextIbisID, ibis);
            logger.info("Adding Ibis " + this.nextIbisID + " " + ibis);
            if (ibis.equals(this.identifier())) {
                logger.info("I am " + this.nextIbisID + " " + ibis);
                this.myID = this.nextIbisID;
            }
            ++this.nextIbisID;
            this.notifyAll();
        }
    }

    synchronized IbisIdentifier getId(int id) {
        if (this.diedIbises.get(id)) {
            return null;
        }
        IbisIdentifier ibisID = this.ibisList.get(id);
        if (ibisID == null) {
            try {
                this.wait(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.ibisList.get(id);
        }
        return ibisID;
    }

    synchronized int getIbisID(IbisIdentifier ibis) {
        Integer s = this.knownIbis.get(ibis);
        if (s != null) {
            return s;
        }
        logger.debug("Ibis " + ibis + " not known!");
        return -1;
    }

    public synchronized void removeIbis(IbisIdentifier ibis) {
        Integer tmp = this.knownIbis.remove(ibis);
        if (tmp != null) {
            logger.info("Removing ibis " + tmp + " " + ibis);
            this.ibisList.remove(tmp);
        }
        this.diedIbises.set(tmp);
    }

    synchronized Multicaster getMulticaster(String name, PortType portType) throws IOException {
        Multicaster om = this.multicasters.get(name);
        if (om == null) {
            om = new Multicaster(this, portType, name);
            this.multicasters.put(name, om);
        } else if (!om.portType.equals((Object)portType)) {
            throw new IOException("Mismatch in port types for name " + name);
        }
        return om;
    }

    public String getVersion() {
        return "LrmcIbis on top of " + this.base.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendPort createSendPort(PortType portType, String name, SendPortDisconnectUpcall cU, Properties props) throws IOException {
        this.matchPortType(portType);
        if (LrmcIbis.ourPortType(portType)) {
            if (name == null) {
                throw new IOException("Anonymous  ports not supported");
            }
            if (cU != null && !portType.hasCapability("connection.upcalls")) {
                throw new IbisConfigurationException("connection upcalls not supported by this porttype");
            }
            LrmcIbis lrmcIbis = this;
            synchronized (lrmcIbis) {
                Multicaster mc = this.getMulticaster(name, portType);
                if (mc.sendPort != null) {
                    throw new IOException("A sendport with the same name already exists");
                }
                mc.sendPort = new LrmcSendPort(mc, this, props);
                return mc.sendPort;
            }
        }
        return new StackingSendPort(portType, this, name, cU, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceivePort createReceivePort(PortType portType, String name, MessageUpcall u, ReceivePortConnectUpcall cU, Properties props) throws IOException {
        this.matchPortType(portType);
        if (LrmcIbis.ourPortType(portType)) {
            if (name == null) {
                throw new IOException("Anonymous  ports not supported");
            }
            if (cU != null && !portType.hasCapability("connection.upcalls")) {
                throw new IbisConfigurationException("connection upcalls not supported by this porttype");
            }
            if (u != null && !portType.hasCapability("receive.autoupcalls")) {
                throw new IbisConfigurationException("upcalls not supported by this porttype");
            }
            if (u == null && !portType.hasCapability("receive.explicit")) {
                throw new IbisConfigurationException("explicit receive not supported by this porttype");
            }
            LrmcIbis lrmcIbis = this;
            synchronized (lrmcIbis) {
                Multicaster mc = this.getMulticaster(name, portType);
                if (mc.receivePort != null) {
                    throw new IOException("A receiveport with the same name already exists");
                }
                mc.receivePort = new LrmcReceivePort(mc, this, u, props);
                return mc.receivePort;
            }
        }
        return new StackingReceivePort(portType, this, name, u, cU, props);
    }

    public ReceivePort createReceivePort(PortType portType, String receivePortName) throws IOException {
        return this.createReceivePort(portType, receivePortName, null, null, null);
    }

    public ReceivePort createReceivePort(PortType portType, String receivePortName, MessageUpcall messageUpcall) throws IOException {
        return this.createReceivePort(portType, receivePortName, messageUpcall, null, null);
    }

    public ReceivePort createReceivePort(PortType portType, String receivePortName, ReceivePortConnectUpcall receivePortConnectUpcall) throws IOException {
        return this.createReceivePort(portType, receivePortName, null, receivePortConnectUpcall, null);
    }

    public SendPort createSendPort(PortType tp) throws IOException {
        return this.createSendPort(tp, null, null, null);
    }

    public SendPort createSendPort(PortType tp, String name) throws IOException {
        return this.createSendPort(tp, name, null, null);
    }

    private void matchPortType(PortType tp) {
        boolean matched = false;
        for (PortType p : this.portTypes) {
            if (!tp.equals((Object)p)) continue;
            matched = true;
        }
        if (!matched) {
            throw new IbisConfigurationException("PortType " + tp + " not specified when creating this Ibis instance");
        }
    }

    public void end() throws IOException {
        for (Map.Entry<String, Multicaster> x : this.multicasters.entrySet()) {
            x.getValue().done();
        }
        this.base.end();
    }

    public Registry registry() {
        return this.base.registry();
    }

    public Map<String, String> managementProperties() {
        return this.base.managementProperties();
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return this.base.getManagementProperty(key);
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        this.base.setManagementProperties(properties);
    }

    public void setManagementProperty(String key, String val) throws NoSuchPropertyException {
        this.base.setManagementProperty(key, val);
    }

    public void printManagementProperties(PrintStream stream) {
        this.base.printManagementProperties(stream);
    }

    public void poll() throws IOException {
        this.base.poll();
    }

    public IbisIdentifier identifier() {
        return this.base.identifier();
    }

    public Properties properties() {
        return this.base.properties();
    }

    private static boolean ourPortType(PortType tp) {
        return (tp.hasCapability("connection.manytomany") || tp.hasCapability("connection.onetomany")) && !tp.hasCapability("communication.reliable") && !tp.hasCapability("connection.upcalls") && !tp.hasCapability("connection.downcalls") && !tp.hasCapability("communication.numbered") && !tp.hasCapability("communication.fifo");
    }

    private static class EventHandler
    implements RegistryEventHandler {
        RegistryEventHandler h;
        LrmcIbis ibis;

        EventHandler(RegistryEventHandler h, LrmcIbis ibis) {
            this.h = h;
            this.ibis = ibis;
        }

        public void joined(IbisIdentifier id) {
            this.ibis.addIbis(id);
            if (this.h != null) {
                this.h.joined(id);
            }
        }

        public void left(IbisIdentifier id) {
            this.ibis.removeIbis(id);
            if (this.h != null) {
                this.h.left(id);
            }
        }

        public void died(IbisIdentifier id) {
            this.ibis.removeIbis(id);
            if (this.h != null) {
                this.h.died(id);
            }
        }

        public void gotSignal(String s, IbisIdentifier id) {
            if (this.h != null) {
                this.h.gotSignal(s, id);
            }
        }

        public void electionResult(String electionName, IbisIdentifier winner) {
            if (this.h != null) {
                this.h.electionResult(electionName, winner);
            }
        }

        public void poolClosed() {
            if (this.h != null) {
                this.h.poolClosed();
            }
        }

        public void poolTerminated(IbisIdentifier source) {
            if (this.h != null) {
                this.h.poolTerminated(source);
            }
        }
    }
}

