/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ticket {
    private static final int INIT_SIZE = 16;
    static Logger logger = LoggerFactory.getLogger((String)Ticket.class.getName());
    private int size;
    private int[] tickets;
    private int top;
    private Bucket[] buckets;

    public Ticket() {
        this(16);
    }

    public Ticket(int initialSize) {
        this.buckets = new Bucket[initialSize];
        this.tickets = new int[initialSize];
        for (int i = 0; i < initialSize; ++i) {
            this.buckets[i] = new Bucket();
            this.tickets[i] = i;
        }
        this.top = initialSize;
        this.size = initialSize;
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket(" + initialSize + ") done");
        }
    }

    public synchronized int get() {
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.get() starting");
        }
        if (this.top == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ticket.get() resizing from " + this.size + " to " + this.size * 2);
            }
            int new_size = this.size * 2;
            this.tickets = new int[new_size];
            Bucket[] new_buckets = new Bucket[new_size];
            System.arraycopy(this.buckets, 0, new_buckets, 0, this.size);
            for (int i = 0; i < this.size; ++i) {
                this.tickets[i] = this.size + i;
                new_buckets[this.size + i] = new Bucket();
            }
            this.top = this.size;
            this.size = new_size;
            this.buckets = new_buckets;
        }
        --this.top;
        int ticket = this.tickets[this.top];
        this.buckets[ticket].setValid();
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.get() returning tickets[" + this.top + "] = " + ticket);
        }
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int ticket, Object object) {
        Bucket bucket;
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.put(" + ticket + ") starting");
        }
        Ticket ticket2 = this;
        synchronized (ticket2) {
            bucket = this.buckets[ticket];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.put() got a bucket");
        }
        bucket.put(object);
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.put() done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object collect(int ticket) {
        Bucket bucket;
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.collect(" + ticket + ") starting");
        }
        Ticket ticket2 = this;
        synchronized (ticket2) {
            bucket = this.buckets[ticket];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.collect() got a bucket");
        }
        Object result = bucket.collect();
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.collect() got a result");
        }
        ticket2 = this;
        synchronized (ticket2) {
            this.tickets[this.top++] = ticket;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.collect() done");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(int ticket) {
        Bucket bucket;
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.peek(" + ticket + ") starting");
        }
        Ticket ticket2 = this;
        synchronized (ticket2) {
            bucket = this.buckets[ticket];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.peek() got a bucket");
        }
        Object result = bucket.peek();
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.peek() done");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int ticket) {
        Bucket bucket;
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.get(" + ticket + ") starting");
        }
        Ticket ticket2 = this;
        synchronized (ticket2) {
            bucket = this.buckets[ticket];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.get() got a bucket");
        }
        Object result = bucket.get();
        if (logger.isDebugEnabled()) {
            logger.debug("Ticket.get() done");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeTicket(int ticket) {
        Bucket bucket;
        Ticket ticket2 = this;
        synchronized (ticket2) {
            bucket = this.buckets[ticket];
        }
        bucket.release();
        ticket2 = this;
        synchronized (ticket2) {
            this.tickets[this.top++] = ticket;
        }
    }

    private static class Bucket {
        private Object data = null;
        private int waiters = 0;
        private boolean valid = false;
        private boolean initialized = false;

        Bucket() {
        }

        synchronized void setValid() {
            this.valid = true;
        }

        synchronized Object get() {
            if (!this.valid) {
                throw new RuntimeException("Invalid ticket");
            }
            while (!this.initialized) {
                ++this.waiters;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.waiters;
            }
            Object result = this.data;
            this.initialized = false;
            if (this.waiters != 0) {
                this.notifyAll();
            }
            return result;
        }

        synchronized Object collect() {
            if (!this.valid) {
                throw new RuntimeException("Invalid ticket");
            }
            while (!this.initialized) {
                ++this.waiters;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.waiters;
            }
            Object result = this.data;
            this.initialized = false;
            this.valid = false;
            return result;
        }

        synchronized void release() {
            if (!this.valid) {
                throw new RuntimeException("Invalid ticket");
            }
            this.initialized = false;
            this.valid = false;
        }

        synchronized Object peek() {
            if (!this.valid) {
                throw new RuntimeException("Invalid ticket");
            }
            while (!this.initialized) {
                ++this.waiters;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.waiters;
            }
            return this.data;
        }

        synchronized void put(Object o) {
            if (!this.valid) {
                throw new RuntimeException("Invalid ticket");
            }
            while (this.initialized) {
                ++this.waiters;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.waiters;
            }
            this.data = o;
            this.initialized = true;
            if (this.waiters != 0) {
                this.notifyAll();
            }
        }
    }
}

