/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Postpone {
    private Postpone() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java ibis.util.Postpone [ -o <outputfile> ] <seconds> <main class> ...");
            System.exit(1);
        }
        int count = Integer.parseInt(args[0]);
        int argsbase = 1;
        if (args[1].equals("-o")) {
            if (args.length < 4) {
                throw new Error("Usage: java ibis.util.Postpone [ -o <outputfile> ] <seconds> <main class> ...");
            }
            String outfile = args[2];
            try {
                FileOutputStream s = new FileOutputStream(outfile);
                PrintStream p = new PrintStream(s);
                System.setErr(p);
                System.setOut(p);
            }
            catch (Exception e) {
                System.err.println("Could not write file " + outfile);
                System.exit(1);
            }
            argsbase = 3;
        }
        try {
            Thread.sleep(count * 1000);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Class<?> cl = null;
        try {
            cl = Class.forName(args[argsbase]);
        }
        catch (ClassNotFoundException e) {
            try {
                cl = Thread.currentThread().getContextClassLoader().loadClass(args[argsbase]);
            }
            catch (ClassNotFoundException e2) {
                throw new Error("Could not load class " + args[argsbase]);
            }
        }
        Method m = null;
        try {
            m = cl.getMethod("main", args.getClass());
        }
        catch (Exception e) {
            throw new Error("Could not find a main(String[]) in class " + args[argsbase]);
        }
        String[] args2 = new String[args.length - argsbase - 1];
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = args[i + argsbase + 1];
        }
        if (!m.isAccessible()) {
            final Method temporary_method = m;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    temporary_method.setAccessible(true);
                    return null;
                }
            });
        }
        try {
            m.invoke(null, new Object[]{args2});
        }
        catch (Exception e) {
            System.out.println("Could not invoke main: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

