/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public abstract class TGAbstractMousePausedUI
extends TGUserInterface {
    private AMPUIMouseMotionListener mml;
    private AMPUIMouseListener ml;
    protected TGPanel tgPanel;
    Point mousePos = null;
    PauseThread pauseThread = null;

    public TGAbstractMousePausedUI(TGPanel tgp) {
        this.tgPanel = tgp;
        this.ml = new AMPUIMouseListener();
        this.mml = new AMPUIMouseMotionListener();
    }

    public final void activate() {
        this.preActivate();
        this.tgPanel.addMouseMotionListener(this.mml);
        this.tgPanel.addMouseListener(this.ml);
    }

    public final void deactivate() {
        this.tgPanel.removeMouseMotionListener(this.mml);
        this.tgPanel.removeMouseListener(this.ml);
        this.postDeactivate();
        super.deactivate();
    }

    public void preActivate() {
    }

    public void postDeactivate() {
    }

    public abstract void mousePaused(MouseEvent var1);

    public abstract void mouseMoved(MouseEvent var1);

    public abstract void mouseDragged(MouseEvent var1);

    public void resetPause() {
        if (this.pauseThread != null && this.pauseThread.isAlive()) {
            this.pauseThread.reset();
        } else {
            this.pauseThread = new PauseThread();
        }
    }

    public void cancelPause() {
        if (this.pauseThread != null && this.pauseThread.isAlive()) {
            this.pauseThread.cancel();
        }
    }

    private class AMPUIMouseListener
    extends MouseAdapter {
        private AMPUIMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            TGAbstractMousePausedUI.this.cancelPause();
        }

        public void mouseReleased(MouseEvent e) {
            TGAbstractMousePausedUI.this.cancelPause();
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class AMPUIMouseMotionListener
    implements MouseMotionListener {
        private AMPUIMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent e) {
            TGAbstractMousePausedUI.this.mousePos = e.getPoint();
            TGAbstractMousePausedUI.this.resetPause();
            TGAbstractMousePausedUI.this.mouseMoved(e);
        }

        public void mouseDragged(MouseEvent e) {
            TGAbstractMousePausedUI.this.mousePos = e.getPoint();
            TGAbstractMousePausedUI.this.resetPause();
            TGAbstractMousePausedUI.this.mouseDragged(e);
        }
    }

    class PauseThread
    extends Thread {
        boolean resetSleep;
        boolean cancelled = false;

        PauseThread() {
            this.start();
        }

        void reset() {
            this.resetSleep = true;
            this.cancelled = false;
        }

        void cancel() {
            this.cancelled = true;
        }

        public void run() {
            try {
                do {
                    this.resetSleep = false;
                    PauseThread.sleep(250L);
                } while (this.resetSleep);
                if (!this.cancelled) {
                    MouseEvent pausedEvent = new MouseEvent(TGAbstractMousePausedUI.this.tgPanel, 504, 0L, 0, TGAbstractMousePausedUI.this.mousePos.x, TGAbstractMousePausedUI.this.mousePos.y, 0, false);
                    TGAbstractMousePausedUI.this.mousePaused(pausedEvent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

