/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class GLNavigateUI
extends TGUserInterface {
    GLPanel glPanel;
    TGPanel tgPanel;
    GLNavigateMouseListener ml;
    TGAbstractDragUI hvDragUI;
    TGAbstractDragUI rotateDragUI;
    DragNodeUI dragNodeUI;

    public GLNavigateUI(GLPanel glp) {
        this.glPanel = glp;
        this.tgPanel = this.glPanel.getTGPanel();
        this.hvDragUI = this.glPanel.getHVScroll().getHVDragUI();
        if (this.glPanel.getRotateScroll() != null) {
            this.rotateDragUI = this.glPanel.getRotateScroll().getRotateDragUI();
        }
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.ml = new GLNavigateMouseListener();
    }

    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
    }

    public void deactivate() {
        this.tgPanel.removeMouseListener(this.ml);
    }

    class GLNavigateMouseListener
    extends MouseAdapter {
        GLNavigateMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Node mouseOverN = GLNavigateUI.this.tgPanel.getMouseOverN();
            if (e.getModifiers() == 16) {
                if (mouseOverN == null) {
                    GLNavigateUI.this.hvDragUI.activate(e);
                } else {
                    GLNavigateUI.this.dragNodeUI.activate(e);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            Node mouseOverN = GLNavigateUI.this.tgPanel.getMouseOverN();
            if (e.getModifiers() == 16 && mouseOverN != null) {
                GLNavigateUI.this.tgPanel.setSelect(mouseOverN);
                GLNavigateUI.this.glPanel.getHVScroll().slowScrollToCenter(mouseOverN);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 3) {
                GLNavigateUI.this.glPanel.showPopup(e.getX(), e.getY());
            } else {
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
            }
        }
    }
}

