/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.NodePair;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.ImmutableGraphEltSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphEltSet
implements ImmutableGraphEltSet {
    protected Vector<Node> nodes = new Vector();
    protected Collection<Edge> edges = Collections.synchronizedSet(new HashSet());
    protected Hashtable<String, Node> nodeIDRegistry = new Hashtable();

    @Override
    public synchronized Iterable<Node> getNodeIterable() {
        return new NodeIterable(this.nodes);
    }

    @Override
    public synchronized Iterable<Edge> getEdgeIterable() {
        return new EdgeIterable(this.edges);
    }

    @Override
    public synchronized Iterable<NodePair> getNodePairIterable() {
        return new NodePairIterable(this.nodes);
    }

    @Override
    public int nodeNum() {
        return this.nodes.size();
    }

    @Override
    public int nodeCount() {
        return this.nodes.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addNode(Node node) throws TGException {
        String id = node.getID();
        if (id != null) {
            if (this.findNode(id) != null) throw new TGException(1, "node ID '" + id + "' already exists.");
            this.nodeIDRegistry.put(id, node);
            this.nodes.add(node);
            return;
        } else {
            String label = node.getLabel().trim();
            if (label == null) {
                label = "";
            }
            if (!label.equals("") && this.findNode(node.getLabel()) == null) {
                id = label;
            } else {
                int i = 1;
                while (this.findNode(label + "-" + i) != null) {
                    ++i;
                }
                id = label + "-" + i;
            }
            node.setID(id);
            this.nodeIDRegistry.put(id, node);
            this.nodes.add(node);
        }
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    @Override
    public int edgeNum() {
        return this.edges.size();
    }

    @Override
    public int edgeCount() {
        return this.edges.size();
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        if (!this.contains(edge)) {
            this.edges.add(edge);
            edge.from.addEdge(edge);
            edge.to.addEdge(edge);
        }
    }

    public Edge addEdge(Node from, Node to, int tension) {
        Edge edge = null;
        if (from != null && to != null) {
            edge = new Edge(from, to, tension);
            this.addEdge(edge);
        }
        return edge;
    }

    public boolean contains(Edge edge) {
        return this.edges.contains(edge);
    }

    @Override
    public Node findNode(String id) {
        if (id == null) {
            return null;
        }
        return this.nodeIDRegistry.get(id);
    }

    public Node findNodeByURL(String strURL) {
        Node retVal = null;
        if (strURL == null) {
            return null;
        }
        Enumeration<Node> myEnum = this.nodeIDRegistry.elements();
        while (myEnum.hasMoreElements()) {
            Node node = myEnum.nextElement();
            if (!node.getURL().equalsIgnoreCase(strURL)) continue;
            retVal = node;
            break;
        }
        return retVal;
    }

    @Override
    public Node findNodeLabelContaining(String substring) {
        for (Node n : this.nodes) {
            if (!n.getLabel().toLowerCase().equals(substring.toLowerCase())) continue;
            return n;
        }
        for (Node n : this.nodes) {
            if (n.getLabel().toLowerCase().indexOf(substring.toLowerCase()) <= -1) continue;
            return n;
        }
        return null;
    }

    @Override
    public Edge findEdge(Node from, Node to) {
        for (Edge e : from.getEdgeIterable()) {
            if (e.to != to) continue;
            return e;
        }
        return null;
    }

    public boolean deleteEdge(Edge edge) {
        if (edge == null) {
            return false;
        }
        if (!this.edges.remove(edge)) {
            return false;
        }
        edge.from.removeEdge(edge);
        edge.to.removeEdge(edge);
        return true;
    }

    public void deleteEdges(Vector<Edge> edgesToDelete) {
        for (Edge e : edgesToDelete) {
            this.deleteEdge(e);
        }
    }

    public boolean deleteEdge(Node from, Node to) {
        Edge e = this.findEdge(from, to);
        if (e != null) {
            return this.deleteEdge(e);
        }
        return false;
    }

    public synchronized boolean deleteNode(Node node) {
        if (node == null) {
            return false;
        }
        if (!this.nodes.remove(node)) {
            return false;
        }
        String id = node.getID();
        if (id != null) {
            this.nodeIDRegistry.remove(id);
        }
        for (Edge e : node.getEdgeIterable()) {
            if (e.from == node) {
                this.edges.remove(e);
                e.to.removeEdge(e);
                continue;
            }
            if (e.to != node) continue;
            this.edges.remove(e);
            e.from.removeEdge(e);
        }
        return true;
    }

    public synchronized void deleteNodes(Vector<Node> nodesToDelete) {
        for (Node n : nodesToDelete) {
            this.deleteNode(n);
        }
    }

    @Override
    public Node getRandomNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        int r = (int)(Math.random() * (double)this.nodeCount());
        return this.nodes.get(r);
    }

    @Override
    public Node getFirstNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.get(0);
    }

    public synchronized void clearAll() {
        this.nodes.clear();
        this.edges.clear();
        this.nodeIDRegistry.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodePairIterable
    implements Iterable<NodePair> {
        Node[] nodes;

        NodePairIterable(Vector<Node> nodes) {
            this.nodes = nodes.toArray(new Node[nodes.size()]);
        }

        @Override
        public Iterator<NodePair> iterator() {
            return new NodePairIterator(this.nodes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodePairIterator
    implements Iterator<NodePair> {
        Node[] nodes;
        int i = 0;
        int j = 1;
        NodePair pair = new NodePair();

        NodePairIterator(Node[] nodes) {
            this.nodes = nodes;
            if (nodes.length < 2) {
                this.i = nodes.length;
            }
        }

        @Override
        public boolean hasNext() {
            return this.i < this.nodes.length;
        }

        @Override
        public NodePair next() {
            if (this.i >= this.nodes.length) {
                throw new NoSuchElementException("Iterator exhausted");
            }
            this.pair.n1 = this.nodes[this.i];
            this.pair.n2 = this.nodes[this.j++];
            if (this.j >= this.nodes.length) {
                ++this.i;
                this.j = this.i + 1;
                if (this.j >= this.nodes.length) {
                    this.i = this.nodes.length;
                }
            }
            return this.pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeIterable
    implements Iterable<Edge> {
        Edge[] edges;

        EdgeIterable(Collection<Edge> edges) {
            this.edges = edges.toArray(new Edge[edges.size()]);
        }

        @Override
        public Iterator<Edge> iterator() {
            return new EdgeIterator(this.edges);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeIterator
    implements Iterator<Edge> {
        Edge[] edges;
        int i = 0;

        EdgeIterator(Edge[] edges) {
            this.edges = edges;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.edges.length;
        }

        @Override
        public Edge next() {
            if (this.i >= this.edges.length) {
                throw new NoSuchElementException("Iterator exhausted");
            }
            return this.edges[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeIterable
    implements Iterable<Node> {
        Node[] nodes;

        NodeIterable(Vector<Node> nodes) {
            this.nodes = nodes.toArray(new Node[nodes.size()]);
            Arrays.sort(this.nodes);
        }

        @Override
        public Iterator<Node> iterator() {
            return new NodeIterator(this.nodes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeIterator
    implements Iterator<Node> {
        Node[] nodes;
        int i = 0;

        NodeIterator(Node[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.nodes.length;
        }

        @Override
        public Node next() {
            if (this.i >= this.nodes.length) {
                throw new NoSuchElementException("Iterator exhausted");
            }
            return this.nodes[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

