/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.ConnectionFailedException;
import ibis.ipl.ConnectionsFailedException;
import ibis.ipl.Ibis;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.multi.ManageableMapper;
import ibis.ipl.impl.multi.MultiIbis;
import ibis.ipl.impl.multi.MultiIbisIdentifier;
import ibis.ipl.impl.multi.MultiReceivePortIdentifier;
import ibis.ipl.impl.multi.MultiSendPortIdentifier;
import ibis.ipl.impl.multi.MultiWriteMessage;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSendPort
implements SendPort {
    private static final Logger logger = LoggerFactory.getLogger(MultiSendPort.class);
    private final ManageableMapper ManageableMapper;
    private final HashMap<String, SendPort> subPortMap = new HashMap();
    private ArrayList<DowncallHandler> handlers = new ArrayList();
    private final PortType portType;
    private final MultiSendPortIdentifier id;
    private final String name;
    private final MultiIbis ibis;
    private SendPort activeSendPort;
    private String activeIbisName;
    private final ArrayList<ReceivePortIdentifier> idQueue = new ArrayList();
    private final ArrayList<IOException> errorQueue = new ArrayList();
    private int handlerCount;

    public MultiSendPort(PortType type, MultiIbis ibis, String name, SendPortDisconnectUpcall connectUpcall, Properties props) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Constructing MultiSendPort");
        }
        for (String ibisName : ibis.subIbisMap.keySet()) {
            Ibis subIbis = ibis.subIbisMap.get(ibisName);
            DisconnectUpcaller upcaller = null;
            if (connectUpcall != null) {
                upcaller = new DisconnectUpcaller(ibisName, this, connectUpcall);
            }
            SendPort subPort = subIbis.createSendPort(type, name, upcaller, props);
            DowncallHandler handler = new DowncallHandler(subPort, ibisName);
            this.handlers.add(handler);
            this.subPortMap.put(ibisName, subPort);
            ibis.sendPortMap.put(subPort, this);
            ThreadPool.createNew((Runnable)handler, (String)("Connect Handler: " + ibisName));
        }
        this.ManageableMapper = new ManageableMapper(this.subPortMap);
        this.portType = type;
        this.id = new MultiSendPortIdentifier(ibis.identifier(), name);
        this.name = name;
        this.ibis = ibis;
    }

    public void close() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing port: " + this);
        }
        for (SendPort port : this.subPortMap.values()) {
            try {
                port.close();
            }
            catch (IOException iOException) {}
        }
        this.ibis.closeSendPort(this);
    }

    public void connect(ReceivePortIdentifier receiver) throws ConnectionFailedException {
        this.connect(receiver, 0L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(ReceivePortIdentifier receiver, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        ArrayList<ReceivePortIdentifier> arrayList = this.idQueue;
        synchronized (arrayList) {
            logger.debug("Attempting to connect.");
            this.errorQueue.clear();
            this.idQueue.clear();
            this.handlerCount = 0;
            if (this.activeSendPort == null) {
                logger.debug("No active sendport.");
                for (DowncallHandler handler : this.handlers) {
                    handler.timeout = timeoutMillis;
                    handler.fillTimeout = fillTimeout;
                    handler.opcode = 3;
                    handler.rpid = receiver;
                }
                this.idQueue.notifyAll();
                while (this.activeSendPort == null && this.handlerCount < this.handlers.size()) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Waiting for connection to open.");
                        }
                        this.idQueue.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Done waiting for connection.");
                }
                if (this.activeSendPort == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No Connection. Throwing exception.");
                    }
                    if (this.errorQueue.size() == 0) {
                        throw new ConnectionFailedException("Unable to open connection.", receiver);
                    }
                    throw new ConnectionFailedException("Unable to open connection.", receiver, (Throwable)this.errorQueue.get(0));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Using active send port to connect");
                }
                this.activeSendPort.connect(receiver, timeoutMillis, fillTimeout);
            }
        }
    }

    public ReceivePortIdentifier connect(IbisIdentifier id, String name) throws ConnectionFailedException {
        return this.connect(id, name, 0L, true);
    }

    public synchronized ReceivePortIdentifier connect(IbisIdentifier id, String name, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        ArrayList<ReceivePortIdentifier> arrayList = this.idQueue;
        synchronized (arrayList) {
            if (id == null) {
                throw new IllegalArgumentException("Null ibis identifier!");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connecting to: " + id + ":" + name + " timeout: " + timeoutMillis + " fill: " + fillTimeout);
            }
            this.errorQueue.clear();
            this.idQueue.clear();
            this.handlerCount = 0;
            if (this.activeSendPort == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No active connection...");
                }
                for (DowncallHandler handler : this.handlers) {
                    handler.timeout = timeoutMillis;
                    handler.fillTimeout = fillTimeout;
                    handler.opcode = 4;
                    handler.id = id;
                    handler.name = name;
                }
                this.idQueue.notifyAll();
                while (this.activeSendPort == null && this.handlerCount < this.handlers.size()) {
                    try {
                        logger.debug("Waiting for handler to connect.");
                        this.idQueue.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (this.activeSendPort == null) {
                    if (this.errorQueue.size() == 0) {
                        throw new ConnectionFailedException("Unable to open connection.", id, name);
                    }
                    throw new ConnectionFailedException("Unable to open connection.", id, name, (Throwable)this.errorQueue.get(0));
                }
                try {
                    return this.ibis.mapReceivePortIdentifier(this.idQueue.get(0), this.activeIbisName);
                }
                catch (IOException e) {
                    throw new ConnectionFailedException("Unable to map identifier.", null, this.idQueue.get(0).name(), (Throwable)e);
                }
            }
            logger.debug("Using active send port to connect.");
            try {
                MultiIbisIdentifier ident = (MultiIbisIdentifier)id;
                return this.ibis.mapReceivePortIdentifier(this.activeSendPort.connect(ident.subIdForIbis(this.activeIbisName), name, timeoutMillis, fillTimeout), this.activeIbisName);
            }
            catch (IOException e) {
                throw new ConnectionFailedException("Unable to map identifier.", null, name, (Throwable)e);
            }
        }
    }

    public void connect(ReceivePortIdentifier[] ports) throws ConnectionsFailedException {
        this.connect(ports, 0L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ReceivePortIdentifier[] ports, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        ArrayList<ReceivePortIdentifier> arrayList = this.idQueue;
        synchronized (arrayList) {
            logger.debug("Connecting...");
            this.errorQueue.clear();
            this.idQueue.clear();
            this.handlerCount = 0;
            if (this.activeSendPort == null) {
                logger.debug("No active connection");
                for (DowncallHandler handler : this.handlers) {
                    handler.timeout = timeoutMillis;
                    handler.fillTimeout = fillTimeout;
                    handler.opcode = 1;
                    handler.rpids = ports;
                }
                this.idQueue.notifyAll();
                while (this.activeSendPort == null && this.handlerCount < this.handlers.size()) {
                    try {
                        logger.debug("Waiting for handler to connect...");
                        this.idQueue.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (this.activeSendPort == null) {
                    throw new ConnectionsFailedException("All of them!");
                }
            } else {
                logger.debug("Using active send port to connect");
                this.activeSendPort.connect(ports, timeoutMillis, fillTimeout);
            }
        }
    }

    public ReceivePortIdentifier[] connect(Map<IbisIdentifier, String> ports) throws ConnectionsFailedException {
        return this.connect(ports, 0L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceivePortIdentifier[] connect(Map<IbisIdentifier, String> ports, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        ArrayList<ReceivePortIdentifier> arrayList = this.idQueue;
        synchronized (arrayList) {
            logger.debug("Connecting...");
            this.errorQueue.clear();
            this.idQueue.clear();
            this.handlerCount = 0;
            if (this.activeSendPort == null) {
                logger.debug("No active sendport");
                for (DowncallHandler handler : this.handlers) {
                    handler.timeout = timeoutMillis;
                    handler.fillTimeout = fillTimeout;
                    handler.opcode = 2;
                    handler.iidMap = ports;
                }
                this.idQueue.notifyAll();
                while (this.activeSendPort == null && this.handlerCount < this.handlers.size()) {
                    try {
                        logger.debug("Waiting for connection...");
                        this.idQueue.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (this.activeSendPort == null) {
                    throw new ConnectionsFailedException("All of them!");
                }
                ReceivePortIdentifier[] ids = this.activeSendPort.connectedTo();
                for (int i = 0; i < ids.length; ++i) {
                    try {
                        ids[i] = this.ibis.mapReceivePortIdentifier(ids[i], this.activeIbisName);
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return ids;
            }
            logger.debug("Using active send port to connect.");
            ReceivePortIdentifier[] ids = this.activeSendPort.connect(ports, timeoutMillis, fillTimeout);
            for (int i = 0; i < ids.length; ++i) {
                try {
                    ids[i] = this.ibis.mapReceivePortIdentifier(ids[i], this.activeIbisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return ids;
        }
    }

    public ReceivePortIdentifier[] connectedTo() {
        HashMap<ReceivePortIdentifier, String> idList = new HashMap<ReceivePortIdentifier, String>();
        for (String ibisName : this.subPortMap.keySet()) {
            ReceivePortIdentifier[] ids;
            SendPort subPort = this.subPortMap.get(ibisName);
            for (ReceivePortIdentifier id : ids = subPort.connectedTo()) {
                try {
                    idList.put(this.ibis.mapReceivePortIdentifier(id, ibisName), ibisName);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return idList.keySet().toArray(new ReceivePortIdentifier[idList.size()]);
    }

    public void disconnect(ReceivePortIdentifier receiver) throws IOException {
        MultiIbisIdentifier id = (MultiIbisIdentifier)receiver.ibisIdentifier();
        for (String ibisName : this.subPortMap.keySet()) {
            SendPort subPort = this.subPortMap.get(ibisName);
            IbisIdentifier subId = id.subIdForIbis(ibisName);
            try {
                subPort.disconnect(subId, receiver.name());
            }
            catch (IOException e) {}
        }
    }

    public void disconnect(IbisIdentifier identifier, String name) throws IOException {
        MultiIbisIdentifier id = (MultiIbisIdentifier)identifier;
        for (String ibisName : this.subPortMap.keySet()) {
            SendPort subPort = this.subPortMap.get(ibisName);
            IbisIdentifier subId = id.subIdForIbis(ibisName);
            try {
                subPort.disconnect(subId, name);
            }
            catch (IOException e) {}
        }
    }

    public PortType getPortType() {
        return this.portType;
    }

    public SendPortIdentifier identifier() {
        return this.id;
    }

    public ReceivePortIdentifier[] lostConnections() {
        HashMap<ReceivePortIdentifier, String> idList = new HashMap<ReceivePortIdentifier, String>();
        for (String ibisName : this.subPortMap.keySet()) {
            SendPort subPort = this.subPortMap.get(ibisName);
            ReceivePortIdentifier[] ids = subPort.lostConnections();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    idList.put(this.ibis.mapReceivePortIdentifier(ids[i], ibisName), ibisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return idList.keySet().toArray(new ReceivePortIdentifier[idList.size()]);
    }

    public String name() {
        return this.name;
    }

    public WriteMessage newMessage() throws IOException {
        return new MultiWriteMessage(this.activeSendPort.newMessage(), this);
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return this.ManageableMapper.getManagementProperty(key);
    }

    public Map<String, String> managementProperties() {
        return this.ManageableMapper.managementProperties();
    }

    public void printManagementProperties(PrintStream stream) {
        this.ManageableMapper.printManagementProperties(stream);
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperties(properties);
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit(MultiSendPort port) {
        for (DowncallHandler handler : port.handlers) {
            handler.opcode = 0;
            DowncallHandler downcallHandler = handler;
            synchronized (downcallHandler) {
                handler.notifyAll();
            }
        }
    }

    private final class DisconnectUpcaller
    implements SendPortDisconnectUpcall {
        MultiSendPort port;
        SendPortDisconnectUpcall upcaller;
        String ibisName;

        public DisconnectUpcaller(String ibisName, MultiSendPort port, SendPortDisconnectUpcall upcaller) {
            this.port = port;
            this.upcaller = upcaller;
            this.ibisName = ibisName;
        }

        public void lostConnection(SendPort me, ReceivePortIdentifier johnDoe, Throwable reason) {
            if (logger.isDebugEnabled()) {
                logger.debug("Passing lost connection along: " + me + " : " + johnDoe + " : " + reason.getMessage());
            }
            try {
                this.upcaller.lostConnection((SendPort)((MultiSendPort)MultiSendPort.this).ibis.sendPortMap.get(me), MultiSendPort.this.ibis.mapReceivePortIdentifier(johnDoe, this.ibisName), reason);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private final class DowncallHandler
    implements Runnable {
        private static final int OPP_NOOP = -1;
        private static final int OPP_QUIT = 0;
        private static final int OPP_CONNECT_RPID_ARRAY = 1;
        private static final int OPP_CONNECT_IID_NAME_MAP = 2;
        private static final int OPP_CONNECT_RPID = 3;
        private static final int OPP_CONNECT_IID_NAME = 4;
        private final SendPort subPort;
        private final String ibisName;
        int opcode = -1;
        ReceivePortIdentifier[] rpids;
        Map<IbisIdentifier, String> iidMap;
        IbisIdentifier id;
        String name;
        ReceivePortIdentifier rpid;
        long timeout;
        boolean fillTimeout;

        public DowncallHandler(SendPort subPort, String ibisName) {
            this.subPort = subPort;
            this.ibisName = ibisName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setActive() {
            boolean set = false;
            ArrayList arrayList = MultiSendPort.this.idQueue;
            synchronized (arrayList) {
                if (MultiSendPort.this.activeSendPort == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Setting active SendPort port: " + this.subPort);
                    }
                    MultiSendPort.this.activeSendPort = this.subPort;
                    MultiSendPort.this.activeIbisName = this.ibisName;
                    MultiSendPort.this.idQueue.notifyAll();
                    set = true;
                } else {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Closing Inactive SendPort port: " + this.subPort);
                        }
                        this.subPort.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.opcode = -1;
            }
            return set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setActive(ReceivePortIdentifier portId) {
            ArrayList arrayList = MultiSendPort.this.idQueue;
            synchronized (arrayList) {
                boolean ret = this.setActive();
                if (ret) {
                    MultiSendPort.this.idQueue.add(portId);
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setError(IOException e) {
            ArrayList arrayList = MultiSendPort.this.idQueue;
            synchronized (arrayList) {
                if (MultiSendPort.this.activeSendPort == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Got Error While Connecting SendPort: " + this.subPort + " : " + e.getMessage());
                    }
                    MultiSendPort.this.errorQueue.add(e);
                    MultiSendPort.this.handlerCount++;
                    if (MultiSendPort.this.handlerCount >= MultiSendPort.this.handlers.size()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Notifying due to all handlers being done.");
                        }
                        MultiSendPort.this.idQueue.notifyAll();
                    }
                }
                this.opcode = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.opcode != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Running:" + this.opcode + " for: " + this.subPort);
                }
                switch (this.opcode) {
                    case -1: {
                        ArrayList arrayList = MultiSendPort.this.idQueue;
                        synchronized (arrayList) {
                            if (this.opcode == -1) {
                                try {
                                    logger.debug("Handler waiting.");
                                    MultiSendPort.this.idQueue.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            if (MultiSendPort.this.activeSendPort != null) {
                                logger.debug("We got beat to connect!");
                                this.opcode = -1;
                            }
                            break;
                        }
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        try {
                            for (int i = 0; i < this.rpids.length; ++i) {
                                this.rpids[i] = ((MultiReceivePortIdentifier)this.rpids[i]).getSubId(this.ibisName);
                            }
                            this.subPort.connect(this.rpids, this.timeout, this.fillTimeout);
                            this.setActive();
                        }
                        catch (ConnectionsFailedException e) {
                            this.setError((IOException)((Object)e));
                        }
                        break;
                    }
                    case 2: {
                        ReceivePortIdentifier[] portId;
                        try {
                            HashMap<IbisIdentifier, String> ids = new HashMap<IbisIdentifier, String>();
                            for (IbisIdentifier id : this.iidMap.keySet()) {
                                MultiIbisIdentifier mid = (MultiIbisIdentifier)id;
                                ids.put(mid.subIdForIbis(this.ibisName), this.iidMap.get(id));
                            }
                            portId = this.subPort.connect(ids, this.timeout, this.fillTimeout);
                            MultiSendPort.this.idQueue.add(portId[0]);
                            this.setActive();
                        }
                        catch (ConnectionsFailedException e) {
                            MultiSendPort.this.errorQueue.add(e);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            this.rpid = ((MultiReceivePortIdentifier)this.rpid).getSubId(this.ibisName);
                            this.subPort.connect(this.rpid, this.timeout, this.fillTimeout);
                            this.setActive();
                        }
                        catch (ConnectionFailedException e) {
                            MultiSendPort.this.errorQueue.add(e);
                        }
                        break;
                    }
                    case 4: {
                        ReceivePortIdentifier[] portId;
                        try {
                            MultiIbisIdentifier mid = (MultiIbisIdentifier)this.id;
                            portId = this.subPort.connect(mid.subIdForIbis(this.ibisName), this.name, this.timeout, this.fillTimeout);
                            this.setActive((ReceivePortIdentifier)portId);
                            break;
                        }
                        catch (ConnectionFailedException e) {
                            MultiSendPort.this.errorQueue.add(e);
                        }
                    }
                }
            }
        }
    }
}

