/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.impl.multi.MultiIbis;
import ibis.ipl.impl.multi.MultiIbisIdentifier;
import ibis.ipl.impl.multi.MultiRegistry;
import java.io.IOException;

public class MultiRegistryEventHandler
implements RegistryEventHandler {
    private final RegistryEventHandler subHandler;
    private final MultiIbis ibis;
    private MultiRegistry registry;
    private String ibisName;

    public MultiRegistryEventHandler(MultiIbis ibis, RegistryEventHandler subHandler) {
        this.ibis = ibis;
        this.subHandler = subHandler;
    }

    public synchronized void died(IbisIdentifier corpse) {
        while (this.registry == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        try {
            MultiIbisIdentifier id = this.ibis.mapIdentifier(corpse, this.ibisName);
            if (!this.registry.died.containsKey(id)) {
                this.registry.died.put(id, id);
                this.subHandler.died((IbisIdentifier)id);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void electionResult(String electionName, IbisIdentifier winner) {
        while (this.registry == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        try {
            MultiIbisIdentifier id = this.ibis.mapIdentifier(winner, this.ibisName);
            if (!this.registry.elected.containsKey(electionName)) {
                this.registry.elected.put(electionName, id);
                this.subHandler.electionResult(electionName, (IbisIdentifier)id);
            } else {
                MultiIbisIdentifier oldWinner = this.registry.elected.get(electionName);
                if (!oldWinner.equals(id)) {
                    this.registry.elected.put(electionName, id);
                    this.subHandler.electionResult(electionName, (IbisIdentifier)id);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void gotSignal(String signal, IbisIdentifier source) {
        this.subHandler.gotSignal(signal, source);
    }

    public synchronized void joined(IbisIdentifier joinedIbis) {
        while (this.registry == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        try {
            MultiIbisIdentifier id = this.ibis.mapIdentifier(joinedIbis, this.ibisName);
            if (!this.registry.joined.containsKey(id)) {
                this.registry.joined.put(id, id);
                this.subHandler.joined((IbisIdentifier)id);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void left(IbisIdentifier leftIbis) {
        while (this.registry == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        try {
            MultiIbisIdentifier id = this.ibis.mapIdentifier(leftIbis, this.ibisName);
            if (!this.registry.left.containsKey(id)) {
                this.registry.left.put(id, id);
                this.subHandler.left((IbisIdentifier)id);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void setName(String ibisName) {
        this.ibisName = ibisName;
    }

    public synchronized void setRegistry(MultiRegistry registry) {
        this.registry = (MultiRegistry)this.ibis.registry();
        this.notifyAll();
    }

    public void poolClosed() {
    }

    public void poolTerminated(IbisIdentifier source) {
    }
}

