/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.Ibis;
import ibis.ipl.MessageUpcall;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.ReceiveTimedOutException;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.multi.ManageableMapper;
import ibis.ipl.impl.multi.MultiIbis;
import ibis.ipl.impl.multi.MultiReadMessage;
import ibis.ipl.impl.multi.MultiReceivePortIdentifier;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MultiReceivePort
implements ReceivePort {
    private final Map<String, ReceivePort> subPortMap = Collections.synchronizedMap(new HashMap());
    private final MultiReceivePortIdentifier id;
    private final ManageableMapper ManageableMapper;
    private final PortType portType;
    private final ArrayList<MultiReadMessage> messageQueue = new ArrayList();
    private final ArrayList<IOException> exceptionQueue = new ArrayList();
    private final ArrayList<DowncallHandler> handlers = new ArrayList();
    private final MultiIbis ibis;
    private boolean handlersStarted;

    public MultiReceivePort(PortType type, MultiIbis ibis, String name, MessageUpcall upcall, ReceivePortConnectUpcall connectUpcall, Properties properties) throws IOException {
        this.id = new MultiReceivePortIdentifier(ibis.identifier(), name);
        if (upcall != null) {
            upcall = new Upcaller(upcall, this);
        }
        for (String ibisName : ibis.subIbisMap.keySet()) {
            Ibis subIbis = ibis.subIbisMap.get(ibisName);
            ConnectUpcaller upcaller = null;
            if (connectUpcall != null) {
                upcaller = new ConnectUpcaller(ibisName, this, connectUpcall);
            }
            ReceivePort subPort = subIbis.createReceivePort(type, name, upcall, upcaller, properties);
            this.subPortMap.put(ibisName, subPort);
            ibis.receivePortMap.put(subPort, this);
            this.id.addSubId(ibisName, subPort.identifier());
            if (!type.hasCapability("receive.explicit") && !type.hasCapability("receive.poll") && !type.hasCapability("receive.pollupcalls") && !type.hasCapability("receive.timeout")) continue;
            DowncallHandler handler = new DowncallHandler(subPort, ibisName);
            this.handlers.add(handler);
        }
        this.ManageableMapper = new ManageableMapper(this.subPortMap);
        this.portType = type;
        this.ibis = ibis;
    }

    public synchronized void close() throws IOException {
        for (DowncallHandler handler : this.handlers) {
            handler.running = false;
        }
        for (ReceivePort port : this.subPortMap.values()) {
            try {
                port.close();
            }
            catch (IOException iOException) {}
        }
        this.ibis.closeReceivePort(this);
    }

    public synchronized void close(long timeoutMillis) throws IOException {
        long timeout = timeoutMillis / (long)this.subPortMap.size();
        for (ReceivePort port : this.subPortMap.values()) {
            try {
                port.close(timeout);
            }
            catch (IOException e) {}
        }
    }

    public synchronized SendPortIdentifier[] connectedTo() {
        HashMap<SendPortIdentifier, String> connectedTo = new HashMap<SendPortIdentifier, String>();
        for (String ibisName : this.subPortMap.keySet()) {
            ReceivePort port = this.subPortMap.get(ibisName);
            SendPortIdentifier[] ids = port.connectedTo();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    connectedTo.put(this.ibis.mapSendPortIdentifier(ids[i], ibisName), ibisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return connectedTo.keySet().toArray(new SendPortIdentifier[connectedTo.size()]);
    }

    public synchronized void disableConnections() {
        for (ReceivePort port : this.subPortMap.values()) {
            port.disableConnections();
        }
    }

    public synchronized void disableMessageUpcalls() {
        for (ReceivePort port : this.subPortMap.values()) {
            port.disableMessageUpcalls();
        }
    }

    public synchronized void enableConnections() {
        for (ReceivePort port : this.subPortMap.values()) {
            port.enableConnections();
        }
    }

    public synchronized void enableMessageUpcalls() {
        for (ReceivePort port : this.subPortMap.values()) {
            port.enableMessageUpcalls();
        }
    }

    public synchronized PortType getPortType() {
        return this.portType;
    }

    public ReceivePortIdentifier identifier() {
        return this.id;
    }

    public synchronized SendPortIdentifier[] lostConnections() {
        HashMap<SendPortIdentifier, String> connectedTo = new HashMap<SendPortIdentifier, String>();
        for (String ibisName : this.subPortMap.keySet()) {
            ReceivePort port = this.subPortMap.get(ibisName);
            SendPortIdentifier[] ids = port.lostConnections();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    connectedTo.put(this.ibis.mapSendPortIdentifier(ids[i], ibisName), ibisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return connectedTo.keySet().toArray(new SendPortIdentifier[connectedTo.size()]);
    }

    public String name() {
        return this.id.name();
    }

    public synchronized SendPortIdentifier[] newConnections() {
        HashMap<SendPortIdentifier, String> connectedTo = new HashMap<SendPortIdentifier, String>();
        for (String ibisName : this.subPortMap.keySet()) {
            ReceivePort port = this.subPortMap.get(ibisName);
            SendPortIdentifier[] ids = port.newConnections();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    connectedTo.put(this.ibis.mapSendPortIdentifier(ids[i], ibisName), ibisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return connectedTo.keySet().toArray(new SendPortIdentifier[connectedTo.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadMessage poll() throws IOException {
        ReadMessage result = null;
        ArrayList<MultiReadMessage> arrayList = this.messageQueue;
        synchronized (arrayList) {
            if (this.messageQueue.size() == 0) {
                for (ReceivePort port : this.subPortMap.values()) {
                    ReadMessage message = port.poll();
                    if (message == null) continue;
                    this.messageQueue.add(new MultiReadMessage(message, this));
                }
            }
            if (this.messageQueue.size() > 0) {
                result = this.messageQueue.remove(0);
            }
        }
        return result;
    }

    public ReadMessage receive() throws IOException {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadMessage receive(long timeoutMillis) throws IOException {
        if (this.handlers.size() == 0) {
            throw new IOException("Downcalls Not Configured!");
        }
        if (!this.handlersStarted) {
            for (DowncallHandler handler : this.handlers) {
                ThreadPool.createNew((Runnable)handler, (String)("Handler Thread: " + handler.ibisName));
            }
            this.handlersStarted = true;
        }
        ReadMessage ret = null;
        ArrayList<MultiReadMessage> arrayList = this.messageQueue;
        synchronized (arrayList) {
            if (this.messageQueue.size() == 0) {
                do {
                    try {
                        if (timeoutMillis > 0L) {
                            this.messageQueue.wait(timeoutMillis);
                            continue;
                        }
                        this.messageQueue.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (this.messageQueue.size() == 0 && this.exceptionQueue.size() == 0);
                if (this.messageQueue.size() == 0) {
                    IOException e = this.exceptionQueue.remove(0);
                    this.exceptionQueue.clear();
                    throw e;
                }
            }
            ret = this.messageQueue.remove(0);
        }
        return ret;
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return this.ManageableMapper.getManagementProperty(key);
    }

    public Map<String, String> managementProperties() {
        return this.ManageableMapper.managementProperties();
    }

    public void printManagementProperties(PrintStream stream) {
        this.ManageableMapper.printManagementProperties(stream);
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperties(properties);
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperty(key, value);
    }

    private static final class Upcaller
    implements MessageUpcall {
        MessageUpcall upcaller;
        MultiReceivePort port;

        public Upcaller(MessageUpcall upcaller, MultiReceivePort port) {
            this.upcaller = upcaller;
            this.port = port;
        }

        public void upcall(ReadMessage m) throws IOException, ClassNotFoundException {
            this.upcaller.upcall((ReadMessage)new MultiReadMessage(m, this.port));
        }
    }

    private final class ConnectUpcaller
    implements ReceivePortConnectUpcall {
        final MultiReceivePort port;
        final ReceivePortConnectUpcall upcaller;
        final String ibisName;

        public ConnectUpcaller(String ibisName, MultiReceivePort port, ReceivePortConnectUpcall upcaller) {
            this.port = port;
            this.upcaller = upcaller;
            this.ibisName = ibisName;
        }

        public boolean gotConnection(ReceivePort me, SendPortIdentifier applicant) {
            return this.upcaller.gotConnection((ReceivePort)this.port, applicant);
        }

        public void lostConnection(ReceivePort me, SendPortIdentifier johnDoe, Throwable reason) {
            try {
                this.upcaller.lostConnection((ReceivePort)this.port, MultiReceivePort.this.ibis.mapSendPortIdentifier(johnDoe, this.ibisName), reason);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private final class DowncallHandler
    implements Runnable {
        private final ReceivePort subPort;
        private final String ibisName;
        boolean running = false;

        public DowncallHandler(ReceivePort subPort, String ibisName) {
            this.subPort = subPort;
            this.ibisName = ibisName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                ReadMessage message = null;
                IOException exception = null;
                try {
                    message = this.subPort.receive();
                }
                catch (IOException e) {
                    exception = e;
                }
                ArrayList arrayList = MultiReceivePort.this.messageQueue;
                synchronized (arrayList) {
                    if (message != null || exception != null) {
                        if (message != null) {
                            MultiReceivePort.this.messageQueue.add(new MultiReadMessage(message, ((MultiReceivePort)MultiReceivePort.this).ibis.receivePortMap.get(this.subPort)));
                        } else if (exception != null) {
                            MultiReceivePort.this.exceptionQueue.add(exception);
                        } else {
                            MultiReceivePort.this.exceptionQueue.add(new ReceiveTimedOutException("Timeout waiting for message."));
                        }
                        MultiReceivePort.this.messageQueue.notifyAll();
                    }
                }
            }
        }
    }
}

