/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public final class MultiIbisIdentifier
implements IbisIdentifier {
    private static final long serialVersionUID = 5259510418367257559L;
    public final ibis.ipl.impl.multi.Location location;
    public final String pool;
    private byte[] registryData;
    private final String id;
    private transient byte[] codedForm;
    private final HashMap<String, IbisIdentifier> idMap;
    private byte[] tag;

    public MultiIbisIdentifier(String id, HashMap<String, IbisIdentifier> idMap, byte[] registryData, ibis.ipl.impl.multi.Location location, String pool, byte[] applicationTag) {
        this.id = id;
        this.idMap = idMap;
        this.registryData = registryData;
        this.location = location;
        this.pool = pool;
        this.tag = applicationTag;
        this.codedForm = this.computeCodedForm();
    }

    public MultiIbisIdentifier(byte[] codedForm) throws IOException {
        this(codedForm, 0, codedForm.length);
    }

    public MultiIbisIdentifier(byte[] codedForm, int offset, int size) throws IOException {
        this(new ObjectInputStream(new ByteArrayInputStream(codedForm, offset, size)));
    }

    public MultiIbisIdentifier(ObjectInputStream dis) throws IOException {
        this.location = new ibis.ipl.impl.multi.Location(dis);
        this.pool = dis.readUTF();
        this.idMap = new HashMap();
        int subCount = dis.readInt();
        for (int i = 0; i < subCount; ++i) {
            try {
                String impl = dis.readUTF();
                IbisIdentifier ibisId = (IbisIdentifier)dis.readObject();
                this.idMap.put(impl, ibisId);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        int registrySize = dis.readInt();
        if (registrySize < 0) {
            this.registryData = null;
        } else {
            this.registryData = new byte[registrySize];
            dis.readFully(this.registryData);
        }
        int tagSize = dis.readInt();
        if (tagSize < 0) {
            this.tag = null;
        } else {
            this.tag = new byte[tagSize];
            dis.readFully(this.tag);
        }
        this.id = dis.readUTF();
        this.codedForm = this.computeCodedForm();
    }

    public byte[] toBytes() {
        if (this.codedForm == null) {
            this.codedForm = this.computeCodedForm();
        }
        return (byte[])this.codedForm.clone();
    }

    private synchronized byte[] computeCodedForm() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream dos = new ObjectOutputStream(bos);
            this.location.writeTo(dos);
            dos.writeUTF(this.pool);
            dos.write(this.idMap.size());
            for (String impl : this.idMap.keySet()) {
                dos.writeUTF(impl);
                dos.writeObject(this.idMap.get(impl));
            }
            if (this.registryData == null) {
                dos.writeInt(-1);
            } else {
                dos.writeInt(this.registryData.length);
                dos.write(this.registryData);
            }
            if (this.tag == null) {
                dos.writeInt(-1);
            } else {
                dos.writeInt(this.tag.length);
                dos.write(this.tag);
            }
            dos.writeUTF(this.id);
            dos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeTo(DataOutput dos) throws IOException {
        if (this.codedForm == null) {
            this.codedForm = this.computeCodedForm();
        }
        dos.write(this.codedForm);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        MultiIbisIdentifier other = (MultiIbisIdentifier)o;
        return other.id.equals(this.id) && other.pool.equals(this.pool);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "(Ibis " + this.id + ", location " + this.location + ")";
    }

    public String name() {
        return "(Ibis " + this.id + ")";
    }

    public Location location() {
        return this.location;
    }

    public String poolName() {
        return this.pool;
    }

    public synchronized byte[] getRegistryData() {
        return this.registryData;
    }

    public int compareTo(IbisIdentifier c) {
        if (c instanceof MultiIbisIdentifier) {
            MultiIbisIdentifier other = (MultiIbisIdentifier)c;
            int cmp = this.pool.compareTo(other.pool);
            if (cmp == 0 && (cmp = this.location.compareTo(other.location)) == 0) {
                return this.id.compareTo(other.id);
            }
            return cmp;
        }
        return this.getClass().getName().compareTo(c.getClass().getName());
    }

    public String getID() {
        return this.id;
    }

    public String tagAsString() {
        if (this.tag == null) {
            return null;
        }
        try {
            return new String(this.tag, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("could not convert tag to string", e);
        }
    }

    public byte[] tag() {
        return this.tag;
    }

    public IbisIdentifier subIdForIbis(String ibisName) {
        return this.idMap.get(ibisName);
    }
}

