/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.util.TypedProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class Location
implements ibis.ipl.Location {
    private static final Location universe = new Location(new String[0]);
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = "@";
    private String[] levelNames;
    private transient byte[] codedForm;
    private transient Location parent = null;

    public Location(String[] levels) {
        this.levelNames = new String[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            this.levelNames[i] = levels[i];
        }
        this.codedForm = this.computeCodedForm();
    }

    public Location(String s) {
        this.levelNames = s.equals("") ? new String[0] : s.split(SEPARATOR);
        this.codedForm = this.computeCodedForm();
    }

    public Location(byte[] codedForm) throws IOException {
        this(codedForm, 0, codedForm.length);
    }

    public Location(byte[] codedForm, int offset, int size) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(codedForm, offset, size)));
    }

    public Location(DataInput dis) throws IOException {
        this(dis.readUTF());
    }

    public byte[] toBytes() {
        if (this.codedForm == null) {
            this.codedForm = this.computeCodedForm();
        }
        return (byte[])this.codedForm.clone();
    }

    private byte[] computeCodedForm() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(this.toString());
            dos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeTo(DataOutput dos) throws IOException {
        if (this.codedForm == null) {
            this.codedForm = this.computeCodedForm();
        }
        dos.write(this.codedForm);
    }

    public int numberOfLevels() {
        return this.levelNames.length;
    }

    public String[] getLevels() {
        return (String[])this.levelNames.clone();
    }

    public String getLevel(int level) {
        return this.levelNames[level];
    }

    public int numberOfMatchingLevels(ibis.ipl.Location o) {
        int n1 = o.numberOfLevels();
        for (int i = this.levelNames.length - 1; i >= 0; --i) {
            if (--n1 >= 0 && this.levelNames[i].equals(o.getLevel(n1))) continue;
            return this.levelNames.length - 1 - i;
        }
        return this.levelNames.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        Location l = (Location)o;
        if (l.levelNames.length != this.levelNames.length) {
            return false;
        }
        return this.numberOfMatchingLevels(l) == this.levelNames.length;
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 0; i < this.levelNames.length; ++i) {
            retval += this.levelNames[i].hashCode();
        }
        return retval;
    }

    public static Location defaultLocation(Properties props) {
        String fullHostName = null;
        try {
            InetAddress a = InetAddress.getLocalHost();
            fullHostName = a.getCanonicalHostName();
        }
        catch (IOException e) {
            fullHostName = "Unknown location";
        }
        String[] split = fullHostName.split("\\.");
        TypedProperties p = new TypedProperties(props);
        String s = p.getProperty("ibis.location");
        if (s == null) {
            s = "%HOSTNAME%@%DOMAIN%";
        }
        char[] buf = s.toCharArray();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            int j;
            if (buf[i] != '%') {
                b.append(buf[i]);
                continue;
            }
            if (i == buf.length - 1) {
                b.append('%');
                continue;
            }
            if (buf[i + 1] == '%') {
                b.append('%');
                ++i;
                continue;
            }
            StringBuffer keyBuffer = new StringBuffer();
            String key = null;
            for (j = i + 1; j < buf.length; ++j) {
                if (buf[j] == '%') {
                    key = keyBuffer.toString();
                    i = j;
                    break;
                }
                keyBuffer.append(buf[j]);
            }
            if (key == null) {
                b.append('%');
                b.append(keyBuffer);
                i = buf.length - 1;
                break;
            }
            if (key.equals("HOSTNAME")) {
                b.append(split[0]);
                continue;
            }
            if (key.equals("DOMAIN") || key.equals("FLAT_DOMAIN")) {
                for (j = 1; j < split.length; ++j) {
                    b.append(split[j]);
                    if (j >= split.length - 1) continue;
                    b.append(key.equals("DOMAIN") ? SEPARATOR : Character.valueOf(':'));
                }
                continue;
            }
            if (key.equals("PID")) {
                int pid = -1;
                try {
                    pid = Integer.parseInt(new File("/proc/self").getCanonicalFile().getName());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                b.append(pid);
                continue;
            }
            b.append('%');
            b.append(key);
            b.append('%');
        }
        return new Location(b.toString());
    }

    public String toString() {
        String retval = "";
        for (int i = 0; i < this.levelNames.length; ++i) {
            if (i != 0) {
                retval = retval + SEPARATOR;
            }
            retval = retval + this.levelNames[i];
        }
        return retval;
    }

    public int compareTo(ibis.ipl.Location o) {
        int n = o.numberOfLevels();
        for (int i = this.levelNames.length - 1; i >= 0; --i) {
            if (--n < 0) {
                return 1;
            }
            int cmp = this.levelNames[i].compareTo(o.getLevel(n));
            if (cmp == 0) continue;
            return cmp;
        }
        if (n == 0) {
            return 0;
        }
        return -1;
    }

    public ibis.ipl.Location getParent() {
        if (this.parent == null) {
            if (this.levelNames.length <= 1) {
                this.parent = universe;
            } else {
                String[] names = new String[this.levelNames.length - 1];
                for (int i = 1; i < this.levelNames.length; ++i) {
                    names[i - 1] = this.levelNames[i];
                }
                this.parent = new Location(names);
            }
        }
        return this.parent;
    }

    public Iterator<String> iterator() {
        return new Iter();
    }

    private class Iter
    implements Iterator<String> {
        int index;

        private Iter() {
            this.index = Location.this.levelNames.length;
        }

        @Override
        public boolean hasNext() {
            return this.index > 0;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                return Location.this.levelNames[--this.index];
            }
            throw new NoSuchElementException("Iterator exhausted");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }
}

