/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;

public class ASMRepository
implements Opcodes {
    public static HashMap<String, ClassNode> classes = new HashMap();

    public static void addClass(ClassNode cl) {
        classes.put(cl.name, cl);
    }

    public static ClassNode findClass(String name) throws ClassNotFoundException {
        ClassNode clazz = classes.get(name);
        if (clazz == null) {
            ClassReader cr;
            String externalName = name;
            if (name.contains("/")) {
                externalName = name.replaceAll("/", ".");
            }
            try {
                cr = new ClassReader(externalName);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Class not found: " + externalName, e);
            }
            clazz = new ClassNode(262144);
            cr.accept((ClassVisitor)clazz, 0);
            classes.put(name, clazz);
        }
        return clazz;
    }

    public static void dump(String fileName, ClassNode clazz) throws IOException {
        ClassWriter w = new ClassWriter(2);
        clazz.accept((ClassVisitor)w);
        byte[] b = w.toByteArray();
        FileOutputStream o = new FileOutputStream(fileName);
        o.write(b);
        o.close();
    }

    public static void removeClass(String name) {
        if (name.contains(".")) {
            name = name.replaceAll(".", "/");
        }
        classes.remove(name);
    }

    public static ClassNode parseClassFile(String fileName) throws IOException {
        return ASMRepository.parseInputStream(new BufferedInputStream(new FileInputStream(fileName)), fileName);
    }

    public static ClassNode parseInputStream(InputStream in, String fileName) throws IOException {
        ClassNode n = new ClassNode(262144);
        ClassReader r = new ClassReader(in);
        r.accept((ClassVisitor)n, 0);
        classes.put(n.name, n);
        return n;
    }

    public static boolean instanceOf(ClassNode clazz, String type) throws ClassNotFoundException {
        ClassNode n = clazz;
        while (true) {
            if (n.name.equals(type)) {
                return true;
            }
            if (n.name.equals("java/lang/Object") || n.superName == null) break;
            n = ASMRepository.findClass(n.superName);
        }
        return ASMRepository.implementationOf(clazz, type);
    }

    public static ClassNode[] getSuperClasses(ClassNode clazz) throws ClassNotFoundException {
        ArrayList<ClassNode> supers = new ArrayList<ClassNode>();
        while (!clazz.name.equals("java/lang/Object") && clazz.superName != null) {
            ClassReader r;
            try {
                r = new ClassReader(clazz.superName);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Could not find class " + clazz.superName, e);
            }
            clazz = new ClassNode(262144);
            r.accept((ClassVisitor)clazz, 0);
            classes.put(clazz.name, clazz);
            supers.add(clazz);
        }
        return supers.toArray(new ClassNode[supers.size()]);
    }

    public static boolean implementationOf(ClassNode clazz, String type) throws ClassNotFoundException {
        List interfaces = clazz.interfaces;
        for (String i : interfaces) {
            if (!i.equals(type)) continue;
            return true;
        }
        if (clazz.name.equals("java/lang/Object")) {
            return false;
        }
        if (clazz.superName == null) {
            return false;
        }
        ClassNode superClass = ASMRepository.findClass(clazz.superName);
        return ASMRepository.implementationOf(superClass, type);
    }

    public static void clearCache() {
        classes.clear();
    }
}

