/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;

@Beta
public class PagedIterables {
    public static <T> PagedIterable<T> onlyPage(final IterableWithMarker<T> only) {
        return new PagedIterable<T>(){

            public Iterator<IterableWithMarker<T>> iterator() {
                return ImmutableSet.of((Object)((Object)only)).iterator();
            }
        };
    }

    @Deprecated
    public static <T> PagedIterable<T> of(IterableWithMarker<T> only) {
        return PagedIterables.onlyPage(only);
    }

    public static <T> PagedIterable<T> advance(final IterableWithMarker<T> initial, final Function<Object, IterableWithMarker<T>> markerToNext) {
        return new PagedIterable<T>(){

            public Iterator<IterableWithMarker<T>> iterator() {
                return PagedIterables.advancingIterator(initial, markerToNext);
            }
        };
    }

    private static <T> Iterator<IterableWithMarker<T>> advancingIterator(IterableWithMarker<T> initial, Function<Object, IterableWithMarker<T>> markerToNext) {
        if (!initial.nextMarker().isPresent()) {
            return ImmutableSet.of(initial).iterator();
        }
        return new AdvancingIterator(initial, markerToNext);
    }

    private static class AdvancingIterator<T>
    extends AbstractIterator<IterableWithMarker<T>> {
        private final Function<Object, IterableWithMarker<T>> markerToNext;
        private transient IterableWithMarker<T> current;
        private transient boolean unread = true;

        private AdvancingIterator(IterableWithMarker<T> initial, Function<Object, IterableWithMarker<T>> markerToNext) {
            this.current = (IterableWithMarker)((Object)Preconditions.checkNotNull(initial, (Object)"initial iterable"));
            this.markerToNext = (Function)Preconditions.checkNotNull(markerToNext, (Object)"marker to next iterable");
        }

        protected IterableWithMarker<T> computeNext() {
            if (this.unread) {
                try {
                    IterableWithMarker<T> iterableWithMarker = this.current;
                    return iterableWithMarker;
                }
                finally {
                    this.unread = false;
                }
            }
            if (this.current.nextMarker().isPresent()) {
                this.current = (IterableWithMarker)((Object)this.markerToNext.apply(this.current.nextMarker().get()));
                return this.current;
            }
            return (IterableWithMarker)((Object)this.endOfData());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.current, this.unread});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AdvancingIterator other = (AdvancingIterator)((Object)AdvancingIterator.class.cast(obj));
            return Objects.equal(this.current, other.current) && Objects.equal((Object)this.unread, (Object)other.unread);
        }

        public String toString() {
            return Objects.toStringHelper((String)"").add("current", this.current).add("unread", this.unread).toString();
        }
    }
}

