/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.randomsteal;

import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Random;

public class Client {
    public static final byte OPCODE_PING = 101;
    public static final byte OPCODE_PONG = 102;
    private static int SERVER_TIMEOUT = 60000;
    private final VirtualSocketFactory sf;
    private final VirtualSocket s;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final VirtualServerSocket ss;
    private boolean done = false;
    private final int clientTimeout;

    public Client(VirtualSocketAddress target, int timeout) throws IOException, InitializationException {
        this.clientTimeout = timeout;
        this.sf = VirtualSocketFactory.createSocketFactory();
        this.s = this.sf.createClientSocket(target, SERVER_TIMEOUT, true, null);
        this.s.setTcpNoDelay(true);
        this.in = new DataInputStream(new BufferedInputStream(this.s.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.s.getOutputStream()));
        this.ss = this.sf.createServerSocket(0, 0, null);
        this.s.setSoTimeout(SERVER_TIMEOUT);
        this.ss.getLocalSocketAddress().write(this.out);
        this.out.flush();
    }

    private static void configure(VirtualSocket s) throws SocketException {
        s.setTcpNoDelay(true);
    }

    public synchronized boolean getDone() {
        return this.done;
    }

    private void doAccept() throws IOException {
        VirtualSocket s;
        try {
            s = this.ss.accept();
        }
        catch (SocketTimeoutException e) {
            return;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            Client.configure(s);
            in = s.getInputStream();
            out = s.getOutputStream();
            int request = in.read();
            if (request != 101) {
                throw new Error("Client accept received junk!" + request);
            }
            out.write(102);
            out.flush();
        }
        catch (Exception e) {
            try {
                throw new Error("Client accept failed!", e);
            }
            catch (Throwable throwable) {
                VirtualSocketFactory.close(s, out, in);
                throw throwable;
            }
        }
        VirtualSocketFactory.close(s, out, in);
    }

    private void doConnect(VirtualSocketAddress target) {
        VirtualSocket s = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            s = this.sf.createClientSocket(target, this.clientTimeout, true, null);
            Client.configure(s);
            in = s.getInputStream();
            out = s.getOutputStream();
            out.write(101);
            out.flush();
            int result = in.read();
            if (result != 102) {
                throw new Error("Client connect received junk!" + result);
            }
        }
        catch (Exception e) {
            try {
                throw new Error("Client connect failed!", e);
            }
            catch (Throwable throwable) {
                VirtualSocketFactory.close(s, out, in);
                throw throwable;
            }
        }
        VirtualSocketFactory.close(s, out, in);
    }

    private boolean syncWithServer(int time) throws IOException {
        this.out.writeByte(43);
        this.out.writeInt(time);
        this.out.flush();
        return this.in.readByte() == 42;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Random random = new Random();
        int count = this.in.readInt();
        int clients = this.in.readInt();
        VirtualSocketAddress[] addresses = new VirtualSocketAddress[clients];
        for (int i = 0; i < clients; ++i) {
            addresses[i] = new VirtualSocketAddress(this.in);
        }
        new AcceptThread().start();
        byte result = this.in.readByte();
        if (result != 42) {
            throw new Error("Client received junk from server!" + result);
        }
        boolean cont = true;
        while (cont) {
            long start = System.currentTimeMillis();
            for (int c = 0; c < count; ++c) {
                this.doConnect(addresses[random.nextInt(clients)]);
            }
            long end = System.currentTimeMillis();
            cont = this.syncWithServer((int)(end - start));
        }
        Client client = this;
        synchronized (client) {
            this.done = true;
        }
        VirtualSocketFactory.close(this.s, this.out, this.in);
    }

    private class AcceptThread
    extends Thread {
        private AcceptThread() {
        }

        @Override
        public void run() {
            try {
                Client.this.ss.setSoTimeout(10000);
                while (!Client.this.getDone()) {
                    Client.this.doAccept();
                }
                Client.this.ss.close();
            }
            catch (Exception e) {
                throw new Error("Accept failed!", e);
            }
        }
    }
}

