/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.util.Vector;

public class Filters {
    public static final String DEFAULT_EXCLUDE = "*.*():E";
    protected boolean defaultExclude = true;
    protected Vector filters = new Vector();

    public void setDefaultExclude(boolean value) {
        this.defaultExclude = value;
    }

    public void addInclude(Include incl) {
        this.filters.addElement(incl);
    }

    public void addExclude(Exclude excl) {
        this.filters.addElement(excl);
    }

    public String toString() {
        StringBuffer buf2 = new StringBuffer();
        int size = this.filters.size();
        if (this.defaultExclude) {
            buf2.append(DEFAULT_EXCLUDE);
            if (size > 0) {
                buf2.append(',');
            }
        }
        int i = 0;
        while (i < size) {
            buf2.append(this.filters.elementAt(i).toString());
            if (i < size - 1) {
                buf2.append(',');
            }
            ++i;
        }
        return buf2.toString();
    }

    public static class Exclude
    extends FilterElement {
        public String toString() {
            return super.toString() + ":E" + (this.enabled ? "" : "#");
        }
    }

    public static class Include
    extends FilterElement {
        public String toString() {
            return super.toString() + ":I" + (this.enabled ? "" : "#");
        }
    }

    public static abstract class FilterElement {
        protected String clazz;
        protected String method = "*";
        protected boolean enabled = true;

        public void setName(String value) {
            this.clazz = value;
        }

        public void setClass(String value) {
            this.clazz = value;
        }

        public void setMethod(String value) {
            this.method = value;
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }

        public String toString() {
            return this.clazz + "." + this.method + "()";
        }
    }
}

