/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.viz;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.hub.servicelink.HubInfo;
import ibis.smartsockets.viz.ClientNode;
import ibis.smartsockets.viz.CollectionClientNode;
import ibis.smartsockets.viz.RouterClientNode;
import ibis.smartsockets.viz.SmartNode;
import ibis.smartsockets.viz.SmartsocketsViz;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubNode
extends SmartNode {
    private static Logger logger = LoggerFactory.getLogger(HubNode.class);
    final SmartsocketsViz parent;
    private HubInfo info;
    private HashMap<DirectSocketAddress, Edge> edges = new HashMap();
    private HashMap<Object, ClientNode> clients = new HashMap();
    private CollectionClientNode clientCollection;
    private boolean collapseClients = false;

    public HubNode(SmartsocketsViz parent, HubInfo info) {
        super(info.hubAddress.toString());
        this.setPopup("CollapsedHubNode");
        if (parent.isCompact()) {
            this.setType(3);
        } else {
            this.setType(2);
        }
        this.setPattern(parent.getUniqueColor());
        if (parent.isCompact()) {
            this.setLabel("H");
        } else {
            this.setLabel("Hub");
        }
        this.setRank(0);
        this.setMouseOverText(new String[]{"Hub", info.hubAddress.toString()});
        this.parent = parent;
        this.updateInfo(info);
        this.clientCollection = new CollectionClientNode(info.clients, this);
    }

    public void deleteEdge(Edge e) {
        this.parent.deleteEdge(e);
    }

    public void showEdge(Edge e) {
        this.parent.addEdge(e);
    }

    public void removeUnusedEdges() {
        HashMap<DirectSocketAddress, Edge> oldEdges = this.edges;
        this.edges = new HashMap();
        for (int i = 0; i < this.info.connectedTo.length; ++i) {
            DirectSocketAddress to = this.info.connectedTo[i];
            Edge e = oldEdges.remove(to);
            if (e == null) continue;
            this.edges.put(to, e);
        }
        if (oldEdges.size() > 0) {
            for (Edge edge : oldEdges.values()) {
                this.parent.deleteEdge(edge);
            }
        }
    }

    public void addAndUpdateEdges() {
        for (int i = 0; i < this.info.connectedTo.length; ++i) {
            DirectSocketAddress to = this.info.connectedTo[i];
            Edge e = this.edges.get(to);
            if (e == null) {
                HubNode other = this.parent.getHubNode(to);
                if (other != null) {
                    Edge e2 = other.edges.get(this.info.hubAddress);
                    if (e2 != null) {
                        e2.useArrowHead(false);
                        if (this.info.usingSSH[i]) {
                            e2.setColor(Color.red);
                        } else {
                            e2.setColor(Color.blue);
                        }
                    } else {
                        e = new Edge((Node)this, (Node)other, 200);
                        e.useArrowHead(true);
                        if (this.info.usingSSH[i]) {
                            e.setColor(Color.red);
                        } else {
                            e.setColor(Color.blue);
                        }
                        this.parent.addEdge(e);
                    }
                } else {
                    System.out.println("Failed to find hub: " + to);
                }
            }
            if (e == null) continue;
            this.edges.put(to, e);
        }
    }

    public synchronized void updateClients() {
        HashMap<Object, ClientNode> old = this.clients;
        this.clients = new HashMap();
        if (this.info.clients > 0) {
            if (this.collapseClients) {
                this.clientCollection.setClients(this.info.clients);
                CollectionClientNode tmp = (CollectionClientNode)old.remove("collection");
                if (tmp == null) {
                    this.parent.addNode(this.clientCollection);
                    this.parent.addEdge(this.clientCollection.getEdge());
                }
                this.clients.put("collection", this.clientCollection);
            } else {
                ClientInfo[] cs = this.parent.getClientsForHub(this.info.hubAddress);
                if (cs != null) {
                    for (int c = 0; c < cs.length; ++c) {
                        DirectSocketAddress a = cs[c].getClientAddress();
                        ClientNode ci = old.remove(a);
                        if (ci == null) {
                            ci = new ClientNode(cs[c], this, this.parent.isCompact());
                            if (ci.isVisible()) {
                                this.parent.addNode(ci);
                                this.parent.addEdge(ci.getEdge());
                            }
                        } else {
                            ci.update(cs[c], this);
                            if (!ci.isVisible()) {
                                this.parent.deleteNode(ci);
                                this.parent.deleteEdge(ci.getEdge());
                            }
                        }
                        this.clients.put(a, ci);
                    }
                }
            }
        }
        if (old.size() > 0) {
            for (ClientNode ci : old.values()) {
                if (ci.getEdge() != null) {
                    this.parent.deleteEdge(ci.getEdge());
                }
                this.parent.deleteNode(ci);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.edges.size() > 0) {
            for (Edge edge : this.edges.values()) {
                this.parent.deleteEdge(edge);
            }
        }
        HubNode hubNode = this;
        synchronized (hubNode) {
            if (this.clients.size() > 0) {
                for (ClientNode n : this.clients.values()) {
                    if (n.getEdge() != null) {
                        this.parent.deleteEdge(n.getEdge());
                    }
                    this.parent.deleteNode(n);
                }
            }
        }
        this.parent.deleteNode(this);
    }

    public synchronized void updateInfo(HubInfo info) {
        this.info = info;
        if (logger.isDebugEnabled()) {
            logger.debug("Updating info for hub: \"" + info.vizInfo + "\"");
        }
        if (info.vizInfo != null && info.vizInfo.length() > 0) {
            String[] split = info.vizInfo.split("\\^");
            if (split.length >= 1) {
                if (split[0].length() > 1) {
                    this.setLabel(" " + split[0].substring(0, 1) + " ");
                } else {
                    this.setLabel(" " + split[0] + " ");
                }
            }
            if (split.length >= 2 && !this.parent.isCompact()) {
                this.setLabel(split[1]);
            }
            if (split.length >= 3) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(split[2].split(",")));
                list.add(info.hubAddress.toString());
                this.setMouseOverText(list.toArray(new String[0]));
            } else {
                this.setMouseOverText(new String[]{"Hub: " + info.name, "Loc: " + info.hubAddress.toString()});
            }
            if (split.length >= 4) {
                Color color = Color.decode(split[3]);
                this.setPattern(color);
            }
            if (split.length >= 5) {
                try {
                    int r = Integer.parseInt(split[4], 10);
                    this.setRank(r);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void expandClients() {
        this.collapseClients = false;
        this.setPopup("ExpandedHubNode");
        this.updateClients();
    }

    public synchronized void collapseClients() {
        this.collapseClients = true;
        this.setPopup("CollapsedHubNode");
        this.updateClients();
    }

    public synchronized void updateRouters(HashMap<Object, ClientNode> allClients) {
        if (this.collapseClients) {
            return;
        }
        if (this.clients.size() > 0) {
            for (ClientNode n : this.clients.values()) {
                if (!(n instanceof RouterClientNode)) continue;
                ((RouterClientNode)n).showConnections(allClients);
            }
        }
    }

    public synchronized void getClients(HashMap<Object, ClientNode> target) {
        target.putAll(this.clients);
    }
}

