/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.splice;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.direct.IPAddressSet;
import ibis.smartsockets.util.ThreadPool;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.NonFatalIOException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.modules.AbstractDirectModule;
import ibis.smartsockets.virtual.modules.splice.SplicedVirtualSocket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Splice
extends AbstractDirectModule {
    protected static final byte ACCEPT = 1;
    protected static final byte PORT_NOT_FOUND = 2;
    protected static final byte WRONG_MACHINE = 3;
    protected static final byte CONNECTION_REJECTED = 4;
    private static final int PLEASE_CONNECT = 1;
    private static final int CONNECT_ACK = 2;
    private static final byte OK = 20;
    private static final byte NOT_FOUND = 21;
    private static final byte NO_EXTERNAL_HUB = 22;
    private static final int MAX_ATTEMPTS = 3;
    private static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    private static final int PORT_RANGE = 5;
    private boolean behindNAT = false;
    private byte[] behindNATByte = new byte[]{0};
    private DirectSocketFactory factory;
    private DirectSocketAddress myMachine;
    private DirectSocketAddress externalHub;
    private IPAddressSet externalAddress;
    private LinkedList<DirectSocketAddress> hubsToTest = new LinkedList();
    private LinkedList<DirectSocketAddress> testedHubs = new LinkedList();
    private HashMap<String, Object> hubConnectProperties;
    private int nextID = 0;
    private final HashMap<Integer, byte[][]> replies = new HashMap();
    private int defaultConnectTimeout;

    public Splice() {
        super("ConnectModule(Splice)", true);
    }

    private synchronized int getID() {
        return this.nextID++;
    }

    private synchronized DirectSocketAddress getExternalHub() {
        return this.externalHub;
    }

    private synchronized void setExternalHub(DirectSocketAddress hub) {
        this.externalHub = hub;
    }

    private synchronized void addFailedHub(DirectSocketAddress hub) {
        if (!this.testedHubs.contains(hub)) {
            this.testedHubs.add(hub);
        }
    }

    private synchronized DirectSocketAddress getHubToTest() {
        block6: {
            if (this.hubsToTest != null && this.hubsToTest.size() == 0) {
                try {
                    DirectSocketAddress[] tmp = this.serviceLink.hubs();
                    if (tmp != null) {
                        for (DirectSocketAddress s : tmp) {
                            if (this.testedHubs.contains(s)) continue;
                            this.hubsToTest.add(s);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isInfoEnabled()) break block6;
                    this.logger.info("Failed to retrieve hub list!", (Throwable)e);
                }
            }
        }
        if (this.hubsToTest != null && this.hubsToTest.size() > 0) {
            return this.hubsToTest.removeFirst();
        }
        return null;
    }

    @Override
    public VirtualSocket connect(VirtualSocketAddress target, int timeout, Map<String, Object> properties) throws NonFatalIOException, IOException {
        if (target.machine().sameMachine(this.parent.getLocalHost())) {
            throw new NonFatalIOException("Cannot setup a connection to myself!");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": attempting connection setup to " + target);
        }
        DirectSocketAddress targetMachine = target.machine();
        DirectSocketAddress[] result = new DirectSocketAddress[1];
        int[] localPort = new int[1];
        timeout = this.getInfo(timeout, result, localPort);
        int id = this.getID();
        Object message = new byte[][]{this.fromInt(id), this.fromInt(target.port()), this.fromSocketAddressSet(result[0]), this.fromInt(timeout), this.behindNATByte};
        this.registerReply(id);
        this.serviceLink.send(targetMachine, target.hub(), this.module, 1, (byte[][])message);
        message = this.getReply(id, timeout);
        if (message == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.module + ": Target machine failed to reply to splice request in time!");
            }
            throw new NonFatalIOException("Target machine did not reply to splice request within " + timeout + " ms.");
        }
        if (message[1] == null || message[1].length != 1) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.module + ": Target machine failed to produce expected reply to splice request!");
            }
            throw new NonFatalIOException("Target machine did not produce expected reply to splice request!");
        }
        if (message[1][0] != 20) {
            if (message[1][0] == 21) {
                throw new SocketException("Target port not found!");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.module + ": Target machine failed to participate in splicing");
            }
            throw new NonFatalIOException("Target machine " + target + " failed to participate in splicing");
        }
        try {
            DirectSocketAddress tmp = this.toSocketAddressSet(message[2]);
            boolean otherBehindNAT = message[3][0] == 1;
            DirectSocketAddress[] a = this.getTargetRange(otherBehindNAT, tmp);
            DirectSocket s = this.connect(a, localPort[0], 3000, target.port());
            if (s == null) {
                throw new NonFatalIOException("Failed to connect to " + target);
            }
            return this.createVirtualSocket(target, s);
        }
        catch (IOException e) {
            throw new NonFatalIOException("Failed to connect to " + target, e);
        }
    }

    private DirectSocketAddress[] getTargetRange(boolean behindNAT, DirectSocketAddress realTarget) throws UnknownHostException {
        DirectSocketAddress[] a;
        if (!behindNAT) {
            a = new DirectSocketAddress[]{realTarget};
        } else {
            a = new DirectSocketAddress[5];
            a[0] = realTarget;
            int port = realTarget.getPorts(false)[0];
            IPAddressSet ads = realTarget.getAddressSet();
            for (int i = 1; i < 5; ++i) {
                a[i] = DirectSocketAddress.getByAddress(ads, port + 1);
            }
        }
        return a;
    }

    private int getLocalPort(int timeout) throws SocketTimeoutException {
        long deadline = System.currentTimeMillis() + (long)timeout;
        int port = 0;
        while (port == 0) {
            try {
                port = this.factory.getAvailablePort();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= deadline) continue;
                throw new SocketTimeoutException("Failed to get port number within timeout.");
            }
        }
        return port;
    }

    private synchronized void registerReply(Integer id) {
        this.replies.put(id, null);
    }

    private synchronized byte[][] getReply(Integer id, int timeout) {
        byte[][] message = this.replies.get(id);
        long deadline = System.currentTimeMillis() + (long)timeout;
        long timeleft = timeout;
        while (message == null && timeleft > 0L) {
            try {
                this.wait(timeleft);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((message = this.replies.get(id)) != null) continue;
            timeleft = deadline - System.currentTimeMillis();
        }
        this.replies.remove(id);
        return message;
    }

    private synchronized void storeReply(Integer id, byte[][] message) {
        if (this.replies.containsKey(id)) {
            this.replies.put(id, message);
            this.notifyAll();
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": ACK dropped, no one is listning!");
        }
    }

    private int getInfo(int timeout, DirectSocketAddress[] result, int[] localPort) throws NonFatalIOException {
        int local = -1;
        if (!this.behindNAT && this.externalAddress != null) {
            try {
                localPort[0] = this.getLocalPort(timeout);
                result[0] = DirectSocketAddress.getByAddress(this.externalAddress, localPort[0]);
            }
            catch (IOException e) {
                throw new NonFatalIOException("Failed to create local port", e);
            }
            return timeout;
        }
        long deadline = 0L;
        long timeleft = timeout;
        if (timeleft > 0L) {
            deadline = System.currentTimeMillis() + (long)timeout;
        }
        do {
            DirectSocketAddress hub;
            boolean testing;
            block15: {
                testing = false;
                hub = this.getExternalHub();
                if (hub == null) {
                    testing = true;
                    hub = this.getHubToTest();
                    if (deadline > 0L) {
                        timeleft = deadline - System.currentTimeMillis();
                    }
                    if (hub == null) {
                        throw new NonFatalIOException("Failed to find external hub");
                    }
                }
                try {
                    local = this.getInfo(hub, (int)timeleft, local, result);
                }
                catch (IOException e) {
                    if (!this.logger.isInfoEnabled()) break block15;
                    this.logger.info("Failed to contact hub: " + hub.toString() + " for splice info (will try other hubs)", (Throwable)e);
                }
            }
            if (result[0] != null) {
                localPort[0] = local;
                this.externalAddress = result[0].getAddressSet();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Splicing found external address: " + this.externalAddress + " port " + localPort[0]);
                }
                if (testing) {
                    this.setExternalHub(hub);
                }
                if (deadline > 0L) {
                    return (int)(deadline - System.currentTimeMillis());
                }
                return 0;
            }
            if (testing) {
                this.addFailedHub(hub);
                continue;
            }
            this.setExternalHub(null);
        } while (deadline <= 0L || (timeleft = deadline - System.currentTimeMillis()) > 0L);
        throw new NonFatalIOException("Timeout while looking for external hub");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInfo(DirectSocketAddress externalHub, int timeout, int local, DirectSocketAddress[] result) throws IOException {
        int n;
        DirectSocketAddress tmp;
        int port;
        String addr;
        DataInputStream in;
        OutputStream out;
        DirectSocket s;
        block5: {
            s = null;
            out = null;
            in = null;
            if (this.hubConnectProperties == null) {
                this.hubConnectProperties = new HashMap();
                this.hubConnectProperties.put("direct.forcePublic", null);
            }
            s = this.factory.createSocket(externalHub, timeout, local, -1, -1, this.hubConnectProperties, false, 0);
            s.setReuseAddress(true);
            s.setSoTimeout(timeout);
            local = s.getLocalPort();
            out = s.getOutputStream();
            out.write(8);
            out.flush();
            in = new DataInputStream(s.getInputStream());
            addr = in.readUTF();
            port = in.readInt();
            tmp = DirectSocketAddress.getByAddress(addr, port);
            if (tmp.hasPublicAddress()) break block5;
            int n2 = local;
            DirectSocketFactory.close(s, out, (InputStream)in);
            return n2;
        }
        try {
            result[0] = tmp;
            for (int i = 1; i < result.length; ++i) {
                result[i] = DirectSocketAddress.getByAddress(addr, port + i);
            }
            n = local;
        }
        catch (Throwable throwable) {
            DirectSocketFactory.close(s, out, in);
            throw throwable;
        }
        DirectSocketFactory.close(s, out, (InputStream)in);
        return n;
    }

    private DirectSocket connect(DirectSocketAddress[] target, int localPort, int timeout, int userdata) throws IOException {
        if (target.length == 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.module + ": Single splice attempt!");
            }
            return this.factory.createSocket(target[0], timeout, localPort, -1, -1, null, true, userdata);
        }
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            for (int t = 0; t < target.length; ++t) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.module + ": Splice attempt (" + i + "/" + t + ")");
                }
                try {
                    return this.factory.createSocket(target[t], timeout, localPort, -1, -1, null, false, userdata);
                }
                catch (IOException e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.module + ": Connection failed " + Arrays.deepToString(target), (Throwable)e);
                    }
                    cause = e;
                    continue;
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.module + ": Splice failed.");
        }
        if (cause != null) {
            throw cause;
        }
        return null;
    }

    @Override
    public DirectSocketAddress getAddresses() {
        return null;
    }

    @Override
    public void initModule(TypedProperties properties) throws Exception {
        this.factory = DirectSocketFactory.getSocketFactory();
        this.defaultConnectTimeout = properties.getIntProperty("smartsockets.modules.splice.connecttimeout", 3000);
    }

    @Override
    public boolean matchAdditionalRuntimeRequirements(Map<String, ?> requirements) {
        return true;
    }

    @Override
    public void startModule() throws Exception {
        if (this.serviceLink == null) {
            throw new Exception(this.module + ": no service link available!");
        }
        this.myMachine = this.parent.getLocalHost();
        this.behindNAT = !this.myMachine.hasPublicAddress();
        this.behindNATByte[0] = (byte)(this.behindNAT ? 1 : 0);
        if (!this.behindNAT && this.myMachine.numberOfAddresses() == 1) {
            this.externalAddress = this.myMachine.getAddressSet();
        }
    }

    private void handleConnect(DirectSocketAddress src, DirectSocketAddress srcHub, byte[][] message) {
        if (message == null || message.length != 5) {
            this.logger.warn(this.module + ": malformed connect message " + src + "@" + srcHub + "\"" + Arrays.deepToString((Object[])message) + "\"");
            return;
        }
        SpliceRequest r = new SpliceRequest();
        r.id = message[0];
        r.src = src;
        r.srcHub = srcHub;
        try {
            r.port = this.toInt(message[1]);
            r.target = this.toSocketAddressSet(message[2]);
            r.timeout = this.toInt(message[3]);
            r.otherBehindNAT = message[4][0] == 1;
        }
        catch (Exception e) {
            this.logger.warn(this.module + ": failed to parse connect message " + src + "@" + srcHub + "\"" + Arrays.deepToString((Object[])message) + "\"", (Throwable)e);
            return;
        }
        ThreadPool.createNew(r, "Splice Request Handler");
    }

    private void handleReply(DirectSocketAddress src, DirectSocketAddress srcHub, byte[][] message) {
        if (message == null || message.length != 2 && message.length != 4) {
            this.logger.warn(this.module + ": malformed connect ack " + src + "@" + srcHub + "\"" + Arrays.deepToString((Object[])message) + "\"");
            return;
        }
        this.storeReply(this.toInt(message[0]), message);
    }

    @Override
    public void gotMessage(DirectSocketAddress src, DirectSocketAddress srcHub, int opcode, boolean returnToSender, byte[][] message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": got message " + src + "@" + srcHub + " " + opcode + " \"" + Arrays.deepToString((Object[])message) + "\"");
        }
        if (returnToSender) {
            System.out.println("***SPLICE ignoring returnToSender");
            return;
        }
        switch (opcode) {
            case 1: {
                this.handleConnect(src, srcHub, message);
                break;
            }
            case 2: {
                this.handleReply(src, srcHub, message);
                break;
            }
            default: {
                this.logger.warn(this.module + ": ignoring message " + src + "@" + srcHub + " " + opcode + "\"" + Arrays.deepToString((Object[])message) + "\"");
            }
        }
    }

    private VirtualSocket createVirtualSocket(VirtualSocketAddress a, DirectSocket s) throws IOException {
        DataInputStream in = null;
        DataOutputStream out = null;
        try {
            in = new DataInputStream(s.getInputStream());
            out = new DataOutputStream(s.getOutputStream());
            return new SplicedVirtualSocket(a, s, out, in, null);
        }
        catch (IOException e) {
            DirectSocketFactory.close(s, out, (InputStream)in);
            throw e;
        }
    }

    @Override
    protected VirtualSocket createVirtualSocket(VirtualSocketAddress a, DirectSocket s, OutputStream out, InputStream in) {
        return new SplicedVirtualSocket(a, s, out, in, null);
    }

    @Override
    public int getDefaultTimeout() {
        return this.defaultConnectTimeout;
    }

    private class SpliceRequest
    implements Runnable {
        byte[] id;
        DirectSocketAddress src;
        DirectSocketAddress srcHub;
        DirectSocketAddress target;
        int port = 0;
        int timeout = 0;
        boolean otherBehindNAT = false;

        private SpliceRequest() {
        }

        @Override
        public void run() {
            block9: {
                VirtualServerSocket ss = Splice.this.parent.getServerSocket(this.port);
                if (ss == null) {
                    if (Splice.this.logger.isInfoEnabled()) {
                        Splice.this.logger.info(Splice.this.module + ": port " + this.port + " not found!");
                    }
                    Splice.this.serviceLink.send(this.src, this.srcHub, Splice.this.module, 2, new byte[][]{this.id, {21}});
                    return;
                }
                DirectSocketAddress[] result = new DirectSocketAddress[1];
                int[] localPort = new int[1];
                try {
                    this.timeout = Splice.this.getInfo(this.timeout, result, localPort);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (result[0] == null) {
                    Splice.this.serviceLink.send(this.src, this.srcHub, Splice.this.module, 2, new byte[][]{this.id, {22}});
                    return;
                }
                Splice.this.serviceLink.send(this.src, this.srcHub, Splice.this.module, 2, new byte[][]{this.id, {20}, Splice.this.fromSocketAddressSet(result[0]), Splice.this.behindNATByte});
                try {
                    DirectSocketAddress[] a = Splice.this.getTargetRange(this.otherBehindNAT, this.target);
                    DirectSocket s = Splice.this.connect(a, localPort[0], this.timeout, 0);
                    if (s == null) {
                        if (Splice.this.logger.isInfoEnabled()) {
                            Splice.this.logger.info(Splice.this.module + ": Incoming connection setup failed!");
                        }
                        return;
                    }
                    Splice.this.handleAccept(s);
                }
                catch (Exception e) {
                    if (!Splice.this.logger.isInfoEnabled()) break block9;
                    Splice.this.logger.info(Splice.this.module + ": Incoming connection setup failed!", (Throwable)e);
                }
            }
        }
    }
}

