/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.reverse;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.NonFatalIOException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.modules.MessagingModule;
import ibis.smartsockets.virtual.modules.direct.Direct;
import ibis.smartsockets.virtual.modules.direct.DirectVirtualSocket;
import ibis.smartsockets.virtual.modules.reverse.ReverseVirtualSocket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Reverse
extends MessagingModule {
    private static final int DEFAULT_CONNECT_TIMEOUT = 3500;
    private static final boolean USE_THREAD = true;
    private static final int PLEASE_CONNECT = 1;
    private static final int CANNOT_CONNECT = 3;
    private Direct direct;
    private int requestID = 0;
    private boolean denyConnectionsToSelf = true;
    private HashMap<Integer, String> replies = new HashMap();
    private int acceptTimeout;
    private int defaultConnectTimeout;

    public Reverse() {
        super("ConnectModule(Reverse)", true);
        this.properties.put("direct.forcePublic", "");
    }

    @Override
    public void initModule(TypedProperties properties) throws Exception {
        this.denyConnectionsToSelf = !properties.booleanProperty("smartsockets.modules.reverse.selfconnect", false);
        this.acceptTimeout = properties.getIntProperty("smartsockets.modules.reverse.accepttimeout", 100);
        this.defaultConnectTimeout = properties.getIntProperty("smartsockets.modules.reverse.connecttimeout", 3500);
    }

    @Override
    public void startModule() throws Exception {
        if (this.serviceLink == null) {
            throw new Exception(this.module + ": no service link available!");
        }
        this.direct = (Direct)this.parent.findModule("ConnectModule(Direct)");
        if (this.direct == null) {
            throw new Exception(this.module + ": no direct module available!");
        }
    }

    @Override
    public DirectSocketAddress getAddresses() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeReply(int requestID, String reply) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Storing reply: [" + requestID + "] " + reply);
        }
        HashMap<Integer, String> hashMap = this.replies;
        synchronized (hashMap) {
            if (this.replies.containsKey(requestID)) {
                this.replies.put(requestID, reply);
                this.replies.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeRequest(int requestID) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Storing request: [" + requestID + "]");
        }
        HashMap<Integer, String> hashMap = this.replies;
        synchronized (hashMap) {
            this.replies.put(requestID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String removeRequest(int requestID) {
        String result = null;
        HashMap<Integer, String> hashMap = this.replies;
        synchronized (hashMap) {
            result = this.replies.remove(requestID);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removing request: [" + requestID + "] " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveReply(int requestID) {
        String result = null;
        HashMap<Integer, String> hashMap = this.replies;
        synchronized (hashMap) {
            result = this.replies.get(requestID);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Check request: [" + requestID + "] " + result);
        }
        return result != null;
    }

    private synchronized int nextRequestID() {
        return this.requestID++;
    }

    @Override
    public VirtualSocket connect(VirtualSocketAddress target, int timeout, Map<String, Object> properties) throws NonFatalIOException {
        if (this.denyConnectionsToSelf && target.machine().sameMachine(this.parent.getLocalHost())) {
            throw new NonFatalIOException("Cannot set up a connection to myself!");
        }
        if (timeout <= 0) {
            timeout = this.defaultConnectTimeout;
        }
        VirtualServerSocket ss = null;
        try {
            ss = this.parent.createServerSocket(0, 1, null);
        }
        catch (Exception e) {
            throw new NonFatalIOException("Failed to set up reverse connection", e);
        }
        int id = this.nextRequestID();
        String reply = "Attempt timed out";
        DirectVirtualSocket s = null;
        try {
            this.storeRequest(id);
            byte[][] message = new byte[7][];
            VirtualSocketAddress vs = ss.getLocalSocketAddress();
            message[0] = this.fromInt(target.port());
            message[1] = this.fromSocketAddressSet(vs.machine());
            message[2] = this.fromInt(vs.port());
            message[3] = this.fromSocketAddressSet(vs.hub());
            message[4] = this.fromString(vs.cluster());
            message[5] = this.fromInt(timeout);
            message[6] = this.fromInt(id);
            this.serviceLink.send(target.machine(), target.hub(), this.module, 1, message);
            int waittime = this.acceptTimeout;
            boolean stop = false;
            long deadline = System.currentTimeMillis() + (long)timeout;
            while (!stop) {
                long left = deadline - System.currentTimeMillis();
                if (left <= 0L) {
                    stop = true;
                } else {
                    if (left < (long)waittime) {
                        waittime = (int)left;
                    }
                    try {
                        ss.setSoTimeout(waittime);
                        s = (DirectVirtualSocket)ss.accept();
                        stop = true;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                    }
                }
                if (stop || !this.haveReply(id)) continue;
                stop = true;
                reply = this.removeRequest(id);
            }
        }
        catch (Exception e) {
            throw new NonFatalIOException("Failed to set up reverse connection", e);
        }
        finally {
            this.removeRequest(id);
            try {
                ss.close();
            }
            catch (Exception exception) {}
        }
        if (s == null) {
            throw new NonFatalIOException("Target failed to set up reverse connection (" + reply + ")");
        }
        return s;
    }

    private void sendReply(VirtualSocketAddress to, int requestID, String reply) {
        if (reply == null) {
            reply = "";
        }
        byte[][] message = new byte[][]{this.fromInt(requestID), this.fromString(reply)};
        this.serviceLink.send(to.machine(), to.hub(), this.module, 3, message);
    }

    void setupConnection(VirtualServerSocket ss, VirtualSocketAddress target, int timeout, int requestID) {
        block9: {
            try {
                ReverseVirtualSocket rvs;
                int accept;
                DirectVirtualSocket s = (DirectVirtualSocket)this.direct.connect(target, timeout, this.properties);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.module + ": Connection to " + target + " created!");
                }
                if ((accept = ss.incomingConnection(rvs = new ReverseVirtualSocket(s))) != 0) {
                    if (accept == -1) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info(this.module + ": Serversocket is NOT willing to accept (REJECTED)");
                        }
                        s.connectionRejected(4);
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info(this.module + ": Serversocket is NOT willing to accept (OVERLOAD)");
                        }
                        s.connectionRejected(5);
                    }
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.module + ": Socket queued at serversocket");
                }
            }
            catch (Exception e) {
                this.sendReply(target, requestID, e.getMessage());
                if (!this.logger.isInfoEnabled()) break block9;
                this.logger.info(this.module + ": Connection to " + target + " failed!", (Throwable)e);
            }
        }
    }

    private void handleCannotConnectMessage(byte[][] message) {
        int requestID;
        String reply = null;
        try {
            requestID = this.toInt(message[0]);
            reply = this.toString(message[1]);
        }
        catch (Exception e) {
            this.logger.warn(this.module + ": failed to parse reply message!", (Throwable)e);
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": connection reply (" + requestID + "): " + reply);
        }
        this.storeReply(requestID, reply);
    }

    private void handleConnectMessageFailed(byte[][] message) {
        int requestID;
        try {
            requestID = this.toInt(message[6]);
        }
        catch (Exception e) {
            this.logger.warn(this.module + ": failed to parse connect message!", (Throwable)e);
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": connection request failed (" + requestID + ")");
        }
        this.storeReply(requestID, "Target not reachable");
    }

    private void handleConnectMessage(byte[][] message) {
        VirtualServerSocket ss;
        int requestID;
        int timeout = 0;
        int localport = 0;
        VirtualSocketAddress target = null;
        try {
            localport = this.toInt(message[0]);
            DirectSocketAddress machine = this.toSocketAddressSet(message[1]);
            int port = this.toInt(message[2]);
            DirectSocketAddress hub = this.toSocketAddressSet(message[3]);
            String cluster = this.toString(message[4]);
            timeout = this.toInt(message[5]);
            requestID = this.toInt(message[6]);
            target = new VirtualSocketAddress(machine, port, hub, cluster);
        }
        catch (Exception e) {
            this.logger.warn(this.module + ": failed to parse connect message!", (Throwable)e);
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": connection request (" + requestID + "):  local port: " + localport + ", target " + target + ", timeout " + timeout);
        }
        if ((ss = this.parent.getServerSocket(localport)) == null) {
            this.sendReply(target, requestID, "Port " + localport + " not found");
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.module + ": port " + localport + " not found!");
            }
            return;
        }
        if (timeout <= 0) {
            timeout = this.defaultConnectTimeout;
        }
        new Connector(ss, target, timeout, requestID).start();
    }

    @Override
    public void gotMessage(DirectSocketAddress src, DirectSocketAddress srcProxy, int opcode, boolean returnToSender, byte[][] message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": handling connection request from " + src + "@" + srcProxy + " message = \"" + Arrays.toString((Object[])message) + "\"");
        }
        switch (opcode) {
            case 1: {
                if (returnToSender) {
                    this.handleConnectMessageFailed(message);
                    break;
                }
                this.handleConnectMessage(message);
                break;
            }
            case 3: {
                if (returnToSender) break;
                this.handleCannotConnectMessage(message);
                break;
            }
            default: {
                this.logger.warn(this.module + " got unexpected message from " + src + "@" + srcProxy + " message = \"" + Arrays.deepToString((Object[])message) + "\"");
            }
        }
    }

    @Override
    public boolean matchAdditionalRuntimeRequirements(Map<String, ?> requirements) {
        return true;
    }

    @Override
    public int getDefaultTimeout() {
        return this.defaultConnectTimeout;
    }

    private class Connector
    extends Thread {
        private final VirtualServerSocket ss;
        private final VirtualSocketAddress target;
        private final int timeout;
        private final int requestID;

        Connector(VirtualServerSocket ss, VirtualSocketAddress target, int timeout, int requestID) {
            this.ss = ss;
            this.target = target;
            this.timeout = timeout;
            this.requestID = requestID;
        }

        @Override
        public void run() {
            Reverse.this.setupConnection(this.ss, this.target, this.timeout, this.requestID);
        }
    }
}

