/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.hubrouted;

import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.virtual.TargetOverloadedException;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.modules.hubrouted.HubRoutedInputStream;
import ibis.smartsockets.virtual.modules.hubrouted.HubRoutedOutputStream;
import ibis.smartsockets.virtual.modules.hubrouted.Hubrouted;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class HubRoutedVirtualSocket
extends VirtualSocket {
    private final Hubrouted parent;
    private final ServiceLink serviceLink;
    private long connectionIndex;
    private int timeout = 0;
    private boolean closed = false;
    private HubRoutedOutputStream out;
    private HubRoutedInputStream in;
    private final int localFragmentation;
    private final int localBufferSize;
    private final int localMinimalACKSize;
    private int remoteFragmentation;
    private int remoteBufferSize;
    private boolean waitingForACK = false;
    private boolean gotACK = false;
    private int ackResult = 0;
    private boolean waitingForACKACK = false;
    private boolean gotACKACK = false;
    private boolean ackACKResult = false;
    private boolean gotTargetOverload = false;

    protected HubRoutedVirtualSocket(Hubrouted parent, int localFragmentation, int localBufferSize, int localMinimalACKSize, int remoteFragmentation, int remoteBufferSize, VirtualSocketAddress target, ServiceLink serviceLink, long connectionIndex, Map<String, ?> p) {
        super(target);
        this.parent = parent;
        this.serviceLink = serviceLink;
        this.connectionIndex = connectionIndex;
        this.localFragmentation = localFragmentation;
        this.localBufferSize = localBufferSize;
        this.localMinimalACKSize = localMinimalACKSize;
        this.remoteFragmentation = remoteFragmentation;
        this.remoteBufferSize = remoteBufferSize;
        this.out = new HubRoutedOutputStream(this, remoteFragmentation, remoteBufferSize);
        this.in = new HubRoutedInputStream(this, localFragmentation, localBufferSize, localMinimalACKSize);
    }

    protected HubRoutedVirtualSocket(Hubrouted parent, int localFragmentation, int localBufferSize, int localMinimalACKSize, VirtualSocketAddress target, ServiceLink serviceLink, Map<String, ?> p) {
        super(target);
        this.parent = parent;
        this.serviceLink = serviceLink;
        this.localFragmentation = localFragmentation;
        this.localBufferSize = localBufferSize;
        this.localMinimalACKSize = localMinimalACKSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectionAccepted(int timeout) throws IOException {
        if (timeout <= 0) {
            timeout = 120000;
        }
        long deadline = System.currentTimeMillis() + (long)timeout;
        long timeleft = timeout;
        HubRoutedVirtualSocket hubRoutedVirtualSocket = this;
        synchronized (hubRoutedVirtualSocket) {
            this.waitingForACKACK = true;
        }
        this.serviceLink.ackVirtualConnection(this.connectionIndex, this.localFragmentation, this.localBufferSize);
        hubRoutedVirtualSocket = this;
        synchronized (hubRoutedVirtualSocket) {
            while (!this.gotACKACK) {
                try {
                    this.wait(timeleft);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.gotACKACK || (timeleft = deadline - System.currentTimeMillis()) > 0L) continue;
                throw new SocketTimeoutException("Handshake timed out (" + timeout + ", " + timeleft + ") !");
            }
            this.waitingForACKACK = false;
        }
        if (!this.gotACKACK || !this.ackACKResult) {
            throw new SocketException("Handshake failed");
        }
    }

    @Override
    public void connectionRejected(int timeout) {
        this.serviceLink.nackVirtualConnection(this.connectionIndex, (byte)3);
    }

    @Override
    public void waitForAccept(int timeout) throws IOException {
        if (this.gotTargetOverload) {
            throw new TargetOverloadedException("Connection refused, target socket overloaded!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean local) {
        HubRoutedVirtualSocket hubRoutedVirtualSocket = this;
        synchronized (hubRoutedVirtualSocket) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (local) {
            this.parent.close(this.connectionIndex);
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return 0;
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return false;
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return 0;
    }

    @Override
    public int getSoLinger() throws SocketException {
        return 0;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return true;
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return 0;
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isConnected() {
        return !this.closed;
    }

    @Override
    public boolean isInputShutdown() {
        return this.in.closed();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.out.closed();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
    }

    @Override
    public void setReceiveBufferSize(int sz) throws SocketException {
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
    }

    @Override
    public void setSendBufferSize(int sz) throws SocketException {
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
    }

    @Override
    public void setSoTimeout(int t) throws SocketException {
        this.timeout = t;
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
    }

    @Override
    public void shutdownInput() throws IOException {
        this.in.close();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.out.close();
    }

    @Override
    public String toString() {
        return "HubRoutedVirtualSocket(" + this.connectionIndex + ")";
    }

    protected final void message(int len, DataInputStream dis) throws IOException {
        this.in.add(len, dis);
    }

    protected void sendACK(int data) throws IOException {
        this.serviceLink.ackVirtualMessage(this.connectionIndex, data);
    }

    public void flush(byte[] buffer, int off, int len) throws IOException {
        this.serviceLink.sendVirtualMessage(this.connectionIndex, buffer, off, len, this.timeout);
    }

    protected void setTargetOverload() {
        this.gotTargetOverload = true;
    }

    protected synchronized void reset(long index) {
        this.connectionIndex = index;
        this.gotACK = false;
        this.waitingForACK = true;
        this.gotTargetOverload = false;
    }

    protected synchronized int waitForACK(int timeout) {
        long deadline = System.currentTimeMillis() + (long)timeout;
        long timeleft = timeout;
        while (!this.gotACK) {
            try {
                this.wait(timeleft);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.gotACK || (timeleft = deadline - System.currentTimeMillis()) > 0L) continue;
            this.gotACK = true;
            this.ackResult = -1;
        }
        this.waitingForACK = false;
        return this.ackResult;
    }

    protected synchronized void connectACK(int fragment, int buffer) {
        if (!this.waitingForACK) {
            this.parent.sendAckAck(this.connectionIndex, false);
            return;
        }
        this.gotACK = true;
        this.ackResult = 0;
        this.remoteFragmentation = fragment;
        this.remoteBufferSize = buffer;
        this.out = new HubRoutedOutputStream(this, this.remoteFragmentation, this.remoteBufferSize);
        this.in = new HubRoutedInputStream(this, this.localFragmentation, this.localBufferSize, this.localMinimalACKSize);
        this.notifyAll();
        this.parent.sendAckAck(this.connectionIndex, true);
    }

    protected synchronized void connectNACK(byte reason) {
        if (!this.waitingForACK) {
            return;
        }
        this.gotACK = true;
        this.ackResult = reason;
        this.notifyAll();
    }

    public synchronized boolean connectACKACK(boolean succes) {
        if (!this.waitingForACKACK) {
            return false;
        }
        this.gotACKACK = true;
        this.ackACKResult = succes;
        this.notifyAll();
        return true;
    }

    protected void messageACK(int data) {
        this.out.messageACK(data);
    }
}

