/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.direct;

import ibis.smartsockets.direct.DirectServerSocket;
import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.NonFatalIOException;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.modules.AbstractDirectModule;
import ibis.smartsockets.virtual.modules.direct.DirectVirtualSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class Direct
extends AbstractDirectModule {
    private static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    private final DirectSocketFactory direct;
    private AcceptThread acceptThread;
    private DirectServerSocket server;
    private int defaultSendBuffer;
    private int defaultReceiveBuffer;
    private boolean count = false;
    private int defaultConnectTimeout;

    public Direct(DirectSocketFactory direct) {
        super("ConnectModule(Direct)", false);
        this.direct = direct;
    }

    @Override
    public void initModule(TypedProperties p) throws Exception {
        int port = 0;
        this.count = p.booleanProperty("smartsockets.modules.direct.count", false);
        int backlog = p.getIntProperty("smartsockets.modules.direct.backlog", 100);
        this.defaultReceiveBuffer = p.getIntProperty("smartsockets.modules.direct.receivebuffer", -1);
        this.defaultSendBuffer = p.getIntProperty("smartsockets.modules.direct.sendbuffer", -1);
        this.defaultConnectTimeout = p.getIntProperty("smartsockets.modules.direct.timeout", 3000);
        HashMap<String, String> prop = new HashMap<String, String>(3);
        prop.put("PortForwarding", "yes");
        prop.put("ForwardingMayFail", "yes");
        prop.put("SameExternalPort", "no");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.module + ": Creating ServerSocket on port " + port);
            }
            this.server = this.direct.createServerSocket(port, backlog, this.defaultReceiveBuffer, prop);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.module + ": ServerSocket created: " + this.server.getAddressSet());
            }
        }
        catch (IOException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.module + ": Failed to initialize direct module " + port, (Throwable)e);
            }
            throw e;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.module + ": Starting AcceptThread");
        }
        this.acceptThread = new AcceptThread();
        this.acceptThread.start();
    }

    @Override
    public void startModule() throws Exception {
    }

    @Override
    public DirectSocketAddress getAddresses() {
        return this.server.getAddressSet();
    }

    void handleAccept() {
        try {
            this.handleAccept(this.server.accept());
        }
        catch (IOException e) {
            this.logger.warn(this.module + ": Got exception while waiting for connection!, waiting one second, then retrying", (Throwable)e);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public VirtualSocket connect(VirtualSocketAddress target, int timeout, Map<String, Object> properties) throws NonFatalIOException {
        int sendBuffer = this.defaultSendBuffer;
        int receiveBuffer = this.defaultReceiveBuffer;
        if (properties != null) {
            Integer tmp = (Integer)properties.get("sendbuffer");
            if (tmp != null) {
                sendBuffer = tmp;
            }
            if ((tmp = (Integer)properties.get("receivebuffer")) != null) {
                receiveBuffer = tmp;
            }
        }
        try {
            DirectSocket s = this.direct.createSocket(target.machine(), timeout, 0, sendBuffer, receiveBuffer, properties, false, target.port());
            return this.createVirtualSocket(target, s);
        }
        catch (IOException e) {
            throw new NonFatalIOException(e);
        }
    }

    @Override
    public boolean matchAdditionalRuntimeRequirements(Map<String, ?> requirements) {
        return true;
    }

    @Override
    protected VirtualSocket createVirtualSocket(VirtualSocketAddress a, DirectSocket s, OutputStream out, InputStream in) {
        return new DirectVirtualSocket(a, s, out, in, this.count, null);
    }

    private VirtualSocket createVirtualSocket(VirtualSocketAddress a, DirectSocket s) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (s != null) {
                in = s.getInputStream();
                out = s.getOutputStream();
            }
            return new DirectVirtualSocket(a, s, out, in, this.count, null);
        }
        catch (IOException e) {
            DirectSocketFactory.close(s, out, in);
            throw e;
        }
    }

    @Override
    public int getDefaultTimeout() {
        return this.defaultConnectTimeout;
    }

    private class AcceptThread
    extends Thread {
        AcceptThread() {
            super("DirectModule AcceptThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                Direct.this.handleAccept();
            }
        }
    }
}

