/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.servicelink.CallBack;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.NonFatalIOException;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectModule
implements CallBack {
    protected static final Logger statslogger = LoggerFactory.getLogger((String)"ibis.smartsockets.statistics");
    public final String module;
    public final boolean requiresServiceLink;
    protected VirtualSocketFactory parent;
    protected Logger logger;
    protected ServiceLink serviceLink;
    protected Map<String, Object> properties;
    protected String name;
    protected long connectSuccesTime;
    protected long connectSuccesCount;
    protected long connectFailedTime;
    protected long connectFailedCount;
    protected long connectRejectedTime;
    protected long connectRejectedCount;
    protected long connectNotAllowedCount;
    protected long acceptSuccesTime;
    protected long acceptSuccesCount;
    protected long acceptFailedTime;
    protected long acceptFailedCount;
    protected long acceptRejectedTime;
    protected long acceptRejectedCount;
    protected int timeout;

    protected ConnectModule(String name, boolean requiresServiceLink) {
        this(name, requiresServiceLink, null);
    }

    protected ConnectModule(String name, boolean requiresServiceLink, Map<String, Object> p) {
        this.module = name;
        this.requiresServiceLink = requiresServiceLink;
        this.properties = p == null ? new HashMap<String, Object>() : p;
        if (!this.properties.containsKey("connect.module.name")) {
            this.properties.put("connect.module.name", name);
        }
        if (!this.properties.containsKey("connect.module.type")) {
            if (!requiresServiceLink) {
                this.properties.put("connect.module.type", new String[]{"direct"});
            } else {
                this.properties.put("connect.module.type", new String[]{"indirect"});
            }
        }
    }

    public void init(VirtualSocketFactory p, String name, TypedProperties properties, Logger l) throws Exception {
        this.name = name;
        this.parent = p;
        this.logger = l;
        if (l.isInfoEnabled()) {
            l.info("Initializing module: " + name + " -> " + this.module);
        }
        this.initModule(properties);
        this.timeout = this.getDefaultTimeout();
    }

    public String getName() {
        return this.name;
    }

    public void startModule(ServiceLink sl) throws Exception {
        if (this.requiresServiceLink) {
            if (sl == null) {
                throw new Exception("Failed to initialize module: " + this.module + " (service link required)");
            }
            this.serviceLink = sl;
            this.serviceLink.register(this.module, this);
        }
        this.startModule();
    }

    @Override
    public void gotMessage(DirectSocketAddress src, DirectSocketAddress proxy, int opcode, boolean returnToSender, byte[][] message) {
        this.logger.warn("Module: " + this.module + " got unexpected message from " + src + "@" + proxy + ", " + returnToSender + ", " + opcode + ", " + Arrays.deepToString((Object[])message));
    }

    private boolean contains(String csv, String target) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Checking if \"" + target + "\" is part of \"" + csv + "\"");
        }
        int start = 0;
        int end = target.length();
        while (end <= csv.length()) {
            boolean endOK;
            start = csv.indexOf(target, start);
            end = start + target.length();
            if (start == -1) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("\"" + target + "\" is NOT part of \"" + csv + "\"");
                }
                return false;
            }
            boolean startOK = start == 0 || csv.charAt(start - 1) == ',' || csv.charAt(start - 1) == ' ';
            boolean bl = endOK = end == csv.length() || csv.charAt(end + 1) == ',' || csv.charAt(end + 1) == ' ';
            if (startOK && endOK) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("\"" + target + "\" IS part of \"" + csv + "\"");
                }
                return true;
            }
            ++start;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\"" + target + "\" IS NOT part of \"" + csv + "\"");
        }
        return false;
    }

    private boolean contains(String csv, String[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            if (!this.contains(csv, targets[i])) continue;
            return true;
        }
        return false;
    }

    public boolean matchRuntimeRequirements(Map<String, Object> requirements) {
        if (requirements == null) {
            return true;
        }
        String tmp = (String)requirements.get("connect.module.skip");
        if (tmp != null && this.contains(tmp, this.module)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Skipping module: " + this.module);
            }
            return false;
        }
        String[] myTypes = (String[])this.properties.get("connect.module.type");
        tmp = (String)requirements.get("connect.module.type.skip");
        if (tmp != null && this.contains(tmp, myTypes)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Skipping module type: " + tmp + "(" + this.module + ")");
            }
            return false;
        }
        boolean selectionExists = false;
        boolean selected = false;
        tmp = (String)requirements.get("connect.module.allow");
        if (tmp != null) {
            selectionExists = true;
            selected = this.contains(tmp, this.module);
        }
        if (!selected && (tmp = (String)requirements.get("connect.module.type.allow")) != null) {
            selectionExists = true;
            selected = this.contains(tmp, myTypes);
        }
        if (selectionExists && !selected) {
            return false;
        }
        return this.matchAdditionalRuntimeRequirements(requirements);
    }

    public String toString() {
        return this.name;
    }

    public void connectSucces(long time) {
        this.connectSuccesTime += time;
        ++this.connectSuccesCount;
    }

    public void connectFailed(long time) {
        this.connectFailedTime += time;
        ++this.connectFailedCount;
    }

    public void connectRejected(long time) {
        this.connectRejectedTime += time;
        ++this.connectRejectedCount;
    }

    public void connectNotAllowed() {
        ++this.connectNotAllowedCount;
    }

    public abstract int getDefaultTimeout();

    public abstract void initModule(TypedProperties var1) throws Exception;

    public abstract void startModule() throws Exception;

    public abstract boolean matchAdditionalRuntimeRequirements(Map<String, ?> var1);

    public abstract DirectSocketAddress getAddresses();

    public abstract VirtualSocket connect(VirtualSocketAddress var1, int var2, Map<String, Object> var3) throws NonFatalIOException, IOException;

    public void printStatistics(String prefix) {
        if (statslogger.isInfoEnabled()) {
            long total = this.connectSuccesCount + this.connectFailedCount + this.connectRejectedCount + this.connectNotAllowedCount;
            statslogger.info(prefix + " -> " + this.name + " out: " + total + " total, " + this.connectSuccesCount + " successful (" + this.connectSuccesTime + " ms.), " + this.connectRejectedCount + " rejected (" + this.connectRejectedTime + " ms.), " + this.connectFailedCount + " failed (" + this.connectFailedTime + " ms.), " + this.connectNotAllowedCount + " not allowed.");
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

