/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util.ssh;

import ibis.smartsockets.util.ssh.Credential;
import ibis.smartsockets.util.ssh.UserCredential;
import java.util.HashMap;
import java.util.Set;

public class CredentialMap
implements Credential {
    private final HashMap<String, UserCredential> map = new HashMap();
    private UserCredential defaultCredential;

    public CredentialMap() {
        this(null);
    }

    public CredentialMap(UserCredential defaultCredential) {
        this.defaultCredential = defaultCredential;
    }

    public UserCredential put(String key, UserCredential credential) {
        if (key == null) {
            throw new IllegalArgumentException("Key may not be null");
        }
        return this.map.put(key, credential);
    }

    public boolean containsCredential(String key) {
        return this.map.containsKey(key);
    }

    public UserCredential get(String key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return this.defaultCredential;
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public UserCredential getDefault() {
        return this.defaultCredential;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultCredential == null ? 0 : this.defaultCredential.hashCode());
        result = 31 * result + this.map.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CredentialMap other = (CredentialMap)obj;
        if (this.defaultCredential == null ? other.defaultCredential != null : !this.defaultCredential.equals(other.defaultCredential)) {
            return false;
        }
        return this.map.equals(other.map);
    }
}

