/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.util.net.NativeNetworkConfig;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.network.util");
    private static long MILLIS_1582_1970 = 12216618000000L;
    private static byte[][] localSubnetMask = new byte[][]{{127, 0, 0, 0}, {-1, 0, 0, 0}, {-1, 0, 0, 0}, {10, 0, 0, 0}, {-1, 0, 0, 0}, {-1, 0, 0, 0}, {-84, 16, 0, 0}, {-1, -16, 0, 0}, {-1, -1, 0, 0}, {-64, -88, 0, 0}, {-1, -1, 0, 0}, {-1, -1, -1, 0}, {-87, -2, 0, 0}, {-1, -1, 0, 0}, {-1, -1, 0, 0}};
    private static String localHostname;

    private NetworkUtils() {
    }

    public static boolean isExternalAddress(InetAddress address) {
        if (address.isLoopbackAddress()) {
            return false;
        }
        if (address.isLinkLocalAddress()) {
            return false;
        }
        return !address.isSiteLocalAddress();
    }

    public static boolean isLocalAddress(InetAddress address) {
        return !NetworkUtils.isExternalAddress(address);
    }

    public static boolean containsGlobalAddress(InetAddress[] inas) {
        for (int i = 0; i < inas.length; ++i) {
            if (!NetworkUtils.isExternalAddress(inas[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(InetSocketAddress[] inas, InetSocketAddress a) {
        if (inas == null || inas.length == 0 || a == null) {
            return false;
        }
        for (InetSocketAddress sa : inas) {
            if (sa == null || !a.equals(sa)) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<NetworkInterface> getNetworkInterfacesList() {
        ArrayList<NetworkInterface> list;
        block3: {
            list = new ArrayList<NetworkInterface>();
            Enumeration<NetworkInterface> e = null;
            try {
                e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    list.add(e.nextElement());
                }
            }
            catch (SocketException ex) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Could not get network interfaces.");
            }
        }
        return list;
    }

    public static NetworkInterface[] getNetworkInterfaces() {
        ArrayList<NetworkInterface> list = NetworkUtils.getNetworkInterfacesList();
        return list.toArray(new NetworkInterface[list.size()]);
    }

    private static void getAllHostAddresses(NetworkInterface nw, List<InetAddress> target, boolean ignoreLoopback, boolean ignoreIP6) {
        if (logger.isInfoEnabled()) {
            logger.info("   " + nw.getDisplayName() + ":");
        }
        Enumeration<InetAddress> e2 = nw.getInetAddresses();
        while (e2.hasMoreElements()) {
            boolean t2;
            InetAddress tmp = e2.nextElement();
            boolean t1 = !ignoreLoopback || !tmp.isLoopbackAddress();
            boolean bl = t2 = !ignoreIP6 || tmp instanceof Inet4Address;
            if (t1 && t2) {
                if (logger.isInfoEnabled()) {
                    logger.info("    - " + tmp.getHostAddress() + " (used)");
                }
                target.add(tmp);
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("    - " + tmp.getHostAddress() + " (ignored)");
        }
    }

    public static InetAddress[] getAllHostAddresses() {
        return NetworkUtils.getAllHostAddresses(false, false);
    }

    public static InetAddress[] getAllHostAddresses(boolean ignoreLoopback, boolean ignoreIP6) {
        ArrayList<NetworkInterface> nwl = NetworkUtils.getNetworkInterfacesList();
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        if (logger.isInfoEnabled()) {
            logger.info("Determining available addresses:");
        }
        for (NetworkInterface nwi : nwl) {
            NetworkUtils.getAllHostAddresses(nwi, list, ignoreLoopback, ignoreIP6);
        }
        return list.toArray(new InetAddress[list.size()]);
    }

    public static InetAddress[] getAllHostAddresses(NetworkInterface nw) {
        return NetworkUtils.getAllHostAddresses(nw, false, false);
    }

    public static InetAddress[] getAllHostAddresses(NetworkInterface nw, boolean ignoreLoopback, boolean ignoreIP6) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        NetworkUtils.getAllHostAddresses(nw, list, ignoreLoopback, ignoreIP6);
        return list.toArray(new InetAddress[list.size()]);
    }

    public static String bytesToString(byte[] bytes) {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < bytes.length; ++i) {
            result.append(bytes[i] & 0xFF);
            if (i == bytes.length - 1) continue;
            result.append(".");
        }
        return result.toString();
    }

    public static String ipToString(InetAddress ad) {
        return ad.getHostAddress().trim();
    }

    public static String saToString(InetSocketAddress ad) {
        return NetworkUtils.ipToString(ad.getAddress()) + ":" + ad.getPort();
    }

    public static String ipToString(InetAddress[] ads) {
        StringBuffer result = new StringBuffer("[");
        for (int i = 0; i < ads.length; ++i) {
            result.append(NetworkUtils.ipToString(ads[i]));
            if (i == ads.length - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public static byte[] MACStringToBytes(String mac) {
        byte[] result = new byte[6];
        StringBuffer tmp = new StringBuffer(mac);
        for (int i = 0; i < 6; ++i) {
            result[i] = (byte)(0xFF & Integer.parseInt(tmp.substring(i * 3, i * 3 + 2), 16));
        }
        return result;
    }

    private static String bytesToString(byte[] b, boolean hex, char sep) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            if (hex) {
                int value = 0xFF & b[i];
                if (value <= 15) {
                    tmp.append('0');
                }
                tmp.append(Integer.toHexString(value));
            } else {
                tmp.append(0xFF & b[i]);
            }
            if (i == b.length - 1) continue;
            tmp.append(sep);
        }
        return tmp.toString();
    }

    private static byte[] stringToBytes(String s, boolean hex, char sep) {
        StringTokenizer st = new StringTokenizer(s, "" + sep);
        int len = st.countTokens();
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            String tmp = st.nextToken();
            result[i] = hex ? (byte)(0xFF & Integer.parseInt(tmp, 16)) : (byte)(0xFF & Integer.parseInt(tmp, 10));
        }
        return result;
    }

    public static String MACToString(byte[] mac) {
        return NetworkUtils.bytesToString(mac, true, ':');
    }

    public static String UUIDToString(byte[] UUID) {
        return NetworkUtils.bytesToString(UUID, true, '.');
    }

    public static byte[] stringToUUID(String UUID) {
        return NetworkUtils.stringToBytes(UUID, true, '.');
    }

    public static byte[] getUUID() {
        int i;
        long time = (System.currentTimeMillis() + MILLIS_1582_1970) * 10L;
        time |= 2L;
        Random r = new Random();
        int clock = r.nextInt(131071);
        clock |= 4;
        byte[] mac = NetworkUtils.getAnyMACAddress(NetworkUtils.getAllHostAddresses(false, true));
        if (mac == null) {
            mac = new byte[6];
            r.nextBytes(mac);
        }
        byte[] uuid = new byte[16];
        for (i = 7; i >= 0; --i) {
            uuid[i] = (byte)(time >> i * 8 & 0xFFL);
        }
        for (i = 1; i >= 0; --i) {
            uuid[8 + i] = (byte)(clock >> i * 8 & 0xFF);
        }
        for (i = 0; i < 6; ++i) {
            uuid[10 + i] = mac[i];
        }
        return uuid;
    }

    public static String ipv4ToString(byte[] ipv4) {
        return NetworkUtils.bytesToString(ipv4, false, '.');
    }

    public static boolean matchAddress(byte[] ad, byte[] sub, byte[] mask) {
        if (sub.length != ad.length) {
            return false;
        }
        for (int i = 0; i < sub.length; ++i) {
            if ((ad[i] & mask[i]) == (sub[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchAddress(InetAddress ad, byte[] sub, byte[] mask) {
        return NetworkUtils.matchAddress(ad.getAddress(), sub, mask);
    }

    public static boolean getSubnetMask(byte[] a, byte[] sub, byte[] mask) {
        if (sub.length != a.length) {
            throw new IllegalArgumentException("Subnet array has wrong size!");
        }
        if (mask.length != a.length) {
            throw new IllegalArgumentException("Mask array has wrong size!");
        }
        for (int i = 0; i < localSubnetMask.length; i += 3) {
            if (!NetworkUtils.matchAddress(a, localSubnetMask[i], localSubnetMask[i + 1])) continue;
            for (int b = 0; b < sub.length; ++b) {
                mask[b] = localSubnetMask[i + 2][b];
                sub[b] = (byte)(a[b] & mask[b]);
            }
            return true;
        }
        return false;
    }

    public static synchronized String getHostname() throws IOException {
        InetAddress[] adds;
        if (localHostname != null) {
            return localHostname;
        }
        try {
            InetAddress a = InetAddress.getLocalHost();
            if (a != null) {
                localHostname = a.getHostName();
                return localHostname;
            }
        }
        catch (Exception a) {
            // empty catch block
        }
        for (InetAddress a : adds = NetworkUtils.getAllHostAddresses(true, false)) {
            try {
                localHostname = a.getHostName();
                return localHostname;
            }
            catch (Exception exception) {
            }
        }
        throw new IOException("Failed to get hostname!");
    }

    public static String getMACAddressAsString(InetAddress ip) throws IOException {
        return NetworkUtils.MACToString(NetworkUtils.getMACAddress(ip));
    }

    public static String getNetmaskAsString(InetAddress ip) throws IOException {
        return NetworkUtils.ipv4ToString(NetworkUtils.getNetmask(ip));
    }

    public static String getBroadAsString(InetAddress ip) throws IOException {
        return NetworkUtils.ipv4ToString(NetworkUtils.getBroadcast(ip));
    }

    public static byte[] getMACAddress(InetAddress ip) throws IOException {
        return NativeNetworkConfig.getMACAddress(ip);
    }

    public static byte[] getAnyMACAddress(InetAddress[] ips) {
        for (InetAddress ip : ips) {
            try {
                byte[] mac = NativeNetworkConfig.getMACAddress(ip);
                if (mac == null) continue;
                return mac;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static byte[] getNetmask(InetAddress ip) throws IOException {
        return NativeNetworkConfig.getNetmask(ip);
    }

    public static byte[] getBroadcast(InetAddress ip) throws IOException {
        return NativeNetworkConfig.getBroadcast(ip);
    }

    public static void main(String[] args) {
        ArrayList<NetworkInterface> nwl = NetworkUtils.getNetworkInterfacesList();
        for (NetworkInterface nwi : nwl) {
            System.out.println("Found network interface: " + nwi.getDisplayName());
            ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
            NetworkUtils.getAllHostAddresses(nwi, ips, false, true);
            String mac = null;
            for (InetAddress ip : ips) {
                try {
                    mac = NetworkUtils.getMACAddressAsString(ip);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mac == null) continue;
                break;
            }
            System.out.println("  MAC Address    : " + (mac != null ? mac : "unknown"));
            for (InetAddress ip : ips) {
                if (ip instanceof Inet4Address) {
                    String netmask = null;
                    try {
                        netmask = NetworkUtils.getNetmaskAsString(ip);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String broadcast = null;
                    try {
                        broadcast = NetworkUtils.getBroadAsString(ip);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println("  IPv4 Address   : " + NetworkUtils.ipToString(ip));
                    System.out.println("       Netmask   : " + (netmask != null ? netmask : "unknown"));
                    System.out.println("       Broadcast : " + (broadcast != null ? broadcast : "unknown"));
                } else {
                    System.out.println("  IPv6 Address   : " + NetworkUtils.ipToString(ip));
                }
                String type = "global";
                if (ip.isLoopbackAddress()) {
                    type = "loopback";
                } else if (ip.isLinkLocalAddress()) {
                    type = "link local";
                } else if (ip.isSiteLocalAddress()) {
                    type = "site local";
                } else if (ip.isMulticastAddress()) {
                    type = "multicast";
                }
                System.out.println("       Type      : " + type);
                System.out.println();
            }
        }
    }
}

