/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.util.MultiplexInputStream;
import ibis.smartsockets.util.MultiplexOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public final class MultiplexStreamFactory {
    private static final int ACK = 42;
    private static final int DATA = 43;
    private static final int DEFAULT_BUFFER_SIZE = 16392;
    private static final int DEFAULT_CREDITS = 16;
    private final int bufferSize;
    private final InputStream in;
    private final OutputStream out;
    private final HashMap<Integer, MultiplexInputStream> inputs = new HashMap();
    private final HashMap<Integer, MultiplexOutputStream> outputs = new HashMap();
    private final InputReader reader;
    private boolean closed = false;

    public MultiplexStreamFactory(InputStream in, OutputStream out) {
        this(in, out, 16392);
    }

    public MultiplexStreamFactory(InputStream in, OutputStream out, int bufferSize) {
        this.in = in;
        this.out = out;
        this.bufferSize = bufferSize;
        this.outputs.put(0, new MultiplexOutputStream(this, out, 0, bufferSize, 16));
        this.inputs.put(0, new MultiplexInputStream(this, 0));
        this.reader = new InputReader();
        this.reader.start();
        System.out.println("Factory started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MultiplexInputStream findInput(int target) {
        HashMap<Integer, MultiplexInputStream> hashMap = this.inputs;
        synchronized (hashMap) {
            return this.inputs.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MultiplexOutputStream findOutput(int target) {
        HashMap<Integer, MultiplexOutputStream> hashMap = this.outputs;
        synchronized (hashMap) {
            return this.outputs.get(target);
        }
    }

    final void deliverBuffer(int target, byte[] buffer) throws IOException {
        MultiplexInputStream min = this.findInput(target);
        if (min != null) {
            min.addBuffer(buffer);
        } else {
            System.err.println("Warning received data for unknown stream!");
            this.returnBuffer(buffer, target);
        }
    }

    final void deliverACK(int target, int credits) {
        MultiplexOutputStream min = this.findOutput(target);
        if (min != null) {
            min.addCredits(credits);
        } else {
            System.err.println("Warning received ack for unknown stream!");
        }
    }

    final byte[] getBuffer() {
        return new byte[this.bufferSize];
    }

    static final void writeDataOpcode(byte[] buffer) {
        buffer[0] = 43;
    }

    private static final void writeACK(byte[] buffer, int stream) {
        buffer[0] = 42;
        buffer[1] = (byte)(0xFF & stream >> 16);
        buffer[2] = (byte)(0xFF & stream >> 8);
        buffer[3] = (byte)(0xFF & stream);
        buffer[4] = 0;
        buffer[5] = 0;
        buffer[6] = 0;
        buffer[7] = 8;
    }

    static final void writeStream(byte[] buffer, int stream) {
        buffer[1] = (byte)(0xFF & stream >> 16);
        buffer[2] = (byte)(0xFF & stream >> 8);
        buffer[3] = (byte)(0xFF & stream);
    }

    static final void writeLength(byte[] buffer, int length) {
        buffer[4] = (byte)(0xFF & length >> 24);
        buffer[5] = (byte)(0xFF & length >> 16);
        buffer[6] = (byte)(0xFF & length >> 8);
        buffer[7] = (byte)(0xFF & length);
    }

    static final int readOpcode(byte[] buffer) {
        return buffer[0] & 0xFF;
    }

    static final int readLength(byte[] buffer) {
        return (buffer[4] & 0xFF) << 24 | (buffer[5] & 0xFF) << 16 | (buffer[6] & 0xFF) << 8 | buffer[7] & 0xFF;
    }

    static final int readStream(byte[] buf2) {
        return (buf2[1] & 0xFF) << 16 | (buf2[2] & 0xFF) << 8 | buf2[3] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void returnBuffer(byte[] buffer, int stream) throws IOException {
        MultiplexStreamFactory.writeACK(buffer, stream);
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(buffer, 0, 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deleteOutputStream(int number) {
        HashMap<Integer, MultiplexOutputStream> hashMap = this.outputs;
        synchronized (hashMap) {
            this.outputs.remove(number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deleteInputStream(int number) {
        HashMap<Integer, MultiplexInputStream> hashMap = this.inputs;
        synchronized (hashMap) {
            this.inputs.remove(number);
        }
    }

    public OutputStream getBaseOut() {
        return this.findOutput(0);
    }

    public InputStream getBaseIn() {
        return this.findInput(0);
    }

    public OutputStream getOutputStream(int number) {
        return this.findOutput(number);
    }

    public InputStream getInputStream(int number) {
        return this.findInput(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexOutputStream createOutputStream(int number) {
        HashMap<Integer, MultiplexOutputStream> hashMap = this.outputs;
        synchronized (hashMap) {
            MultiplexOutputStream mos = new MultiplexOutputStream(this, this.out, number, this.bufferSize, 16);
            this.outputs.put(number, mos);
            return mos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexInputStream createInputStream(int number) {
        HashMap<Integer, MultiplexInputStream> hashMap = this.inputs;
        synchronized (hashMap) {
            MultiplexInputStream mis = new MultiplexInputStream(this, number);
            this.inputs.put(number, mis);
            return mis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        HashMap<Integer, Closeable> hashMap = this.inputs;
        synchronized (hashMap) {
            if (this.inputs.size() > 0) {
                throw new IOException("Attempting to close MultiplexFactory, but there are " + this.inputs.size() + " inputs active!");
            }
        }
        hashMap = this.outputs;
        synchronized (hashMap) {
            if (this.outputs.size() > 0) {
                throw new IOException("Attempting to close MultiplexFactory, but there are " + this.outputs.size() + " outputs active!");
            }
        }
        System.out.println("Closing factory");
        this.closed = true;
        this.in.close();
        this.out.close();
    }

    private class InputReader
    extends Thread {
        private InputReader() {
        }

        private final int read(InputStream in, byte[] buffer, int offset, int len) throws IOException {
            int read;
            int bytes;
            for (read = 0; read < len; read += bytes) {
                bytes = in.read(buffer, offset + read, len - read);
                if (bytes != -1) continue;
                return read;
            }
            return read;
        }

        @Override
        public void run() {
            try {
                byte[] buffer = null;
                int read = 0;
                int length = 0;
                int target = 0;
                int opcode = 0;
                block6: while (true) {
                    if (buffer == null) {
                        buffer = MultiplexStreamFactory.this.getBuffer();
                    }
                    if ((read = this.read(MultiplexStreamFactory.this.in, buffer, 0, 8)) != 8) {
                        System.out.println("Reader: Stream closed");
                        return;
                    }
                    opcode = MultiplexStreamFactory.readOpcode(buffer);
                    target = MultiplexStreamFactory.readStream(buffer);
                    length = MultiplexStreamFactory.readLength(buffer);
                    switch (opcode) {
                        case 42: {
                            MultiplexStreamFactory.this.deliverACK(target, length);
                            continue block6;
                        }
                        case 43: {
                            this.read(MultiplexStreamFactory.this.in, buffer, read, length - read);
                            MultiplexStreamFactory.this.deliverBuffer(target, buffer);
                            buffer = null;
                            continue block6;
                        }
                    }
                    System.out.println("Reader: Got UNKNOWN OPCODE!");
                }
            }
            catch (IOException e) {
                if (MultiplexStreamFactory.this.closed) {
                    System.out.println("Reader: Stream closed");
                    return;
                }
                System.out.println("Reader: got exception " + e);
                return;
            }
        }
    }
}

