/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Comparator;

public class AddressSorter
implements Serializable,
Comparator<InetAddress> {
    private static final long serialVersionUID = -2003381888113229585L;

    private int compareAddress(InetAddress i1, InetAddress i2) {
        byte[] tmp2;
        byte[] tmp1 = i1.getAddress();
        if (tmp1.length != (tmp2 = i2.getAddress()).length) {
            return tmp2.length - tmp1.length;
        }
        for (int i = 0; i < tmp1.length; ++i) {
            if (tmp1[i] == tmp2[i]) continue;
            int t1 = tmp1[i] & 0xFF;
            int t2 = tmp2[i] & 0xFF;
            return t2 - t1;
        }
        return 0;
    }

    private int score(InetAddress ina) {
        if (ina.isLoopbackAddress()) {
            return 8;
        }
        if (ina.isLinkLocalAddress()) {
            return 6;
        }
        if (ina.isSiteLocalAddress()) {
            return 4;
        }
        return 2;
    }

    @Override
    public int compare(InetAddress i1, InetAddress i2) {
        int score1 = this.score(i1);
        int score2 = this.score(i2);
        int result = 0;
        result = score1 == score2 ? this.compareAddress(i1, i2) : score1 - score2;
        return result;
    }
}

