/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.state;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.Selector;
import ibis.smartsockets.hub.state.StateCounter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class HubList {
    private static int RETRY_DELAY = 15000;
    private final StateCounter state;
    private final LinkedList<HubDescription> connectedHubs = new LinkedList();
    private final LinkedList<HubDescription> mustCheck = new LinkedList();
    private final HashMap<DirectSocketAddress, HubDescription> map = new HashMap();
    private HubDescription localDescription;

    public HubList(StateCounter state) {
        this.state = state;
    }

    public synchronized HubDescription nextHubToCheck() {
        while (this.mustCheck.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        HubDescription tmp;
        while ((tmp = this.mustCheck.getFirst()).getLastContact() != 0L) {
            long now = System.currentTimeMillis();
            if (tmp.getLastConnect() + (long)RETRY_DELAY < now) {
                return this.mustCheck.removeFirst();
            }
            long waitTime = tmp.getLastConnect() + (long)RETRY_DELAY - now;
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return this.mustCheck.removeFirst();
    }

    public void addLocalDescription(HubDescription desc) {
        this.localDescription = desc;
        this.map.put(desc.hubAddress, desc);
    }

    public HubDescription getLocalDescription() {
        return this.localDescription;
    }

    public synchronized boolean contains(DirectSocketAddress m) {
        return this.map.containsKey(m);
    }

    public synchronized HubDescription get(DirectSocketAddress m) {
        return this.map.get(m);
    }

    public synchronized void select(Selector s) {
        boolean all = s.needAll();
        boolean connected = s.needConnected();
        boolean local = s.needLocal();
        if (local && !all && !connected) {
            s.select(this.localDescription);
            return;
        }
        for (HubDescription d : this.map.values()) {
            if (!all && (!connected || d.getConnection() == null) && (!local || !d.local)) continue;
            s.select(d);
        }
    }

    public synchronized void putBack(HubDescription d) {
        if (d.reachableKnown() && d.isReachable()) {
            this.connectedHubs.addLast(d);
        } else {
            this.mustCheck.addLast(d);
            this.notifyAll();
        }
    }

    public synchronized HubDescription add(DirectSocketAddress a) {
        HubDescription tmp = this.get(a);
        if (tmp == null) {
            tmp = new HubDescription(a, this.state);
            this.map.put(tmp.hubAddress, tmp);
            this.mustCheck.addFirst(tmp);
            this.notifyAll();
        }
        return tmp;
    }

    public synchronized DirectSocketAddress[] knownHubs() {
        ArrayList<DirectSocketAddress> l = new ArrayList<DirectSocketAddress>();
        l.add(this.localDescription.hubAddress);
        for (HubDescription d : this.connectedHubs) {
            l.add(d.hubAddress);
        }
        for (HubDescription d : this.mustCheck) {
            if (d.haveConnection()) {
                l.add(d.hubAddress);
                continue;
            }
            if (d.state.get() <= 0L) continue;
            l.add(d.hubAddress);
        }
        return l.toArray(new DirectSocketAddress[l.size()]);
    }

    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Local hub:\n");
        result.append(this.localDescription).append("\n");
        result.append("Hubs with a direct connection:\n");
        for (HubDescription desc : this.connectedHubs) {
            result.append(desc).append('\n');
        }
        result.append("Hubs without a direct connection:\n");
        result.append("Hubs which need to be checked:\n");
        for (HubDescription desc : this.mustCheck) {
            result.append(desc).append('\n');
        }
        return result.toString();
    }
}

