/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.state;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.connections.HubConnection;
import ibis.smartsockets.hub.state.ClientDescription;
import ibis.smartsockets.hub.state.StateCounter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class HubDescription {
    public static final byte UNKNOWN = 0;
    public static final byte UNREACHABLE = 1;
    public static final byte REACHABLE = 2;
    public final DirectSocketAddress hubAddress;
    public final String hubAddressAsString;
    private String name;
    final StateCounter state;
    private String vizInfo;
    final boolean local;
    private long lastLocalUpdate;
    private long homeState;
    private int hops = 0x3FFFFFFF;
    private long lastContact;
    private long lastConnect;
    private byte reachable = 0;
    private byte canReachMe = 0;
    private HashMap<DirectSocketAddress, ClientDescription> clients;
    private HubConnection connection;
    private HubDescription indirection;
    private ArrayList<String> connectedTo = new ArrayList();

    public HubDescription(DirectSocketAddress address, StateCounter state) {
        this(null, address, state, false, null);
    }

    public HubDescription(String name, DirectSocketAddress address, StateCounter state, boolean local, String vizInfo) {
        this.name = name;
        this.state = state;
        this.hubAddress = address;
        this.hubAddressAsString = address.toString();
        this.lastLocalUpdate = state.increment();
        this.vizInfo = vizInfo == null ? "" : vizInfo;
        this.reachable = 0;
        this.canReachMe = 0;
        this.local = local;
        this.clients = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addClient(DirectSocketAddress client) {
        if (!this.local) {
            throw new IllegalStateException("Cannot add clients to remote hub descriptions!");
        }
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            if (this.clients.containsKey(client)) {
                return false;
            }
            this.lastLocalUpdate = this.state.increment();
            this.clients.put(client, new ClientDescription(client));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean knowsClient(DirectSocketAddress client) {
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            return this.clients.containsKey(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeClient(DirectSocketAddress client) {
        if (!this.local) {
            throw new IllegalStateException("Cannot remove clients from remote hub descriptions!");
        }
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            if (!this.clients.containsKey(client)) {
                return false;
            }
            this.lastLocalUpdate = this.state.increment();
            this.clients.remove(client);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ClientDescription[] clients, String[] connectedTo, String name, long remoteState, String vizInfo) {
        if (this.local) {
            throw new IllegalStateException("Cannot update the local hub description!");
        }
        Object object = this.clients;
        synchronized (object) {
            this.clients.clear();
            for (ClientDescription c : clients) {
                this.clients.put(c.clientAddress, c);
            }
        }
        object = this.connectedTo;
        synchronized (object) {
            this.connectedTo.clear();
            for (String s : connectedTo) {
                this.connectedTo.add(s);
            }
        }
        if (name.length() > 0) {
            object = this;
            synchronized (object) {
                if (this.name == null || this.name.length() == 0) {
                    this.name = name;
                }
            }
        }
        this.homeState = remoteState;
        this.lastLocalUpdate = this.state.increment();
        this.vizInfo = vizInfo;
    }

    public long getHomeState() {
        return this.homeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addService(DirectSocketAddress client, String tag, String address) {
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            if (!this.clients.containsKey(client)) {
                return false;
            }
            ClientDescription c = this.clients.get(client);
            if (c.addService(tag, address)) {
                this.lastLocalUpdate = this.state.increment();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateService(DirectSocketAddress client, String tag, String address) {
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            if (!this.clients.containsKey(client)) {
                return false;
            }
            ClientDescription c = this.clients.get(client);
            if (c.updateService(tag, address)) {
                this.lastLocalUpdate = this.state.increment();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeService(DirectSocketAddress client, String tag) {
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            if (!this.clients.containsKey(client)) {
                return false;
            }
            ClientDescription c = this.clients.get(client);
            if (c.removeService(tag)) {
                this.lastLocalUpdate = this.state.increment();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsClient(DirectSocketAddress client) {
        DirectSocketAddress directSocketAddress = client;
        synchronized (directSocketAddress) {
            return this.clients.containsKey(client);
        }
    }

    public int numberOfClients() {
        return this.clients.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ClientDescription> getClients(String tag) {
        ArrayList<ClientDescription> result = new ArrayList<ClientDescription>();
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            for (ClientDescription c : this.clients.values()) {
                if (!c.containsService(tag)) continue;
                result.add(c);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClientsAsString(LinkedList<String> result, String tag) {
        if (this.clients == null) {
            return;
        }
        HashMap<DirectSocketAddress, ClientDescription> hashMap = this.clients;
        synchronized (hashMap) {
            for (ClientDescription c : this.clients.values()) {
                if (!c.containsService(tag)) continue;
                result.add(c.toString());
            }
        }
    }

    public synchronized void setContactTimeStamp(boolean connect) {
        this.lastContact = System.currentTimeMillis();
        if (connect) {
            this.lastConnect = this.lastContact;
        }
    }

    public synchronized long getLastLocalUpdate() {
        return this.lastLocalUpdate;
    }

    synchronized long getLastConnect() {
        return this.lastConnect;
    }

    synchronized long getLastContact() {
        return this.lastContact;
    }

    public synchronized int getHops() {
        return this.hops;
    }

    public synchronized void setReachable() {
        if (this.reachable != 2) {
            this.reachable = (byte)2;
            this.indirection = null;
            this.hops = 0;
            this.lastLocalUpdate = this.state.increment();
        }
        this.setContactTimeStamp(true);
    }

    public synchronized void setUnreachable() {
        if (this.reachable != 1) {
            this.reachable = 1;
            this.lastLocalUpdate = this.state.increment();
        }
        this.setContactTimeStamp(true);
    }

    public synchronized void setCanReachMe() {
        if (this.canReachMe != 2) {
            this.canReachMe = (byte)2;
            this.lastLocalUpdate = this.state.increment();
            this.hops = 0;
            this.indirection = null;
        }
        this.setContactTimeStamp(false);
    }

    public synchronized void setCanNotReachMe() {
        if (this.canReachMe != 1) {
            this.canReachMe = 1;
            this.lastLocalUpdate = this.state.increment();
        }
        this.setContactTimeStamp(false);
    }

    public synchronized boolean addIndirection(HubDescription indirection, int hops) {
        if (this.reachable != 2 && hops < this.hops) {
            this.hops = hops;
            this.indirection = indirection;
            this.lastLocalUpdate = this.state.increment();
            return true;
        }
        return false;
    }

    public synchronized HubDescription getIndirection() {
        return this.indirection;
    }

    public synchronized boolean directlyReachable() {
        return this.reachable == 2 || this.canReachMe == 2;
    }

    public synchronized boolean reachableKnown() {
        return this.reachable != 0;
    }

    public synchronized boolean canReachMe() {
        return this.canReachMe == 2;
    }

    public synchronized boolean canReachMeKnown() {
        return this.canReachMe != 0;
    }

    public synchronized boolean isReachable() {
        return this.reachable == 2;
    }

    public synchronized boolean isLocal() {
        return this.local;
    }

    public synchronized boolean createConnection(HubConnection c) {
        if (this.connection != null) {
            return false;
        }
        this.connection = c;
        return true;
    }

    public synchronized HubConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] connectedTo() {
        ArrayList<String> arrayList = this.connectedTo;
        synchronized (arrayList) {
            return this.connectedTo.toArray(new String[this.connectedTo.size()]);
        }
    }

    public synchronized boolean haveConnection() {
        return this.connection != null;
    }

    public synchronized void removeConnection() {
        this.connection = null;
    }

    private String reachableToString(byte r) {
        switch (r) {
            case 2: {
                return "directly";
            }
            case 1: {
                if (this.indirection != null) {
                    return "indirectly";
                }
                return "no";
            }
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String n = this.getName();
        if (n.length() > 0) {
            buffer.append("Name         : ").append(this.name).append('\n');
        } else {
            buffer.append("Name         : <unknown>").append('\n');
        }
        buffer.append("Address      : ").append(this.hubAddress).append('\n');
        buffer.append("Last Update  : ").append(this.lastLocalUpdate).append('\n');
        if (!this.local) {
            buffer.append("Home State   : ").append(this.homeState).append('\n');
            long time = (System.currentTimeMillis() - this.lastContact) / 1000L;
            buffer.append("Last Contact : ").append(time).append(" seconds ago\n");
            buffer.append("Reachable    : ").append(this.reachableToString(this.reachable)).append('\n');
            if (this.reachable == 1 && this.indirection != null) {
                buffer.append("Reachable Via: ").append(this.indirection.hubAddressAsString).append('\n');
            }
            buffer.append("Required Hops: ").append(this.hops).append('\n');
            buffer.append("Can Reach Me : ").append(this.reachableToString(this.canReachMe)).append('\n');
            buffer.append("Connection   : ");
            if (this.haveConnection()) {
                buffer.append("yes\n");
            } else {
                buffer.append("no\n");
            }
        }
        Cloneable cloneable = this.connectedTo;
        synchronized (cloneable) {
            buffer.append("Connections  : ");
            buffer.append(this.connectedTo.size());
            buffer.append("\n");
            for (String s : this.connectedTo) {
                buffer.append("             : ");
                buffer.append(s);
                buffer.append("\n");
            }
        }
        cloneable = this.clients;
        synchronized (cloneable) {
            buffer.append("Clients      : ");
            buffer.append(this.clients.size());
            buffer.append("\n");
            for (ClientDescription c : this.clients.values()) {
                buffer.append("             : ");
                buffer.append(c.toString());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedTo(String address) {
        if (!this.local) {
            throw new IllegalStateException("Cannot add connections to remote hub descriptions!");
        }
        ArrayList<String> arrayList = this.connectedTo;
        synchronized (arrayList) {
            this.connectedTo.add(address);
            this.lastLocalUpdate = this.state.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectedTo(String address) {
        if (!this.local) {
            throw new IllegalStateException("Cannot remove connections from remote hub descriptions!");
        }
        ArrayList<String> arrayList = this.connectedTo;
        synchronized (arrayList) {
            this.lastLocalUpdate = this.state.increment();
            for (int i = 0; i < this.connectedTo.size(); ++i) {
                if (!this.connectedTo.get(i).startsWith(address)) continue;
                this.connectedTo.remove(i);
                return;
            }
        }
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getVizInfo() {
        return this.vizInfo;
    }
}

