/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.NestedIOExceptionData;
import java.io.IOException;
import java.util.LinkedList;

public class NestedIOException
extends IOException {
    private static final long serialVersionUID = 7906462081071080010L;
    private final String[] names;
    private final Throwable[] causes;
    private final LinkedList<NestedIOExceptionData> exceptions;

    public NestedIOException(String message, LinkedList<NestedIOExceptionData> exceptions) {
        super(message);
        this.names = null;
        this.causes = null;
        this.exceptions = exceptions;
    }

    public NestedIOException(String message, String[] names, Throwable[] causes) {
        super(message);
        this.names = (String[])names.clone();
        this.causes = (Throwable[])causes.clone();
        this.exceptions = null;
    }

    @Override
    public String toString() {
        return this.toString("       ");
    }

    public String toString(String pre) {
        String name = this.getClass().getName();
        String message = this.getLocalizedMessage();
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        if (message != null) {
            builder.append(": ");
            builder.append(message);
        }
        if (this.exceptions != null) {
            for (NestedIOExceptionData d : this.exceptions) {
                builder.append("\n");
                builder.append(pre);
                builder.append(d.description);
                builder.append(": ");
                builder.append(d.cause.toString());
            }
        } else if (this.causes != null) {
            for (int i = 0; i < this.causes.length; ++i) {
                builder.append("\n");
                builder.append(pre);
                builder.append(this.names[i]);
                builder.append(": ");
                if (this.causes[i] != null) {
                    builder.append(this.causes[i].toString());
                    continue;
                }
                builder.append("<unknown cause>");
            }
        } else {
            builder.append(" (no information)");
        }
        return builder.toString();
    }
}

