/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.util.AddressSorter;
import ibis.smartsockets.util.InetAddressCache;
import ibis.smartsockets.util.NetworkUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class IPAddressSet
implements Serializable {
    private static final long serialVersionUID = 8548119455369383377L;
    private static final int LENGTH_IPv4 = 4;
    private static final int LENGTH_IPv6 = 16;
    protected static final AddressSorter SORTER = new AddressSorter();
    private static IPAddressSet localHost;
    private transient byte[] codedForm;
    protected final InetAddress[] addresses;
    protected final byte[] UUID;

    private IPAddressSet(InetAddress[] addresses, byte[] UUID, byte[] codedForm) {
        this.addresses = addresses;
        this.UUID = UUID;
        this.codedForm = codedForm;
    }

    private IPAddressSet(InetAddress[] addresses) {
        this(addresses, null, null);
    }

    private IPAddressSet(InetAddress[] addresses, byte[] UUID) {
        this(addresses, UUID, null);
    }

    public byte[] getAddress() {
        if (this.codedForm == null) {
            if (this.addresses.length == 1 && this.UUID == null) {
                this.codedForm = this.addresses[0].getAddress();
            } else {
                int len = 2;
                for (int i = 0; i < this.addresses.length; ++i) {
                    len += 1 + this.addresses[i].getAddress().length;
                }
                if (this.UUID != null) {
                    len += 16;
                }
                if (len == 16) {
                    ++len;
                }
                this.codedForm = new byte[len];
                int index = 0;
                this.codedForm[index++] = (byte)this.addresses.length;
                this.codedForm[index++] = (byte)(this.UUID != null ? 1 : 0);
                for (int i = 0; i < this.addresses.length; ++i) {
                    byte[] tmp = this.addresses[i].getAddress();
                    this.codedForm[index++] = (byte)tmp.length;
                    System.arraycopy(tmp, 0, this.codedForm, index, tmp.length);
                    index += tmp.length;
                }
                if (this.UUID != null) {
                    System.arraycopy(this.UUID, 0, this.codedForm, index, this.UUID.length);
                }
            }
        }
        return (byte[])this.codedForm.clone();
    }

    public InetAddress[] getAddresses() {
        return (InetAddress[])this.addresses.clone();
    }

    public boolean containsPublicAddress() {
        return NetworkUtils.containsGlobalAddress(this.addresses);
    }

    public boolean containsUUID() {
        return this.UUID != null;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.addresses.length; ++i) {
            code ^= this.addresses[i].hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IPAddressSet)) {
            return false;
        }
        IPAddressSet tmp = (IPAddressSet)other;
        if (!Arrays.equals(this.addresses, tmp.addresses)) {
            return false;
        }
        if (this.UUID == null && tmp.UUID == null) {
            return true;
        }
        return Arrays.equals(this.UUID, tmp.UUID);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("");
        for (int i = 0; i < this.addresses.length; ++i) {
            tmp.append(NetworkUtils.ipToString(this.addresses[i]));
            if (i == this.addresses.length - 1) continue;
            tmp.append("/");
        }
        if (this.UUID != null) {
            tmp.append("#");
            tmp.append(NetworkUtils.UUIDToString(this.UUID));
        }
        return tmp.toString();
    }

    public static IPAddressSet add(IPAddressSet address, InetAddress add) {
        int len = address.addresses.length;
        InetAddress[] tmp = new InetAddress[len + 1];
        tmp[0] = add;
        System.arraycopy(address.addresses, 0, tmp, 1, len);
        return IPAddressSet.getFromAddress(tmp);
    }

    public static IPAddressSet merge(IPAddressSet a1, IPAddressSet a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        InetAddress[] tmp = new InetAddress[a1.addresses.length + a2.addresses.length];
        System.arraycopy(a1.addresses, 0, tmp, 0, a1.addresses.length);
        System.arraycopy(a2.addresses, 0, tmp, a1.addresses.length, a2.addresses.length);
        IPAddressSet result = IPAddressSet.getFromAddress(tmp);
        if (a1.UUID != null) {
            result = IPAddressSet.merge(result, a1.UUID);
        } else if (a2.UUID != null) {
            result = IPAddressSet.merge(result, a2.UUID);
        }
        return result;
    }

    public static IPAddressSet merge(IPAddressSet a1, InetAddress a2) {
        if (a1 == null && a2 != null) {
            return new IPAddressSet(new InetAddress[]{a2});
        }
        if (a2 == null) {
            return a1;
        }
        InetAddress[] tmp = new InetAddress[a1.addresses.length + 1];
        System.arraycopy(a1.addresses, 0, tmp, 0, a1.addresses.length);
        tmp[tmp.length - 1] = a2;
        IPAddressSet result = IPAddressSet.getFromAddress(tmp);
        if (a1.UUID != null) {
            result = IPAddressSet.merge(result, a1.UUID);
        }
        return result;
    }

    public static IPAddressSet merge(IPAddressSet a, byte[] uuid) {
        return new IPAddressSet(a.addresses, uuid, null);
    }

    public static IPAddressSet getByAddress(byte[] bytes) throws UnknownHostException {
        return IPAddressSet.getByAddress(bytes, 0, bytes.length);
    }

    public static IPAddressSet getByAddress(byte[] bytes, int off, int len) throws UnknownHostException {
        InetAddress[] addresses;
        byte[] uuid = null;
        if (len == 4 || len == 16) {
            addresses = new InetAddress[1];
            byte[] tmp = new byte[len];
            System.arraycopy(bytes, off, tmp, 0, len);
            String ipAddress = "" + (tmp[0] & 0xFF) + "." + (tmp[1] & 0xFF) + "." + (tmp[2] & 0xFF) + "." + (tmp[3] & 0xFF);
            addresses[0] = InetAddressCache.getByName(ipAddress);
        } else {
            int index = 0;
            byte length = bytes[index++];
            boolean hasUUID = bytes[index++] != 0;
            addresses = new InetAddress[length];
            byte[] tmp = null;
            for (int i = 0; i < addresses.length; ++i) {
                byte size = bytes[index++];
                if (tmp == null || tmp.length != size) {
                    tmp = new byte[size];
                }
                System.arraycopy(bytes, index, tmp, 0, size);
                String ipAddress = "" + (tmp[0] & 0xFF) + "." + (tmp[1] & 0xFF) + "." + (tmp[2] & 0xFF) + "." + (tmp[3] & 0xFF);
                addresses[i] = InetAddress.getByName(ipAddress);
                index += size;
            }
            if (hasUUID) {
                uuid = new byte[16];
                System.arraycopy(bytes, index, uuid, 0, 16);
            }
        }
        return new IPAddressSet(addresses, uuid, bytes);
    }

    public static IPAddressSet getFromString(String address) throws UnknownHostException {
        boolean hasUUID;
        StringTokenizer st = new StringTokenizer(address, "/#", false);
        int len = st.countTokens();
        boolean bl = hasUUID = address.indexOf(35) != -1;
        if (hasUUID) {
            --len;
        }
        InetAddress[] addresses = new InetAddress[len];
        for (int i = 0; i < len; ++i) {
            addresses[i] = InetAddressCache.getByName(st.nextToken());
        }
        byte[] uuid = null;
        if (hasUUID) {
            uuid = NetworkUtils.stringToUUID(st.nextToken());
        }
        return new IPAddressSet(IPAddressSet.sort(addresses), uuid);
    }

    public static IPAddressSet getFromAddress(InetAddress[] addresses) {
        return new IPAddressSet(IPAddressSet.sort(addresses));
    }

    public static IPAddressSet getFromAddress(InetAddress address) {
        return new IPAddressSet(new InetAddress[]{address});
    }

    public static IPAddressSet getLocalHost() {
        return IPAddressSet.getLocalHost(true);
    }

    public static IPAddressSet getLocalHost(boolean cacheIPaddress) {
        if (localHost == null || !cacheIPaddress) {
            InetAddress[] addresses = NetworkUtils.getAllHostAddresses(true, true);
            if (addresses == null || addresses.length == 0) {
                addresses = NetworkUtils.getAllHostAddresses(false, true);
            }
            addresses = IPAddressSet.sort(addresses);
            DirectSocketFactory.logger.info("Result after sorting: ");
            DirectSocketFactory.logger.info(" " + NetworkUtils.ipToString(addresses));
            if (!NetworkUtils.containsGlobalAddress(addresses)) {
                DirectSocketFactory.logger.info(" Result does NOT contain public address!");
            } else {
                DirectSocketFactory.logger.info(" Result contains public address!");
            }
            localHost = new IPAddressSet(addresses);
        }
        return localHost;
    }

    private static InetAddress[] sort(InetAddress[] in) {
        if (in != null && in.length > 1) {
            Arrays.sort(in, SORTER);
        }
        return in;
    }
}

